# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gkehub/v1/service_pb"

module Google
  module Cloud
    module GkeHub
      module V1
        module GkeHub
          ##
          # Client for the GkeHub service.
          #
          # The GKE Hub service handles the registration of many Kubernetes clusters to
          # Google Cloud, and the management of multi-cluster features over those
          # clusters.
          #
          # The GKE Hub service operates on the following resources:
          #
          # * {::Google::Cloud::GkeHub::V1::Membership Membership}
          # * {::Google::Cloud::GkeHub::V1::Feature Feature}
          #
          # GKE Hub is currently available in the global region and all regions in
          # https://cloud.google.com/compute/docs/regions-zones. Feature is only
          # available in global region while membership is global region and all the
          # regions.
          #
          # **Membership management may be non-trivial:** it is recommended to use one
          # of the Google-provided client libraries or tools where possible when working
          # with Membership resources.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "gkehub.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :gke_hub_stub

            ##
            # Configure the GkeHub Client class.
            #
            # See {::Google::Cloud::GkeHub::V1::GkeHub::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all GkeHub clients
            #   ::Google::Cloud::GkeHub::V1::GkeHub::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "GkeHub", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the GkeHub Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::GkeHub::V1::GkeHub::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @gke_hub_stub.universe_domain
            end

            ##
            # Create a new GkeHub client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::GkeHub::V1::GkeHub::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the GkeHub client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/gkehub/v1/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @gke_hub_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::GkeHub::V1::GkeHub::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @gke_hub_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::GkeHub::V1::GkeHub::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @gke_hub_stub.logger
            end

            # Service calls

            ##
            # Lists Memberships in a given project and location.
            #
            # @overload list_memberships(request, options = nil)
            #   Pass arguments to `list_memberships` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::ListMembershipsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::ListMembershipsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_memberships(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_memberships` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent (project and location) where the Memberships will be
            #     listed. Specified in the format `projects/*/locations/*`.
            #     `projects/*/locations/-` list memberships in all the regions.
            #   @param page_size [::Integer]
            #     Optional. When requesting a 'page' of resources, `page_size` specifies
            #     number of resources to return. If unspecified or set to 0, all resources
            #     will be returned.
            #   @param page_token [::String]
            #     Optional. Token returned by previous call to `ListMemberships` which
            #     specifies the position in the list from where to continue listing the
            #     resources.
            #   @param filter [::String]
            #     Optional. Lists Memberships that match the filter expression, following the
            #     syntax outlined in https://google.aip.dev/160.
            #
            #     Examples:
            #
            #       - Name is `bar` in project `foo-proj` and location `global`:
            #
            #           name = "projects/foo-proj/locations/global/membership/bar"
            #
            #       - Memberships that have a label called `foo`:
            #
            #           labels.foo:*
            #
            #       - Memberships that have a label called `foo` whose value is `bar`:
            #
            #           labels.foo = bar
            #
            #       - Memberships in the CREATING state:
            #
            #           state = CREATING
            #   @param order_by [::String]
            #     Optional. One or more fields to compare and use to sort the output.
            #     See https://google.aip.dev/132#ordering.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeHub::V1::Membership>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeHub::V1::Membership>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::ListMembershipsRequest.new
            #
            #   # Call the list_memberships method.
            #   result = client.list_memberships request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeHub::V1::Membership.
            #     p item
            #   end
            #
            def list_memberships request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::ListMembershipsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_memberships.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_memberships.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_memberships.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :list_memberships, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gke_hub_stub, :list_memberships, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Features in a given project and location.
            #
            # @overload list_features(request, options = nil)
            #   Pass arguments to `list_features` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::ListFeaturesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::ListFeaturesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_features(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_features` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent (project and location) where the Features will be
            #     listed. Specified in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     When requesting a 'page' of resources, `page_size` specifies number of
            #     resources to return. If unspecified or set to 0, all resources will
            #     be returned.
            #   @param page_token [::String]
            #     Token returned by previous call to `ListFeatures` which
            #     specifies the position in the list from where to continue listing the
            #     resources.
            #   @param filter [::String]
            #     Lists Features that match the filter expression, following the syntax
            #     outlined in https://google.aip.dev/160.
            #
            #     Examples:
            #
            #       - Feature with the name "servicemesh" in project "foo-proj":
            #
            #           name = "projects/foo-proj/locations/global/features/servicemesh"
            #
            #       - Features that have a label called `foo`:
            #
            #           labels.foo:*
            #
            #       - Features that have a label called `foo` whose value is `bar`:
            #
            #           labels.foo = bar
            #   @param order_by [::String]
            #     One or more fields to compare and use to sort the output.
            #     See https://google.aip.dev/132#ordering.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeHub::V1::Feature>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeHub::V1::Feature>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::ListFeaturesRequest.new
            #
            #   # Call the list_features method.
            #   result = client.list_features request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeHub::V1::Feature.
            #     p item
            #   end
            #
            def list_features request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::ListFeaturesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_features.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_features.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_features.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :list_features, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gke_hub_stub, :list_features, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a Membership.
            #
            # @overload get_membership(request, options = nil)
            #   Pass arguments to `get_membership` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::GetMembershipRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::GetMembershipRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_membership(name: nil)
            #   Pass arguments to `get_membership` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The Membership resource name in the format
            #     `projects/*/locations/*/memberships/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeHub::V1::Membership]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeHub::V1::Membership]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::GetMembershipRequest.new
            #
            #   # Call the get_membership method.
            #   result = client.get_membership request
            #
            #   # The returned object is of type Google::Cloud::GkeHub::V1::Membership.
            #   p result
            #
            def get_membership request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::GetMembershipRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_membership.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_membership.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_membership.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :get_membership, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Feature.
            #
            # @overload get_feature(request, options = nil)
            #   Pass arguments to `get_feature` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::GetFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::GetFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_feature(name: nil)
            #   Pass arguments to `get_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The Feature resource name in the format
            #     `projects/*/locations/*/features/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeHub::V1::Feature]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeHub::V1::Feature]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::GetFeatureRequest.new
            #
            #   # Call the get_feature method.
            #   result = client.get_feature request
            #
            #   # The returned object is of type Google::Cloud::GkeHub::V1::Feature.
            #   p result
            #
            def get_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::GetFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :get_feature, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Membership.
            #
            # **This is currently only supported for GKE clusters on Google Cloud**.
            # To register other clusters, follow the instructions at
            # https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
            #
            # @overload create_membership(request, options = nil)
            #   Pass arguments to `create_membership` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::CreateMembershipRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::CreateMembershipRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_membership(parent: nil, membership_id: nil, resource: nil, request_id: nil)
            #   Pass arguments to `create_membership` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent (project and location) where the Memberships will be
            #     created. Specified in the format `projects/*/locations/*`.
            #   @param membership_id [::String]
            #     Required. Client chosen ID for the membership. `membership_id` must be a
            #     valid RFC 1123 compliant DNS label:
            #
            #       1. At most 63 characters in length
            #       2. It must consist of lower case alphanumeric characters or `-`
            #       3. It must start and end with an alphanumeric character
            #
            #     Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
            #     with a maximum length of 63 characters.
            #   @param resource [::Google::Cloud::GkeHub::V1::Membership, ::Hash]
            #     Required. The membership to create.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server will guarantee
            #     that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::CreateMembershipRequest.new
            #
            #   # Call the create_membership method.
            #   result = client.create_membership request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_membership request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::CreateMembershipRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_membership.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_membership.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_membership.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :create_membership, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Adds a new Feature.
            #
            # @overload create_feature(request, options = nil)
            #   Pass arguments to `create_feature` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::CreateFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::CreateFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_feature(parent: nil, feature_id: nil, resource: nil, request_id: nil)
            #   Pass arguments to `create_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent (project and location) where the Feature will be
            #     created. Specified in the format `projects/*/locations/*`.
            #   @param feature_id [::String]
            #     The ID of the feature to create.
            #   @param resource [::Google::Cloud::GkeHub::V1::Feature, ::Hash]
            #     The Feature resource to create.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server will guarantee
            #     that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::CreateFeatureRequest.new
            #
            #   # Call the create_feature method.
            #   result = client.create_feature request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::CreateFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :create_feature, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Removes a Membership.
            #
            # **This is currently only supported for GKE clusters on Google Cloud**.
            # To unregister other clusters, follow the instructions at
            # https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
            #
            # @overload delete_membership(request, options = nil)
            #   Pass arguments to `delete_membership` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::DeleteMembershipRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::DeleteMembershipRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_membership(name: nil, request_id: nil, force: nil)
            #   Pass arguments to `delete_membership` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The Membership resource name in the format
            #     `projects/*/locations/*/memberships/*`.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server will guarantee
            #     that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param force [::Boolean]
            #     Optional. If set to true, any subresource from this Membership will also be
            #     deleted. Otherwise, the request will only work if the Membership has no
            #     subresource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::DeleteMembershipRequest.new
            #
            #   # Call the delete_membership method.
            #   result = client.delete_membership request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_membership request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::DeleteMembershipRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_membership.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_membership.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_membership.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :delete_membership, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Removes a Feature.
            #
            # @overload delete_feature(request, options = nil)
            #   Pass arguments to `delete_feature` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::DeleteFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::DeleteFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_feature(name: nil, force: nil, request_id: nil)
            #   Pass arguments to `delete_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The Feature resource name in the format
            #     `projects/*/locations/*/features/*`.
            #   @param force [::Boolean]
            #     If set to true, the delete will ignore any outstanding resources for
            #     this Feature (that is, `FeatureState.has_resources` is set to true). These
            #     resources will NOT be cleaned up or modified in any way.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server will guarantee
            #     that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::DeleteFeatureRequest.new
            #
            #   # Call the delete_feature method.
            #   result = client.delete_feature request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::DeleteFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :delete_feature, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing Membership.
            #
            # @overload update_membership(request, options = nil)
            #   Pass arguments to `update_membership` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::UpdateMembershipRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::UpdateMembershipRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_membership(name: nil, update_mask: nil, resource: nil, request_id: nil)
            #   Pass arguments to `update_membership` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The Membership resource name in the format
            #     `projects/*/locations/*/memberships/*`.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update.
            #   @param resource [::Google::Cloud::GkeHub::V1::Membership, ::Hash]
            #     Required. Only fields specified in update_mask are updated.
            #     If you specify a field in the update_mask but don't specify its value here
            #     that field will be deleted.
            #     If you are updating a map field, set the value of a key to null or empty
            #     string to delete the key from the map. It's not possible to update a key's
            #     value to the empty string.
            #     If you specify the update_mask to be a special path "*", fully replaces all
            #     user-modifiable fields to match `resource`.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server will guarantee
            #     that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::UpdateMembershipRequest.new
            #
            #   # Call the update_membership method.
            #   result = client.update_membership request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_membership request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::UpdateMembershipRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_membership.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_membership.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_membership.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :update_membership, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing Feature.
            #
            # @overload update_feature(request, options = nil)
            #   Pass arguments to `update_feature` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::UpdateFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::UpdateFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_feature(name: nil, update_mask: nil, resource: nil, request_id: nil)
            #   Pass arguments to `update_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The Feature resource name in the format
            #     `projects/*/locations/*/features/*`.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask of fields to update.
            #   @param resource [::Google::Cloud::GkeHub::V1::Feature, ::Hash]
            #     Only fields specified in update_mask are updated.
            #     If you specify a field in the update_mask but don't specify its value here
            #     that field will be deleted.
            #     If you are updating a map field, set the value of a key to null or empty
            #     string to delete the key from the map. It's not possible to update a key's
            #     value to the empty string.
            #     If you specify the update_mask to be a special path "*", fully replaces all
            #     user-modifiable fields to match `resource`.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server will guarantee
            #     that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::UpdateFeatureRequest.new
            #
            #   # Call the update_feature method.
            #   result = client.update_feature request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::UpdateFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :update_feature, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates the manifest for deployment of the GKE connect agent.
            #
            # **This method is used internally by Google-provided libraries.**
            # Most clients should not need to call this method directly.
            #
            # @overload generate_connect_manifest(request, options = nil)
            #   Pass arguments to `generate_connect_manifest` via a request object, either of type
            #   {::Google::Cloud::GkeHub::V1::GenerateConnectManifestRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeHub::V1::GenerateConnectManifestRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_connect_manifest(name: nil, namespace: nil, proxy: nil, version: nil, is_upgrade: nil, registry: nil, image_pull_secret_content: nil)
            #   Pass arguments to `generate_connect_manifest` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The Membership resource name the Agent will associate with, in
            #     the format `projects/*/locations/*/memberships/*`.
            #   @param namespace [::String]
            #     Optional. Namespace for GKE Connect agent resources. Defaults to
            #     `gke-connect`.
            #
            #     The Connect Agent is authorized automatically when run in the default
            #     namespace. Otherwise, explicit authorization must be granted with an
            #     additional IAM binding.
            #   @param proxy [::String]
            #     Optional. URI of a proxy if connectivity from the agent to
            #     gkeconnect.googleapis.com requires the use of a proxy. Format must be in
            #     the form `http(s)://{proxy_address}`, depending on the HTTP/HTTPS protocol
            #     supported by the proxy. This will direct the connect agent's outbound
            #     traffic through a HTTP(S) proxy.
            #   @param version [::String]
            #     Optional. The Connect agent version to use. Defaults to the most current
            #     version.
            #   @param is_upgrade [::Boolean]
            #     Optional. If true, generate the resources for upgrade only. Some resources
            #     generated only for installation (e.g. secrets) will be excluded.
            #   @param registry [::String]
            #     Optional. The registry to fetch the connect agent image from. Defaults to
            #     gcr.io/gkeconnect.
            #   @param image_pull_secret_content [::String]
            #     Optional. The image pull secret content for the registry, if not public.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeHub::V1::GenerateConnectManifestResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeHub::V1::GenerateConnectManifestResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeHub::V1::GkeHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeHub::V1::GenerateConnectManifestRequest.new
            #
            #   # Call the generate_connect_manifest method.
            #   result = client.generate_connect_manifest request
            #
            #   # The returned object is of type Google::Cloud::GkeHub::V1::GenerateConnectManifestResponse.
            #   p result
            #
            def generate_connect_manifest request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1::GenerateConnectManifestRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_connect_manifest.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_connect_manifest.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_connect_manifest.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gke_hub_stub.call_rpc :generate_connect_manifest, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the GkeHub API.
            #
            # This class represents the configuration for GkeHub,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::GkeHub::V1::GkeHub::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_memberships to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::GkeHub::V1::GkeHub::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_memberships.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::GkeHub::V1::GkeHub::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_memberships.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::GkeHub::V1::GkeHub::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "gkehub.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the GkeHub API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_memberships`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_memberships
                ##
                # RPC-specific configuration for `list_features`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_features
                ##
                # RPC-specific configuration for `get_membership`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_membership
                ##
                # RPC-specific configuration for `get_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_feature
                ##
                # RPC-specific configuration for `create_membership`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_membership
                ##
                # RPC-specific configuration for `create_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_feature
                ##
                # RPC-specific configuration for `delete_membership`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_membership
                ##
                # RPC-specific configuration for `delete_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_feature
                ##
                # RPC-specific configuration for `update_membership`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_membership
                ##
                # RPC-specific configuration for `update_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_feature
                ##
                # RPC-specific configuration for `generate_connect_manifest`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_connect_manifest

                # @private
                def initialize parent_rpcs = nil
                  list_memberships_config = parent_rpcs.list_memberships if parent_rpcs.respond_to? :list_memberships
                  @list_memberships = ::Gapic::Config::Method.new list_memberships_config
                  list_features_config = parent_rpcs.list_features if parent_rpcs.respond_to? :list_features
                  @list_features = ::Gapic::Config::Method.new list_features_config
                  get_membership_config = parent_rpcs.get_membership if parent_rpcs.respond_to? :get_membership
                  @get_membership = ::Gapic::Config::Method.new get_membership_config
                  get_feature_config = parent_rpcs.get_feature if parent_rpcs.respond_to? :get_feature
                  @get_feature = ::Gapic::Config::Method.new get_feature_config
                  create_membership_config = parent_rpcs.create_membership if parent_rpcs.respond_to? :create_membership
                  @create_membership = ::Gapic::Config::Method.new create_membership_config
                  create_feature_config = parent_rpcs.create_feature if parent_rpcs.respond_to? :create_feature
                  @create_feature = ::Gapic::Config::Method.new create_feature_config
                  delete_membership_config = parent_rpcs.delete_membership if parent_rpcs.respond_to? :delete_membership
                  @delete_membership = ::Gapic::Config::Method.new delete_membership_config
                  delete_feature_config = parent_rpcs.delete_feature if parent_rpcs.respond_to? :delete_feature
                  @delete_feature = ::Gapic::Config::Method.new delete_feature_config
                  update_membership_config = parent_rpcs.update_membership if parent_rpcs.respond_to? :update_membership
                  @update_membership = ::Gapic::Config::Method.new update_membership_config
                  update_feature_config = parent_rpcs.update_feature if parent_rpcs.respond_to? :update_feature
                  @update_feature = ::Gapic::Config::Method.new update_feature_config
                  generate_connect_manifest_config = parent_rpcs.generate_connect_manifest if parent_rpcs.respond_to? :generate_connect_manifest
                  @generate_connect_manifest = ::Gapic::Config::Method.new generate_connect_manifest_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
