# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/gkebackup/v1/gkebackup_pb"
require "google/cloud/gke_backup/v1/backup_for_gke/rest"


class ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_backup_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_plan = {}
    backup_plan_id = "hello world"

    create_backup_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_create_backup_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_plan_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup_plan({ parent: parent, backup_plan: backup_plan, backup_plan_id: backup_plan_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup_plan parent: parent, backup_plan: backup_plan, backup_plan_id: backup_plan_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup_plan ::Google::Cloud::GkeBackup::V1::CreateBackupPlanRequest.new(parent: parent, backup_plan: backup_plan, backup_plan_id: backup_plan_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup_plan({ parent: parent, backup_plan: backup_plan, backup_plan_id: backup_plan_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup_plan(::Google::Cloud::GkeBackup::V1::CreateBackupPlanRequest.new(parent: parent, backup_plan: backup_plan, backup_plan_id: backup_plan_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_plan_client_stub.call_count
      end
    end
  end

  def test_list_backup_plans
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListBackupPlansResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backup_plans_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_backup_plans_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_plans_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_plans({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_plans parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_plans ::Google::Cloud::GkeBackup::V1::ListBackupPlansRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_plans({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_plans(::Google::Cloud::GkeBackup::V1::ListBackupPlansRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_plans_client_stub.call_count
      end
    end
  end

  def test_get_backup_plan
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::BackupPlan.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_backup_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_plan_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_plan({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_plan name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_plan ::Google::Cloud::GkeBackup::V1::GetBackupPlanRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_plan({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_plan(::Google::Cloud::GkeBackup::V1::GetBackupPlanRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_plan_client_stub.call_count
      end
    end
  end

  def test_update_backup_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    backup_plan = {}
    update_mask = {}

    update_backup_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_update_backup_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_plan_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup_plan({ backup_plan: backup_plan, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup_plan backup_plan: backup_plan, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup_plan ::Google::Cloud::GkeBackup::V1::UpdateBackupPlanRequest.new(backup_plan: backup_plan, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup_plan({ backup_plan: backup_plan, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup_plan(::Google::Cloud::GkeBackup::V1::UpdateBackupPlanRequest.new(backup_plan: backup_plan, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_plan_client_stub.call_count
      end
    end
  end

  def test_delete_backup_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_backup_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_delete_backup_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_plan_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup_plan({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup_plan name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup_plan ::Google::Cloud::GkeBackup::V1::DeleteBackupPlanRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup_plan({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup_plan(::Google::Cloud::GkeBackup::V1::DeleteBackupPlanRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_plan_client_stub.call_count
      end
    end
  end

  def test_create_backup_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_channel = {}
    backup_channel_id = "hello world"

    create_backup_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_create_backup_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_channel_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup_channel({ parent: parent, backup_channel: backup_channel, backup_channel_id: backup_channel_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup_channel parent: parent, backup_channel: backup_channel, backup_channel_id: backup_channel_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup_channel ::Google::Cloud::GkeBackup::V1::CreateBackupChannelRequest.new(parent: parent, backup_channel: backup_channel, backup_channel_id: backup_channel_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup_channel({ parent: parent, backup_channel: backup_channel, backup_channel_id: backup_channel_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup_channel(::Google::Cloud::GkeBackup::V1::CreateBackupChannelRequest.new(parent: parent, backup_channel: backup_channel, backup_channel_id: backup_channel_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_channel_client_stub.call_count
      end
    end
  end

  def test_list_backup_channels
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListBackupChannelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backup_channels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_backup_channels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_channels_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_channels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_channels parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_channels ::Google::Cloud::GkeBackup::V1::ListBackupChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_channels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_channels(::Google::Cloud::GkeBackup::V1::ListBackupChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_channels_client_stub.call_count
      end
    end
  end

  def test_get_backup_channel
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::BackupChannel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_backup_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_channel_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_channel({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_channel name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_channel ::Google::Cloud::GkeBackup::V1::GetBackupChannelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_channel({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_channel(::Google::Cloud::GkeBackup::V1::GetBackupChannelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_channel_client_stub.call_count
      end
    end
  end

  def test_update_backup_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    backup_channel = {}
    update_mask = {}

    update_backup_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_update_backup_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_channel_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup_channel({ backup_channel: backup_channel, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup_channel backup_channel: backup_channel, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup_channel ::Google::Cloud::GkeBackup::V1::UpdateBackupChannelRequest.new(backup_channel: backup_channel, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup_channel({ backup_channel: backup_channel, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup_channel(::Google::Cloud::GkeBackup::V1::UpdateBackupChannelRequest.new(backup_channel: backup_channel, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_channel_client_stub.call_count
      end
    end
  end

  def test_delete_backup_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    force = true

    delete_backup_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_delete_backup_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_channel_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup_channel({ name: name, etag: etag, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup_channel name: name, etag: etag, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup_channel ::Google::Cloud::GkeBackup::V1::DeleteBackupChannelRequest.new(name: name, etag: etag, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup_channel({ name: name, etag: etag, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup_channel(::Google::Cloud::GkeBackup::V1::DeleteBackupChannelRequest.new(name: name, etag: etag, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_channel_client_stub.call_count
      end
    end
  end

  def test_list_backup_plan_bindings
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backup_plan_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_backup_plan_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_plan_bindings_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_plan_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_plan_bindings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_plan_bindings ::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_plan_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_plan_bindings(::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_plan_bindings_client_stub.call_count
      end
    end
  end

  def test_get_backup_plan_binding
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::BackupPlanBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_plan_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_backup_plan_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_plan_binding_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_plan_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_plan_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_plan_binding ::Google::Cloud::GkeBackup::V1::GetBackupPlanBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_plan_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_plan_binding(::Google::Cloud::GkeBackup::V1::GetBackupPlanBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_plan_binding_client_stub.call_count
      end
    end
  end

  def test_create_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup = {}
    backup_id = "hello world"

    create_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_create_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup({ parent: parent, backup: backup, backup_id: backup_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup parent: parent, backup: backup, backup_id: backup_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup ::Google::Cloud::GkeBackup::V1::CreateBackupRequest.new(parent: parent, backup: backup, backup_id: backup_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup({ parent: parent, backup: backup, backup_id: backup_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup(::Google::Cloud::GkeBackup::V1::CreateBackupRequest.new(parent: parent, backup: backup, backup_id: backup_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_client_stub.call_count
      end
    end
  end

  def test_list_backups
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListBackupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    return_partial_success = true

    list_backups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_backups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backups_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backups ::Google::Cloud::GkeBackup::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backups(::Google::Cloud::GkeBackup::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backups_client_stub.call_count
      end
    end
  end

  def test_get_backup
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::Backup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup ::Google::Cloud::GkeBackup::V1::GetBackupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup(::Google::Cloud::GkeBackup::V1::GetBackupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_client_stub.call_count
      end
    end
  end

  def test_update_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    backup = {}
    update_mask = {}

    update_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_update_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup({ backup: backup, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup backup: backup, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup ::Google::Cloud::GkeBackup::V1::UpdateBackupRequest.new(backup: backup, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup({ backup: backup, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup(::Google::Cloud::GkeBackup::V1::UpdateBackupRequest.new(backup: backup, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_client_stub.call_count
      end
    end
  end

  def test_delete_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    force = true

    delete_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_delete_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup({ name: name, etag: etag, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup name: name, etag: etag, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup ::Google::Cloud::GkeBackup::V1::DeleteBackupRequest.new(name: name, etag: etag, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup({ name: name, etag: etag, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup(::Google::Cloud::GkeBackup::V1::DeleteBackupRequest.new(name: name, etag: etag, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_client_stub.call_count
      end
    end
  end

  def test_list_volume_backups
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListVolumeBackupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_volume_backups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_volume_backups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_volume_backups_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_volume_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_volume_backups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_volume_backups ::Google::Cloud::GkeBackup::V1::ListVolumeBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_volume_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_volume_backups(::Google::Cloud::GkeBackup::V1::ListVolumeBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_volume_backups_client_stub.call_count
      end
    end
  end

  def test_get_volume_backup
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::VolumeBackup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_volume_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_volume_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_volume_backup_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_volume_backup({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_volume_backup name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_volume_backup ::Google::Cloud::GkeBackup::V1::GetVolumeBackupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_volume_backup({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_volume_backup(::Google::Cloud::GkeBackup::V1::GetVolumeBackupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_volume_backup_client_stub.call_count
      end
    end
  end

  def test_create_restore_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    restore_plan = {}
    restore_plan_id = "hello world"

    create_restore_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_create_restore_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_restore_plan_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_restore_plan({ parent: parent, restore_plan: restore_plan, restore_plan_id: restore_plan_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_restore_plan parent: parent, restore_plan: restore_plan, restore_plan_id: restore_plan_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_restore_plan ::Google::Cloud::GkeBackup::V1::CreateRestorePlanRequest.new(parent: parent, restore_plan: restore_plan, restore_plan_id: restore_plan_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_restore_plan({ parent: parent, restore_plan: restore_plan, restore_plan_id: restore_plan_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_restore_plan(::Google::Cloud::GkeBackup::V1::CreateRestorePlanRequest.new(parent: parent, restore_plan: restore_plan, restore_plan_id: restore_plan_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_restore_plan_client_stub.call_count
      end
    end
  end

  def test_list_restore_plans
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListRestorePlansResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_restore_plans_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_restore_plans_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_restore_plans_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_restore_plans({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_restore_plans parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_restore_plans ::Google::Cloud::GkeBackup::V1::ListRestorePlansRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_restore_plans({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_restore_plans(::Google::Cloud::GkeBackup::V1::ListRestorePlansRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_restore_plans_client_stub.call_count
      end
    end
  end

  def test_get_restore_plan
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::RestorePlan.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_restore_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_restore_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_restore_plan_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_restore_plan({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_restore_plan name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_restore_plan ::Google::Cloud::GkeBackup::V1::GetRestorePlanRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_restore_plan({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_restore_plan(::Google::Cloud::GkeBackup::V1::GetRestorePlanRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_restore_plan_client_stub.call_count
      end
    end
  end

  def test_update_restore_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    restore_plan = {}
    update_mask = {}

    update_restore_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_update_restore_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_restore_plan_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_restore_plan({ restore_plan: restore_plan, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_restore_plan restore_plan: restore_plan, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_restore_plan ::Google::Cloud::GkeBackup::V1::UpdateRestorePlanRequest.new(restore_plan: restore_plan, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_restore_plan({ restore_plan: restore_plan, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_restore_plan(::Google::Cloud::GkeBackup::V1::UpdateRestorePlanRequest.new(restore_plan: restore_plan, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_restore_plan_client_stub.call_count
      end
    end
  end

  def test_delete_restore_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    force = true

    delete_restore_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_delete_restore_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_restore_plan_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_restore_plan({ name: name, etag: etag, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_restore_plan name: name, etag: etag, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_restore_plan ::Google::Cloud::GkeBackup::V1::DeleteRestorePlanRequest.new(name: name, etag: etag, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_restore_plan({ name: name, etag: etag, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_restore_plan(::Google::Cloud::GkeBackup::V1::DeleteRestorePlanRequest.new(name: name, etag: etag, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_restore_plan_client_stub.call_count
      end
    end
  end

  def test_create_restore_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    restore_channel = {}
    restore_channel_id = "hello world"

    create_restore_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_create_restore_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_restore_channel_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_restore_channel({ parent: parent, restore_channel: restore_channel, restore_channel_id: restore_channel_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_restore_channel parent: parent, restore_channel: restore_channel, restore_channel_id: restore_channel_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_restore_channel ::Google::Cloud::GkeBackup::V1::CreateRestoreChannelRequest.new(parent: parent, restore_channel: restore_channel, restore_channel_id: restore_channel_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_restore_channel({ parent: parent, restore_channel: restore_channel, restore_channel_id: restore_channel_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_restore_channel(::Google::Cloud::GkeBackup::V1::CreateRestoreChannelRequest.new(parent: parent, restore_channel: restore_channel, restore_channel_id: restore_channel_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_restore_channel_client_stub.call_count
      end
    end
  end

  def test_list_restore_channels
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListRestoreChannelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_restore_channels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_restore_channels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_restore_channels_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_restore_channels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_restore_channels parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_restore_channels ::Google::Cloud::GkeBackup::V1::ListRestoreChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_restore_channels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_restore_channels(::Google::Cloud::GkeBackup::V1::ListRestoreChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_restore_channels_client_stub.call_count
      end
    end
  end

  def test_get_restore_channel
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::RestoreChannel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_restore_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_restore_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_restore_channel_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_restore_channel({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_restore_channel name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_restore_channel ::Google::Cloud::GkeBackup::V1::GetRestoreChannelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_restore_channel({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_restore_channel(::Google::Cloud::GkeBackup::V1::GetRestoreChannelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_restore_channel_client_stub.call_count
      end
    end
  end

  def test_update_restore_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    restore_channel = {}
    update_mask = {}

    update_restore_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_update_restore_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_restore_channel_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_restore_channel({ restore_channel: restore_channel, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_restore_channel restore_channel: restore_channel, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_restore_channel ::Google::Cloud::GkeBackup::V1::UpdateRestoreChannelRequest.new(restore_channel: restore_channel, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_restore_channel({ restore_channel: restore_channel, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_restore_channel(::Google::Cloud::GkeBackup::V1::UpdateRestoreChannelRequest.new(restore_channel: restore_channel, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_restore_channel_client_stub.call_count
      end
    end
  end

  def test_delete_restore_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_restore_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_delete_restore_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_restore_channel_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_restore_channel({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_restore_channel name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_restore_channel ::Google::Cloud::GkeBackup::V1::DeleteRestoreChannelRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_restore_channel({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_restore_channel(::Google::Cloud::GkeBackup::V1::DeleteRestoreChannelRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_restore_channel_client_stub.call_count
      end
    end
  end

  def test_list_restore_plan_bindings
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_restore_plan_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_restore_plan_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_restore_plan_bindings_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_restore_plan_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_restore_plan_bindings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_restore_plan_bindings ::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_restore_plan_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_restore_plan_bindings(::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_restore_plan_bindings_client_stub.call_count
      end
    end
  end

  def test_get_restore_plan_binding
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::RestorePlanBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_restore_plan_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_restore_plan_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_restore_plan_binding_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_restore_plan_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_restore_plan_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_restore_plan_binding ::Google::Cloud::GkeBackup::V1::GetRestorePlanBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_restore_plan_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_restore_plan_binding(::Google::Cloud::GkeBackup::V1::GetRestorePlanBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_restore_plan_binding_client_stub.call_count
      end
    end
  end

  def test_create_restore
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    restore = {}
    restore_id = "hello world"

    create_restore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_create_restore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_restore_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_restore({ parent: parent, restore: restore, restore_id: restore_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_restore parent: parent, restore: restore, restore_id: restore_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_restore ::Google::Cloud::GkeBackup::V1::CreateRestoreRequest.new(parent: parent, restore: restore, restore_id: restore_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_restore({ parent: parent, restore: restore, restore_id: restore_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_restore(::Google::Cloud::GkeBackup::V1::CreateRestoreRequest.new(parent: parent, restore: restore, restore_id: restore_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_restore_client_stub.call_count
      end
    end
  end

  def test_list_restores
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListRestoresResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_restores_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_restores_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_restores_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_restores({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_restores parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_restores ::Google::Cloud::GkeBackup::V1::ListRestoresRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_restores({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_restores(::Google::Cloud::GkeBackup::V1::ListRestoresRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_restores_client_stub.call_count
      end
    end
  end

  def test_get_restore
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::Restore.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_restore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_restore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_restore_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_restore({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_restore name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_restore ::Google::Cloud::GkeBackup::V1::GetRestoreRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_restore({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_restore(::Google::Cloud::GkeBackup::V1::GetRestoreRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_restore_client_stub.call_count
      end
    end
  end

  def test_update_restore
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    restore = {}
    update_mask = {}

    update_restore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_update_restore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_restore_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_restore({ restore: restore, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_restore restore: restore, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_restore ::Google::Cloud::GkeBackup::V1::UpdateRestoreRequest.new(restore: restore, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_restore({ restore: restore, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_restore(::Google::Cloud::GkeBackup::V1::UpdateRestoreRequest.new(restore: restore, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_restore_client_stub.call_count
      end
    end
  end

  def test_delete_restore
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    force = true

    delete_restore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_delete_restore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_restore_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_restore({ name: name, etag: etag, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_restore name: name, etag: etag, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_restore ::Google::Cloud::GkeBackup::V1::DeleteRestoreRequest.new(name: name, etag: etag, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_restore({ name: name, etag: etag, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_restore(::Google::Cloud::GkeBackup::V1::DeleteRestoreRequest.new(name: name, etag: etag, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_restore_client_stub.call_count
      end
    end
  end

  def test_list_volume_restores
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::ListVolumeRestoresResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_volume_restores_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_list_volume_restores_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_volume_restores_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_volume_restores({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_volume_restores parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_volume_restores ::Google::Cloud::GkeBackup::V1::ListVolumeRestoresRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_volume_restores({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_volume_restores(::Google::Cloud::GkeBackup::V1::ListVolumeRestoresRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_volume_restores_client_stub.call_count
      end
    end
  end

  def test_get_volume_restore
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::VolumeRestore.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_volume_restore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_volume_restore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_volume_restore_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_volume_restore({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_volume_restore name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_volume_restore ::Google::Cloud::GkeBackup::V1::GetVolumeRestoreRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_volume_restore({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_volume_restore(::Google::Cloud::GkeBackup::V1::GetVolumeRestoreRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_volume_restore_client_stub.call_count
      end
    end
  end

  def test_get_backup_index_download_url
    # Create test objects.
    client_result = ::Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    backup = "hello world"

    get_backup_index_download_url_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::ServiceStub.stub :transcode_get_backup_index_download_url_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_index_download_url_client_stub do
        # Create client
        client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_index_download_url({ backup: backup }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_index_download_url backup: backup do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_index_download_url ::Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlRequest.new(backup: backup) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_index_download_url({ backup: backup }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_index_download_url(::Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlRequest.new(backup: backup), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_index_download_url_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GkeBackup::V1::BackupForGKE::Rest::Client::Configuration, config
  end
end
