# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeBackup
      module V1
        # A RestorePlanBinding binds a RestorePlan with a RestoreChannel.
        # This resource is created automatically when a RestorePlan is created using a
        # RestoreChannel. This also serves as a holder for cross-project fields
        # that need to be displayed in the current project.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The fully qualified name of the RestorePlanBinding.
        #     `projects/*/locations/*/restoreChannels/*/restorePlanBindings/*`
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server generated global unique identifier of
        #     [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this binding was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this binding was created.
        # @!attribute [r] restore_plan
        #   @return [::String]
        #     Output only. The fully qualified name of the RestorePlan bound to this
        #     RestoreChannel. `projects/*/locations/*/restorePlans/{restore_plan}`
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. `etag` is used for optimistic concurrency control as a way to
        #     help prevent simultaneous updates of a RestorePlanBinding from overwriting
        #     each other. It is strongly suggested that systems make use of the 'etag' in
        #     the read-modify-write cycle to perform RestorePlanBinding updates in
        #     order to avoid race conditions: An `etag` is returned in the response to
        #     `GetRestorePlanBinding`, and systems are expected to put that etag in
        #     the request to `UpdateRestorePlanBinding` or
        #     `DeleteRestorePlanBinding` to ensure that their change will be applied
        #     to the same version of the resource.
        # @!attribute [r] backup_plan
        #   @return [::String]
        #     Output only. The fully qualified name of the BackupPlan bound to the
        #     specified RestorePlan. `projects/*/locations/*/backukpPlans/{backup_plan}`
        class RestorePlanBinding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
