# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeBackup
      module V1
        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateBackupPlan.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location within which to create the BackupPlan.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] backup_plan
        #   @return [::Google::Cloud::GkeBackup::V1::BackupPlan]
        #     Required. The BackupPlan resource object to create.
        # @!attribute [rw] backup_plan_id
        #   @return [::String]
        #     Required. The client-provided short name for the BackupPlan resource.
        #     This name must:
        #
        #     - be between 1 and 63 characters long (inclusive)
        #     - consist of only lower-case ASCII letters, numbers, and dashes
        #     - start with a lower-case letter
        #     - end with a lower-case letter or number
        #     - be unique within the set of BackupPlans in this location
        class CreateBackupPlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListBackupPlans.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location that contains the BackupPlans to list.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListBackupPlansResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListBackupPlansResponse#next_page_token next_page_token}
        #     received from a previous `ListBackupPlans` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListBackupPlans` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListBackupPlansRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListBackupPlans.
        # @!attribute [rw] backup_plans
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::BackupPlan>]
        #     The list of BackupPlans matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListBackupPlansRequest#page_token page_token}
        #     in a subsequent `ListBackupPlans` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupPlansResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetBackupPlan.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified BackupPlan name.
        #     Format: `projects/*/locations/*/backupPlans/*`
        class GetBackupPlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateBackupPlan.
        # @!attribute [rw] backup_plan
        #   @return [::Google::Cloud::GkeBackup::V1::BackupPlan]
        #     Required. A new version of the BackupPlan resource that contains updated
        #     fields. This may be sparsely populated if an `update_mask` is provided.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. This is used to specify the fields to be overwritten in the
        #     BackupPlan targeted for update. The values for each of these
        #     updated fields will be taken from the `backup_plan` provided
        #     with this request. Field names are relative to the root of the resource
        #     (e.g., `description`, `backup_config.include_volume_data`, etc.)
        #     If no `update_mask` is provided, all fields in `backup_plan` will be
        #     written to the target BackupPlan resource.
        #     Note that OUTPUT_ONLY and IMMUTABLE fields in `backup_plan` are ignored
        #     and are not used to update the target BackupPlan.
        class UpdateBackupPlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteBackupPlan.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified BackupPlan name.
        #     Format: `projects/*/locations/*/backupPlans/*`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If provided, this value must match the current value of the
        #     target BackupPlan's {::Google::Cloud::GkeBackup::V1::BackupPlan#etag etag} field
        #     or the request is rejected.
        class DeleteBackupPlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateBackupChannel.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location within which to create the BackupChannel.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] backup_channel
        #   @return [::Google::Cloud::GkeBackup::V1::BackupChannel]
        #     Required. The BackupChannel resource object to create.
        # @!attribute [rw] backup_channel_id
        #   @return [::String]
        #     Optional. The client-provided short name for the BackupChannel resource.
        #     This name must:
        #
        #     - be between 1 and 63 characters long (inclusive)
        #     - consist of only lower-case ASCII letters, numbers, and dashes
        #     - start with a lower-case letter
        #     - end with a lower-case letter or number
        #     - be unique within the set of BackupChannels in this location
        #     If the user does not provide a name, a uuid will be used as the name.
        class CreateBackupChannelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListBackupChannels.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location that contains the BackupChannels to list.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListBackupChannelsResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListBackupChannelsResponse#next_page_token next_page_token}
        #     received from a previous `ListBackupChannels` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListBackupChannels` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListBackupChannelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListBackupChannels.
        # @!attribute [rw] backup_channels
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::BackupChannel>]
        #     The list of BackupChannels matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListBackupChannelsRequest#page_token page_token}
        #     in a subsequent `ListBackupChannels` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupChannelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetBackupChannel.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified BackupChannel name.
        #     Format: `projects/*/locations/*/backupChannels/*`
        class GetBackupChannelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateBackupChannel.
        # @!attribute [rw] backup_channel
        #   @return [::Google::Cloud::GkeBackup::V1::BackupChannel]
        #     Required. A new version of the BackupChannel resource that contains updated
        #     fields. This may be sparsely populated if an `update_mask` is provided.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. This is used to specify the fields to be overwritten in the
        #     BackupChannel targeted for update. The values for each of these
        #     updated fields will be taken from the `backup_channel` provided
        #     with this request. Field names are relative to the root of the resource
        #     (e.g., `description`, `labels`, etc.)
        #     If no `update_mask` is provided, all fields in `backup_channel` will
        #     be written to the target BackupChannel resource. Note that
        #     OUTPUT_ONLY and IMMUTABLE fields in `backup_channel` are ignored and
        #     are not used to update the target BackupChannel.
        class UpdateBackupChannelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteBackupChannel.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified BackupChannel name.
        #     Format: `projects/*/locations/*/backupChannels/*`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If provided, this value must match the current value of the
        #     target BackupChannel's {::Google::Cloud::GkeBackup::V1::BackupChannel#etag etag}
        #     field or the request is rejected.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any BackupPlanAssociations below this
        #     BackupChannel will also be deleted. Otherwise, the request will only
        #     succeed if the BackupChannel has no BackupPlanAssociations.
        class DeleteBackupChannelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListBackupPlanBindings.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The BackupChannel that contains the BackupPlanBindings to list.
        #     Format: `projects/*/locations/*/backupChannels/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsResponse#next_page_token next_page_token}
        #     received from a previous `ListBackupPlanBindings` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListBackupPlanBindings` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListBackupPlanBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListBackupPlanBindings.
        # @!attribute [rw] backup_plan_bindings
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::BackupPlanBinding>]
        #     The list of BackupPlanBindings matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsRequest#page_token page_token}
        #     in a subsequent `ListBackupPlanBindingss` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupPlanBindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetBackupPlanBinding.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified BackupPlanBinding name.
        #     Format:
        #     `projects/*/locations/*/backupChannels/*/backupPlanBindings/*`
        class GetBackupPlanBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateBackup.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The BackupPlan within which to create the Backup.
        #     Format: `projects/*/locations/*/backupPlans/*`
        # @!attribute [rw] backup
        #   @return [::Google::Cloud::GkeBackup::V1::Backup]
        #     Optional. The Backup resource to create.
        # @!attribute [rw] backup_id
        #   @return [::String]
        #     Optional. The client-provided short name for the Backup resource.
        #     This name must:
        #
        #     - be between 1 and 63 characters long (inclusive)
        #     - consist of only lower-case ASCII letters, numbers, and dashes
        #     - start with a lower-case letter
        #     - end with a lower-case letter or number
        #     - be unique within the set of Backups in this BackupPlan
        class CreateBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListBackups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The BackupPlan that contains the Backups to list.
        #     Format: `projects/*/locations/*/backupPlans/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListBackupsResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListBackupsResponse#next_page_token next_page_token}
        #     received from a previous `ListBackups` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListBackups` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If set to true, the response will return partial results when
        #     some regions are unreachable and the unreachable field will be populated.
        class ListBackupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListBackups.
        # @!attribute [rw] backups
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::Backup>]
        #     The list of Backups matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListBackupsRequest#page_token page_token} in a
        #     subsequent `ListBackups` call to retrieve the next page of results. If this
        #     field is omitted or empty, then there are no more results to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetBackup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full name of the Backup resource.
        #     Format: `projects/*/locations/*/backupPlans/*/backups/*`
        class GetBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateBackup.
        # @!attribute [rw] backup
        #   @return [::Google::Cloud::GkeBackup::V1::Backup]
        #     Required. A new version of the Backup resource that contains updated
        #     fields. This may be sparsely populated if an `update_mask` is provided.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. This is used to specify the fields to be overwritten in the
        #     Backup targeted for update. The values for each of these
        #     updated fields will be taken from the `backup_plan` provided
        #     with this request. Field names are relative to the root of the resource.
        #     If no `update_mask` is provided, all fields in `backup` will be
        #     written to the target Backup resource.
        #     Note that OUTPUT_ONLY and IMMUTABLE fields in `backup` are ignored
        #     and are not used to update the target Backup.
        class UpdateBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteBackup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Backup resource.
        #     Format: `projects/*/locations/*/backupPlans/*/backups/*`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If provided, this value must match the current value of the
        #     target Backup's {::Google::Cloud::GkeBackup::V1::Backup#etag etag} field or the
        #     request is rejected.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any VolumeBackups below this Backup will also be
        #     deleted. Otherwise, the request will only succeed if the Backup has no
        #     VolumeBackups.
        class DeleteBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListVolumeBackups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Backup that contains the VolumeBackups to list.
        #     Format: `projects/*/locations/*/backupPlans/*/backups/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListVolumeBackupsResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListVolumeBackupsResponse#next_page_token next_page_token}
        #     received from a previous `ListVolumeBackups` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListVolumeBackups` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListVolumeBackupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListVolumeBackups.
        # @!attribute [rw] volume_backups
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::VolumeBackup>]
        #     The list of VolumeBackups matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListVolumeBackupsRequest#page_token page_token}
        #     in a subsequent `ListVolumeBackups` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        class ListVolumeBackupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetVolumeBackup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full name of the VolumeBackup resource.
        #     Format: `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`
        class GetVolumeBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateRestorePlan.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location within which to create the RestorePlan.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] restore_plan
        #   @return [::Google::Cloud::GkeBackup::V1::RestorePlan]
        #     Required. The RestorePlan resource object to create.
        # @!attribute [rw] restore_plan_id
        #   @return [::String]
        #     Required. The client-provided short name for the RestorePlan resource.
        #     This name must:
        #
        #     - be between 1 and 63 characters long (inclusive)
        #     - consist of only lower-case ASCII letters, numbers, and dashes
        #     - start with a lower-case letter
        #     - end with a lower-case letter or number
        #     - be unique within the set of RestorePlans in this location
        class CreateRestorePlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRestorePlans.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location that contains the RestorePlans to list.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListRestorePlansResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListRestorePlansResponse#next_page_token next_page_token}
        #     received from a previous `ListRestorePlans` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListRestorePlans` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListRestorePlansRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRestorePlans.
        # @!attribute [rw] restore_plans
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::RestorePlan>]
        #     The list of RestorePlans matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListRestorePlansRequest#page_token page_token}
        #     in a subsequent `ListRestorePlans` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListRestorePlansResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetRestorePlan.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified RestorePlan name.
        #     Format: `projects/*/locations/*/restorePlans/*`
        class GetRestorePlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateRestorePlan.
        # @!attribute [rw] restore_plan
        #   @return [::Google::Cloud::GkeBackup::V1::RestorePlan]
        #     Required. A new version of the RestorePlan resource that contains updated
        #     fields. This may be sparsely populated if an `update_mask` is provided.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. This is used to specify the fields to be overwritten in the
        #     RestorePlan targeted for update. The values for each of these
        #     updated fields will be taken from the `restore_plan` provided
        #     with this request. Field names are relative to the root of the resource.
        #     If no `update_mask` is provided, all fields in `restore_plan` will be
        #     written to the target RestorePlan resource.
        #     Note that OUTPUT_ONLY and IMMUTABLE fields in `restore_plan` are ignored
        #     and are not used to update the target RestorePlan.
        class UpdateRestorePlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteRestorePlan.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified RestorePlan name.
        #     Format: `projects/*/locations/*/restorePlans/*`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If provided, this value must match the current value of the
        #     target RestorePlan's {::Google::Cloud::GkeBackup::V1::RestorePlan#etag etag}
        #     field or the request is rejected.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any Restores below this RestorePlan will also be
        #     deleted. Otherwise, the request will only succeed if the RestorePlan has no
        #     Restores.
        class DeleteRestorePlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateRestoreChannel.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location within which to create the RestoreChannel.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] restore_channel
        #   @return [::Google::Cloud::GkeBackup::V1::RestoreChannel]
        #     Required. The RestoreChannel resource object to create.
        # @!attribute [rw] restore_channel_id
        #   @return [::String]
        #     Optional. The client-provided short name for the RestoreChannel resource.
        #     This name must:
        #
        #     - be between 1 and 63 characters long (inclusive)
        #     - consist of only lower-case ASCII letters, numbers, and dashes
        #     - start with a lower-case letter
        #     - end with a lower-case letter or number
        #     - be unique within the set of RestoreChannels in this location
        #     If the user does not provide a name, a uuid will be used as the name.
        class CreateRestoreChannelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRestoreChannels.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location that contains the RestoreChannels to list.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListRestoreChannelsResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListRestoreChannelsResponse#next_page_token next_page_token}
        #     received from a previous `ListRestoreChannels` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListRestoreChannels` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListRestoreChannelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRestoreChannels.
        # @!attribute [rw] restore_channels
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::RestoreChannel>]
        #     The list of RestoreChannels matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListRestoreChannelsRequest#page_token page_token}
        #     in a subsequent `ListRestoreChannels` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListRestoreChannelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetRestoreChannel.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified RestoreChannel name.
        #     Format: `projects/*/locations/*/restoreChannels/*`
        class GetRestoreChannelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateRestoreChannel.
        # @!attribute [rw] restore_channel
        #   @return [::Google::Cloud::GkeBackup::V1::RestoreChannel]
        #     Required. A new version of the RestoreChannel resource that contains
        #     updated fields. This may be sparsely populated if an `update_mask` is
        #     provided.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. This is used to specify the fields to be overwritten in the
        #     RestoreChannel targeted for update. The values for each of these
        #     updated fields will be taken from the `restore_channel` provided
        #     with this request. Field names are relative to the root of the resource
        #     (e.g., `description`, `destination_project_id`, etc.)
        #     If no `update_mask` is provided, all fields in `restore_channel` will
        #     be written to the target RestoreChannel resource. Note that
        #     OUTPUT_ONLY and IMMUTABLE fields in `restore_channel` are ignored and
        #     are not used to update the target RestoreChannel.
        class UpdateRestoreChannelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteRestoreChannel.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified RestoreChannel name.
        #     Format: `projects/*/locations/*/restoreChannels/*`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If provided, this value must match the current value of the
        #     target RestoreChannel's
        #     {::Google::Cloud::GkeBackup::V1::RestoreChannel#etag etag} field or the request
        #     is rejected.
        class DeleteRestoreChannelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRestorePlanBindings.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The RestoreChannel that contains the ListRestorePlanBindings to
        #     list. Format: `projects/*/locations/*/restoreChannels/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsResponse#next_page_token next_page_token}
        #     received from a previous `ListRestorePlanBindings` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListRestorePlanBindings` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListRestorePlanBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRestorePlanBindings.
        # @!attribute [rw] restore_plan_bindings
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::RestorePlanBinding>]
        #     The list of RestorePlanBindings matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsRequest#page_token page_token}
        #     in a subsequent `ListRestorePlanBindings` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListRestorePlanBindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetRestorePlanBinding.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified RestorePlanBinding name.
        #     Format:
        #     `projects/*/locations/*/restoreChannels/*/restorePlanBindings/*`
        class GetRestorePlanBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateRestore.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The RestorePlan within which to create the Restore.
        #     Format: `projects/*/locations/*/restorePlans/*`
        # @!attribute [rw] restore
        #   @return [::Google::Cloud::GkeBackup::V1::Restore]
        #     Required. The restore resource to create.
        # @!attribute [rw] restore_id
        #   @return [::String]
        #     Required. The client-provided short name for the Restore resource.
        #     This name must:
        #
        #     - be between 1 and 63 characters long (inclusive)
        #     - consist of only lower-case ASCII letters, numbers, and dashes
        #     - start with a lower-case letter
        #     - end with a lower-case letter or number
        #     - be unique within the set of Restores in this RestorePlan.
        class CreateRestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRestores.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The RestorePlan that contains the Restores to list.
        #     Format: `projects/*/locations/*/restorePlans/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListRestoresResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListRestoresResponse#next_page_token next_page_token}
        #     received from a previous `ListRestores` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to `ListRestores`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListRestoresRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRestores.
        # @!attribute [rw] restores
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::Restore>]
        #     The list of Restores matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListRestoresRequest#page_token page_token} in a
        #     subsequent `ListRestores` call to retrieve the next page of results. If
        #     this field is omitted or empty, then there are no more results to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListRestoresResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetRestore.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the restore resource.
        #     Format: `projects/*/locations/*/restorePlans/*/restores/*`
        class GetRestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateRestore.
        # @!attribute [rw] restore
        #   @return [::Google::Cloud::GkeBackup::V1::Restore]
        #     Required. A new version of the Restore resource that contains updated
        #     fields. This may be sparsely populated if an `update_mask` is provided.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. This is used to specify the fields to be overwritten in the
        #     Restore targeted for update. The values for each of these
        #     updated fields will be taken from the `restore` provided
        #     with this request. Field names are relative to the root of the resource.
        #     If no `update_mask` is provided, all fields in `restore` will be
        #     written to the target Restore resource.
        #     Note that OUTPUT_ONLY and IMMUTABLE fields in `restore` are ignored
        #     and are not used to update the target Restore.
        class UpdateRestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteRestore.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full name of the Restore
        #     Format: `projects/*/locations/*/restorePlans/*/restores/*`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If provided, this value must match the current value of the
        #     target Restore's {::Google::Cloud::GkeBackup::V1::Restore#etag etag} field or
        #     the request is rejected.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any VolumeRestores below this restore will also
        #     be deleted. Otherwise, the request will only succeed if the restore has no
        #     VolumeRestores.
        class DeleteRestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListVolumeRestores.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Restore that contains the VolumeRestores to list.
        #     Format: `projects/*/locations/*/restorePlans/*/restores/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeBackup::V1::ListVolumeRestoresResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeBackup::V1::ListVolumeRestoresResponse#next_page_token next_page_token}
        #     received from a previous `ListVolumeRestores` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListVolumeRestores` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListVolumeRestoresRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListVolumeRestores.
        # @!attribute [rw] volume_restores
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::VolumeRestore>]
        #     The list of VolumeRestores matching the given criteria.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::GkeBackup::V1::ListVolumeRestoresRequest#page_token page_token}
        #     in a subsequent `ListVolumeRestores` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        class ListVolumeRestoresResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetVolumeRestore.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full name of the VolumeRestore resource.
        #     Format: `projects/*/locations/*/restorePlans/*/restores/*/volumeRestores/*`
        class GetVolumeRestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetBackupIndexDownloadUrl.
        # @!attribute [rw] backup
        #   @return [::String]
        #     Required. Full name of Backup resource.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/backupPlans/\\{backup_plan}/backups/\\{backup}
        class GetBackupIndexDownloadUrlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for GetBackupIndexDownloadUrl.
        # @!attribute [rw] signed_url
        #   @return [::String]
        #     Required. The signed URL for downloading the backup index.
        class GetBackupIndexDownloadUrlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
