# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeBackup
      module V1
        # A BackupPlanBinding binds a BackupPlan with a BackupChannel.
        # This resource is created automatically when a BackupPlan is created using a
        # BackupChannel. This also serves as a holder for cross-project fields
        # that need to be displayed in the current project.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The fully qualified name of the BackupPlanBinding.
        #     `projects/*/locations/*/backupChannels/*/backupPlanBindings/*`
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server generated global unique identifier of
        #     [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this binding was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this binding was created.
        # @!attribute [r] backup_plan
        #   @return [::String]
        #     Output only. Immutable. The fully qualified name of the BackupPlan bound
        #     with the parent BackupChannel.
        #     `projects/*/locations/*/backupPlans/{backup_plan}`
        # @!attribute [r] cluster
        #   @return [::String]
        #     Output only. Immutable. The fully qualified name of the cluster that is
        #     being backed up Valid formats:
        #
        #     - `projects/*/locations/*/clusters/*`
        #     - `projects/*/zones/*/clusters/*`
        # @!attribute [r] backup_plan_details
        #   @return [::Google::Cloud::GkeBackup::V1::BackupPlanBinding::BackupPlanDetails]
        #     Output only. Contains details about the backup plan/backup.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. `etag` is used for optimistic concurrency control as a way to
        #     help prevent simultaneous updates of a BackupPlanBinding from overwriting
        #     each other. It is strongly suggested that systems make use of the 'etag' in
        #     the read-modify-write cycle to perform BackupPlanBinding updates in
        #     order to avoid race conditions: An `etag` is returned in the response to
        #     `GetBackupPlanBinding`, and systems are expected to put that etag in
        #     the request to `UpdateBackupPlanBinding` or
        #     `DeleteBackupPlanBinding` to ensure that their change will be applied
        #     to the same version of the resource.
        class BackupPlanBinding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains metadata about the backup plan/backup.
          # @!attribute [r] protected_pod_count
          #   @return [::Integer]
          #     Output only. The number of Kubernetes Pods backed up in the
          #     last successful Backup created via this BackupPlan.
          # @!attribute [r] state
          #   @return [::Google::Cloud::GkeBackup::V1::BackupPlanBinding::BackupPlanDetails::State]
          #     Output only. State of the BackupPlan.
          # @!attribute [r] last_successful_backup_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Completion time of the last successful Backup. This is
          #     sourced from a successful Backup's complete_time field.
          # @!attribute [r] next_scheduled_backup_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Start time of next scheduled backup under this BackupPlan by
          #     either cron_schedule or rpo config. This is sourced from BackupPlan.
          # @!attribute [r] rpo_risk_level
          #   @return [::Integer]
          #     Output only. A number that represents the current risk level of this
          #     BackupPlan from RPO perspective with 1 being no risk and 5 being highest
          #     risk.
          # @!attribute [r] last_successful_backup
          #   @return [::String]
          #     Output only. The fully qualified name of the last successful Backup
          #     created under this BackupPlan.
          #     `projects/*/locations/*/backupPlans/*/backups/*`
          # @!attribute [r] backup_config_details
          #   @return [::Google::Cloud::GkeBackup::V1::BackupPlanBinding::BackupPlanDetails::BackupConfigDetails]
          #     Output only. Contains details about the BackupConfig of Backups created
          #     via this BackupPlan.
          # @!attribute [r] retention_policy_details
          #   @return [::Google::Cloud::GkeBackup::V1::BackupPlanBinding::BackupPlanDetails::RetentionPolicyDetails]
          #     Output only. Contains details about the RetentionPolicy of Backups
          #     created via this BackupPlan.
          class BackupPlanDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # BackupConfigDetails defines the configuration of Backups created via this
            # BackupPlan.
            # @!attribute [r] all_namespaces
            #   @return [::Boolean]
            #     Output only. If True, include all namespaced resources
            #
            #     Note: The following fields are mutually exclusive: `all_namespaces`, `selected_namespaces`, `selected_applications`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [r] selected_namespaces
            #   @return [::Google::Cloud::GkeBackup::V1::Namespaces]
            #     Output only. If set, include just the resources in the listed
            #     namespaces.
            #
            #     Note: The following fields are mutually exclusive: `selected_namespaces`, `all_namespaces`, `selected_applications`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [r] selected_applications
            #   @return [::Google::Cloud::GkeBackup::V1::NamespacedNames]
            #     Output only. If set, include just the resources referenced by the
            #     listed ProtectedApplications.
            #
            #     Note: The following fields are mutually exclusive: `selected_applications`, `all_namespaces`, `selected_namespaces`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [r] include_volume_data
            #   @return [::Boolean]
            #     Output only. This flag specifies whether volume data should be backed
            #     up when PVCs are included in the scope of a Backup.
            #
            #     Default: False
            # @!attribute [r] include_secrets
            #   @return [::Boolean]
            #     Output only. This flag specifies whether Kubernetes Secret resources
            #     should be included when they fall into the scope of Backups.
            #
            #     Default: False
            # @!attribute [r] encryption_key
            #   @return [::Google::Cloud::GkeBackup::V1::EncryptionKey]
            #     Output only. This defines a customer managed encryption key that will
            #     be used to encrypt the "config" portion (the Kubernetes resources) of
            #     Backups created via this plan.
            #
            #     Default (empty): Config backup artifacts will not be encrypted.
            class BackupConfigDetails
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # RetentionPolicyDetails defines a Backup retention policy for a
            # BackupPlan.
            # @!attribute [rw] backup_delete_lock_days
            #   @return [::Integer]
            #     Optional. Minimum age for Backups created via this BackupPlan (in
            #     days). This field MUST be an integer value between 0-90 (inclusive). A
            #     Backup created under this BackupPlan will NOT be deletable until it
            #     reaches Backup's (create_time + backup_delete_lock_days).
            #     Updating this field of a BackupPlan does NOT affect existing Backups
            #     under it. Backups created AFTER a successful update will inherit
            #     the new value.
            #
            #     Default: 0 (no delete blocking)
            # @!attribute [rw] backup_retain_days
            #   @return [::Integer]
            #     Optional. The default maximum age of a Backup created via this
            #     BackupPlan. This field MUST be an integer value >= 0 and <= 365. If
            #     specified, a Backup created under this BackupPlan will be automatically
            #     deleted after its age reaches (create_time + backup_retain_days). If
            #     not specified, Backups created under this BackupPlan will NOT be
            #     subject to automatic deletion.
            #     Default: 0 (no automatic deletion)
            class RetentionPolicyDetails
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State
            module State
              # Default first value for Enums.
              STATE_UNSPECIFIED = 0

              # Waiting for cluster state to be RUNNING.
              CLUSTER_PENDING = 1

              # The BackupPlan is in the process of being created.
              PROVISIONING = 2

              # The BackupPlan has successfully been created and is ready for Backups.
              READY = 3

              # BackupPlan creation has failed.
              FAILED = 4

              # The BackupPlan has been deactivated.
              DEACTIVATED = 5

              # The BackupPlan is in the process of being deleted.
              DELETING = 6
            end
          end
        end
      end
    end
  end
end
