# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeBackup
      module V1
        # Defines the configuration and scheduling for a "line" of Backups.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The full name of the BackupPlan resource.
        #     Format: `projects/*/locations/*/backupPlans/*`
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server generated global unique identifier of
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this BackupPlan resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this BackupPlan resource was last
        #     updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User specified descriptive string for this BackupPlan.
        # @!attribute [rw] cluster
        #   @return [::String]
        #     Required. Immutable. The source cluster from which Backups will be created
        #     via this BackupPlan. Valid formats:
        #
        #     - `projects/*/locations/*/clusters/*`
        #     - `projects/*/zones/*/clusters/*`
        # @!attribute [rw] retention_policy
        #   @return [::Google::Cloud::GkeBackup::V1::BackupPlan::RetentionPolicy]
        #     Optional. RetentionPolicy governs lifecycle of Backups created under this
        #     plan.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. A set of custom labels supplied by user.
        # @!attribute [rw] backup_schedule
        #   @return [::Google::Cloud::GkeBackup::V1::BackupPlan::Schedule]
        #     Optional. Defines a schedule for automatic Backup creation via this
        #     BackupPlan.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. `etag` is used for optimistic concurrency control as a way to
        #     help prevent simultaneous updates of a backup plan from overwriting each
        #     other. It is strongly suggested that systems make use of the 'etag' in the
        #     read-modify-write cycle to perform BackupPlan updates in order to avoid
        #     race conditions: An `etag` is returned in the response to `GetBackupPlan`,
        #     and systems are expected to put that etag in the request to
        #     `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
        #     will be applied to the same version of the resource.
        # @!attribute [rw] deactivated
        #   @return [::Boolean]
        #     Optional. This flag indicates whether this BackupPlan has been deactivated.
        #     Setting this field to True locks the BackupPlan such that no further
        #     updates will be allowed (except deletes), including the deactivated field
        #     itself. It also prevents any new Backups from being created via this
        #     BackupPlan (including scheduled Backups).
        #
        #     Default: False
        # @!attribute [rw] backup_config
        #   @return [::Google::Cloud::GkeBackup::V1::BackupPlan::BackupConfig]
        #     Optional. Defines the configuration of Backups created via this BackupPlan.
        # @!attribute [r] protected_pod_count
        #   @return [::Integer]
        #     Output only. The number of Kubernetes Pods backed up in the
        #     last successful Backup created via this BackupPlan.
        # @!attribute [r] state
        #   @return [::Google::Cloud::GkeBackup::V1::BackupPlan::State]
        #     Output only. State of the BackupPlan. This State field reflects the
        #     various stages a BackupPlan can be in
        #     during the Create operation. It will be set to "DEACTIVATED"
        #     if the BackupPlan is deactivated on an Update
        # @!attribute [r] state_reason
        #   @return [::String]
        #     Output only. Human-readable description of why BackupPlan is in the current
        #     `state`. This field is only meant for human readability and should not be
        #     used programmatically as this field is not guaranteed to be consistent.
        # @!attribute [r] rpo_risk_level
        #   @return [::Integer]
        #     Output only. A number that represents the current risk level of this
        #     BackupPlan from RPO perspective with 1 being no risk and 5 being highest
        #     risk.
        # @!attribute [r] rpo_risk_reason
        #   @return [::String]
        #     Output only. Human-readable description of why the BackupPlan is in the
        #     current rpo_risk_level and action items if any.
        # @!attribute [r] backup_channel
        #   @return [::String]
        #     Output only. The fully qualified name of the BackupChannel to be used to
        #     create a backup. This field is set only if the cluster being backed up is
        #     in a different project.
        #     `projects/*/locations/*/backupChannels/*`
        # @!attribute [r] last_successful_backup_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Completion time of the last successful Backup. This is sourced
        #     from a successful Backup's complete_time field. This field is added to
        #     maintain consistency with BackupPlanBinding to display last successful
        #     backup time.
        class BackupPlan
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # RetentionPolicy defines a Backup retention policy for a BackupPlan.
          # @!attribute [rw] backup_delete_lock_days
          #   @return [::Integer]
          #     Optional. Minimum age for Backups created via this BackupPlan (in days).
          #     This field MUST be an integer value between 0-90 (inclusive).
          #     A Backup created under this BackupPlan will NOT be deletable until it
          #     reaches Backup's (create_time + backup_delete_lock_days).
          #     Updating this field of a BackupPlan does NOT affect existing Backups
          #     under it. Backups created AFTER a successful update will inherit
          #     the new value.
          #
          #     Default: 0 (no delete blocking)
          # @!attribute [rw] backup_retain_days
          #   @return [::Integer]
          #     Optional. The default maximum age of a Backup created via this
          #     BackupPlan. This field MUST be an integer value >= 0 and <= 365. If
          #     specified, a Backup created under this BackupPlan will be automatically
          #     deleted after its age reaches (create_time + backup_retain_days). If not
          #     specified, Backups created under this BackupPlan will NOT be subject to
          #     automatic deletion. Updating this field does NOT affect existing Backups
          #     under it. Backups created AFTER a successful update will automatically
          #     pick up the new value. NOTE: backup_retain_days must be >=
          #     {::Google::Cloud::GkeBackup::V1::BackupPlan::RetentionPolicy#backup_delete_lock_days backup_delete_lock_days}.
          #     If
          #     {::Google::Cloud::GkeBackup::V1::BackupPlan::Schedule#cron_schedule cron_schedule}
          #     is defined, then this must be
          #     <= 360 * the creation interval. If
          #     {::Google::Cloud::GkeBackup::V1::BackupPlan::Schedule#rpo_config rpo_config} is
          #     defined, then this must be
          #     <= 360 * [target_rpo_minutes][Schedule.rpo_config.target_rpo_minutes] /
          #     (1440minutes/day).
          #
          #     Default: 0 (no automatic deletion)
          # @!attribute [rw] locked
          #   @return [::Boolean]
          #     Optional. This flag denotes whether the retention policy of this
          #     BackupPlan is locked.  If set to True, no further update is allowed on
          #     this policy, including the `locked` field itself.
          #
          #     Default: False
          class RetentionPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines scheduling parameters for automatically creating Backups
          # via this BackupPlan.
          # @!attribute [rw] cron_schedule
          #   @return [::String]
          #     Optional. A standard [cron](https://wikipedia.com/wiki/cron) string that
          #     defines a repeating schedule for creating Backups via this BackupPlan.
          #     This is mutually exclusive with the
          #     {::Google::Cloud::GkeBackup::V1::BackupPlan::Schedule#rpo_config rpo_config}
          #     field since at most one schedule can be defined for a BackupPlan. If this
          #     is defined, then
          #     {::Google::Cloud::GkeBackup::V1::BackupPlan::RetentionPolicy#backup_retain_days backup_retain_days}
          #     must also be defined.
          #
          #     Default (empty): no automatic backup creation will occur.
          # @!attribute [rw] paused
          #   @return [::Boolean]
          #     Optional. This flag denotes whether automatic Backup creation is paused
          #     for this BackupPlan.
          #
          #     Default: False
          # @!attribute [rw] rpo_config
          #   @return [::Google::Cloud::GkeBackup::V1::RpoConfig]
          #     Optional. Defines the RPO schedule configuration for this BackupPlan.
          #     This is mutually exclusive with the
          #     {::Google::Cloud::GkeBackup::V1::BackupPlan::Schedule#cron_schedule cron_schedule}
          #     field since at most one schedule can be defined for a BackupPLan. If this
          #     is defined, then
          #     {::Google::Cloud::GkeBackup::V1::BackupPlan::RetentionPolicy#backup_retain_days backup_retain_days}
          #     must also be defined.
          #
          #     Default (empty): no automatic backup creation will occur.
          # @!attribute [r] next_scheduled_backup_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Start time of next scheduled backup under this BackupPlan by
          #     either cron_schedule or rpo config.
          class Schedule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # BackupConfig defines the configuration of Backups created via this
          # BackupPlan.
          # @!attribute [rw] all_namespaces
          #   @return [::Boolean]
          #     If True, include all namespaced resources
          #
          #     Note: The following fields are mutually exclusive: `all_namespaces`, `selected_namespaces`, `selected_applications`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] selected_namespaces
          #   @return [::Google::Cloud::GkeBackup::V1::Namespaces]
          #     If set, include just the resources in the listed namespaces.
          #
          #     Note: The following fields are mutually exclusive: `selected_namespaces`, `all_namespaces`, `selected_applications`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] selected_applications
          #   @return [::Google::Cloud::GkeBackup::V1::NamespacedNames]
          #     If set, include just the resources referenced by the listed
          #     ProtectedApplications.
          #
          #     Note: The following fields are mutually exclusive: `selected_applications`, `all_namespaces`, `selected_namespaces`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] include_volume_data
          #   @return [::Boolean]
          #     Optional. This flag specifies whether volume data should be backed up
          #     when PVCs are included in the scope of a Backup.
          #
          #     Default: False
          # @!attribute [rw] include_secrets
          #   @return [::Boolean]
          #     Optional. This flag specifies whether Kubernetes Secret resources should
          #     be included when they fall into the scope of Backups.
          #
          #     Default: False
          # @!attribute [rw] encryption_key
          #   @return [::Google::Cloud::GkeBackup::V1::EncryptionKey]
          #     Optional. This defines a customer managed encryption key that will be
          #     used to encrypt the "config" portion (the Kubernetes resources) of
          #     Backups created via this plan.
          #
          #     Default (empty): Config backup artifacts will not be encrypted.
          # @!attribute [rw] permissive_mode
          #   @return [::Boolean]
          #     Optional. If false, Backups will fail when Backup for GKE detects
          #     Kubernetes configuration that is non-standard or
          #     requires additional setup to restore.
          #
          #     Default: False
          class BackupConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State
          module State
            # Default first value for Enums.
            STATE_UNSPECIFIED = 0

            # Waiting for cluster state to be RUNNING.
            CLUSTER_PENDING = 1

            # The BackupPlan is in the process of being created.
            PROVISIONING = 2

            # The BackupPlan has successfully been created and is ready for Backups.
            READY = 3

            # BackupPlan creation has failed.
            FAILED = 4

            # The BackupPlan has been deactivated.
            DEACTIVATED = 5

            # The BackupPlan is in the process of being deleted.
            DELETING = 6
          end
        end

        # Defines RPO scheduling configuration for automatically creating
        # Backups via this BackupPlan.
        # @!attribute [rw] target_rpo_minutes
        #   @return [::Integer]
        #     Required. Defines the target RPO for the BackupPlan in minutes, which means
        #     the target maximum data loss in time that is acceptable for this
        #     BackupPlan. This must be at least 60, i.e., 1 hour, and at most 86400,
        #     i.e., 60 days.
        # @!attribute [rw] exclusion_windows
        #   @return [::Array<::Google::Cloud::GkeBackup::V1::ExclusionWindow>]
        #     Optional. User specified time windows during which backup can NOT happen
        #     for this BackupPlan - backups should start and finish outside of any given
        #     exclusion window. Note: backup jobs will be scheduled to start and
        #     finish outside the duration of the window as much as possible, but
        #     running jobs will not get canceled when it runs into the window.
        #     All the time and date values in exclusion_windows entry in the API are in
        #     UTC.
        #     We only allow <=1 recurrence (daily or weekly) exclusion window for a
        #     BackupPlan while no restriction on number of single occurrence
        #     windows.
        class RpoConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines a time window during which no backup should
        # happen. All time and date are in UTC.
        # @!attribute [rw] start_time
        #   @return [::Google::Type::TimeOfDay]
        #     Required. Specifies the start time of the window using time of the day in
        #     UTC.
        # @!attribute [rw] duration
        #   @return [::Google::Protobuf::Duration]
        #     Required. Specifies duration of the window.
        #     Duration must be >= 5 minutes and < (target RPO - 20 minutes).
        #     Additional restrictions based on the recurrence type to allow some time for
        #     backup to happen:
        #     - single_occurrence_date:  no restriction, but UI may warn about this when
        #     duration >= target RPO
        #     - daily window: duration < 24 hours
        #     - weekly window:
        #       - days of week includes all seven days of a week: duration < 24 hours
        #       - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
        # @!attribute [rw] single_occurrence_date
        #   @return [::Google::Type::Date]
        #     No recurrence. The exclusion window occurs only once and on this
        #     date in UTC.
        #
        #     Note: The following fields are mutually exclusive: `single_occurrence_date`, `daily`, `days_of_week`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] daily
        #   @return [::Boolean]
        #     The exclusion window occurs every day if set to "True".
        #     Specifying this field to "False" is an error.
        #
        #     Note: The following fields are mutually exclusive: `daily`, `single_occurrence_date`, `days_of_week`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] days_of_week
        #   @return [::Google::Cloud::GkeBackup::V1::ExclusionWindow::DayOfWeekList]
        #     The exclusion window occurs on these days of each week in UTC.
        #
        #     Note: The following fields are mutually exclusive: `days_of_week`, `single_occurrence_date`, `daily`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ExclusionWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Holds repeated DaysOfWeek values as a container.
          # @!attribute [rw] days_of_week
          #   @return [::Array<::Google::Type::DayOfWeek>]
          #     Optional. A list of days of week.
          class DayOfWeekList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
