# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gkebackup/v1/gkebackup_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module GkeBackup
      module V1
        module BackupForGKE
          ##
          # Client for the BackupForGKE service.
          #
          # BackupForGKE allows Kubernetes administrators to configure, execute, and
          # manage backup and restore operations for their GKE clusters.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "gkebackup.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :backup_for_gke_stub

            ##
            # Configure the BackupForGKE Client class.
            #
            # See {::Google::Cloud::GkeBackup::V1::BackupForGKE::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all BackupForGKE clients
            #   ::Google::Cloud::GkeBackup::V1::BackupForGKE::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "GkeBackup", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_backup_plan.timeout = 300.0

                default_config.rpcs.list_backup_plans.timeout = 60.0
                default_config.rpcs.list_backup_plans.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_backup_plan.timeout = 60.0
                default_config.rpcs.get_backup_plan.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_backup_plan.timeout = 60.0

                default_config.rpcs.delete_backup_plan.timeout = 60.0

                default_config.rpcs.create_backup_channel.timeout = 60.0

                default_config.rpcs.list_backup_channels.timeout = 60.0
                default_config.rpcs.list_backup_channels.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_backup_channel.timeout = 60.0
                default_config.rpcs.get_backup_channel.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_backup_channel.timeout = 60.0

                default_config.rpcs.delete_backup_channel.timeout = 60.0

                default_config.rpcs.list_backup_plan_bindings.timeout = 60.0
                default_config.rpcs.list_backup_plan_bindings.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_backup_plan_binding.timeout = 60.0
                default_config.rpcs.get_backup_plan_binding.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_backup.timeout = 120.0

                default_config.rpcs.list_backups.timeout = 60.0
                default_config.rpcs.list_backups.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_backup.timeout = 60.0
                default_config.rpcs.get_backup.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_backup.timeout = 60.0

                default_config.rpcs.delete_backup.timeout = 300.0

                default_config.rpcs.list_volume_backups.timeout = 60.0
                default_config.rpcs.list_volume_backups.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_volume_backup.timeout = 60.0
                default_config.rpcs.get_volume_backup.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_restore_plan.timeout = 120.0

                default_config.rpcs.list_restore_plans.timeout = 60.0
                default_config.rpcs.list_restore_plans.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_restore_plan.timeout = 60.0
                default_config.rpcs.get_restore_plan.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_restore_plan.timeout = 60.0

                default_config.rpcs.delete_restore_plan.timeout = 60.0

                default_config.rpcs.create_restore_channel.timeout = 60.0

                default_config.rpcs.list_restore_channels.timeout = 60.0
                default_config.rpcs.list_restore_channels.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_restore_channel.timeout = 60.0
                default_config.rpcs.get_restore_channel.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_restore_channel.timeout = 60.0

                default_config.rpcs.delete_restore_channel.timeout = 60.0

                default_config.rpcs.list_restore_plan_bindings.timeout = 60.0
                default_config.rpcs.list_restore_plan_bindings.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_restore_plan_binding.timeout = 60.0
                default_config.rpcs.get_restore_plan_binding.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_restore.timeout = 120.0

                default_config.rpcs.list_restores.timeout = 60.0
                default_config.rpcs.list_restores.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_restore.timeout = 60.0
                default_config.rpcs.get_restore.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_restore.timeout = 60.0

                default_config.rpcs.delete_restore.timeout = 60.0

                default_config.rpcs.list_volume_restores.timeout = 60.0
                default_config.rpcs.list_volume_restores.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_volume_restore.timeout = 60.0
                default_config.rpcs.get_volume_restore.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_backup_index_download_url.timeout = 60.0
                default_config.rpcs.get_backup_index_download_url.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the BackupForGKE Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::GkeBackup::V1::BackupForGKE::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @backup_for_gke_stub.universe_domain
            end

            ##
            # Create a new BackupForGKE client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the BackupForGKE client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/gkebackup/v1/gkebackup_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @backup_for_gke_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::GkeBackup::V1::BackupForGKE::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @backup_for_gke_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @backup_for_gke_stub.endpoint
                config.universe_domain = @backup_for_gke_stub.universe_domain
                config.logger = @backup_for_gke_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @backup_for_gke_stub.endpoint
                config.universe_domain = @backup_for_gke_stub.universe_domain
                config.logger = @backup_for_gke_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::GkeBackup::V1::BackupForGKE::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @backup_for_gke_stub.logger
            end

            # Service calls

            ##
            # Creates a new BackupPlan in a given location.
            #
            # @overload create_backup_plan(request, options = nil)
            #   Pass arguments to `create_backup_plan` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::CreateBackupPlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::CreateBackupPlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_backup_plan(parent: nil, backup_plan: nil, backup_plan_id: nil)
            #   Pass arguments to `create_backup_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location within which to create the BackupPlan.
            #     Format: `projects/*/locations/*`
            #   @param backup_plan [::Google::Cloud::GkeBackup::V1::BackupPlan, ::Hash]
            #     Required. The BackupPlan resource object to create.
            #   @param backup_plan_id [::String]
            #     Required. The client-provided short name for the BackupPlan resource.
            #     This name must:
            #
            #     - be between 1 and 63 characters long (inclusive)
            #     - consist of only lower-case ASCII letters, numbers, and dashes
            #     - start with a lower-case letter
            #     - end with a lower-case letter or number
            #     - be unique within the set of BackupPlans in this location
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::CreateBackupPlanRequest.new
            #
            #   # Call the create_backup_plan method.
            #   result = client.create_backup_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_backup_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::CreateBackupPlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_backup_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_backup_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_backup_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :create_backup_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BackupPlans in a given location.
            #
            # @overload list_backup_plans(request, options = nil)
            #   Pass arguments to `list_backup_plans` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListBackupPlansRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListBackupPlansRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backup_plans(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_backup_plans` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location that contains the BackupPlans to list.
            #     Format: `projects/*/locations/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListBackupPlansResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListBackupPlansResponse#next_page_token next_page_token}
            #     received from a previous `ListBackupPlans` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListBackupPlans` must match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::BackupPlan>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::BackupPlan>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListBackupPlansRequest.new
            #
            #   # Call the list_backup_plans method.
            #   result = client.list_backup_plans request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::BackupPlan.
            #     p item
            #   end
            #
            def list_backup_plans request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListBackupPlansRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backup_plans.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backup_plans.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backup_plans.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_backup_plans, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_backup_plans, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single BackupPlan.
            #
            # @overload get_backup_plan(request, options = nil)
            #   Pass arguments to `get_backup_plan` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetBackupPlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetBackupPlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup_plan(name: nil)
            #   Pass arguments to `get_backup_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified BackupPlan name.
            #     Format: `projects/*/locations/*/backupPlans/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::BackupPlan]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::BackupPlan]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetBackupPlanRequest.new
            #
            #   # Call the get_backup_plan method.
            #   result = client.get_backup_plan request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::BackupPlan.
            #   p result
            #
            def get_backup_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetBackupPlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_backup_plan, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a BackupPlan.
            #
            # @overload update_backup_plan(request, options = nil)
            #   Pass arguments to `update_backup_plan` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::UpdateBackupPlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::UpdateBackupPlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_backup_plan(backup_plan: nil, update_mask: nil)
            #   Pass arguments to `update_backup_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param backup_plan [::Google::Cloud::GkeBackup::V1::BackupPlan, ::Hash]
            #     Required. A new version of the BackupPlan resource that contains updated
            #     fields. This may be sparsely populated if an `update_mask` is provided.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. This is used to specify the fields to be overwritten in the
            #     BackupPlan targeted for update. The values for each of these
            #     updated fields will be taken from the `backup_plan` provided
            #     with this request. Field names are relative to the root of the resource
            #     (e.g., `description`, `backup_config.include_volume_data`, etc.)
            #     If no `update_mask` is provided, all fields in `backup_plan` will be
            #     written to the target BackupPlan resource.
            #     Note that OUTPUT_ONLY and IMMUTABLE fields in `backup_plan` are ignored
            #     and are not used to update the target BackupPlan.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::UpdateBackupPlanRequest.new
            #
            #   # Call the update_backup_plan method.
            #   result = client.update_backup_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_backup_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::UpdateBackupPlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_backup_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup_plan&.name
                header_params["backup_plan.name"] = request.backup_plan.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_backup_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_backup_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :update_backup_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing BackupPlan.
            #
            # @overload delete_backup_plan(request, options = nil)
            #   Pass arguments to `delete_backup_plan` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::DeleteBackupPlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::DeleteBackupPlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_backup_plan(name: nil, etag: nil)
            #   Pass arguments to `delete_backup_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified BackupPlan name.
            #     Format: `projects/*/locations/*/backupPlans/*`
            #   @param etag [::String]
            #     Optional. If provided, this value must match the current value of the
            #     target BackupPlan's {::Google::Cloud::GkeBackup::V1::BackupPlan#etag etag} field
            #     or the request is rejected.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::DeleteBackupPlanRequest.new
            #
            #   # Call the delete_backup_plan method.
            #   result = client.delete_backup_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_backup_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::DeleteBackupPlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_backup_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_backup_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_backup_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :delete_backup_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new BackupChannel in a given location.
            #
            # @overload create_backup_channel(request, options = nil)
            #   Pass arguments to `create_backup_channel` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::CreateBackupChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::CreateBackupChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_backup_channel(parent: nil, backup_channel: nil, backup_channel_id: nil)
            #   Pass arguments to `create_backup_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location within which to create the BackupChannel.
            #     Format: `projects/*/locations/*`
            #   @param backup_channel [::Google::Cloud::GkeBackup::V1::BackupChannel, ::Hash]
            #     Required. The BackupChannel resource object to create.
            #   @param backup_channel_id [::String]
            #     Optional. The client-provided short name for the BackupChannel resource.
            #     This name must:
            #
            #     - be between 1 and 63 characters long (inclusive)
            #     - consist of only lower-case ASCII letters, numbers, and dashes
            #     - start with a lower-case letter
            #     - end with a lower-case letter or number
            #     - be unique within the set of BackupChannels in this location
            #     If the user does not provide a name, a uuid will be used as the name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::CreateBackupChannelRequest.new
            #
            #   # Call the create_backup_channel method.
            #   result = client.create_backup_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_backup_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::CreateBackupChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_backup_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_backup_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_backup_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :create_backup_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BackupChannels in a given location.
            #
            # @overload list_backup_channels(request, options = nil)
            #   Pass arguments to `list_backup_channels` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListBackupChannelsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListBackupChannelsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backup_channels(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_backup_channels` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location that contains the BackupChannels to list.
            #     Format: `projects/*/locations/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListBackupChannelsResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListBackupChannelsResponse#next_page_token next_page_token}
            #     received from a previous `ListBackupChannels` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListBackupChannels` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::BackupChannel>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::BackupChannel>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListBackupChannelsRequest.new
            #
            #   # Call the list_backup_channels method.
            #   result = client.list_backup_channels request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::BackupChannel.
            #     p item
            #   end
            #
            def list_backup_channels request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListBackupChannelsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backup_channels.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backup_channels.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backup_channels.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_backup_channels, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_backup_channels, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single BackupChannel.
            #
            # @overload get_backup_channel(request, options = nil)
            #   Pass arguments to `get_backup_channel` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetBackupChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetBackupChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup_channel(name: nil)
            #   Pass arguments to `get_backup_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified BackupChannel name.
            #     Format: `projects/*/locations/*/backupChannels/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::BackupChannel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::BackupChannel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetBackupChannelRequest.new
            #
            #   # Call the get_backup_channel method.
            #   result = client.get_backup_channel request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::BackupChannel.
            #   p result
            #
            def get_backup_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetBackupChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_backup_channel, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a BackupChannel.
            #
            # @overload update_backup_channel(request, options = nil)
            #   Pass arguments to `update_backup_channel` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::UpdateBackupChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::UpdateBackupChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_backup_channel(backup_channel: nil, update_mask: nil)
            #   Pass arguments to `update_backup_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param backup_channel [::Google::Cloud::GkeBackup::V1::BackupChannel, ::Hash]
            #     Required. A new version of the BackupChannel resource that contains updated
            #     fields. This may be sparsely populated if an `update_mask` is provided.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. This is used to specify the fields to be overwritten in the
            #     BackupChannel targeted for update. The values for each of these
            #     updated fields will be taken from the `backup_channel` provided
            #     with this request. Field names are relative to the root of the resource
            #     (e.g., `description`, `labels`, etc.)
            #     If no `update_mask` is provided, all fields in `backup_channel` will
            #     be written to the target BackupChannel resource. Note that
            #     OUTPUT_ONLY and IMMUTABLE fields in `backup_channel` are ignored and
            #     are not used to update the target BackupChannel.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::UpdateBackupChannelRequest.new
            #
            #   # Call the update_backup_channel method.
            #   result = client.update_backup_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_backup_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::UpdateBackupChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_backup_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup_channel&.name
                header_params["backup_channel.name"] = request.backup_channel.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_backup_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_backup_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :update_backup_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing BackupChannel.
            #
            # @overload delete_backup_channel(request, options = nil)
            #   Pass arguments to `delete_backup_channel` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::DeleteBackupChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::DeleteBackupChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_backup_channel(name: nil, etag: nil, force: nil)
            #   Pass arguments to `delete_backup_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified BackupChannel name.
            #     Format: `projects/*/locations/*/backupChannels/*`
            #   @param etag [::String]
            #     Optional. If provided, this value must match the current value of the
            #     target BackupChannel's {::Google::Cloud::GkeBackup::V1::BackupChannel#etag etag}
            #     field or the request is rejected.
            #   @param force [::Boolean]
            #     Optional. If set to true, any BackupPlanAssociations below this
            #     BackupChannel will also be deleted. Otherwise, the request will only
            #     succeed if the BackupChannel has no BackupPlanAssociations.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::DeleteBackupChannelRequest.new
            #
            #   # Call the delete_backup_channel method.
            #   result = client.delete_backup_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_backup_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::DeleteBackupChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_backup_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_backup_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_backup_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :delete_backup_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BackupPlanBindings in a given location.
            #
            # @overload list_backup_plan_bindings(request, options = nil)
            #   Pass arguments to `list_backup_plan_bindings` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backup_plan_bindings(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_backup_plan_bindings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The BackupChannel that contains the BackupPlanBindings to list.
            #     Format: `projects/*/locations/*/backupChannels/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsResponse#next_page_token next_page_token}
            #     received from a previous `ListBackupPlanBindings` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListBackupPlanBindings` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::BackupPlanBinding>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::BackupPlanBinding>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsRequest.new
            #
            #   # Call the list_backup_plan_bindings method.
            #   result = client.list_backup_plan_bindings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::BackupPlanBinding.
            #     p item
            #   end
            #
            def list_backup_plan_bindings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListBackupPlanBindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backup_plan_bindings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backup_plan_bindings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backup_plan_bindings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_backup_plan_bindings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_backup_plan_bindings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single BackupPlanBinding.
            #
            # @overload get_backup_plan_binding(request, options = nil)
            #   Pass arguments to `get_backup_plan_binding` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetBackupPlanBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetBackupPlanBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup_plan_binding(name: nil)
            #   Pass arguments to `get_backup_plan_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified BackupPlanBinding name.
            #     Format:
            #     `projects/*/locations/*/backupChannels/*/backupPlanBindings/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::BackupPlanBinding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::BackupPlanBinding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetBackupPlanBindingRequest.new
            #
            #   # Call the get_backup_plan_binding method.
            #   result = client.get_backup_plan_binding request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::BackupPlanBinding.
            #   p result
            #
            def get_backup_plan_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetBackupPlanBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup_plan_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup_plan_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup_plan_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_backup_plan_binding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a Backup for the given BackupPlan.
            #
            # @overload create_backup(request, options = nil)
            #   Pass arguments to `create_backup` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::CreateBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::CreateBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_backup(parent: nil, backup: nil, backup_id: nil)
            #   Pass arguments to `create_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The BackupPlan within which to create the Backup.
            #     Format: `projects/*/locations/*/backupPlans/*`
            #   @param backup [::Google::Cloud::GkeBackup::V1::Backup, ::Hash]
            #     Optional. The Backup resource to create.
            #   @param backup_id [::String]
            #     Optional. The client-provided short name for the Backup resource.
            #     This name must:
            #
            #     - be between 1 and 63 characters long (inclusive)
            #     - consist of only lower-case ASCII letters, numbers, and dashes
            #     - start with a lower-case letter
            #     - end with a lower-case letter or number
            #     - be unique within the set of Backups in this BackupPlan
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::CreateBackupRequest.new
            #
            #   # Call the create_backup method.
            #   result = client.create_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::CreateBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :create_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the Backups for a given BackupPlan.
            #
            # @overload list_backups(request, options = nil)
            #   Pass arguments to `list_backups` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListBackupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListBackupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, return_partial_success: nil)
            #   Pass arguments to `list_backups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The BackupPlan that contains the Backups to list.
            #     Format: `projects/*/locations/*/backupPlans/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListBackupsResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListBackupsResponse#next_page_token next_page_token}
            #     received from a previous `ListBackups` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListBackups` must match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #   @param return_partial_success [::Boolean]
            #     Optional. If set to true, the response will return partial results when
            #     some regions are unreachable and the unreachable field will be populated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::Backup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::Backup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListBackupsRequest.new
            #
            #   # Call the list_backups method.
            #   result = client.list_backups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::Backup.
            #     p item
            #   end
            #
            def list_backups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListBackupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_backups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_backups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single Backup.
            #
            # @overload get_backup(request, options = nil)
            #   Pass arguments to `get_backup` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup(name: nil)
            #   Pass arguments to `get_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full name of the Backup resource.
            #     Format: `projects/*/locations/*/backupPlans/*/backups/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::Backup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::Backup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetBackupRequest.new
            #
            #   # Call the get_backup method.
            #   result = client.get_backup request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::Backup.
            #   p result
            #
            def get_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_backup, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a Backup.
            #
            # @overload update_backup(request, options = nil)
            #   Pass arguments to `update_backup` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::UpdateBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::UpdateBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_backup(backup: nil, update_mask: nil)
            #   Pass arguments to `update_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param backup [::Google::Cloud::GkeBackup::V1::Backup, ::Hash]
            #     Required. A new version of the Backup resource that contains updated
            #     fields. This may be sparsely populated if an `update_mask` is provided.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. This is used to specify the fields to be overwritten in the
            #     Backup targeted for update. The values for each of these
            #     updated fields will be taken from the `backup_plan` provided
            #     with this request. Field names are relative to the root of the resource.
            #     If no `update_mask` is provided, all fields in `backup` will be
            #     written to the target Backup resource.
            #     Note that OUTPUT_ONLY and IMMUTABLE fields in `backup` are ignored
            #     and are not used to update the target Backup.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::UpdateBackupRequest.new
            #
            #   # Call the update_backup method.
            #   result = client.update_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::UpdateBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup&.name
                header_params["backup.name"] = request.backup.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :update_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing Backup.
            #
            # @overload delete_backup(request, options = nil)
            #   Pass arguments to `delete_backup` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::DeleteBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::DeleteBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_backup(name: nil, etag: nil, force: nil)
            #   Pass arguments to `delete_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the Backup resource.
            #     Format: `projects/*/locations/*/backupPlans/*/backups/*`
            #   @param etag [::String]
            #     Optional. If provided, this value must match the current value of the
            #     target Backup's {::Google::Cloud::GkeBackup::V1::Backup#etag etag} field or the
            #     request is rejected.
            #   @param force [::Boolean]
            #     Optional. If set to true, any VolumeBackups below this Backup will also be
            #     deleted. Otherwise, the request will only succeed if the Backup has no
            #     VolumeBackups.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::DeleteBackupRequest.new
            #
            #   # Call the delete_backup method.
            #   result = client.delete_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::DeleteBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :delete_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the VolumeBackups for a given Backup.
            #
            # @overload list_volume_backups(request, options = nil)
            #   Pass arguments to `list_volume_backups` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListVolumeBackupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListVolumeBackupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_volume_backups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_volume_backups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The Backup that contains the VolumeBackups to list.
            #     Format: `projects/*/locations/*/backupPlans/*/backups/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListVolumeBackupsResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListVolumeBackupsResponse#next_page_token next_page_token}
            #     received from a previous `ListVolumeBackups` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListVolumeBackups` must match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::VolumeBackup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::VolumeBackup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListVolumeBackupsRequest.new
            #
            #   # Call the list_volume_backups method.
            #   result = client.list_volume_backups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::VolumeBackup.
            #     p item
            #   end
            #
            def list_volume_backups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListVolumeBackupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_volume_backups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_volume_backups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_volume_backups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_volume_backups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_volume_backups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single VolumeBackup.
            #
            # @overload get_volume_backup(request, options = nil)
            #   Pass arguments to `get_volume_backup` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetVolumeBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetVolumeBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_volume_backup(name: nil)
            #   Pass arguments to `get_volume_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full name of the VolumeBackup resource.
            #     Format: `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::VolumeBackup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::VolumeBackup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetVolumeBackupRequest.new
            #
            #   # Call the get_volume_backup method.
            #   result = client.get_volume_backup request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::VolumeBackup.
            #   p result
            #
            def get_volume_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetVolumeBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_volume_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_volume_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_volume_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_volume_backup, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new RestorePlan in a given location.
            #
            # @overload create_restore_plan(request, options = nil)
            #   Pass arguments to `create_restore_plan` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::CreateRestorePlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::CreateRestorePlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_restore_plan(parent: nil, restore_plan: nil, restore_plan_id: nil)
            #   Pass arguments to `create_restore_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location within which to create the RestorePlan.
            #     Format: `projects/*/locations/*`
            #   @param restore_plan [::Google::Cloud::GkeBackup::V1::RestorePlan, ::Hash]
            #     Required. The RestorePlan resource object to create.
            #   @param restore_plan_id [::String]
            #     Required. The client-provided short name for the RestorePlan resource.
            #     This name must:
            #
            #     - be between 1 and 63 characters long (inclusive)
            #     - consist of only lower-case ASCII letters, numbers, and dashes
            #     - start with a lower-case letter
            #     - end with a lower-case letter or number
            #     - be unique within the set of RestorePlans in this location
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::CreateRestorePlanRequest.new
            #
            #   # Call the create_restore_plan method.
            #   result = client.create_restore_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_restore_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::CreateRestorePlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_restore_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_restore_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_restore_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :create_restore_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists RestorePlans in a given location.
            #
            # @overload list_restore_plans(request, options = nil)
            #   Pass arguments to `list_restore_plans` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListRestorePlansRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListRestorePlansRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_restore_plans(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_restore_plans` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location that contains the RestorePlans to list.
            #     Format: `projects/*/locations/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListRestorePlansResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListRestorePlansResponse#next_page_token next_page_token}
            #     received from a previous `ListRestorePlans` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListRestorePlans` must match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::RestorePlan>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::RestorePlan>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListRestorePlansRequest.new
            #
            #   # Call the list_restore_plans method.
            #   result = client.list_restore_plans request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::RestorePlan.
            #     p item
            #   end
            #
            def list_restore_plans request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListRestorePlansRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_restore_plans.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_restore_plans.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_restore_plans.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_restore_plans, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_restore_plans, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single RestorePlan.
            #
            # @overload get_restore_plan(request, options = nil)
            #   Pass arguments to `get_restore_plan` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetRestorePlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetRestorePlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_restore_plan(name: nil)
            #   Pass arguments to `get_restore_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified RestorePlan name.
            #     Format: `projects/*/locations/*/restorePlans/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::RestorePlan]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::RestorePlan]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetRestorePlanRequest.new
            #
            #   # Call the get_restore_plan method.
            #   result = client.get_restore_plan request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::RestorePlan.
            #   p result
            #
            def get_restore_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetRestorePlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_restore_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_restore_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_restore_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_restore_plan, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a RestorePlan.
            #
            # @overload update_restore_plan(request, options = nil)
            #   Pass arguments to `update_restore_plan` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::UpdateRestorePlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::UpdateRestorePlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_restore_plan(restore_plan: nil, update_mask: nil)
            #   Pass arguments to `update_restore_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param restore_plan [::Google::Cloud::GkeBackup::V1::RestorePlan, ::Hash]
            #     Required. A new version of the RestorePlan resource that contains updated
            #     fields. This may be sparsely populated if an `update_mask` is provided.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. This is used to specify the fields to be overwritten in the
            #     RestorePlan targeted for update. The values for each of these
            #     updated fields will be taken from the `restore_plan` provided
            #     with this request. Field names are relative to the root of the resource.
            #     If no `update_mask` is provided, all fields in `restore_plan` will be
            #     written to the target RestorePlan resource.
            #     Note that OUTPUT_ONLY and IMMUTABLE fields in `restore_plan` are ignored
            #     and are not used to update the target RestorePlan.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::UpdateRestorePlanRequest.new
            #
            #   # Call the update_restore_plan method.
            #   result = client.update_restore_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_restore_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::UpdateRestorePlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_restore_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.restore_plan&.name
                header_params["restore_plan.name"] = request.restore_plan.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_restore_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_restore_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :update_restore_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing RestorePlan.
            #
            # @overload delete_restore_plan(request, options = nil)
            #   Pass arguments to `delete_restore_plan` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::DeleteRestorePlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::DeleteRestorePlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_restore_plan(name: nil, etag: nil, force: nil)
            #   Pass arguments to `delete_restore_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified RestorePlan name.
            #     Format: `projects/*/locations/*/restorePlans/*`
            #   @param etag [::String]
            #     Optional. If provided, this value must match the current value of the
            #     target RestorePlan's {::Google::Cloud::GkeBackup::V1::RestorePlan#etag etag}
            #     field or the request is rejected.
            #   @param force [::Boolean]
            #     Optional. If set to true, any Restores below this RestorePlan will also be
            #     deleted. Otherwise, the request will only succeed if the RestorePlan has no
            #     Restores.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::DeleteRestorePlanRequest.new
            #
            #   # Call the delete_restore_plan method.
            #   result = client.delete_restore_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_restore_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::DeleteRestorePlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_restore_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_restore_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_restore_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :delete_restore_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new RestoreChannel in a given location.
            #
            # @overload create_restore_channel(request, options = nil)
            #   Pass arguments to `create_restore_channel` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::CreateRestoreChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::CreateRestoreChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_restore_channel(parent: nil, restore_channel: nil, restore_channel_id: nil)
            #   Pass arguments to `create_restore_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location within which to create the RestoreChannel.
            #     Format: `projects/*/locations/*`
            #   @param restore_channel [::Google::Cloud::GkeBackup::V1::RestoreChannel, ::Hash]
            #     Required. The RestoreChannel resource object to create.
            #   @param restore_channel_id [::String]
            #     Optional. The client-provided short name for the RestoreChannel resource.
            #     This name must:
            #
            #     - be between 1 and 63 characters long (inclusive)
            #     - consist of only lower-case ASCII letters, numbers, and dashes
            #     - start with a lower-case letter
            #     - end with a lower-case letter or number
            #     - be unique within the set of RestoreChannels in this location
            #     If the user does not provide a name, a uuid will be used as the name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::CreateRestoreChannelRequest.new
            #
            #   # Call the create_restore_channel method.
            #   result = client.create_restore_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_restore_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::CreateRestoreChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_restore_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_restore_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_restore_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :create_restore_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists RestoreChannels in a given location.
            #
            # @overload list_restore_channels(request, options = nil)
            #   Pass arguments to `list_restore_channels` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListRestoreChannelsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListRestoreChannelsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_restore_channels(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_restore_channels` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location that contains the RestoreChannels to list.
            #     Format: `projects/*/locations/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListRestoreChannelsResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListRestoreChannelsResponse#next_page_token next_page_token}
            #     received from a previous `ListRestoreChannels` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListRestoreChannels` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::RestoreChannel>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::RestoreChannel>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListRestoreChannelsRequest.new
            #
            #   # Call the list_restore_channels method.
            #   result = client.list_restore_channels request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::RestoreChannel.
            #     p item
            #   end
            #
            def list_restore_channels request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListRestoreChannelsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_restore_channels.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_restore_channels.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_restore_channels.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_restore_channels, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_restore_channels, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single RestoreChannel.
            #
            # @overload get_restore_channel(request, options = nil)
            #   Pass arguments to `get_restore_channel` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetRestoreChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetRestoreChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_restore_channel(name: nil)
            #   Pass arguments to `get_restore_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified RestoreChannel name.
            #     Format: `projects/*/locations/*/restoreChannels/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::RestoreChannel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::RestoreChannel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetRestoreChannelRequest.new
            #
            #   # Call the get_restore_channel method.
            #   result = client.get_restore_channel request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::RestoreChannel.
            #   p result
            #
            def get_restore_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetRestoreChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_restore_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_restore_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_restore_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_restore_channel, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a RestoreChannel.
            #
            # @overload update_restore_channel(request, options = nil)
            #   Pass arguments to `update_restore_channel` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::UpdateRestoreChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::UpdateRestoreChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_restore_channel(restore_channel: nil, update_mask: nil)
            #   Pass arguments to `update_restore_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param restore_channel [::Google::Cloud::GkeBackup::V1::RestoreChannel, ::Hash]
            #     Required. A new version of the RestoreChannel resource that contains
            #     updated fields. This may be sparsely populated if an `update_mask` is
            #     provided.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. This is used to specify the fields to be overwritten in the
            #     RestoreChannel targeted for update. The values for each of these
            #     updated fields will be taken from the `restore_channel` provided
            #     with this request. Field names are relative to the root of the resource
            #     (e.g., `description`, `destination_project_id`, etc.)
            #     If no `update_mask` is provided, all fields in `restore_channel` will
            #     be written to the target RestoreChannel resource. Note that
            #     OUTPUT_ONLY and IMMUTABLE fields in `restore_channel` are ignored and
            #     are not used to update the target RestoreChannel.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::UpdateRestoreChannelRequest.new
            #
            #   # Call the update_restore_channel method.
            #   result = client.update_restore_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_restore_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::UpdateRestoreChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_restore_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.restore_channel&.name
                header_params["restore_channel.name"] = request.restore_channel.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_restore_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_restore_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :update_restore_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing RestoreChannel.
            #
            # @overload delete_restore_channel(request, options = nil)
            #   Pass arguments to `delete_restore_channel` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::DeleteRestoreChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::DeleteRestoreChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_restore_channel(name: nil, etag: nil)
            #   Pass arguments to `delete_restore_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified RestoreChannel name.
            #     Format: `projects/*/locations/*/restoreChannels/*`
            #   @param etag [::String]
            #     Optional. If provided, this value must match the current value of the
            #     target RestoreChannel's
            #     {::Google::Cloud::GkeBackup::V1::RestoreChannel#etag etag} field or the request
            #     is rejected.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::DeleteRestoreChannelRequest.new
            #
            #   # Call the delete_restore_channel method.
            #   result = client.delete_restore_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_restore_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::DeleteRestoreChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_restore_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_restore_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_restore_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :delete_restore_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists RestorePlanBindings in a given location.
            #
            # @overload list_restore_plan_bindings(request, options = nil)
            #   Pass arguments to `list_restore_plan_bindings` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_restore_plan_bindings(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_restore_plan_bindings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The RestoreChannel that contains the ListRestorePlanBindings to
            #     list. Format: `projects/*/locations/*/restoreChannels/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsResponse#next_page_token next_page_token}
            #     received from a previous `ListRestorePlanBindings` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListRestorePlanBindings` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::RestorePlanBinding>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::RestorePlanBinding>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsRequest.new
            #
            #   # Call the list_restore_plan_bindings method.
            #   result = client.list_restore_plan_bindings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::RestorePlanBinding.
            #     p item
            #   end
            #
            def list_restore_plan_bindings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListRestorePlanBindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_restore_plan_bindings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_restore_plan_bindings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_restore_plan_bindings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_restore_plan_bindings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_restore_plan_bindings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single RestorePlanBinding.
            #
            # @overload get_restore_plan_binding(request, options = nil)
            #   Pass arguments to `get_restore_plan_binding` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetRestorePlanBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetRestorePlanBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_restore_plan_binding(name: nil)
            #   Pass arguments to `get_restore_plan_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified RestorePlanBinding name.
            #     Format:
            #     `projects/*/locations/*/restoreChannels/*/restorePlanBindings/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::RestorePlanBinding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::RestorePlanBinding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetRestorePlanBindingRequest.new
            #
            #   # Call the get_restore_plan_binding method.
            #   result = client.get_restore_plan_binding request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::RestorePlanBinding.
            #   p result
            #
            def get_restore_plan_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetRestorePlanBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_restore_plan_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_restore_plan_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_restore_plan_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_restore_plan_binding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Restore for the given RestorePlan.
            #
            # @overload create_restore(request, options = nil)
            #   Pass arguments to `create_restore` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::CreateRestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::CreateRestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_restore(parent: nil, restore: nil, restore_id: nil)
            #   Pass arguments to `create_restore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The RestorePlan within which to create the Restore.
            #     Format: `projects/*/locations/*/restorePlans/*`
            #   @param restore [::Google::Cloud::GkeBackup::V1::Restore, ::Hash]
            #     Required. The restore resource to create.
            #   @param restore_id [::String]
            #     Required. The client-provided short name for the Restore resource.
            #     This name must:
            #
            #     - be between 1 and 63 characters long (inclusive)
            #     - consist of only lower-case ASCII letters, numbers, and dashes
            #     - start with a lower-case letter
            #     - end with a lower-case letter or number
            #     - be unique within the set of Restores in this RestorePlan.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::CreateRestoreRequest.new
            #
            #   # Call the create_restore method.
            #   result = client.create_restore request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_restore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::CreateRestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_restore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_restore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_restore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :create_restore, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the Restores for a given RestorePlan.
            #
            # @overload list_restores(request, options = nil)
            #   Pass arguments to `list_restores` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListRestoresRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListRestoresRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_restores(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_restores` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The RestorePlan that contains the Restores to list.
            #     Format: `projects/*/locations/*/restorePlans/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListRestoresResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListRestoresResponse#next_page_token next_page_token}
            #     received from a previous `ListRestores` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to `ListRestores`
            #     must match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::Restore>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::Restore>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListRestoresRequest.new
            #
            #   # Call the list_restores method.
            #   result = client.list_restores request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::Restore.
            #     p item
            #   end
            #
            def list_restores request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListRestoresRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_restores.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_restores.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_restores.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_restores, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_restores, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves the details of a single Restore.
            #
            # @overload get_restore(request, options = nil)
            #   Pass arguments to `get_restore` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetRestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetRestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_restore(name: nil)
            #   Pass arguments to `get_restore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the restore resource.
            #     Format: `projects/*/locations/*/restorePlans/*/restores/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::Restore]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::Restore]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetRestoreRequest.new
            #
            #   # Call the get_restore method.
            #   result = client.get_restore request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::Restore.
            #   p result
            #
            def get_restore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetRestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_restore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_restore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_restore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_restore, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a Restore.
            #
            # @overload update_restore(request, options = nil)
            #   Pass arguments to `update_restore` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::UpdateRestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::UpdateRestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_restore(restore: nil, update_mask: nil)
            #   Pass arguments to `update_restore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param restore [::Google::Cloud::GkeBackup::V1::Restore, ::Hash]
            #     Required. A new version of the Restore resource that contains updated
            #     fields. This may be sparsely populated if an `update_mask` is provided.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. This is used to specify the fields to be overwritten in the
            #     Restore targeted for update. The values for each of these
            #     updated fields will be taken from the `restore` provided
            #     with this request. Field names are relative to the root of the resource.
            #     If no `update_mask` is provided, all fields in `restore` will be
            #     written to the target Restore resource.
            #     Note that OUTPUT_ONLY and IMMUTABLE fields in `restore` are ignored
            #     and are not used to update the target Restore.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::UpdateRestoreRequest.new
            #
            #   # Call the update_restore method.
            #   result = client.update_restore request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_restore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::UpdateRestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_restore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.restore&.name
                header_params["restore.name"] = request.restore.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_restore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_restore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :update_restore, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing Restore.
            #
            # @overload delete_restore(request, options = nil)
            #   Pass arguments to `delete_restore` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::DeleteRestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::DeleteRestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_restore(name: nil, etag: nil, force: nil)
            #   Pass arguments to `delete_restore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full name of the Restore
            #     Format: `projects/*/locations/*/restorePlans/*/restores/*`
            #   @param etag [::String]
            #     Optional. If provided, this value must match the current value of the
            #     target Restore's {::Google::Cloud::GkeBackup::V1::Restore#etag etag} field or
            #     the request is rejected.
            #   @param force [::Boolean]
            #     Optional. If set to true, any VolumeRestores below this restore will also
            #     be deleted. Otherwise, the request will only succeed if the restore has no
            #     VolumeRestores.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::DeleteRestoreRequest.new
            #
            #   # Call the delete_restore method.
            #   result = client.delete_restore request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_restore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::DeleteRestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_restore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_restore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_restore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :delete_restore, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the VolumeRestores for a given Restore.
            #
            # @overload list_volume_restores(request, options = nil)
            #   Pass arguments to `list_volume_restores` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::ListVolumeRestoresRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::ListVolumeRestoresRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_volume_restores(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_volume_restores` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The Restore that contains the VolumeRestores to list.
            #     Format: `projects/*/locations/*/restorePlans/*/restores/*`
            #   @param page_size [::Integer]
            #     Optional. The target number of results to return in a single response.
            #     If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::GkeBackup::V1::ListVolumeRestoresResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::GkeBackup::V1::ListVolumeRestoresResponse#next_page_token next_page_token}
            #     received from a previous `ListVolumeRestores` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListVolumeRestores` must match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::VolumeRestore>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeBackup::V1::VolumeRestore>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::ListVolumeRestoresRequest.new
            #
            #   # Call the list_volume_restores method.
            #   result = client.list_volume_restores request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeBackup::V1::VolumeRestore.
            #     p item
            #   end
            #
            def list_volume_restores request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::ListVolumeRestoresRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_volume_restores.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_volume_restores.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_volume_restores.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :list_volume_restores, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_for_gke_stub, :list_volume_restores, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the details of a single VolumeRestore.
            #
            # @overload get_volume_restore(request, options = nil)
            #   Pass arguments to `get_volume_restore` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetVolumeRestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetVolumeRestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_volume_restore(name: nil)
            #   Pass arguments to `get_volume_restore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full name of the VolumeRestore resource.
            #     Format: `projects/*/locations/*/restorePlans/*/restores/*/volumeRestores/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::VolumeRestore]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::VolumeRestore]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetVolumeRestoreRequest.new
            #
            #   # Call the get_volume_restore method.
            #   result = client.get_volume_restore request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::VolumeRestore.
            #   p result
            #
            def get_volume_restore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetVolumeRestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_volume_restore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_volume_restore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_volume_restore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_volume_restore, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the link to the backupIndex.
            #
            # @overload get_backup_index_download_url(request, options = nil)
            #   Pass arguments to `get_backup_index_download_url` via a request object, either of type
            #   {::Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup_index_download_url(backup: nil)
            #   Pass arguments to `get_backup_index_download_url` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param backup [::String]
            #     Required. Full name of Backup resource.
            #     Format:
            #     projects/\\{project}/locations/\\{location}/backupPlans/\\{backup_plan}/backups/\\{backup}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_backup/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlRequest.new
            #
            #   # Call the get_backup_index_download_url method.
            #   result = client.get_backup_index_download_url request
            #
            #   # The returned object is of type Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlResponse.
            #   p result
            #
            def get_backup_index_download_url request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeBackup::V1::GetBackupIndexDownloadUrlRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup_index_download_url.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeBackup::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup
                header_params["backup"] = request.backup
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup_index_download_url.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup_index_download_url.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_for_gke_stub.call_rpc :get_backup_index_download_url, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the BackupForGKE API.
            #
            # This class represents the configuration for BackupForGKE,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::GkeBackup::V1::BackupForGKE::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_backup_plan to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::GkeBackup::V1::BackupForGKE::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_backup_plan.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_backup_plan.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::GkeBackup::V1::BackupForGKE::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "gkebackup.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the BackupForGKE API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_backup_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_backup_plan
                ##
                # RPC-specific configuration for `list_backup_plans`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backup_plans
                ##
                # RPC-specific configuration for `get_backup_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup_plan
                ##
                # RPC-specific configuration for `update_backup_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_backup_plan
                ##
                # RPC-specific configuration for `delete_backup_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_backup_plan
                ##
                # RPC-specific configuration for `create_backup_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_backup_channel
                ##
                # RPC-specific configuration for `list_backup_channels`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backup_channels
                ##
                # RPC-specific configuration for `get_backup_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup_channel
                ##
                # RPC-specific configuration for `update_backup_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_backup_channel
                ##
                # RPC-specific configuration for `delete_backup_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_backup_channel
                ##
                # RPC-specific configuration for `list_backup_plan_bindings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backup_plan_bindings
                ##
                # RPC-specific configuration for `get_backup_plan_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup_plan_binding
                ##
                # RPC-specific configuration for `create_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_backup
                ##
                # RPC-specific configuration for `list_backups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backups
                ##
                # RPC-specific configuration for `get_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup
                ##
                # RPC-specific configuration for `update_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_backup
                ##
                # RPC-specific configuration for `delete_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_backup
                ##
                # RPC-specific configuration for `list_volume_backups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_volume_backups
                ##
                # RPC-specific configuration for `get_volume_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_volume_backup
                ##
                # RPC-specific configuration for `create_restore_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_restore_plan
                ##
                # RPC-specific configuration for `list_restore_plans`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_restore_plans
                ##
                # RPC-specific configuration for `get_restore_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_restore_plan
                ##
                # RPC-specific configuration for `update_restore_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_restore_plan
                ##
                # RPC-specific configuration for `delete_restore_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_restore_plan
                ##
                # RPC-specific configuration for `create_restore_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_restore_channel
                ##
                # RPC-specific configuration for `list_restore_channels`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_restore_channels
                ##
                # RPC-specific configuration for `get_restore_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_restore_channel
                ##
                # RPC-specific configuration for `update_restore_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_restore_channel
                ##
                # RPC-specific configuration for `delete_restore_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_restore_channel
                ##
                # RPC-specific configuration for `list_restore_plan_bindings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_restore_plan_bindings
                ##
                # RPC-specific configuration for `get_restore_plan_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_restore_plan_binding
                ##
                # RPC-specific configuration for `create_restore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_restore
                ##
                # RPC-specific configuration for `list_restores`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_restores
                ##
                # RPC-specific configuration for `get_restore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_restore
                ##
                # RPC-specific configuration for `update_restore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_restore
                ##
                # RPC-specific configuration for `delete_restore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_restore
                ##
                # RPC-specific configuration for `list_volume_restores`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_volume_restores
                ##
                # RPC-specific configuration for `get_volume_restore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_volume_restore
                ##
                # RPC-specific configuration for `get_backup_index_download_url`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup_index_download_url

                # @private
                def initialize parent_rpcs = nil
                  create_backup_plan_config = parent_rpcs.create_backup_plan if parent_rpcs.respond_to? :create_backup_plan
                  @create_backup_plan = ::Gapic::Config::Method.new create_backup_plan_config
                  list_backup_plans_config = parent_rpcs.list_backup_plans if parent_rpcs.respond_to? :list_backup_plans
                  @list_backup_plans = ::Gapic::Config::Method.new list_backup_plans_config
                  get_backup_plan_config = parent_rpcs.get_backup_plan if parent_rpcs.respond_to? :get_backup_plan
                  @get_backup_plan = ::Gapic::Config::Method.new get_backup_plan_config
                  update_backup_plan_config = parent_rpcs.update_backup_plan if parent_rpcs.respond_to? :update_backup_plan
                  @update_backup_plan = ::Gapic::Config::Method.new update_backup_plan_config
                  delete_backup_plan_config = parent_rpcs.delete_backup_plan if parent_rpcs.respond_to? :delete_backup_plan
                  @delete_backup_plan = ::Gapic::Config::Method.new delete_backup_plan_config
                  create_backup_channel_config = parent_rpcs.create_backup_channel if parent_rpcs.respond_to? :create_backup_channel
                  @create_backup_channel = ::Gapic::Config::Method.new create_backup_channel_config
                  list_backup_channels_config = parent_rpcs.list_backup_channels if parent_rpcs.respond_to? :list_backup_channels
                  @list_backup_channels = ::Gapic::Config::Method.new list_backup_channels_config
                  get_backup_channel_config = parent_rpcs.get_backup_channel if parent_rpcs.respond_to? :get_backup_channel
                  @get_backup_channel = ::Gapic::Config::Method.new get_backup_channel_config
                  update_backup_channel_config = parent_rpcs.update_backup_channel if parent_rpcs.respond_to? :update_backup_channel
                  @update_backup_channel = ::Gapic::Config::Method.new update_backup_channel_config
                  delete_backup_channel_config = parent_rpcs.delete_backup_channel if parent_rpcs.respond_to? :delete_backup_channel
                  @delete_backup_channel = ::Gapic::Config::Method.new delete_backup_channel_config
                  list_backup_plan_bindings_config = parent_rpcs.list_backup_plan_bindings if parent_rpcs.respond_to? :list_backup_plan_bindings
                  @list_backup_plan_bindings = ::Gapic::Config::Method.new list_backup_plan_bindings_config
                  get_backup_plan_binding_config = parent_rpcs.get_backup_plan_binding if parent_rpcs.respond_to? :get_backup_plan_binding
                  @get_backup_plan_binding = ::Gapic::Config::Method.new get_backup_plan_binding_config
                  create_backup_config = parent_rpcs.create_backup if parent_rpcs.respond_to? :create_backup
                  @create_backup = ::Gapic::Config::Method.new create_backup_config
                  list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                  @list_backups = ::Gapic::Config::Method.new list_backups_config
                  get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                  @get_backup = ::Gapic::Config::Method.new get_backup_config
                  update_backup_config = parent_rpcs.update_backup if parent_rpcs.respond_to? :update_backup
                  @update_backup = ::Gapic::Config::Method.new update_backup_config
                  delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                  @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                  list_volume_backups_config = parent_rpcs.list_volume_backups if parent_rpcs.respond_to? :list_volume_backups
                  @list_volume_backups = ::Gapic::Config::Method.new list_volume_backups_config
                  get_volume_backup_config = parent_rpcs.get_volume_backup if parent_rpcs.respond_to? :get_volume_backup
                  @get_volume_backup = ::Gapic::Config::Method.new get_volume_backup_config
                  create_restore_plan_config = parent_rpcs.create_restore_plan if parent_rpcs.respond_to? :create_restore_plan
                  @create_restore_plan = ::Gapic::Config::Method.new create_restore_plan_config
                  list_restore_plans_config = parent_rpcs.list_restore_plans if parent_rpcs.respond_to? :list_restore_plans
                  @list_restore_plans = ::Gapic::Config::Method.new list_restore_plans_config
                  get_restore_plan_config = parent_rpcs.get_restore_plan if parent_rpcs.respond_to? :get_restore_plan
                  @get_restore_plan = ::Gapic::Config::Method.new get_restore_plan_config
                  update_restore_plan_config = parent_rpcs.update_restore_plan if parent_rpcs.respond_to? :update_restore_plan
                  @update_restore_plan = ::Gapic::Config::Method.new update_restore_plan_config
                  delete_restore_plan_config = parent_rpcs.delete_restore_plan if parent_rpcs.respond_to? :delete_restore_plan
                  @delete_restore_plan = ::Gapic::Config::Method.new delete_restore_plan_config
                  create_restore_channel_config = parent_rpcs.create_restore_channel if parent_rpcs.respond_to? :create_restore_channel
                  @create_restore_channel = ::Gapic::Config::Method.new create_restore_channel_config
                  list_restore_channels_config = parent_rpcs.list_restore_channels if parent_rpcs.respond_to? :list_restore_channels
                  @list_restore_channels = ::Gapic::Config::Method.new list_restore_channels_config
                  get_restore_channel_config = parent_rpcs.get_restore_channel if parent_rpcs.respond_to? :get_restore_channel
                  @get_restore_channel = ::Gapic::Config::Method.new get_restore_channel_config
                  update_restore_channel_config = parent_rpcs.update_restore_channel if parent_rpcs.respond_to? :update_restore_channel
                  @update_restore_channel = ::Gapic::Config::Method.new update_restore_channel_config
                  delete_restore_channel_config = parent_rpcs.delete_restore_channel if parent_rpcs.respond_to? :delete_restore_channel
                  @delete_restore_channel = ::Gapic::Config::Method.new delete_restore_channel_config
                  list_restore_plan_bindings_config = parent_rpcs.list_restore_plan_bindings if parent_rpcs.respond_to? :list_restore_plan_bindings
                  @list_restore_plan_bindings = ::Gapic::Config::Method.new list_restore_plan_bindings_config
                  get_restore_plan_binding_config = parent_rpcs.get_restore_plan_binding if parent_rpcs.respond_to? :get_restore_plan_binding
                  @get_restore_plan_binding = ::Gapic::Config::Method.new get_restore_plan_binding_config
                  create_restore_config = parent_rpcs.create_restore if parent_rpcs.respond_to? :create_restore
                  @create_restore = ::Gapic::Config::Method.new create_restore_config
                  list_restores_config = parent_rpcs.list_restores if parent_rpcs.respond_to? :list_restores
                  @list_restores = ::Gapic::Config::Method.new list_restores_config
                  get_restore_config = parent_rpcs.get_restore if parent_rpcs.respond_to? :get_restore
                  @get_restore = ::Gapic::Config::Method.new get_restore_config
                  update_restore_config = parent_rpcs.update_restore if parent_rpcs.respond_to? :update_restore
                  @update_restore = ::Gapic::Config::Method.new update_restore_config
                  delete_restore_config = parent_rpcs.delete_restore if parent_rpcs.respond_to? :delete_restore
                  @delete_restore = ::Gapic::Config::Method.new delete_restore_config
                  list_volume_restores_config = parent_rpcs.list_volume_restores if parent_rpcs.respond_to? :list_volume_restores
                  @list_volume_restores = ::Gapic::Config::Method.new list_volume_restores_config
                  get_volume_restore_config = parent_rpcs.get_volume_restore if parent_rpcs.respond_to? :get_volume_restore
                  @get_volume_restore = ::Gapic::Config::Method.new get_volume_restore_config
                  get_backup_index_download_url_config = parent_rpcs.get_backup_index_download_url if parent_rpcs.respond_to? :get_backup_index_download_url
                  @get_backup_index_download_url = ::Gapic::Config::Method.new get_backup_index_download_url_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
