# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/geminidataanalytics/v1beta/data_chat_service_pb"
require "google/cloud/gemini_data_analytics/v1beta/data_chat_service/rest"


class ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_chat
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::Message.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    inline_context = {}
    project = "hello world"
    parent = "hello world"
    messages = [{}]

    chat_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, is_server_streaming:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ServiceStub.stub :transcode_chat_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, chat_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.chat({ inline_context: inline_context, project: project, parent: parent, messages: messages }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Use named arguments
        client.chat inline_context: inline_context, project: project, parent: parent, messages: messages do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Use protobuf object
        client.chat ::Google::Cloud::GeminiDataAnalytics::V1beta::ChatRequest.new(inline_context: inline_context, project: project, parent: parent, messages: messages) do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Use hash object with options
        client.chat({ inline_context: inline_context, project: project, parent: parent, messages: messages }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Use protobuf object with options
        client.chat(::Google::Cloud::GeminiDataAnalytics::V1beta::ChatRequest.new(inline_context: inline_context, project: project, parent: parent, messages: messages), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Verify method calls
        assert_equal 5, chat_client_stub.call_count
      end
    end
  end

  def test_create_conversation
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversation_id = "hello world"
    conversation = {}
    request_id = "hello world"

    create_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ServiceStub.stub :transcode_create_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_conversation({ parent: parent, conversation_id: conversation_id, conversation: conversation, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_conversation parent: parent, conversation_id: conversation_id, conversation: conversation, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_conversation ::Google::Cloud::GeminiDataAnalytics::V1beta::CreateConversationRequest.new(parent: parent, conversation_id: conversation_id, conversation: conversation, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_conversation({ parent: parent, conversation_id: conversation_id, conversation: conversation, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_conversation(::Google::Cloud::GeminiDataAnalytics::V1beta::CreateConversationRequest.new(parent: parent, conversation_id: conversation_id, conversation: conversation, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_conversation_client_stub.call_count
      end
    end
  end

  def test_delete_conversation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ServiceStub.stub :transcode_delete_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_conversation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_conversation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_conversation ::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteConversationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_conversation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_conversation(::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteConversationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_conversation_client_stub.call_count
      end
    end
  end

  def test_get_conversation
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ServiceStub.stub :transcode_get_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_conversation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_conversation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_conversation ::Google::Cloud::GeminiDataAnalytics::V1beta::GetConversationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_conversation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_conversation(::Google::Cloud::GeminiDataAnalytics::V1beta::GetConversationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_conversation_client_stub.call_count
      end
    end
  end

  def test_list_conversations
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::ListConversationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_conversations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ServiceStub.stub :transcode_list_conversations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_conversations_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_conversations parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_conversations ::Google::Cloud::GeminiDataAnalytics::V1beta::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_conversations(::Google::Cloud::GeminiDataAnalytics::V1beta::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_conversations_client_stub.call_count
      end
    end
  end

  def test_list_messages
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::ListMessagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_messages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ServiceStub.stub :transcode_list_messages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_messages_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_messages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_messages parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_messages ::Google::Cloud::GeminiDataAnalytics::V1beta::ListMessagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_messages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_messages(::Google::Cloud::GeminiDataAnalytics::V1beta::ListMessagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_messages_client_stub.call_count
      end
    end
  end

  def test_query_data
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    prompt = "hello world"
    context = {}
    generation_options = {}

    query_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ServiceStub.stub :transcode_query_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_data_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_data({ parent: parent, prompt: prompt, context: context, generation_options: generation_options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_data parent: parent, prompt: prompt, context: context, generation_options: generation_options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_data ::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataRequest.new(parent: parent, prompt: prompt, context: context, generation_options: generation_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_data({ parent: parent, prompt: prompt, context: context, generation_options: generation_options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_data(::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataRequest.new(parent: parent, prompt: prompt, context: context, generation_options: generation_options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_data_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client::Configuration, config
  end
end
