# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/geminidataanalytics/v1beta/data_agent_service_pb"
require "google/cloud/gemini_data_analytics/v1beta/data_agent_service/rest"


class ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_data_agents
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::ListDataAgentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    show_deleted = true

    list_data_agents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_list_data_agents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_agents_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_agents({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_agents parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_agents ::Google::Cloud::GeminiDataAnalytics::V1beta::ListDataAgentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_agents({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_agents(::Google::Cloud::GeminiDataAnalytics::V1beta::ListDataAgentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_agents_client_stub.call_count
      end
    end
  end

  def test_list_accessible_data_agents
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    show_deleted = true
    creator_filter = :CREATOR_FILTER_UNSPECIFIED

    list_accessible_data_agents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_list_accessible_data_agents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_accessible_data_agents_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_accessible_data_agents({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted, creator_filter: creator_filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_accessible_data_agents parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted, creator_filter: creator_filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_accessible_data_agents ::Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted, creator_filter: creator_filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_accessible_data_agents({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted, creator_filter: creator_filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_accessible_data_agents(::Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, show_deleted: show_deleted, creator_filter: creator_filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_accessible_data_agents_client_stub.call_count
      end
    end
  end

  def test_get_data_agent
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_agent_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_get_data_agent_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_agent_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_agent({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_agent name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_agent ::Google::Cloud::GeminiDataAnalytics::V1beta::GetDataAgentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_agent({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_agent(::Google::Cloud::GeminiDataAnalytics::V1beta::GetDataAgentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_agent_client_stub.call_count
      end
    end
  end

  def test_create_data_agent
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_agent_id = "hello world"
    data_agent = {}
    request_id = "hello world"

    create_data_agent_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_create_data_agent_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_agent_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_agent({ parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_agent parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_agent ::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest.new(parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_agent({ parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_agent(::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest.new(parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_agent_client_stub.call_count
      end
    end
  end

  def test_create_data_agent_sync
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_agent_id = "hello world"
    data_agent = {}
    request_id = "hello world"

    create_data_agent_sync_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_create_data_agent_sync_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_agent_sync_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_agent_sync({ parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_agent_sync parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_agent_sync ::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest.new(parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_agent_sync({ parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_agent_sync(::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest.new(parent: parent, data_agent_id: data_agent_id, data_agent: data_agent, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_agent_sync_client_stub.call_count
      end
    end
  end

  def test_update_data_agent
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_agent = {}
    request_id = "hello world"

    update_data_agent_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_update_data_agent_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_agent_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_agent({ update_mask: update_mask, data_agent: data_agent, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_agent update_mask: update_mask, data_agent: data_agent, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_agent ::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest.new(update_mask: update_mask, data_agent: data_agent, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_agent({ update_mask: update_mask, data_agent: data_agent, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_agent(::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest.new(update_mask: update_mask, data_agent: data_agent, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_agent_client_stub.call_count
      end
    end
  end

  def test_update_data_agent_sync
    # Create test objects.
    client_result = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_agent = {}
    request_id = "hello world"

    update_data_agent_sync_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_update_data_agent_sync_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_agent_sync_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_agent_sync({ update_mask: update_mask, data_agent: data_agent, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_agent_sync update_mask: update_mask, data_agent: data_agent, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_agent_sync ::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest.new(update_mask: update_mask, data_agent: data_agent, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_agent_sync({ update_mask: update_mask, data_agent: data_agent, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_agent_sync(::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest.new(update_mask: update_mask, data_agent: data_agent, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_agent_sync_client_stub.call_count
      end
    end
  end

  def test_delete_data_agent
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_data_agent_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_delete_data_agent_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_agent_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_agent({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_agent name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_agent ::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_agent({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_agent(::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_agent_client_stub.call_count
      end
    end
  end

  def test_delete_data_agent_sync
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_data_agent_sync_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_delete_data_agent_sync_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_agent_sync_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_agent_sync({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_agent_sync name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_agent_sync ::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_agent_sync({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_agent_sync(::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_agent_sync_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client::Configuration, config
  end
end
