# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        # A collection of references to datasources.
        # @!attribute [rw] bq
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::BigQueryTableReferences]
        #     References to BigQuery tables.
        #
        #     Note: The following fields are mutually exclusive: `bq`, `studio`, `looker`, `alloydb`, `spanner_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] studio
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::StudioDatasourceReferences]
        #     References to Looker Studio datasources.
        #
        #     Note: The following fields are mutually exclusive: `studio`, `bq`, `looker`, `alloydb`, `spanner_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] looker
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::LookerExploreReferences]
        #     References to Looker Explores.
        #
        #     Note: The following fields are mutually exclusive: `looker`, `bq`, `studio`, `alloydb`, `spanner_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] alloydb
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AlloyDbReference]
        #     Reference to an AlloyDB database. Only supported for the `QueryData`
        #     method.
        #
        #     Note: The following fields are mutually exclusive: `alloydb`, `bq`, `studio`, `looker`, `spanner_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] spanner_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::SpannerReference]
        #     Reference to a Spanner database. Only supported for the `QueryData`
        #     method.
        #
        #     Note: The following fields are mutually exclusive: `spanner_reference`, `bq`, `studio`, `looker`, `alloydb`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_sql_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::CloudSqlReference]
        #     Reference to a CloudSql database. Only supported for the `QueryData`
        #     method.
        #
        #     Note: The following fields are mutually exclusive: `cloud_sql_reference`, `bq`, `studio`, `looker`, `alloydb`, `spanner_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DatasourceReferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing references to BigQuery tables and property graphs.
        # At least one of `table_references` or `property_graph_references` must be
        # populated.
        # @!attribute [rw] table_references
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::BigQueryTableReference>]
        #     Optional. References to BigQuery tables.
        class BigQueryTableReferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a reference to a single BigQuery table.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The project that the table belongs to.
        # @!attribute [rw] dataset_id
        #   @return [::String]
        #     Required. The dataset that the table belongs to.
        # @!attribute [rw] table_id
        #   @return [::String]
        #     Required. The table id.
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Schema]
        #     Optional. The schema of the datasource.
        class BigQueryTableReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing references to Looker Studio datasources.
        # @!attribute [rw] studio_references
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::StudioDatasourceReference>]
        #     The references to the studio datasources.
        class StudioDatasourceReferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a reference to a single Looker Studio datasource.
        # @!attribute [rw] datasource_id
        #   @return [::String]
        #     Required. The id of the datasource.
        class StudioDatasourceReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing reference to an AlloyDB database and agent context.
        # Only supported for the `QueryData` method.
        # @!attribute [rw] database_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AlloyDbDatabaseReference]
        #     Required. Singular proto that supports specifying which database and tables
        #     to include.
        # @!attribute [rw] agent_context_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AgentContextReference]
        #     Optional. Parameters for retrieving data from Agent Context.
        class AlloyDbReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a reference to a single AlloyDB database.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The project the instance belongs to.
        # @!attribute [rw] region
        #   @return [::String]
        #     Required. The region of the instance.
        # @!attribute [rw] cluster_id
        #   @return [::String]
        #     Required. The cluster id.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. The instance id.
        # @!attribute [rw] database_id
        #   @return [::String]
        #     Required. The database id.
        # @!attribute [rw] table_ids
        #   @return [::Array<::String>]
        #     Optional. The table ids. Denotes all tables if unset.
        class AlloyDbDatabaseReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing reference to a Spanner database and agent context.
        # Only supported for the `QueryData` method.
        # @!attribute [rw] database_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::SpannerDatabaseReference]
        #     Required. Singular proto that supports specifying which database and tables
        #     to include.
        # @!attribute [rw] agent_context_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AgentContextReference]
        #     Optional. Parameters for retrieving data from Agent Context.
        class SpannerReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a reference to a single Spanner database.
        # @!attribute [rw] engine
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::SpannerDatabaseReference::Engine]
        #     Required. The engine of the Spanner instance.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The project the instance belongs to.
        # @!attribute [rw] region
        #   @return [::String]
        #     Required. The region of the instance.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. The instance id.
        # @!attribute [rw] database_id
        #   @return [::String]
        #     Required. The database id.
        # @!attribute [rw] table_ids
        #   @return [::Array<::String>]
        #     Optional. The table ids. Denotes all tables if unset.
        class SpannerDatabaseReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The database engine.
          module Engine
            # Engine is not specified.
            ENGINE_UNSPECIFIED = 0

            # Google SQL
            GOOGLE_SQL = 1

            # PostgreSQL
            POSTGRESQL = 2
          end
        end

        # Message representing reference to a CloudSQL database and agent context.
        # Only supported for the `QueryData` method.
        # @!attribute [rw] database_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::CloudSqlDatabaseReference]
        #     Required. Singular proto that supports specifying which database and tables
        #     to include.
        # @!attribute [rw] agent_context_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AgentContextReference]
        #     Optional. Parameters for retrieving data from Agent Context.
        class CloudSqlReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a reference to a single CloudSQL database.
        # @!attribute [rw] engine
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::CloudSqlDatabaseReference::Engine]
        #     Required. The engine of the Cloud SQL instance.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The project the instance belongs to.
        # @!attribute [rw] region
        #   @return [::String]
        #     Required. The region of the instance.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. The instance id.
        # @!attribute [rw] database_id
        #   @return [::String]
        #     Required. The database id.
        # @!attribute [rw] table_ids
        #   @return [::Array<::String>]
        #     Optional. The table ids. Denotes all tables if unset.
        class CloudSqlDatabaseReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The database engine.
          module Engine
            # Engine is not specified.
            ENGINE_UNSPECIFIED = 0

            # PostgreSQL
            POSTGRESQL = 1

            # MySQL
            MYSQL = 2
          end
        end

        # Message representing references to Looker explores.
        # @!attribute [rw] explore_references
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::LookerExploreReference>]
        #     Required. References to Looker explores.
        # @!attribute [rw] credentials
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Credentials]
        #     Optional. The credentials to use when calling the Looker API.
        #
        #     Currently supports both OAuth token and API key-based credentials, as
        #     described in
        #     [Authentication with an
        #     SDK](https://cloud.google.com/looker/docs/api-auth#authentication_with_an_sdk).
        class LookerExploreReferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a reference to a single Looker explore.
        # @!attribute [rw] looker_instance_uri
        #   @return [::String]
        #     Required. The base url of the Looker instance.
        #
        #     Note: The following fields are mutually exclusive: `looker_instance_uri`, `private_looker_instance_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] private_looker_instance_info
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::PrivateLookerInstanceInfo]
        #     Private Looker instance info.
        #
        #     Note: The following fields are mutually exclusive: `private_looker_instance_info`, `looker_instance_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] lookml_model
        #   @return [::String]
        #     Required. Looker model, as outlined in
        #     [Major LookML
        #     structures](https://cloud.google.com/looker/docs/lookml-terms-and-concepts#major_lookml_structures).
        #     Name of the LookML model.
        # @!attribute [rw] explore
        #   @return [::String]
        #     Required. Looker Explore, as outlined in
        #     [Major LookML
        #     structures](https://cloud.google.com/looker/docs/lookml-terms-and-concepts#major_lookml_structures).
        #     Name of the LookML Explore.
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Schema]
        #     Optional. The schema of the datasource.
        class LookerExploreReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a private Looker instance info required if the Looker
        # instance is behind a private network.
        # @!attribute [rw] looker_instance_id
        #   @return [::String]
        #     The Looker instance id.
        # @!attribute [rw] service_directory_name
        #   @return [::String]
        #     The service directory name of the Looker instance.
        class PrivateLookerInstanceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A datasource that can be used to answer questions.
        # @!attribute [rw] bigquery_table_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::BigQueryTableReference]
        #     A reference to a BigQuery table.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_table_reference`, `studio_datasource_id`, `looker_explore_reference`, `alloy_db_reference`, `spanner_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] studio_datasource_id
        #   @return [::String]
        #     A reference to a Looker Studio datasource.
        #
        #     Note: The following fields are mutually exclusive: `studio_datasource_id`, `bigquery_table_reference`, `looker_explore_reference`, `alloy_db_reference`, `spanner_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] looker_explore_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::LookerExploreReference]
        #     A reference to a Looker explore.
        #
        #     Note: The following fields are mutually exclusive: `looker_explore_reference`, `bigquery_table_reference`, `studio_datasource_id`, `alloy_db_reference`, `spanner_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] alloy_db_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AlloyDbReference]
        #     A reference to an AlloyDB database.
        #
        #     Note: The following fields are mutually exclusive: `alloy_db_reference`, `bigquery_table_reference`, `studio_datasource_id`, `looker_explore_reference`, `spanner_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] spanner_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::SpannerReference]
        #     A reference to a Spanner database.
        #
        #     Note: The following fields are mutually exclusive: `spanner_reference`, `bigquery_table_reference`, `studio_datasource_id`, `looker_explore_reference`, `alloy_db_reference`, `cloud_sql_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_sql_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::CloudSqlReference]
        #     A reference to a CloudSQL database.
        #
        #     Note: The following fields are mutually exclusive: `cloud_sql_reference`, `bigquery_table_reference`, `studio_datasource_id`, `looker_explore_reference`, `alloy_db_reference`, `spanner_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Schema]
        #     Optional. The schema of the datasource.
        # @!attribute [rw] struct_schema
        #   @return [::Google::Protobuf::Struct]
        #     Optional. A struct representation of the schema.
        #     This is populated for datasources with schemas that cannot be
        #     fully represented by the strongly-typed `schema` field.
        #
        #     For Looker datasources, this maps to the LookmlModelExplore type:
        #     https://cloud.google.com/looker/docs/reference/looker-api/latest/types/LookmlModelExplore
        class Datasource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The schema of a Datasource or QueryResult instance.
        # @!attribute [rw] fields
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Field>]
        #     Optional. The fields in the schema.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A textual description of the table's content and purpose.
        #     For example: "Contains information about customer orders in our e-commerce
        #     store." Currently only used for BigQuery data sources.
        # @!attribute [rw] synonyms
        #   @return [::Array<::String>]
        #     Optional. A list of alternative names or synonyms that can be used to refer
        #     to the table. For example: ["sales", "orders", "purchases"]. Currently only
        #     used for BigQuery data sources.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Optional. A list of tags or keywords associated with the table, used for
        #     categorization. For example: ["transaction", "revenue", "customer_data"].
        #     Currently only used for BigQuery data sources.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Table display_name (same as label in
        #     cloud/data_analytics/anarres/data/looker/proto/model_explore.proto), not
        #     required, currently only Looker has this field.
        # @!attribute [rw] filters
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::DataFilter>]
        #     Optional. The filters on the datasource's underlying data. Currently only
        #     used for Looker data sources.
        class Schema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A field in a schema.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The name of the field.
        # @!attribute [rw] type
        #   @return [::String]
        #     Optional. The type of the field.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A brief description of the field.
        # @!attribute [rw] mode
        #   @return [::String]
        #     Optional. The mode of the field (e.g., NULLABLE, REPEATED).
        # @!attribute [rw] synonyms
        #   @return [::Array<::String>]
        #     Optional. A list of alternative names or synonyms that can be used to refer
        #     to this field. For example: ["id", "customerid", "cust_id"]. Currently only
        #     used for BigQuery data sources.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Optional. A list of tags or keywords associated with the field, used for
        #     categorization. For example: ["identifier", "customer", "pii"]. Currently
        #     only used for BigQuery data sources.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Field display_name (same as label in
        # @!attribute [rw] subfields
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Field>]
        #     Optional. Recursive property for nested schema structures.
        # @!attribute [rw] category
        #   @return [::String]
        #     Optional. Field category, not required, currently only useful for Looker.
        #     We are using a string to avoid depending on an external package and keep
        #     this package self-contained.
        # @!attribute [rw] value_format
        #   @return [::String]
        #     Optional. Looker only. Value format of the field.
        #     Ref:
        #     https://cloud.google.com/looker/docs/reference/param-field-value-format
        class Field
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A filter on a datasource's underlying data. Filter syntax documentation:
        # https://cloud.google.com/looker/docs/filter-expressions
        # @!attribute [rw] field
        #   @return [::String]
        #     Optional. The field to filter on. For example: ["event_date",
        #     "customer_id", "product_category"]
        # @!attribute [rw] value
        #   @return [::String]
        #     Optional. The default value used for this filter if the filter is not
        #     overridden in a query. For example: ["after 2024-01-01", "123", "-fashion"]
        # @!attribute [rw] type
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataFilterType]
        #     Optional. The type of filter present on a datasource, such as
        #     ALWAYS_FILTER.
        class DataFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The type of filter present on a datasource, such as ALWAYS_FILTER.
        module DataFilterType
          # The filter type was not specified.
          DATA_FILTER_TYPE_UNSPECIFIED = 0

          # A filter that the user configures, and any queries to the Explore will
          # always apply this filter by default. Currently only used for Looker data
          # sources.
          ALWAYS_FILTER = 1
        end
      end
    end
  end
end
