# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        # Request to query data from a natural language query.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource to generate the query for.
        #     Format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] prompt
        #   @return [::String]
        #     Required. The natural language query for which to generate query.
        #     Example: "What are the top 5 best selling products this month?"
        # @!attribute [rw] context
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataContext]
        #     Required. The context for the data query, including the data sources to
        #     use.
        # @!attribute [rw] generation_options
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::GenerationOptions]
        #     Optional. Options to control query generation and execution behavior.
        class QueryDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to control query generation, execution, and response format.
        # @!attribute [rw] generate_query_result
        #   @return [::Boolean]
        #     Optional. If true, the generated query will be executed, and the result
        #     data will be returned in the response.
        # @!attribute [rw] generate_natural_language_answer
        #   @return [::Boolean]
        #     Optional. If true, a natural language answer based on the query execution
        #     result will be generated and returned in the response.
        # @!attribute [rw] generate_explanation
        #   @return [::Boolean]
        #     Optional. If true, an explanation of the generated query will be returned
        #     in the response.
        # @!attribute [rw] generate_disambiguation_question
        #   @return [::Boolean]
        #     Optional. If true (default to false), the service may return a
        #     clarifying_question if the input query is ambiguous.
        class GenerationOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # References to data sources and context to use for the query.
        # @!attribute [rw] datasource_references
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DatasourceReferences]
        #     Required. The datasource references to use for the query.
        class QueryDataContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response containing the generated query and related information.
        # @!attribute [rw] generated_query
        #   @return [::String]
        #     Generated query for the given user prompt.
        # @!attribute [rw] intent_explanation
        #   @return [::String]
        #     A natural language explanation of the generated query.
        #     Populated if options.generate_explanation was true in the request.
        # @!attribute [rw] query_result
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ExecutedQueryResult]
        #     The result of executing the query.
        #     Populated if options.generate_query_result or
        #     options.generate_natural_language_answer was true in the request, and
        #     execution was successful or attempted.
        # @!attribute [rw] natural_language_answer
        #   @return [::String]
        #     A natural language answer to the query, based on the query_result.
        #     Populated if options.generate_natural_language_answer was true in the
        #     request and query execution was successful based in the response from
        #     executeSql API.
        # @!attribute [rw] disambiguation_question
        #   @return [::Array<::String>]
        #     If ambiguity was detected in the natural language query and
        #     options.generate_disambiguation_question was true, this field contains a
        #     question to the user for clarification. The returned represents the
        #     service's best effort based on the ambiguous input.
        class QueryDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The result of a query execution. The design is generic for all dialects.
        # @!attribute [rw] columns
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::ExecutedQueryResult::Column>]
        #     The columns in the result set, in order.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::ExecutedQueryResult::Row>]
        #     The rows returned by the query.
        # @!attribute [rw] total_row_count
        #   @return [::Integer]
        #     The total number of rows in the full result set, if known.
        #     This may be an estimate or an exact count.
        # @!attribute [rw] partial_result
        #   @return [::Boolean]
        #     Set to true if the returned rows in `query_result` are a subset of the
        #     full result. This can happen, for example, if the query execution hits a
        #     row limit. When true, the `query_result` does not contain all
        #     rows. To retrieve the complete result, consider using the
        #     `generated_query` in `QueryDataResponse` and executing it in your own
        #     environment.
        # @!attribute [rw] query_execution_error
        #   @return [::String]
        #     The error message if the query execution failed.
        class ExecutedQueryResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes a single column in the result set.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the column.
          # @!attribute [rw] type
          #   @return [::String]
          #     The type of the column (e.g., "VARCHAR", "INT64", "TIMESTAMP").
          class Column
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a single value within a row.
          # @!attribute [rw] value
          #   @return [::String]
          #     The cell value, represented in a string format.
          #     Timestamps could be formatted, for example, using RFC3339Nano.
          #     This field is used if the value is not null.
          class Value
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a single row in the result set.
          # @!attribute [rw] values
          #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::ExecutedQueryResult::Value>]
          #     The values in the row, corresponding positionally to the columns.
          class Row
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for listing chat messages based on parent and conversation_id.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The conversation to list messages under.
        #     Format:
        #     `projects/{project}/locations/{location}/conversations/{conversation_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. The max page size is 100. All larger page sizes will be coerced
        #     to 100. If unspecified, server will pick 50 as an approperiate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results. See [AIP-160](https://google.aip.dev/160) for
        #     syntax.
        #
        #     ListMessages allows filtering by:
        #      * create_time (e.g., `createTime > "2025-01-28T06:51:56-08:00"`)
        #      * update_time
        class ListMessagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for listing chat messages.
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::StorageMessage>]
        #     The list of chat messages.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListMessagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A stored message containing user message or system message.
        # @!attribute [rw] message_id
        #   @return [::String]
        #     The unique resource name of a chat message.
        # @!attribute [rw] message
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Message]
        #     The message content.
        class StorageMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for Chat.
        # @!attribute [rw] inline_context
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Context]
        #     Optional. Inline context for the chat request. Use this to chat
        #     statelessly (without managed conversation persistence and without an
        #     Agent) by passing all context inline.
        #
        #     Note: The following fields are mutually exclusive: `inline_context`, `conversation_reference`, `data_agent_context`, `client_managed_resource_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] conversation_reference
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ConversationReference]
        #     Optional. Reference to a persisted conversation and agent context.
        #     Use this to chat with an Agent using managed conversation persistence.
        #
        #     Note: The following fields are mutually exclusive: `conversation_reference`, `inline_context`, `data_agent_context`, `client_managed_resource_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] data_agent_context
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentContext]
        #     Optional. Context for the chat request. Use this to chat with an Agent
        #     statelessly, without managed conversation persistence.
        #
        #     Note: The following fields are mutually exclusive: `data_agent_context`, `inline_context`, `conversation_reference`, `client_managed_resource_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] client_managed_resource_context
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ClientManagedResourceContext]
        #     Optional. Context with client managed resources.
        #     Some clients may not use GDA managed resources including
        #     conversations and agents, instead they create and manage their own
        #     conversations and agents resources.
        #
        #     Note: The following fields are mutually exclusive: `client_managed_resource_context`, `inline_context`, `conversation_reference`, `data_agent_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] project
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Optional. The Google Cloud project to be used for quota and billing.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for chat request.
        #     Pattern: `projects/{project}/locations/{location}`
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Message>]
        #     Required. Content of current conversation.
        class ChatRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Context for the chat request using a data agent.
        # @!attribute [rw] data_agent
        #   @return [::String]
        #     Required. The name of the data agent resource.
        # @!attribute [rw] credentials
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Credentials]
        #     Optional. The credentials to use when calling the Looker data source.
        #
        #     Currently supports both OAuth token and API key-based credentials, as
        #     described in
        #     [Authentication with an
        #     SDK](https://cloud.google.com/looker/docs/api-auth#authentication_with_an_sdk).
        # @!attribute [rw] context_version
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentContext::ContextVersion]
        #     Optional. Version of context to be used by DCS (e.g. STAGING, PUBLISHED)
        class DataAgentContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # List of context versions supported by DCS.
          # There are two versions of context. This is to maintain versioning for the
          # data agent.
          module ContextVersion
            # Unspecified or unrecognized.
            CONTEXT_VERSION_UNSPECIFIED = 0

            # Using this version, DCS will use the latest staging context for the
            # data agent.
            STAGING = 1

            # Using this version, DCS will use the latest published context for the
            # data agent.
            PUBLISHED = 2
          end
        end

        # Reference to a persisted conversation and agent context.
        # @!attribute [rw] conversation
        #   @return [::String]
        #     Required. Name of the conversation resource.
        #     Format:
        #     `projects/{project}/locations/{location}/conversations/{conversation_id}`
        # @!attribute [rw] data_agent_context
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentContext]
        #     Required. Context for the chat request using a data agent.
        class ConversationReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Context with client managed resources.
        # Some clients may not use GDA managed resources including
        # conversations and agents, instead they create and manage their own
        # conversations and agents resources.
        # @!attribute [rw] inline_context
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Context]
        #     Required. Context for the chat request. Use this to chat without GDA API
        #     managed conversation and agent persistence by passing all context inline.
        # @!attribute [rw] conversation_id
        #   @return [::String]
        #     Optional. The client managed conversation id.
        # @!attribute [rw] agent_id
        #   @return [::String]
        #     Optional. The client managed agent id.
        class ClientManagedResourceContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message from an interaction between the user and the system.
        # @!attribute [rw] user_message
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::UserMessage]
        #     A message from the user that is interacting with the system.
        #
        #     Note: The following fields are mutually exclusive: `user_message`, `system_message`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] system_message
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::SystemMessage]
        #     A message from the system in response to the user.
        #
        #     Note: The following fields are mutually exclusive: `system_message`, `user_message`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. For user messages, this is the time at which the system
        #     received the message. For system messages, this is the time at which the
        #     system generated the message.
        # @!attribute [rw] message_id
        #   @return [::String]
        #     Optional. unique id of the message in the conversation for persistence.
        class Message
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message from the user that is interacting with the system.
        # @!attribute [rw] text
        #   @return [::String]
        #     Text should use this field instead of blob.
        class UserMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message from the system in response to the user. This message can also be a
        # message from the user as historical context for multiturn conversations with
        # the system.
        # @!attribute [rw] text
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::TextMessage]
        #     A direct natural language response to the user message.
        #
        #     Note: The following fields are mutually exclusive: `text`, `schema`, `data`, `analysis`, `chart`, `error`, `example_queries`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::SchemaMessage]
        #     A message produced during schema resolution.
        #
        #     Note: The following fields are mutually exclusive: `schema`, `text`, `data`, `analysis`, `chart`, `error`, `example_queries`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] data
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataMessage]
        #     A message produced during data retrieval.
        #
        #     Note: The following fields are mutually exclusive: `data`, `text`, `schema`, `analysis`, `chart`, `error`, `example_queries`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] analysis
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AnalysisMessage]
        #     A message produced during analysis.
        #
        #     Note: The following fields are mutually exclusive: `analysis`, `text`, `schema`, `data`, `chart`, `error`, `example_queries`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] chart
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ChartMessage]
        #     A message produced during chart generation.
        #
        #     Note: The following fields are mutually exclusive: `chart`, `text`, `schema`, `data`, `analysis`, `error`, `example_queries`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] error
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ErrorMessage]
        #     An error message.
        #
        #     Note: The following fields are mutually exclusive: `error`, `text`, `schema`, `data`, `analysis`, `chart`, `example_queries`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] example_queries
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ExampleQueries]
        #     Optional. A message containing example queries.
        #
        #     Note: The following fields are mutually exclusive: `example_queries`, `text`, `schema`, `data`, `analysis`, `chart`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] group_id
        #   @return [::Integer]
        #     Identifies the group that the event belongs to. Similar events are deemed
        #     to be logically relevant to each other and should be shown together in
        #     the UI.
        class SystemMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A multi-part text message.
        # @!attribute [rw] parts
        #   @return [::Array<::String>]
        #     Optional. The parts of the message.
        # @!attribute [rw] text_type
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::TextMessage::TextType]
        #     Optional. The type of the text message.
        class TextMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the text message.
          module TextType
            # The default text type.
            TEXT_TYPE_UNSPECIFIED = 0

            # The text is a final response to the user question.
            FINAL_RESPONSE = 1

            # The text is a thinking plan generated by the thinking tool.
            THOUGHT = 2

            # The text is an informational message about the agent's progress, such as
            # a tool being invoked. This is distinct from the agent's internal thought
            # process (`THOUGHT`) and the final answer to the user
            # (`FINAL_RESPONSE`). These messages provide insight into the agent's
            # actions.
            PROGRESS = 3
          end
        end

        # A message produced during schema resolution.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::SchemaQuery]
        #     A schema resolution query.
        #
        #     Note: The following fields are mutually exclusive: `query`, `result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] result
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::SchemaResult]
        #     The result of a schema resolution query.
        #
        #     Note: The following fields are mutually exclusive: `result`, `query`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SchemaMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A query for resolving the schema relevant to the posed question.
        # @!attribute [rw] question
        #   @return [::String]
        #     Optional. The question to send to the system for schema resolution.
        class SchemaQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The result of schema resolution.
        # @!attribute [rw] datasources
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Datasource>]
        #     Optional. The datasources used to resolve the schema query.
        class SchemaResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message produced during data retrieval.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataQuery]
        #     A data retrieval query.
        #
        #     Note: The following fields are mutually exclusive: `query`, `generated_sql`, `result`, `generated_looker_query`, `big_query_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] generated_sql
        #   @return [::String]
        #     SQL generated by the system to retrieve data.
        #
        #     Note: The following fields are mutually exclusive: `generated_sql`, `query`, `result`, `generated_looker_query`, `big_query_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] result
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataResult]
        #     Retrieved data.
        #
        #     Note: The following fields are mutually exclusive: `result`, `query`, `generated_sql`, `generated_looker_query`, `big_query_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] generated_looker_query
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::LookerQuery]
        #     Looker Query generated by the system to retrieve data.
        #     DEPRECATED: generated looker query is now under DataQuery.looker.
        #
        #     Note: The following fields are mutually exclusive: `generated_looker_query`, `query`, `generated_sql`, `result`, `big_query_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] big_query_job
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::BigQueryJob]
        #     A BigQuery job executed by the system to retrieve data.
        #
        #     Note: The following fields are mutually exclusive: `big_query_job`, `query`, `generated_sql`, `result`, `generated_looker_query`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DataMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A query for retrieving data.
        # @!attribute [rw] looker
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::LookerQuery]
        #     Optional. A query for retrieving data from a Looker explore.
        # @!attribute [rw] question
        #   @return [::String]
        #     Optional. A natural language question to answer.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. A snake-case name for the query that reflects its intent. It is
        #     used to name the corresponding data result, so that it can be referenced in
        #     later steps.
        #
        #     * Example: "total_sales_by_product"
        #     * Example: "sales_for_product_12345"
        # @!attribute [rw] datasources
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Datasource>]
        #     Optional. The datasources available to answer the question.
        class DataQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Retrieved data.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. A snake-case name for the data result that reflects its contents.
        #     The name is used to pass the result around by reference, and serves as a
        #     signal about its meaning.
        #
        #     * Example: "total_sales_by_product"
        #     * Example: "sales_for_product_12345"
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Schema]
        #     Optional. The schema of the data.
        # @!attribute [rw] data
        #   @return [::Array<::Google::Protobuf::Struct>]
        #     Optional. The content of the data. Each row is a struct that matches the
        #     schema. Simple values are represented as strings, while nested structures
        #     are represented as lists or structs.
        class DataResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A BigQuery job executed by the system.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The project that the job belongs to.
        #
        #     See
        #     [JobReference](https://cloud.google.com/bigquery/docs/reference/rest/v2/JobReference).
        # @!attribute [rw] job_id
        #   @return [::String]
        #     Required. The ID of the job.
        #
        #     See
        #     [JobReference](https://cloud.google.com/bigquery/docs/reference/rest/v2/JobReference).
        # @!attribute [rw] location
        #   @return [::String]
        #     Optional. The location of the job.
        #
        #     See
        #     [JobReference](https://cloud.google.com/bigquery/docs/reference/rest/v2/JobReference).
        # @!attribute [rw] destination_table
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::BigQueryTableReference]
        #     Optional. A reference to the destination table of the job's query results.
        #
        #     See
        #     [JobConfigurationQuery](https://cloud.google.com/bigquery/docs/reference/rest/v2/Job#jobconfigurationquery).
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Schema]
        #     Optional. The schema of the job's query results.
        #
        #     See
        #     [JobStatistics2](https://cloud.google.com/bigquery/docs/reference/rest/v2/Job#jobstatistics2).
        class BigQueryJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message produced during analysis.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AnalysisQuery]
        #     An analysis query.
        #
        #     Note: The following fields are mutually exclusive: `query`, `progress_event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] progress_event
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AnalysisEvent]
        #     An event indicating the progress of the analysis.
        #
        #     Note: The following fields are mutually exclusive: `progress_event`, `query`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AnalysisMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A query for performing an analysis.
        # @!attribute [rw] question
        #   @return [::String]
        #     Optional. An analysis question to help answer the user's original question.
        # @!attribute [rw] data_result_names
        #   @return [::Array<::String>]
        #     Optional. The names of previously retrieved data results to analyze.
        class AnalysisQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event indicating the progress of an analysis.
        # @!attribute [rw] planner_reasoning
        #   @return [::String]
        #     Python codegen planner's reasoning.
        #
        #     Note: The following fields are mutually exclusive: `planner_reasoning`, `coder_instruction`, `code`, `execution_output`, `execution_error`, `result_vega_chart_json`, `result_natural_language`, `result_csv_data`, `result_reference_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] coder_instruction
        #   @return [::String]
        #     Instructions issued for code generation.
        #
        #     Note: The following fields are mutually exclusive: `coder_instruction`, `planner_reasoning`, `code`, `execution_output`, `execution_error`, `result_vega_chart_json`, `result_natural_language`, `result_csv_data`, `result_reference_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] code
        #   @return [::String]
        #     Generated code.
        #
        #     Note: The following fields are mutually exclusive: `code`, `planner_reasoning`, `coder_instruction`, `execution_output`, `execution_error`, `result_vega_chart_json`, `result_natural_language`, `result_csv_data`, `result_reference_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] execution_output
        #   @return [::String]
        #     Output from code execution.
        #
        #     Note: The following fields are mutually exclusive: `execution_output`, `planner_reasoning`, `coder_instruction`, `code`, `execution_error`, `result_vega_chart_json`, `result_natural_language`, `result_csv_data`, `result_reference_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] execution_error
        #   @return [::String]
        #     An error from code execution.
        #
        #     Note: The following fields are mutually exclusive: `execution_error`, `planner_reasoning`, `coder_instruction`, `code`, `execution_output`, `result_vega_chart_json`, `result_natural_language`, `result_csv_data`, `result_reference_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] result_vega_chart_json
        #   @return [::String]
        #     Result as Vega chart JSON string.
        #
        #     Note: The following fields are mutually exclusive: `result_vega_chart_json`, `planner_reasoning`, `coder_instruction`, `code`, `execution_output`, `execution_error`, `result_natural_language`, `result_csv_data`, `result_reference_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] result_natural_language
        #   @return [::String]
        #     Result as NL string.
        #
        #     Note: The following fields are mutually exclusive: `result_natural_language`, `planner_reasoning`, `coder_instruction`, `code`, `execution_output`, `execution_error`, `result_vega_chart_json`, `result_csv_data`, `result_reference_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] result_csv_data
        #   @return [::String]
        #     Result as CSV string.
        #
        #     Note: The following fields are mutually exclusive: `result_csv_data`, `planner_reasoning`, `coder_instruction`, `code`, `execution_output`, `execution_error`, `result_vega_chart_json`, `result_natural_language`, `result_reference_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] result_reference_data
        #   @return [::String]
        #     Result as a reference to a data source.
        #
        #     Note: The following fields are mutually exclusive: `result_reference_data`, `planner_reasoning`, `coder_instruction`, `code`, `execution_output`, `execution_error`, `result_vega_chart_json`, `result_natural_language`, `result_csv_data`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] error
        #   @return [::String]
        #     A generic error message.
        #
        #     Note: The following fields are mutually exclusive: `error`, `planner_reasoning`, `coder_instruction`, `code`, `execution_output`, `execution_error`, `result_vega_chart_json`, `result_natural_language`, `result_csv_data`, `result_reference_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AnalysisEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message produced during chart generation.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ChartQuery]
        #     A query for generating a chart.
        #
        #     Note: The following fields are mutually exclusive: `query`, `result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] result
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ChartResult]
        #     The result of a chart generation query.
        #
        #     Note: The following fields are mutually exclusive: `result`, `query`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ChartMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A query for generating a chart.
        # @!attribute [rw] instructions
        #   @return [::String]
        #     Optional. Natural language instructions for generating the chart.
        # @!attribute [rw] data_result_name
        #   @return [::String]
        #     Optional. The name of a previously retrieved data result to use in the
        #     chart.
        class ChartQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The result of a chart generation query.
        # @!attribute [rw] vega_config
        #   @return [::Google::Protobuf::Struct]
        #     Optional. A generated Vega chart config.
        #     See https://vega.github.io/vega/docs/config/
        # @!attribute [rw] image
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Blob]
        #     Optional. A rendering of the chart if this was requested in the context.
        class ChartResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An error message from a tool call.
        # This message is used to represent an error that occurred while an agent was
        # trying to use a tool. It's important to note that not all errors are
        # terminal. Many are recoverable, and the agent may use the information from
        # this error message to self-correct and retry the tool call or try a
        # different approach.
        #
        # For example, if a data query fails, the agent might receive an
        # `ErrorMessage`, analyze it, and then generate a corrected query.
        #
        # Clients should be cautious about interpreting this message as a definitive
        # failure. It can be part of the agent's normal, iterative process of
        # completing a task. Surfacing these errors directly to end-users without
        # context (e.g., as a "hard failure") may be misleading.
        # @!attribute [r] text
        #   @return [::String]
        #     Output only. The text of the error.
        class ErrorMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message containing derived and authored example queries.
        # @!attribute [rw] example_queries
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::ExampleQuery>]
        #     Optional. A list of derived and authored example queries, providing
        #     examples of relevant and commonly used SQL queries and their corresponding
        #     natural language queries optionally present. Currently only used for
        #     BigQuery data sources.
        class ExampleQueries
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A blob of data with a MIME type.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Required. The IANA standard MIME type of the message data.
        # @!attribute [rw] data
        #   @return [::String]
        #     Required. The data represented as bytes.
        class Blob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
