# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        # Message for requesting list of DataAgents.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListDataAgentsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListDataAgents` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListDataAgents` must
        #     match the call that provided the page token. The service may return fewer
        #     than this value.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results. See [AIP-160](https://google.aip.dev/160) for
        #     syntax.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. User specification for how to order the results.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Optional. If true, the list results will include soft-deleted DataAgents.
        #     Defaults to false.
        class ListDataAgentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing DataAgents.
        # @!attribute [rw] data_agents
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent>]
        #     The list of DataAgent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token or empty if none.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListDataAgentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of accessible DataAgents.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListAccessibleDataAgentsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListAccessibleDataAgents`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListAccessibleDataAgents` must match the call that provided the page
        #     token. The service may return fewer than this value.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results. See [AIP-160](https://google.aip.dev/160) for
        #     syntax.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. User specification for how to order the results.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Optional. If true, the list results will include soft-deleted DataAgents.
        #     Defaults to false.
        # @!attribute [rw] creator_filter
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsRequest::CreatorFilter]
        #     Optional. Filter for the creator of the agent.
        class ListAccessibleDataAgentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Filter for the creator of the agent.
          module CreatorFilter
            # Default value.
            CREATOR_FILTER_UNSPECIFIED = 0

            # No creator-specific filter will be applied. All agents will be returned.
            NONE = 1

            # Only agents created by the user calling the API will be returned.
            CREATOR_ONLY = 2

            # Only agents not created by the user calling the API will be returned.
            NOT_CREATOR_ONLY = 3
          end
        end

        # Message for response to listing accessible DataAgents.
        # @!attribute [rw] data_agents
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent>]
        #     The list of accessible DataAgent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token or empty if none.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListAccessibleDataAgentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a DataAgent.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetDataAgentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a DataAgent.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] data_agent_id
        #   @return [::String]
        #     Optional. Id of the requesting object. Must be unique within the parent.
        #     The allowed format is: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
        #     If not provided, the server will auto-generate a value for the id.
        # @!attribute [rw] data_agent
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateDataAgentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a DataAgent.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     DataAgent resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields with non-default values
        #     present in the request will be overwritten. If a wildcard mask is provided,
        #     all fields will be overwritten.
        # @!attribute [rw] data_agent
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateDataAgentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a DataAgent.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteDataAgentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
