# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        # Message describing a DataAgent object.
        # @!attribute [rw] data_analytics_agent
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAnalyticsAgent]
        #     Data analytics agent.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. Identifier. The unique resource name of a DataAgent.
        #     Format:
        #     `projects/{project}/locations/{location}/dataAgents/{data_agent_id}`
        #     `{data_agent}` is the resource id and should be 63 characters or less and
        #     must match the format described in
        #     https://google.aip.dev/122#resource-id-segments
        #
        #     Example: `projects/1234567890/locations/global/dataAgents/my-agent`.
        #
        #     It is recommended to skip setting this field during agent creation as it
        #     will be inferred automatically and overwritten with the
        #     \\{parent}/dataAgents/\\{data_agent_id}.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        #
        #     * Must be between 1-256 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the agent.
        #
        #     * Must be between 1-1024 characters.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels to help users filter related agents.
        #     For example, "sales", "business", "etl", and so on.
        #     Note labels are used only for filtering and not for policies.
        #     See the [labels
        #     documentation](https://cloud.google.com/resource-manager/docs/labels-overview)
        #     for more details on label usage.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the data agent was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the data agent was last updated.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] The time the data agent was soft deleted.
        # @!attribute [r] purge_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp in UTC of when this data agent is considered
        #     expired. This is *always* provided on output, regardless of what was sent
        #     on input.
        class DataAgent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
