# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        # Represents different forms of credential specification.
        # @!attribute [rw] oauth
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::OAuthCredentials]
        #     OAuth credentials.
        class Credentials
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents OAuth credentials.
        # @!attribute [rw] secret
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::OAuthCredentials::SecretBased]
        #     Secret-based OAuth credentials.
        #
        #     Note: The following fields are mutually exclusive: `secret`, `token`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] token
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::OAuthCredentials::TokenBased]
        #     Token-based OAuth credentials.
        #
        #     Note: The following fields are mutually exclusive: `token`, `secret`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class OAuthCredentials
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The name of the secret containing the access token.
          # Represents secret-based OAuth credentials.
          # @!attribute [rw] client_id
          #   @return [::String]
          #     Required. An OAuth client ID.
          # @!attribute [rw] client_secret
          #   @return [::String]
          #     Required. An OAuth client secret.
          class SecretBased
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Read more about Looker access tokens here:
          # https://developers.looker.com/api/advanced-usage/looker-api-oauth
          # @!attribute [rw] access_token
          #   @return [::String]
          #     Required. The name of the secret containing the access token.
          class TokenBased
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
