# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        # Message for a conversation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. Identifier. The unique resource name of a conversation. Format:
        #     `projects/{project}/locations/{location}/conversations/{conversation_id}`
        #     `{conversation_id}` is the resource id and should be 63 characters or less
        #     and must match the format described in
        #     https://google.aip.dev/122#resource-id-segments
        #
        #     Example:
        #     `projects/1234567890/locations/global/conversations/my-conversation`.
        #
        #     It is recommended to skip setting this field during conversation creation
        #     as it will be inferred automatically and overwritten with the
        #     \\{parent}/conversations/\\{conversation_id}.
        # @!attribute [rw] agents
        #   @return [::Array<::String>]
        #     Required. Agent(s) in the conversation.
        #     Currently, only one agent is supported. This field is repeated to allow
        #     for future support of multiple agents in a conversation.
        #     Format: `projects/{project}/locations/{location}/dataAgents/{agent}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp.
        # @!attribute [r] last_used_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp of the last used conversation.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Open-ended and user-defined labels that can be set by the client
        #     to tag a conversation (e.g. to filter conversations for specific
        #     surfaces/products).
        class Conversation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for creating a conversation.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for CreateConversationRequest.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] conversation_id
        #   @return [::String]
        #     Optional. The conversation id of the conversation to create.
        #     Must be unique within the parent.
        #     The allowed format is: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
        #     If not provided, the server will auto-generate a value for the id.
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation]
        #     Required. The conversation to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        class CreateConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting a conversation based on parent and conversation id.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        #     Format:
        #     `projects/{project}/locations/{location}/conversations/{conversation}`
        class GetConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for listing conversations based on parent.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListConversationsRequest.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. The max page size is 100. All larger page sizes will be coerced
        #     to 100. If unspecified, server will pick 50 as an approperiate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Returned conversations will match criteria specified within the
        #     filter. ListConversations allows filtering by:
        #      * agents
        #      * labels
        class ListConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing conversations.
        # @!attribute [rw] conversations
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation>]
        #     The list of conversations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for deleting a conversation based on parent and conversation id.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        #     Format:
        #     `projects/{project}/locations/{location}/conversations/{conversation}`
        class DeleteConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
