# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        # A collection of context to apply to this conversation
        # @!attribute [rw] system_instruction
        #   @return [::String]
        #     Optional. The basic entry point for data owners creating domain knowledge
        #     for Agent.
        #
        #     Why: Business jargon (e.g., YTD revenue is calculated as…, Retirement Age
        #     is 65 in the USA, etc) and system instructions (e.g., answer like a Pirate)
        #     can help the model understand the business context around a user question.
        # @!attribute [rw] datasource_references
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DatasourceReferences]
        #     Required. Data sources that are available for answering the question.
        # @!attribute [rw] options
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ConversationOptions]
        #     Optional. Additional options for the conversation.
        # @!attribute [rw] example_queries
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::ExampleQuery>]
        #     Optional. A list of example queries, providing examples of relevant and
        #     commonly used SQL queries and their corresponding natural language queries
        #     optionally present. Currently only used for BigQuery data sources.
        # @!attribute [rw] looker_golden_queries
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::LookerGoldenQuery>]
        #     Optional. A list of golden queries, providing examples of relevant and
        #     commonly used Looker queries and their corresponding natural language
        #     queries optionally present.
        # @!attribute [rw] glossary_terms
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::GlossaryTerm>]
        #     Optional. Term definitions (currently, only user authored)
        # @!attribute [rw] schema_relationships
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Context::SchemaRelationship>]
        #     Optional. Relationships between table schema, including referencing and
        #     referenced columns.
        class Context
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The relationship between two tables, including referencing and referenced
          # columns. This is a derived context retrieved from Dataplex Dataset
          # Insights.
          # @!attribute [rw] left_schema_paths
          #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Context::SchemaRelationship::SchemaPaths]
          #     An ordered list of fields for the join from the first table.
          #     The size of this list must be the same as `right_schema_paths`.
          #     Each field at index i in this list must correspond to a field at the same
          #     index in the `right_schema_paths` list.
          # @!attribute [rw] right_schema_paths
          #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Context::SchemaRelationship::SchemaPaths]
          #     An ordered list of fields for the join from the second table.
          #     The size of this list must be the same as `left_schema_paths`.
          #     Each field at index i in this list must correspond to a field at the same
          #     index in the `left_schema_paths` list.
          # @!attribute [rw] sources
          #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Context::SchemaRelationship::Source>]
          #     Sources which generated the schema relation edge.
          # @!attribute [rw] confidence_score
          #   @return [::Float]
          #     A confidence score for the suggested relationship.
          #     Manually added edges have the highest confidence score.
          class SchemaRelationship
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents an ordered set of paths within the table schema.
            # @!attribute [rw] table_fqn
            #   @return [::String]
            #     The service-qualified full resource name of the table
            #     Ex:
            #     bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
            # @!attribute [rw] paths
            #   @return [::Array<::String>]
            #     The ordered list of paths within the table schema.
            class SchemaPaths
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Source which generated the schema relation edge.
            module Source
              # The source of the schema relationship is unspecified.
              SOURCE_UNSPECIFIED = 0

              # The source of the schema relationship is BigQuery job history.
              BIGQUERY_JOB_HISTORY = 1

              # The source of the schema relationship is LLM suggested.
              LLM_SUGGESTED = 2

              # The source of the schema relationship is BigQuery table constraints.
              BIGQUERY_TABLE_CONSTRAINTS = 3
            end
          end
        end

        # Example of relevant and commonly used SQL query and its corresponding natural
        # language queries optionally present. Currently only used for BigQuery data
        # sources.
        # @!attribute [rw] sql_query
        #   @return [::String]
        #     Optional. The SQL query that should be generated to answer the natural
        #     language question. For example: "SELECT COUNT(*) FROM orders WHERE
        #     order_date BETWEEN '2024-01-01' AND '2024-01-31'"
        # @!attribute [rw] natural_language_question
        #   @return [::String]
        #     Optional. A natural language question that a user might ask.
        #     For example: "How many orders were placed last month?"
        class ExampleQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A golden query for Looker, including natural language questions and a
        # corresponding Looker Query. Analogous to ExampleQuery.
        # @!attribute [rw] natural_language_questions
        #   @return [::Array<::String>]
        #     Optional. Natural language questions that a user might ask.
        #     For example: "How many orders were placed last month?"
        # @!attribute [rw] looker_query
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::LookerQuery]
        #     Optional. The Looker Query corresponding to the natural language questions.
        class LookerGoldenQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Looker Query Object
        # [Looker API
        # documentation](https://cloud.google.com/looker/docs/reference/looker-api/latest/methods/Query/run_inline_query).
        # @!attribute [rw] model
        #   @return [::String]
        #     Required. The LookML model used to generate the query.
        # @!attribute [rw] explore
        #   @return [::String]
        #     Required. The LookML explore used to generate the query.
        # @!attribute [rw] fields
        #   @return [::Array<::String>]
        #     Optional. The fields to retrieve from the explore.
        # @!attribute [rw] filters
        #   @return [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::LookerQuery::Filter>]
        #     Optional. The filters to apply to the explore.
        # @!attribute [rw] sorts
        #   @return [::Array<::String>]
        #     Optional. The sorts to apply to the explore.
        # @!attribute [rw] limit
        #   @return [::String]
        #     Optional. Limit in the query.
        class LookerQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A Looker query filter.
          # @!attribute [rw] field
          #   @return [::String]
          #     Required. The field to filter on.
          # @!attribute [rw] value
          #   @return [::String]
          #     Required. The value for the field to filter on.
          class Filter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Definition of a term within a specific domain.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User friendly display name of the glossary term being defined.
        #     For example: "CTR", "conversion rate", "pending"
        # @!attribute [rw] description
        #   @return [::String]
        #     Required. The description or meaning of the term.
        #     For example: "Click-through rate", "The percentage of users who complete a
        #     desired action", "An order that is waiting to be processed."
        # @!attribute [rw] labels
        #   @return [::Array<::String>]
        #     Optional. A list of general purpose labels associated to this term.
        #     For example: ["click rate", "clickthrough", "waiting"]
        class GlossaryTerm
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options for the conversation.
        # @!attribute [rw] chart
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ChartOptions]
        #     Optional. Options for chart generation.
        # @!attribute [rw] analysis
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AnalysisOptions]
        #     Optional. Options for analysis.
        # @!attribute [rw] datasource
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DatasourceOptions]
        #     Optional. Options for datasources.
        class ConversationOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options for datasources configurations.
        # @!attribute [rw] big_query_max_billed_bytes
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. This option applies to datasources that require BigQuery queries
        #     only. Limits the bytes billed for each BQ query job. Queries that will have
        #     bytes billed beyond this limit will fail (without incurring a charge).
        #     If unspecified, no limit will be applied.
        class DatasourceOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options for chart generation.
        # @!attribute [rw] image
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ChartOptions::ImageOptions]
        #     Optional. When specified, the agent will render generated charts using the
        #     provided format. Defaults to no image.
        class ChartOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Options for rendering images of generated charts.
          # @!attribute [rw] no_image
          #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ChartOptions::ImageOptions::NoImage]
          #     No image.
          #
          #     Note: The following fields are mutually exclusive: `no_image`, `svg`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] svg
          #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::ChartOptions::ImageOptions::SvgOptions]
          #     SVG format.
          #
          #     Note: The following fields are mutually exclusive: `svg`, `no_image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ImageOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # No image.
            class NoImage
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # SVG options.
            class SvgOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Options for analysis.
        # @!attribute [rw] python
        #   @return [::Google::Cloud::GeminiDataAnalytics::V1beta::AnalysisOptions::Python]
        #     Optional. Options for Python analysis.
        class AnalysisOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Options for Python analysis.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Optional. Whether to enable Python analysis.
          #     Defaults to false.
          class Python
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
