# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/geminidataanalytics/v1beta/data_chat_service_pb"
require "google/cloud/gemini_data_analytics/v1beta/data_chat_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        module DataChatService
          module Rest
            ##
            # REST client for the DataChatService service.
            #
            # Service to ask a natural language question on top of BigQuery
            # and Looker Studio datasources to get back streamed responses of various kinds
            # to help provide a rich conversational answer.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "geminidataanalytics.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :data_chat_service_stub

              ##
              # Configure the DataChatService Client class.
              #
              # See {::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DataChatService clients
              #   ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "GeminiDataAnalytics", "V1beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 600.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DataChatService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @data_chat_service_stub.universe_domain
              end

              ##
              # Create a new DataChatService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DataChatService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @data_chat_service_stub = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @data_chat_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @data_chat_service_stub.endpoint
                  config.universe_domain = @data_chat_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @data_chat_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @data_chat_service_stub.logger
              end

              # Service calls

              ##
              # Answers a data question by generating a stream of
              # [Message][google.cloud.geminidataanalytics.v1alpha.Message] objects.
              #
              # @overload chat(request, options = nil)
              #   Pass arguments to `chat` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::ChatRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::ChatRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload chat(inline_context: nil, conversation_reference: nil, data_agent_context: nil, client_managed_resource_context: nil, project: nil, parent: nil, messages: nil)
              #   Pass arguments to `chat` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param inline_context [::Google::Cloud::GeminiDataAnalytics::V1beta::Context, ::Hash]
              #     Optional. Inline context for the chat request. Use this to chat
              #     statelessly (without managed conversation persistence and without an
              #     Agent) by passing all context inline.
              #
              #     Note: The following parameters are mutually exclusive: `inline_context`, `conversation_reference`, `data_agent_context`, `client_managed_resource_context`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param conversation_reference [::Google::Cloud::GeminiDataAnalytics::V1beta::ConversationReference, ::Hash]
              #     Optional. Reference to a persisted conversation and agent context.
              #     Use this to chat with an Agent using managed conversation persistence.
              #
              #     Note: The following parameters are mutually exclusive: `conversation_reference`, `inline_context`, `data_agent_context`, `client_managed_resource_context`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param data_agent_context [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentContext, ::Hash]
              #     Optional. Context for the chat request. Use this to chat with an Agent
              #     statelessly, without managed conversation persistence.
              #
              #     Note: The following parameters are mutually exclusive: `data_agent_context`, `inline_context`, `conversation_reference`, `client_managed_resource_context`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param client_managed_resource_context [::Google::Cloud::GeminiDataAnalytics::V1beta::ClientManagedResourceContext, ::Hash]
              #     Optional. Context with client managed resources.
              #     Some clients may not use GDA managed resources including
              #     conversations and agents, instead they create and manage their own
              #     conversations and agents resources.
              #
              #     Note: The following parameters are mutually exclusive: `client_managed_resource_context`, `inline_context`, `conversation_reference`, `data_agent_context`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param project [::String]
              #     Optional. The Google Cloud project to be used for quota and billing.
              #   @param parent [::String]
              #     Required. The parent value for chat request.
              #     Pattern: `projects/{project}/locations/{location}`
              #   @param messages [::Array<::Google::Cloud::GeminiDataAnalytics::V1beta::Message, ::Hash>]
              #     Required. Content of current conversation.
              # @return [::Enumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::Message>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::ChatRequest.new
              #
              #   # Call the chat method to start streaming.
              #   output = client.chat request
              #
              #   # The returned object is a streamed enumerable yielding elements of type
              #   # ::Google::Cloud::GeminiDataAnalytics::V1beta::Message
              #   output.each do |current_response|
              #     p current_response
              #   end
              #
              def chat request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::ChatRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.chat.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.chat.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.chat.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                ::Gapic::Rest::ServerStream.new(
                  ::Google::Cloud::GeminiDataAnalytics::V1beta::Message,
                  ::Gapic::Rest::ThreadedEnumerator.new do |in_q, out_q|
                    @data_chat_service_stub.chat request, options do |chunk|
                      in_q.deq
                      out_q.enq chunk
                    end
                  end
                )
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new conversation to persist the conversation history. Each
              # conversation will have multiple messages associated with it.
              #
              # @overload create_conversation(request, options = nil)
              #   Pass arguments to `create_conversation` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::CreateConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::CreateConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_conversation(parent: nil, conversation_id: nil, conversation: nil, request_id: nil)
              #   Pass arguments to `create_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for CreateConversationRequest.
              #     Format: `projects/{project}/locations/{location}`
              #   @param conversation_id [::String]
              #     Optional. The conversation id of the conversation to create.
              #     Must be unique within the parent.
              #     The allowed format is: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #     If not provided, the server will auto-generate a value for the id.
              #   @param conversation [::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation, ::Hash]
              #     Required. The conversation to create.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::CreateConversationRequest.new
              #
              #   # Call the create_conversation method.
              #   result = client.create_conversation request
              #
              #   # The returned object is of type Google::Cloud::GeminiDataAnalytics::V1beta::Conversation.
              #   p result
              #
              def create_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::CreateConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_chat_service_stub.create_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a conversation.
              #
              # @overload delete_conversation(request, options = nil)
              #   Pass arguments to `delete_conversation` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_conversation(name: nil)
              #   Pass arguments to `delete_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #     Format:
              #     `projects/{project}/locations/{location}/conversations/{conversation}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::DeleteConversationRequest.new
              #
              #   # Call the delete_conversation method.
              #   result = client.delete_conversation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_chat_service_stub.delete_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single conversation by using conversation id and parent.
              #
              # @overload get_conversation(request, options = nil)
              #   Pass arguments to `get_conversation` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::GetConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::GetConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_conversation(name: nil)
              #   Pass arguments to `get_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #     Format:
              #     `projects/{project}/locations/{location}/conversations/{conversation}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::GetConversationRequest.new
              #
              #   # Call the get_conversation method.
              #   result = client.get_conversation request
              #
              #   # The returned object is of type Google::Cloud::GeminiDataAnalytics::V1beta::Conversation.
              #   p result
              #
              def get_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::GetConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_chat_service_stub.get_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all conversations for a given parent.
              #
              # @overload list_conversations(request, options = nil)
              #   Pass arguments to `list_conversations` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::ListConversationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::ListConversationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_conversations(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_conversations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListConversationsRequest.
              #     Format: `projects/{project}/locations/{location}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. The max page size is 100. All larger page sizes will be coerced
              #     to 100. If unspecified, server will pick 50 as an approperiate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Returned conversations will match criteria specified within the
              #     filter. ListConversations allows filtering by:
              #      * agents
              #      * labels
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::ListConversationsRequest.new
              #
              #   # Call the list_conversations method.
              #   result = client.list_conversations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GeminiDataAnalytics::V1beta::Conversation.
              #     p item
              #   end
              #
              def list_conversations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::ListConversationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_conversations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_conversations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_conversations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_chat_service_stub.list_conversations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_chat_service_stub, :list_conversations, "conversations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all messages for a given conversation.
              #
              # @overload list_messages(request, options = nil)
              #   Pass arguments to `list_messages` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::ListMessagesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::ListMessagesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_messages(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_messages` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The conversation to list messages under.
              #     Format:
              #     `projects/{project}/locations/{location}/conversations/{conversation_id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. The max page size is 100. All larger page sizes will be coerced
              #     to 100. If unspecified, server will pick 50 as an approperiate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filtering results. See [AIP-160](https://google.aip.dev/160) for
              #     syntax.
              #
              #     ListMessages allows filtering by:
              #      * create_time (e.g., `createTime > "2025-01-28T06:51:56-08:00"`)
              #      * update_time
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::StorageMessage>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::StorageMessage>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::ListMessagesRequest.new
              #
              #   # Call the list_messages method.
              #   result = client.list_messages request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GeminiDataAnalytics::V1beta::StorageMessage.
              #     p item
              #   end
              #
              def list_messages request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::ListMessagesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_messages.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_messages.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_messages.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_chat_service_stub.list_messages request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_chat_service_stub, :list_messages, "messages", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Queries data from a natural language user query.
              #
              # @overload query_data(request, options = nil)
              #   Pass arguments to `query_data` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload query_data(parent: nil, prompt: nil, context: nil, generation_options: nil)
              #   Pass arguments to `query_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource to generate the query for.
              #     Format: projects/\\{project}/locations/\\{location}
              #   @param prompt [::String]
              #     Required. The natural language query for which to generate query.
              #     Example: "What are the top 5 best selling products this month?"
              #   @param context [::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataContext, ::Hash]
              #     Required. The context for the data query, including the data sources to
              #     use.
              #   @param generation_options [::Google::Cloud::GeminiDataAnalytics::V1beta::GenerationOptions, ::Hash]
              #     Optional. Options to control query generation and execution behavior.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataRequest.new
              #
              #   # Call the query_data method.
              #   result = client.query_data request
              #
              #   # The returned object is of type Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataResponse.
              #   p result
              #
              def query_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::QueryDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.query_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.query_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.query_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_chat_service_stub.query_data request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DataChatService REST API.
              #
              # This class represents the configuration for DataChatService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # chat to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.chat.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.chat.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "geminidataanalytics.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DataChatService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `chat`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :chat
                  ##
                  # RPC-specific configuration for `create_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_conversation
                  ##
                  # RPC-specific configuration for `delete_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_conversation
                  ##
                  # RPC-specific configuration for `get_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_conversation
                  ##
                  # RPC-specific configuration for `list_conversations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_conversations
                  ##
                  # RPC-specific configuration for `list_messages`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_messages
                  ##
                  # RPC-specific configuration for `query_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :query_data

                  # @private
                  def initialize parent_rpcs = nil
                    chat_config = parent_rpcs.chat if parent_rpcs.respond_to? :chat
                    @chat = ::Gapic::Config::Method.new chat_config
                    create_conversation_config = parent_rpcs.create_conversation if parent_rpcs.respond_to? :create_conversation
                    @create_conversation = ::Gapic::Config::Method.new create_conversation_config
                    delete_conversation_config = parent_rpcs.delete_conversation if parent_rpcs.respond_to? :delete_conversation
                    @delete_conversation = ::Gapic::Config::Method.new delete_conversation_config
                    get_conversation_config = parent_rpcs.get_conversation if parent_rpcs.respond_to? :get_conversation
                    @get_conversation = ::Gapic::Config::Method.new get_conversation_config
                    list_conversations_config = parent_rpcs.list_conversations if parent_rpcs.respond_to? :list_conversations
                    @list_conversations = ::Gapic::Config::Method.new list_conversations_config
                    list_messages_config = parent_rpcs.list_messages if parent_rpcs.respond_to? :list_messages
                    @list_messages = ::Gapic::Config::Method.new list_messages_config
                    query_data_config = parent_rpcs.query_data if parent_rpcs.respond_to? :query_data
                    @query_data = ::Gapic::Config::Method.new query_data_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
