# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/gemini_data_analytics/v1beta/version"

require "google/cloud/gemini_data_analytics/v1beta/data_chat_service/credentials"
require "google/cloud/gemini_data_analytics/v1beta/data_chat_service/paths"
require "google/cloud/gemini_data_analytics/v1beta/data_chat_service/client"
require "google/cloud/gemini_data_analytics/v1beta/data_chat_service/rest"

module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        ##
        # Service to ask a natural language question on top of BigQuery
        # and Looker Studio datasources to get back streamed responses of various kinds
        # to help provide a rich conversational answer.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/gemini_data_analytics/v1beta/data_chat_service"
        #     client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/gemini_data_analytics/v1beta/data_chat_service/rest"
        #     client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataChatService::Rest::Client.new
        #
        module DataChatService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "data_chat_service", "helpers.rb"
require "google/cloud/gemini_data_analytics/v1beta/data_chat_service/helpers" if ::File.file? helper_path
