# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/geminidataanalytics/v1beta/data_agent_service_pb"
require "google/cloud/gemini_data_analytics/v1beta/data_agent_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module GeminiDataAnalytics
      module V1beta
        module DataAgentService
          module Rest
            ##
            # REST client for the DataAgentService service.
            #
            # Service describing handlers for resources.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "geminidataanalytics.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :data_agent_service_stub

              ##
              # Configure the DataAgentService Client class.
              #
              # See {::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DataAgentService clients
              #   ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "GeminiDataAnalytics", "V1beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 600.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DataAgentService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @data_agent_service_stub.universe_domain
              end

              ##
              # Create a new DataAgentService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DataAgentService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @data_agent_service_stub = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @data_agent_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @data_agent_service_stub.endpoint
                  config.universe_domain = @data_agent_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @data_agent_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @data_agent_service_stub.logger
              end

              # Service calls

              ##
              # Lists DataAgents in a given project and location.
              #
              # @overload list_data_agents(request, options = nil)
              #   Pass arguments to `list_data_agents` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::ListDataAgentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::ListDataAgentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_data_agents(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, show_deleted: nil)
              #   Pass arguments to `list_data_agents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListDataAgentsRequest.
              #   @param page_size [::Integer]
              #     Optional. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListDataAgents` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListDataAgents` must
              #     match the call that provided the page token. The service may return fewer
              #     than this value.
              #   @param filter [::String]
              #     Optional. Filtering results. See [AIP-160](https://google.aip.dev/160) for
              #     syntax.
              #   @param order_by [::String]
              #     Optional. User specification for how to order the results.
              #   @param show_deleted [::Boolean]
              #     Optional. If true, the list results will include soft-deleted DataAgents.
              #     Defaults to false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::ListDataAgentsRequest.new
              #
              #   # Call the list_data_agents method.
              #   result = client.list_data_agents request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent.
              #     p item
              #   end
              #
              def list_data_agents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::ListDataAgentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_data_agents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_data_agents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_data_agents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.list_data_agents request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_agent_service_stub, :list_data_agents, "data_agents", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DataAgents that are accessible to the caller in a given project and
              # location.
              #
              # @overload list_accessible_data_agents(request, options = nil)
              #   Pass arguments to `list_accessible_data_agents` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_accessible_data_agents(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, show_deleted: nil, creator_filter: nil)
              #   Pass arguments to `list_accessible_data_agents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListAccessibleDataAgentsRequest.
              #   @param page_size [::Integer]
              #     Optional. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListAccessibleDataAgents`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListAccessibleDataAgents` must match the call that provided the page
              #     token. The service may return fewer than this value.
              #   @param filter [::String]
              #     Optional. Filtering results. See [AIP-160](https://google.aip.dev/160) for
              #     syntax.
              #   @param order_by [::String]
              #     Optional. User specification for how to order the results.
              #   @param show_deleted [::Boolean]
              #     Optional. If true, the list results will include soft-deleted DataAgents.
              #     Defaults to false.
              #   @param creator_filter [::Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsRequest::CreatorFilter]
              #     Optional. Filter for the creator of the agent.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsRequest.new
              #
              #   # Call the list_accessible_data_agents method.
              #   result = client.list_accessible_data_agents request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent.
              #     p item
              #   end
              #
              def list_accessible_data_agents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::ListAccessibleDataAgentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_accessible_data_agents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_accessible_data_agents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_accessible_data_agents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.list_accessible_data_agents request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_agent_service_stub, :list_accessible_data_agents, "data_agents", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single DataAgent.
              #
              # @overload get_data_agent(request, options = nil)
              #   Pass arguments to `get_data_agent` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::GetDataAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::GetDataAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_data_agent(name: nil)
              #   Pass arguments to `get_data_agent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::GetDataAgentRequest.new
              #
              #   # Call the get_data_agent method.
              #   result = client.get_data_agent request
              #
              #   # The returned object is of type Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent.
              #   p result
              #
              def get_data_agent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::GetDataAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_data_agent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_data_agent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_data_agent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.get_data_agent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new DataAgent in a given project and location.
              #
              # @overload create_data_agent(request, options = nil)
              #   Pass arguments to `create_data_agent` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_data_agent(parent: nil, data_agent_id: nil, data_agent: nil, request_id: nil)
              #   Pass arguments to `create_data_agent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param data_agent_id [::String]
              #     Optional. Id of the requesting object. Must be unique within the parent.
              #     The allowed format is: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #     If not provided, the server will auto-generate a value for the id.
              #   @param data_agent [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest.new
              #
              #   # Call the create_data_agent method.
              #   result = client.create_data_agent request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_data_agent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_data_agent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_data_agent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_data_agent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.create_data_agent request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new DataAgent in a given project and location synchronously.
              #
              # @overload create_data_agent_sync(request, options = nil)
              #   Pass arguments to `create_data_agent_sync` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_data_agent_sync(parent: nil, data_agent_id: nil, data_agent: nil, request_id: nil)
              #   Pass arguments to `create_data_agent_sync` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param data_agent_id [::String]
              #     Optional. Id of the requesting object. Must be unique within the parent.
              #     The allowed format is: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #     If not provided, the server will auto-generate a value for the id.
              #   @param data_agent [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest.new
              #
              #   # Call the create_data_agent_sync method.
              #   result = client.create_data_agent_sync request
              #
              #   # The returned object is of type Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent.
              #   p result
              #
              def create_data_agent_sync request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::CreateDataAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_data_agent_sync.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_data_agent_sync.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_data_agent_sync.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.create_data_agent_sync request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single DataAgent.
              #
              # @overload update_data_agent(request, options = nil)
              #   Pass arguments to `update_data_agent` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_data_agent(update_mask: nil, data_agent: nil, request_id: nil)
              #   Pass arguments to `update_data_agent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     DataAgent resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields with non-default values
              #     present in the request will be overwritten. If a wildcard mask is provided,
              #     all fields will be overwritten.
              #   @param data_agent [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent, ::Hash]
              #     Required. The resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest.new
              #
              #   # Call the update_data_agent method.
              #   result = client.update_data_agent request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_data_agent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_data_agent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_data_agent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_data_agent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.update_data_agent request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single DataAgent synchronously.
              #
              # @overload update_data_agent_sync(request, options = nil)
              #   Pass arguments to `update_data_agent_sync` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_data_agent_sync(update_mask: nil, data_agent: nil, request_id: nil)
              #   Pass arguments to `update_data_agent_sync` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     DataAgent resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields with non-default values
              #     present in the request will be overwritten. If a wildcard mask is provided,
              #     all fields will be overwritten.
              #   @param data_agent [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent, ::Hash]
              #     Required. The resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest.new
              #
              #   # Call the update_data_agent_sync method.
              #   result = client.update_data_agent_sync request
              #
              #   # The returned object is of type Google::Cloud::GeminiDataAnalytics::V1beta::DataAgent.
              #   p result
              #
              def update_data_agent_sync request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::UpdateDataAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_data_agent_sync.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_data_agent_sync.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_data_agent_sync.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.update_data_agent_sync request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single DataAgent.
              #
              # @overload delete_data_agent(request, options = nil)
              #   Pass arguments to `delete_data_agent` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_data_agent(name: nil, request_id: nil)
              #   Pass arguments to `delete_data_agent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest.new
              #
              #   # Call the delete_data_agent method.
              #   result = client.delete_data_agent request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_data_agent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_data_agent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_data_agent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_data_agent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.delete_data_agent request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single DataAgent synchronously.
              #
              # @overload delete_data_agent_sync(request, options = nil)
              #   Pass arguments to `delete_data_agent_sync` via a request object, either of type
              #   {::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_data_agent_sync(name: nil, request_id: nil)
              #   Pass arguments to `delete_data_agent_sync` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest.new
              #
              #   # Call the delete_data_agent_sync method.
              #   result = client.delete_data_agent_sync request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_data_agent_sync request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GeminiDataAnalytics::V1beta::DeleteDataAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_data_agent_sync.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_data_agent_sync.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_data_agent_sync.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.delete_data_agent_sync request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the IAM policy for DataAgent
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the IAM policy for a DataAgent.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gemini_data_analytics/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GeminiDataAnalytics::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_agent_service_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DataAgentService REST API.
              #
              # This class represents the configuration for DataAgentService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_data_agents to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_data_agents.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::GeminiDataAnalytics::V1beta::DataAgentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_data_agents.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "geminidataanalytics.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DataAgentService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_data_agents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_data_agents
                  ##
                  # RPC-specific configuration for `list_accessible_data_agents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_accessible_data_agents
                  ##
                  # RPC-specific configuration for `get_data_agent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_agent
                  ##
                  # RPC-specific configuration for `create_data_agent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_data_agent
                  ##
                  # RPC-specific configuration for `create_data_agent_sync`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_data_agent_sync
                  ##
                  # RPC-specific configuration for `update_data_agent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_agent
                  ##
                  # RPC-specific configuration for `update_data_agent_sync`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_agent_sync
                  ##
                  # RPC-specific configuration for `delete_data_agent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_data_agent
                  ##
                  # RPC-specific configuration for `delete_data_agent_sync`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_data_agent_sync
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy

                  # @private
                  def initialize parent_rpcs = nil
                    list_data_agents_config = parent_rpcs.list_data_agents if parent_rpcs.respond_to? :list_data_agents
                    @list_data_agents = ::Gapic::Config::Method.new list_data_agents_config
                    list_accessible_data_agents_config = parent_rpcs.list_accessible_data_agents if parent_rpcs.respond_to? :list_accessible_data_agents
                    @list_accessible_data_agents = ::Gapic::Config::Method.new list_accessible_data_agents_config
                    get_data_agent_config = parent_rpcs.get_data_agent if parent_rpcs.respond_to? :get_data_agent
                    @get_data_agent = ::Gapic::Config::Method.new get_data_agent_config
                    create_data_agent_config = parent_rpcs.create_data_agent if parent_rpcs.respond_to? :create_data_agent
                    @create_data_agent = ::Gapic::Config::Method.new create_data_agent_config
                    create_data_agent_sync_config = parent_rpcs.create_data_agent_sync if parent_rpcs.respond_to? :create_data_agent_sync
                    @create_data_agent_sync = ::Gapic::Config::Method.new create_data_agent_sync_config
                    update_data_agent_config = parent_rpcs.update_data_agent if parent_rpcs.respond_to? :update_data_agent
                    @update_data_agent = ::Gapic::Config::Method.new update_data_agent_config
                    update_data_agent_sync_config = parent_rpcs.update_data_agent_sync if parent_rpcs.respond_to? :update_data_agent_sync
                    @update_data_agent_sync = ::Gapic::Config::Method.new update_data_agent_sync_config
                    delete_data_agent_config = parent_rpcs.delete_data_agent if parent_rpcs.respond_to? :delete_data_agent
                    @delete_data_agent = ::Gapic::Config::Method.new delete_data_agent_config
                    delete_data_agent_sync_config = parent_rpcs.delete_data_agent_sync if parent_rpcs.respond_to? :delete_data_agent_sync
                    @delete_data_agent_sync = ::Gapic::Config::Method.new delete_data_agent_sync_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
