# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/gdchardwaremanagement/v1alpha/service_pb"
require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management"

class ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_orders
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_orders_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_orders, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_orders_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_orders({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_orders parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_orders ::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_orders({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_orders(::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_orders_client_stub.call_rpc_count
    end
  end

  def test_get_order
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::Order.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_order, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_order_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_order({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_order name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_order ::Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_order({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_order(::Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_order_client_stub.call_rpc_count
    end
  end

  def test_create_order
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    order_id = "hello world"
    order = {}
    request_id = "hello world"

    create_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_order, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["order_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Order), request["order"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_order_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_order({ parent: parent, order_id: order_id, order: order, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_order parent: parent, order_id: order_id, order: order, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_order ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest.new(parent: parent, order_id: order_id, order: order, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_order({ parent: parent, order_id: order_id, order: order, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_order(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest.new(parent: parent, order_id: order_id, order: order, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_order_client_stub.call_rpc_count
    end
  end

  def test_update_order
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    order = {}
    request_id = "hello world"

    update_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_order, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Order), request["order"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_order_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_order({ update_mask: update_mask, order: order, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_order update_mask: update_mask, order: order, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_order ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest.new(update_mask: update_mask, order: order, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_order({ update_mask: update_mask, order: order, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_order(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest.new(update_mask: update_mask, order: order, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_order_client_stub.call_rpc_count
    end
  end

  def test_delete_order
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_order, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_order_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_order({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_order name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_order ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_order({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_order(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_order_client_stub.call_rpc_count
    end
  end

  def test_submit_order
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    type = :TYPE_UNSPECIFIED

    submit_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :submit_order, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal :TYPE_UNSPECIFIED, request["type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, submit_order_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.submit_order({ name: name, request_id: request_id, type: type }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.submit_order name: name, request_id: request_id, type: type do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.submit_order ::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest.new(name: name, request_id: request_id, type: type) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.submit_order({ name: name, request_id: request_id, type: type }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.submit_order(::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest.new(name: name, request_id: request_id, type: type), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, submit_order_client_stub.call_rpc_count
    end
  end

  def test_cancel_order
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    cancel_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_order, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_order_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_order({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_order name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_order ::Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_order({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_order(::Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_order_client_stub.call_rpc_count
    end
  end

  def test_list_sites
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_sites_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sites, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sites_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sites({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sites parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sites ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sites({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sites(::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sites_client_stub.call_rpc_count
    end
  end

  def test_get_site
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::Site.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_site_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_site, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_site_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_site({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_site name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_site ::Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_site({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_site(::Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_site_client_stub.call_rpc_count
    end
  end

  def test_create_site
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    site_id = "hello world"
    site = {}
    request_id = "hello world"

    create_site_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_site, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["site_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Site), request["site"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_site_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_site({ parent: parent, site_id: site_id, site: site, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_site parent: parent, site_id: site_id, site: site, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_site ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest.new(parent: parent, site_id: site_id, site: site, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_site({ parent: parent, site_id: site_id, site: site, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_site(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest.new(parent: parent, site_id: site_id, site: site, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_site_client_stub.call_rpc_count
    end
  end

  def test_update_site
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    site = {}
    request_id = "hello world"

    update_site_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_site, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Site), request["site"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_site_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_site({ update_mask: update_mask, site: site, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_site update_mask: update_mask, site: site, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_site ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest.new(update_mask: update_mask, site: site, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_site({ update_mask: update_mask, site: site, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_site(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest.new(update_mask: update_mask, site: site, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_site_client_stub.call_rpc_count
    end
  end

  def test_delete_site
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_site_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_site, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_site_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_site({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_site name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_site ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_site({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_site(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_site_client_stub.call_rpc_count
    end
  end

  def test_list_hardware_groups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_hardware_groups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_hardware_groups, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_hardware_groups_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_hardware_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_hardware_groups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_hardware_groups ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_hardware_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_hardware_groups(::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_hardware_groups_client_stub.call_rpc_count
    end
  end

  def test_get_hardware_group
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hardware_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_hardware_group, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_hardware_group_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_hardware_group({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_hardware_group name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_hardware_group ::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_hardware_group({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_hardware_group(::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_hardware_group_client_stub.call_rpc_count
    end
  end

  def test_create_hardware_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hardware_group_id = "hello world"
    hardware_group = {}
    request_id = "hello world"

    create_hardware_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_hardware_group, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["hardware_group_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup), request["hardware_group"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_hardware_group_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_hardware_group({ parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_hardware_group parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_hardware_group ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest.new(parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_hardware_group({ parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_hardware_group(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest.new(parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_hardware_group_client_stub.call_rpc_count
    end
  end

  def test_update_hardware_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    hardware_group = {}
    request_id = "hello world"

    update_hardware_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_hardware_group, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup), request["hardware_group"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_hardware_group_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_hardware_group({ update_mask: update_mask, hardware_group: hardware_group, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_hardware_group update_mask: update_mask, hardware_group: hardware_group, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_hardware_group ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest.new(update_mask: update_mask, hardware_group: hardware_group, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_hardware_group({ update_mask: update_mask, hardware_group: hardware_group, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_hardware_group(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest.new(update_mask: update_mask, hardware_group: hardware_group, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_hardware_group_client_stub.call_rpc_count
    end
  end

  def test_delete_hardware_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_hardware_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_hardware_group, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_hardware_group_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_hardware_group({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_hardware_group name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_hardware_group ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_hardware_group({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_hardware_group(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_hardware_group_client_stub.call_rpc_count
    end
  end

  def test_list_hardware
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_hardware_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_hardware, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_hardware_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_hardware({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_hardware parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_hardware({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_hardware_client_stub.call_rpc_count
    end
  end

  def test_get_hardware
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hardware_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_hardware, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_hardware_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_hardware({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_hardware name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_hardware({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_hardware_client_stub.call_rpc_count
    end
  end

  def test_create_hardware
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hardware_id = "hello world"
    hardware = {}

    create_hardware_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_hardware, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["hardware_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware), request["hardware"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_hardware_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_hardware({ parent: parent, hardware_id: hardware_id, hardware: hardware }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_hardware parent: parent, hardware_id: hardware_id, hardware: hardware do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest.new(parent: parent, hardware_id: hardware_id, hardware: hardware) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_hardware({ parent: parent, hardware_id: hardware_id, hardware: hardware }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest.new(parent: parent, hardware_id: hardware_id, hardware: hardware), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_hardware_client_stub.call_rpc_count
    end
  end

  def test_update_hardware
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    hardware = {}
    request_id = "hello world"

    update_hardware_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_hardware, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware), request["hardware"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_hardware_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_hardware({ update_mask: update_mask, hardware: hardware, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_hardware update_mask: update_mask, hardware: hardware, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest.new(update_mask: update_mask, hardware: hardware, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_hardware({ update_mask: update_mask, hardware: hardware, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest.new(update_mask: update_mask, hardware: hardware, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_hardware_client_stub.call_rpc_count
    end
  end

  def test_delete_hardware
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_hardware_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_hardware, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_hardware_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_hardware({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_hardware name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_hardware({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_hardware_client_stub.call_rpc_count
    end
  end

  def test_list_comments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_comments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_comments, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_comments_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_comments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_comments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_comments ::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_comments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_comments(::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_comments_client_stub.call_rpc_count
    end
  end

  def test_get_comment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::Comment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_comment, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_comment_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_comment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_comment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_comment ::Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_comment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_comment(::Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_comment_client_stub.call_rpc_count
    end
  end

  def test_create_comment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    comment_id = "hello world"
    comment = {}
    request_id = "hello world"

    create_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_comment, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["comment_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Comment), request["comment"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_comment_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_comment({ parent: parent, comment_id: comment_id, comment: comment, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_comment parent: parent, comment_id: comment_id, comment: comment, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_comment ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest.new(parent: parent, comment_id: comment_id, comment: comment, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_comment({ parent: parent, comment_id: comment_id, comment: comment, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_comment(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest.new(parent: parent, comment_id: comment_id, comment: comment, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_comment_client_stub.call_rpc_count
    end
  end

  def test_record_action_on_comment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::Comment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    action_type = :ACTION_TYPE_UNSPECIFIED

    record_action_on_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :record_action_on_comment, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :ACTION_TYPE_UNSPECIFIED, request["action_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, record_action_on_comment_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.record_action_on_comment({ name: name, action_type: action_type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.record_action_on_comment name: name, action_type: action_type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.record_action_on_comment ::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest.new(name: name, action_type: action_type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.record_action_on_comment({ name: name, action_type: action_type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.record_action_on_comment(::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest.new(name: name, action_type: action_type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, record_action_on_comment_client_stub.call_rpc_count
    end
  end

  def test_list_change_log_entries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_change_log_entries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_change_log_entries, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_change_log_entries_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_change_log_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_change_log_entries parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_change_log_entries ::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_change_log_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_change_log_entries(::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_change_log_entries_client_stub.call_rpc_count
    end
  end

  def test_get_change_log_entry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_change_log_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_change_log_entry, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_change_log_entry_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_change_log_entry({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_change_log_entry name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_change_log_entry ::Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_change_log_entry({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_change_log_entry(::Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_change_log_entry_client_stub.call_rpc_count
    end
  end

  def test_list_skus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_skus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_skus, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_skus_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_skus({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_skus parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_skus ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_skus({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_skus(::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_skus_client_stub.call_rpc_count
    end
  end

  def test_get_sku
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::Sku.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_sku_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_sku, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_sku_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_sku({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_sku name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_sku ::Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_sku({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_sku(::Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_sku_client_stub.call_rpc_count
    end
  end

  def test_list_zones
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_zones_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_zones, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_zones_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_zones({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_zones parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_zones ::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_zones({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_zones(::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_zones_client_stub.call_rpc_count
    end
  end

  def test_get_zone
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GDCHardwareManagement::V1alpha::Zone.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_zone_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_zone, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_zone_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_zone({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_zone name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_zone ::Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_zone({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_zone(::Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_zone_client_stub.call_rpc_count
    end
  end

  def test_create_zone
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    zone_id = "hello world"
    zone = {}
    request_id = "hello world"

    create_zone_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_zone, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["zone_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Zone), request["zone"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_zone_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_zone({ parent: parent, zone_id: zone_id, zone: zone, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_zone parent: parent, zone_id: zone_id, zone: zone, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_zone ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest.new(parent: parent, zone_id: zone_id, zone: zone, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_zone({ parent: parent, zone_id: zone_id, zone: zone, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_zone(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest.new(parent: parent, zone_id: zone_id, zone: zone, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_zone_client_stub.call_rpc_count
    end
  end

  def test_update_zone
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    zone = {}
    request_id = "hello world"

    update_zone_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_zone, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::Zone), request["zone"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_zone_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_zone({ update_mask: update_mask, zone: zone, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_zone update_mask: update_mask, zone: zone, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_zone ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest.new(update_mask: update_mask, zone: zone, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_zone({ update_mask: update_mask, zone: zone, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_zone(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest.new(update_mask: update_mask, zone: zone, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_zone_client_stub.call_rpc_count
    end
  end

  def test_delete_zone
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_zone_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_zone, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_zone_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_zone({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_zone name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_zone ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_zone({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_zone(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_zone_client_stub.call_rpc_count
    end
  end

  def test_signal_zone_state
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    state_signal = :STATE_SIGNAL_UNSPECIFIED
    provisioning_state_signal = :PROVISIONING_STATE_SIGNAL_UNSPECIFIED
    step = "hello world"
    details = "hello world"

    signal_zone_state_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :signal_zone_state, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal :STATE_SIGNAL_UNSPECIFIED, request["state_signal"]
      assert_equal :PROVISIONING_STATE_SIGNAL_UNSPECIFIED, request["provisioning_state_signal"]
      assert_equal "hello world", request["step"]
      assert_equal "hello world", request["details"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, signal_zone_state_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.signal_zone_state({ name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.signal_zone_state name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.signal_zone_state ::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest.new(name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.signal_zone_state({ name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.signal_zone_state(::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest.new(name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, signal_zone_state_client_stub.call_rpc_count
    end
  end

  def test_request_order_date_change
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    requested_date = {}

    request_order_date_change_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :request_order_date_change, name
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["requested_date"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, request_order_date_change_client_stub do
      # Create client
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.request_order_date_change({ name: name, requested_date: requested_date }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.request_order_date_change name: name, requested_date: requested_date do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.request_order_date_change ::Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest.new(name: name, requested_date: requested_date) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.request_order_date_change({ name: name, requested_date: requested_date }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.request_order_date_change(::Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest.new(name: name, requested_date: requested_date), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, request_order_date_change_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Operations, client.operations_client
  end
end
