# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/gdchardwaremanagement/v1alpha/service_pb"
require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management/rest"


class ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_orders
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_orders_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_list_orders_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_orders_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_orders({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_orders parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_orders ::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_orders({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_orders(::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_orders_client_stub.call_count
      end
    end
  end

  def test_get_order
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::Order.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_get_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_order_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_order({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_order name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_order ::Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_order({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_order(::Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_order_client_stub.call_count
      end
    end
  end

  def test_create_order
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    order_id = "hello world"
    order = {}
    request_id = "hello world"

    create_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_create_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_order_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_order({ parent: parent, order_id: order_id, order: order, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_order parent: parent, order_id: order_id, order: order, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_order ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest.new(parent: parent, order_id: order_id, order: order, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_order({ parent: parent, order_id: order_id, order: order, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_order(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest.new(parent: parent, order_id: order_id, order: order, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_order_client_stub.call_count
      end
    end
  end

  def test_update_order
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    order = {}
    request_id = "hello world"

    update_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_update_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_order_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_order({ update_mask: update_mask, order: order, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_order update_mask: update_mask, order: order, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_order ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest.new(update_mask: update_mask, order: order, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_order({ update_mask: update_mask, order: order, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_order(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest.new(update_mask: update_mask, order: order, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_order_client_stub.call_count
      end
    end
  end

  def test_delete_order
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_delete_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_order_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_order({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_order name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_order ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_order({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_order(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_order_client_stub.call_count
      end
    end
  end

  def test_submit_order
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    type = :TYPE_UNSPECIFIED

    submit_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_submit_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, submit_order_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.submit_order({ name: name, request_id: request_id, type: type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.submit_order name: name, request_id: request_id, type: type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.submit_order ::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest.new(name: name, request_id: request_id, type: type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.submit_order({ name: name, request_id: request_id, type: type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.submit_order(::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest.new(name: name, request_id: request_id, type: type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, submit_order_client_stub.call_count
      end
    end
  end

  def test_cancel_order
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    cancel_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_cancel_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_order_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_order({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_order name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_order ::Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_order({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_order(::Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_order_client_stub.call_count
      end
    end
  end

  def test_list_sites
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_sites_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_list_sites_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sites_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sites({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sites parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sites ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sites({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sites(::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sites_client_stub.call_count
      end
    end
  end

  def test_get_site
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::Site.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_site_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_get_site_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_site_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_site({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_site name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_site ::Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_site({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_site(::Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_site_client_stub.call_count
      end
    end
  end

  def test_create_site
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    site_id = "hello world"
    site = {}
    request_id = "hello world"

    create_site_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_create_site_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_site_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_site({ parent: parent, site_id: site_id, site: site, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_site parent: parent, site_id: site_id, site: site, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_site ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest.new(parent: parent, site_id: site_id, site: site, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_site({ parent: parent, site_id: site_id, site: site, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_site(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest.new(parent: parent, site_id: site_id, site: site, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_site_client_stub.call_count
      end
    end
  end

  def test_update_site
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    site = {}
    request_id = "hello world"

    update_site_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_update_site_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_site_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_site({ update_mask: update_mask, site: site, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_site update_mask: update_mask, site: site, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_site ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest.new(update_mask: update_mask, site: site, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_site({ update_mask: update_mask, site: site, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_site(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest.new(update_mask: update_mask, site: site, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_site_client_stub.call_count
      end
    end
  end

  def test_delete_site
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_site_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_delete_site_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_site_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_site({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_site name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_site ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_site({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_site(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_site_client_stub.call_count
      end
    end
  end

  def test_list_hardware_groups
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_hardware_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_list_hardware_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_hardware_groups_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_hardware_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_hardware_groups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_hardware_groups ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_hardware_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_hardware_groups(::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_hardware_groups_client_stub.call_count
      end
    end
  end

  def test_get_hardware_group
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hardware_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_get_hardware_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_hardware_group_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_hardware_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_hardware_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_hardware_group ::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_hardware_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_hardware_group(::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_hardware_group_client_stub.call_count
      end
    end
  end

  def test_create_hardware_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hardware_group_id = "hello world"
    hardware_group = {}
    request_id = "hello world"

    create_hardware_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_create_hardware_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_hardware_group_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_hardware_group({ parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_hardware_group parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_hardware_group ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest.new(parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_hardware_group({ parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_hardware_group(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest.new(parent: parent, hardware_group_id: hardware_group_id, hardware_group: hardware_group, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_hardware_group_client_stub.call_count
      end
    end
  end

  def test_update_hardware_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    hardware_group = {}
    request_id = "hello world"

    update_hardware_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_update_hardware_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_hardware_group_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_hardware_group({ update_mask: update_mask, hardware_group: hardware_group, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_hardware_group update_mask: update_mask, hardware_group: hardware_group, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_hardware_group ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest.new(update_mask: update_mask, hardware_group: hardware_group, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_hardware_group({ update_mask: update_mask, hardware_group: hardware_group, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_hardware_group(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest.new(update_mask: update_mask, hardware_group: hardware_group, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_hardware_group_client_stub.call_count
      end
    end
  end

  def test_delete_hardware_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_hardware_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_delete_hardware_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_hardware_group_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_hardware_group({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_hardware_group name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_hardware_group ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_hardware_group({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_hardware_group(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_hardware_group_client_stub.call_count
      end
    end
  end

  def test_list_hardware
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_hardware_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_list_hardware_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_hardware_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_hardware({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_hardware parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_hardware({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_hardware_client_stub.call_count
      end
    end
  end

  def test_get_hardware
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hardware_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_get_hardware_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_hardware_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_hardware({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_hardware name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_hardware({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_hardware_client_stub.call_count
      end
    end
  end

  def test_create_hardware
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hardware_id = "hello world"
    hardware = {}

    create_hardware_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_create_hardware_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_hardware_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_hardware({ parent: parent, hardware_id: hardware_id, hardware: hardware }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_hardware parent: parent, hardware_id: hardware_id, hardware: hardware do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest.new(parent: parent, hardware_id: hardware_id, hardware: hardware) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_hardware({ parent: parent, hardware_id: hardware_id, hardware: hardware }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest.new(parent: parent, hardware_id: hardware_id, hardware: hardware), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_hardware_client_stub.call_count
      end
    end
  end

  def test_update_hardware
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    hardware = {}
    request_id = "hello world"

    update_hardware_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_update_hardware_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_hardware_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_hardware({ update_mask: update_mask, hardware: hardware, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_hardware update_mask: update_mask, hardware: hardware, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest.new(update_mask: update_mask, hardware: hardware, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_hardware({ update_mask: update_mask, hardware: hardware, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest.new(update_mask: update_mask, hardware: hardware, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_hardware_client_stub.call_count
      end
    end
  end

  def test_delete_hardware
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_hardware_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_delete_hardware_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_hardware_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_hardware({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_hardware name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_hardware ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_hardware({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_hardware(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_hardware_client_stub.call_count
      end
    end
  end

  def test_list_comments
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_comments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_list_comments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_comments_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_comments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_comments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_comments ::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_comments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_comments(::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_comments_client_stub.call_count
      end
    end
  end

  def test_get_comment
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::Comment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_get_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_comment_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_comment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_comment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_comment ::Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_comment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_comment(::Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_comment_client_stub.call_count
      end
    end
  end

  def test_create_comment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    comment_id = "hello world"
    comment = {}
    request_id = "hello world"

    create_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_create_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_comment_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_comment({ parent: parent, comment_id: comment_id, comment: comment, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_comment parent: parent, comment_id: comment_id, comment: comment, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_comment ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest.new(parent: parent, comment_id: comment_id, comment: comment, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_comment({ parent: parent, comment_id: comment_id, comment: comment, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_comment(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest.new(parent: parent, comment_id: comment_id, comment: comment, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_comment_client_stub.call_count
      end
    end
  end

  def test_record_action_on_comment
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::Comment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    action_type = :ACTION_TYPE_UNSPECIFIED

    record_action_on_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_record_action_on_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, record_action_on_comment_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.record_action_on_comment({ name: name, action_type: action_type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.record_action_on_comment name: name, action_type: action_type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.record_action_on_comment ::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest.new(name: name, action_type: action_type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.record_action_on_comment({ name: name, action_type: action_type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.record_action_on_comment(::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest.new(name: name, action_type: action_type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, record_action_on_comment_client_stub.call_count
      end
    end
  end

  def test_list_change_log_entries
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_change_log_entries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_list_change_log_entries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_change_log_entries_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_change_log_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_change_log_entries parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_change_log_entries ::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_change_log_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_change_log_entries(::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_change_log_entries_client_stub.call_count
      end
    end
  end

  def test_get_change_log_entry
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_change_log_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_get_change_log_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_change_log_entry_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_change_log_entry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_change_log_entry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_change_log_entry ::Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_change_log_entry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_change_log_entry(::Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_change_log_entry_client_stub.call_count
      end
    end
  end

  def test_list_skus
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_skus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_list_skus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_skus_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_skus({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_skus parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_skus ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_skus({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_skus(::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_skus_client_stub.call_count
      end
    end
  end

  def test_get_sku
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::Sku.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_sku_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_get_sku_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_sku_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_sku({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_sku name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_sku ::Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_sku({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_sku(::Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_sku_client_stub.call_count
      end
    end
  end

  def test_list_zones
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_zones_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_list_zones_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_zones_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_zones({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_zones parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_zones ::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_zones({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_zones(::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_zones_client_stub.call_count
      end
    end
  end

  def test_get_zone
    # Create test objects.
    client_result = ::Google::Cloud::GDCHardwareManagement::V1alpha::Zone.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_zone_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_get_zone_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_zone_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_zone({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_zone name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_zone ::Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_zone({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_zone(::Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_zone_client_stub.call_count
      end
    end
  end

  def test_create_zone
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    zone_id = "hello world"
    zone = {}
    request_id = "hello world"

    create_zone_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_create_zone_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_zone_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_zone({ parent: parent, zone_id: zone_id, zone: zone, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_zone parent: parent, zone_id: zone_id, zone: zone, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_zone ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest.new(parent: parent, zone_id: zone_id, zone: zone, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_zone({ parent: parent, zone_id: zone_id, zone: zone, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_zone(::Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest.new(parent: parent, zone_id: zone_id, zone: zone, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_zone_client_stub.call_count
      end
    end
  end

  def test_update_zone
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    zone = {}
    request_id = "hello world"

    update_zone_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_update_zone_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_zone_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_zone({ update_mask: update_mask, zone: zone, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_zone update_mask: update_mask, zone: zone, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_zone ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest.new(update_mask: update_mask, zone: zone, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_zone({ update_mask: update_mask, zone: zone, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_zone(::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest.new(update_mask: update_mask, zone: zone, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_zone_client_stub.call_count
      end
    end
  end

  def test_delete_zone
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_zone_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_delete_zone_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_zone_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_zone({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_zone name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_zone ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_zone({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_zone(::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_zone_client_stub.call_count
      end
    end
  end

  def test_signal_zone_state
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    state_signal = :STATE_SIGNAL_UNSPECIFIED
    provisioning_state_signal = :PROVISIONING_STATE_SIGNAL_UNSPECIFIED
    step = "hello world"
    details = "hello world"

    signal_zone_state_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_signal_zone_state_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, signal_zone_state_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.signal_zone_state({ name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.signal_zone_state name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.signal_zone_state ::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest.new(name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.signal_zone_state({ name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.signal_zone_state(::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest.new(name: name, request_id: request_id, state_signal: state_signal, provisioning_state_signal: provisioning_state_signal, step: step, details: details), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, signal_zone_state_client_stub.call_count
      end
    end
  end

  def test_request_order_date_change
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    requested_date = {}

    request_order_date_change_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::ServiceStub.stub :transcode_request_order_date_change_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, request_order_date_change_client_stub do
        # Create client
        client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.request_order_date_change({ name: name, requested_date: requested_date }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.request_order_date_change name: name, requested_date: requested_date do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.request_order_date_change ::Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest.new(name: name, requested_date: requested_date) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.request_order_date_change({ name: name, requested_date: requested_date }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.request_order_date_change(::Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest.new(name: name, requested_date: requested_date), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, request_order_date_change_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client::Configuration, config
  end
end
