# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GDCHardwareManagement
      module V1alpha
        # A request to list orders.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to list orders in.
        #     Format: `projects/{project}/locations/{location}`
        #
        #     To list orders across all locations, substitute `-` (the hyphen or
        #     dash character) for the location and check the unreachable field in
        #     the response message.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListOrdersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of orders.
        # @!attribute [rw] orders
        #   @return [::Array<::Google::Cloud::GDCHardwareManagement::V1alpha::Order>]
        #     The list of orders.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached. Only used for queries to the wildcard
        #     location `-`. If non-empty, it indicates that the results are incomplete.
        class ListOrdersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get an order.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetOrderRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create an order.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to create the order in.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] order_id
        #   @return [::String]
        #     Optional. ID used to uniquely identify the Order within its parent scope.
        #     This field should contain at most 63 characters and must start with
        #     lowercase characters.
        #     Only lowercase characters, numbers and `-` are accepted.
        #     The `-` character cannot be the first or the last one.
        #     A system generated ID will be used if the field is not set.
        #
        #     The order.name field in the request will be ignored.
        # @!attribute [rw] order
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Order]
        #     Required. The order to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class CreateOrderRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update an order.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. A mask to specify the fields in the Order to overwrite with this
        #     update. The fields specified in the update_mask are relative to the order,
        #     not the full request. A field will be overwritten if it is in the mask. If
        #     you don't provide a mask then all fields will be overwritten.
        # @!attribute [rw] order
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Order]
        #     Required. The order to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class UpdateOrderRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete an order.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the order.
        #     Format: `projects/{project}/locations/{location}/orders/{order}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. An option to delete any nested resources in the Order, such as a
        #     HardwareGroup. If true, any nested resources for this Order will also be
        #     deleted. Otherwise, the request will only succeed if the Order has no
        #     nested resources.
        class DeleteOrderRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to submit an order.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the order.
        #     Format: `projects/{project}/locations/{location}/orders/{order}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        # @!attribute [rw] type
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest::Type]
        #     Optional. Type of this request. If unset, the request type is assumed to be
        #     `INFO_PENDING`.
        class SubmitOrderRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid types of submit order request.
          module Type
            # Request type is unspecified. This should not be used.
            TYPE_UNSPECIFIED = 0

            # Use this request type to submit your order and initiate conversation with
            # Google. After this submission, you will not be able to modify the number
            # or SKU of your ordered hardware. Please note that this order will not be
            # ready for fulfillment yet until you provide more information, such as
            # zone network configuration, hardware physical and installation
            # information, etc.
            # If you are submitting an order for a SKU type of RACK, please use this
            # request type, as additional information will be required outside of the
            # API.
            INFO_PENDING = 1

            # Use this request type if and when you are ready to submit your order for
            # fulfillment. In addition to the information required for `INFO_PENDING`,
            # the order must contain all required information, such as zone network
            # configuration, hardware physical and installation information, etc.
            # Further changes to any order information will no longer be allowed.
            INFO_COMPLETE = 2
          end
        end

        # A request to cancel an order.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the order.
        #     Format: `projects/{project}/locations/{location}/orders/{order}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class CancelOrderRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list sites.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to list sites in.
        #     Format: `projects/{project}/locations/{location}`
        #
        #     To list sites across all locations, substitute `-` (the hyphen or
        #     dash character) for the location and check the unreachable field in
        #     the response message.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListSitesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of sites.
        # @!attribute [rw] sites
        #   @return [::Array<::Google::Cloud::GDCHardwareManagement::V1alpha::Site>]
        #     The list of sites.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached. Only used for queries to the wildcard
        #     location `-`. If non-empty, it indicates that the results are incomplete.
        class ListSitesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a site.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the site.
        #     Format: `projects/{project}/locations/{location}/sites/{site}`
        class GetSiteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a site.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to create the site in.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] site_id
        #   @return [::String]
        #     Optional. ID used to uniquely identify the Site within its parent scope.
        #     This field should contain at most 63 characters and must start with
        #     lowercase characters.
        #     Only lowercase characters, numbers and `-` are accepted.
        #     The `-` character cannot be the first or the last one.
        #     A system generated ID will be used if the field is not set.
        #
        #     The site.name field in the request will be ignored.
        # @!attribute [rw] site
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Site]
        #     Required. The site to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class CreateSiteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update a site.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. A mask to specify the fields in the Site to overwrite with this
        #     update. The fields specified in the update_mask are relative to the site,
        #     not the full request. A field will be overwritten if it is in the mask. If
        #     you don't provide a mask then all fields will be overwritten.
        # @!attribute [rw] site
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Site]
        #     Required. The site to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class UpdateSiteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a site.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the site.
        #     Format: `projects/{project}/locations/{location}/sites/{site}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class DeleteSiteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list hardware groups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The order to list hardware groups in.
        #     Format: `projects/{project}/locations/{location}/orders/{order}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListHardwareGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of hardware groups.
        # @!attribute [rw] hardware_groups
        #   @return [::Array<::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup>]
        #     The list of hardware groups.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListHardwareGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a hardware group.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hardware group.
        #     Format:
        #     `projects/{project}/locations/{location}/orders/{order}/hardwareGroups/{hardware_group}`
        class GetHardwareGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a hardware group.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The order to create the hardware group in.
        #     Format: `projects/{project}/locations/{location}/orders/{order}`
        # @!attribute [rw] hardware_group_id
        #   @return [::String]
        #     Optional. ID used to uniquely identify the HardwareGroup within its parent
        #     scope. This field should contain at most 63 characters and must start with
        #     lowercase characters.
        #     Only lowercase characters, numbers and `-` are accepted.
        #     The `-` character cannot be the first or the last one.
        #     A system generated ID will be used if the field is not set.
        #
        #     The hardware_group.name field in the request will be ignored.
        # @!attribute [rw] hardware_group
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup]
        #     Required. The hardware group to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class CreateHardwareGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update a hardware group.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. A mask to specify the fields in the HardwareGroup to overwrite
        #     with this update. The fields specified in the update_mask are relative to
        #     the hardware group, not the full request. A field will be overwritten if it
        #     is in the mask. If you don't provide a mask then all fields will be
        #     overwritten.
        # @!attribute [rw] hardware_group
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup]
        #     Required. The hardware group to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class UpdateHardwareGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a hardware group.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hardware group.
        #     Format:
        #     `projects/{project}/locations/{location}/orders/{order}/hardwareGroups/{hardware_group}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class DeleteHardwareGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list hardware.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to list hardware in.
        #     Format: `projects/{project}/locations/{location}`
        #
        #     To list hardware across all locations, substitute `-` (the hyphen or
        #     dash character) for the location and check the unreachable field in
        #     the response message.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListHardwareRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of hardware.
        # @!attribute [rw] hardware
        #   @return [::Array<::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware>]
        #     The list of hardware.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached. Only used for queries to the wildcard
        #     location `-`. If non-empty, it indicates that the results are incomplete.
        class ListHardwareResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get hardware.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hardware.
        #     Format: `projects/{project}/locations/{location}/hardware/{hardware}`
        class GetHardwareRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create hardware.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to create hardware in.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] hardware_id
        #   @return [::String]
        #     Optional. ID used to uniquely identify the Hardware within its parent
        #     scope. This field should contain at most 63 characters and must start with
        #     lowercase characters.
        #     Only lowercase characters, numbers and `-` are accepted.
        #     The `-` character cannot be the first or the last one.
        #     A system generated ID will be used if the field is not set.
        #
        #     The hardware.name field in the request will be ignored.
        # @!attribute [rw] hardware
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware]
        #     Required. The resource to create.
        class CreateHardwareRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update hardware.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. A mask to specify the fields in the Hardware to overwrite with
        #     this update. The fields specified in the update_mask are relative to the
        #     hardware, not the full request. A field will be overwritten if it is in the
        #     mask. If you don't provide a mask then all fields will be overwritten.
        # @!attribute [rw] hardware
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware]
        #     Required. The hardware to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class UpdateHardwareRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete hardware.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hardware.
        #     Format: `projects/{project}/locations/{location}/hardware/{hardware}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class DeleteHardwareRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list comments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The order to list comments on.
        #     Format: `projects/{project}/locations/{location}/orders/{order}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListCommentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list comments.
        # @!attribute [rw] comments
        #   @return [::Array<::Google::Cloud::GDCHardwareManagement::V1alpha::Comment>]
        #     The list of comments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListCommentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a comment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the comment.
        #     Format:
        #     `projects/{project}/locations/{location}/orders/{order}/comments/{comment}`
        class GetCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a comment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The order to create the comment on.
        #     Format: `projects/{project}/locations/{location}/orders/{order}`
        # @!attribute [rw] comment_id
        #   @return [::String]
        #     Optional. ID used to uniquely identify the Comment within its parent scope.
        #     This field should contain at most 63 characters and must start with
        #     lowercase characters.
        #     Only lowercase characters, numbers and `-` are accepted.
        #     The `-` character cannot be the first or the last one.
        #     A system generated ID will be used if the field is not set.
        #
        #     The comment.name field in the request will be ignored.
        # @!attribute [rw] comment
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Comment]
        #     Required. The comment to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class CreateCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to record an action on a comment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the comment.
        #     Format:
        #     `projects/{project}/locations/{location}/orders/{order}/comments/{comment}`
        # @!attribute [rw] action_type
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest::ActionType]
        #     Required. The action type of the recorded action.
        class RecordActionOnCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid action types of Comment.
          module ActionType
            # Action is unspecified.
            ACTION_TYPE_UNSPECIFIED = 0

            # Mark comment as read.
            READ = 1

            # Mark comment as unread.
            UNREAD = 2
          end
        end

        # A request to list change log entries.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The order to list change log entries for.
        #     Format: `projects/{project}/locations/{location}/orders/{order}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListChangeLogEntriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of change log entries.
        # @!attribute [rw] change_log_entries
        #   @return [::Array<::Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry>]
        #     The list of change log entries.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListChangeLogEntriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a change log entry.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the change log entry.
        #     Format:
        #     `projects/{project}/locations/{location}/orders/{order}/changeLogEntries/{change_log_entry}`
        class GetChangeLogEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list SKUs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to list SKUs in.
        #     Format: `projects/{project}/locations/{location}`
        #
        #     To list SKUs across all locations, substitute `-` (the hyphen or
        #     dash character) for the location and check the unreachable field in
        #     the response message.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListSkusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of SKUs.
        # @!attribute [rw] skus
        #   @return [::Array<::Google::Cloud::GDCHardwareManagement::V1alpha::Sku>]
        #     The list of SKUs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached. Only used for queries to the wildcard
        #     location `-`. If non-empty, it indicates that the results are incomplete.
        class ListSkusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get an SKU.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the SKU.
        #     Format: `projects/{project}/locations/{location}/skus/{sku}`
        class GetSkuRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list zones.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to list zones in.
        #     Format: `projects/{project}/locations/{location}`
        #
        #     To list zones across all locations, substitute `-` (the hyphen or
        #     dash character) for the location and check the unreachable field in
        #     the response message.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListZonesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of zones.
        # @!attribute [rw] zones
        #   @return [::Array<::Google::Cloud::GDCHardwareManagement::V1alpha::Zone>]
        #     The list of zones.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached. Only used for queries to the wildcard
        #     location `-`. If non-empty, it indicates that the results are incomplete.
        class ListZonesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a zone.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the zone.
        #     Format: `projects/{project}/locations/{location}/zones/{zone}`
        class GetZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a zone.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location to create the zone in.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] zone_id
        #   @return [::String]
        #     Optional. ID used to uniquely identify the Zone within its parent scope.
        #     This field should contain at most 63 characters and must start with
        #     lowercase characters.
        #     Only lowercase characters, numbers and `-` are accepted.
        #     The `-` character cannot be the first or the last one.
        #     A system generated ID will be used if the field is not set.
        #
        #     The zone.name field in the request will be ignored.
        # @!attribute [rw] zone
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Zone]
        #     Required. The zone to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class CreateZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update a zone.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. A mask to specify the fields in the Zone to overwrite with this
        #     update. The fields specified in the update_mask are relative to the zone,
        #     not the full request. A field will be overwritten if it is in the mask. If
        #     you don't provide a mask then all fields will be overwritten.
        # @!attribute [rw] zone
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Zone]
        #     Required. The zone to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class UpdateZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a zone.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the zone.
        #     Format: `projects/{project}/locations/{location}/zones/{zone}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        class DeleteZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to signal the state of a zone.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the zone.
        #     Format: `projects/{project}/locations/{location}/zones/{zone}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional unique identifier for this request. See
        #     [AIP-155](https://google.aip.dev/155).
        # @!attribute [rw] state_signal
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest::StateSignal]
        #     Optional. The state signal to send for this zone. Either state_signal or
        #     provisioning_state_signal must be set, but not both.
        # @!attribute [rw] provisioning_state_signal
        #   @return [::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest::ProvisioningStateSignal]
        #     Optional. The provisioning state signal to send for this zone. Either
        #     state_signal or provisioning_state_signal must be set, but not both.
        # @!attribute [rw] step
        #   @return [::String]
        #     Optional. The step being executed. Provides a finer grained status when the
        #     state_signal is FACTORY_TURNUP_CHECKS_STARTED or
        #     FACTORY_TURNUP_CHECKS_FAILED.
        # @!attribute [rw] details
        #   @return [::String]
        #     Optional. Additional details, such as an error message when state_signal is
        #     FACTORY_TURNUP_CHECKS_FAILED.
        class SignalZoneStateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid state signals for a zone.
          module StateSignal
            # State signal of the zone is unspecified.
            STATE_SIGNAL_UNSPECIFIED = 0

            # Factory turnup checks have started.
            FACTORY_TURNUP_CHECKS_STARTED = 3

            # The Zone is ready for site turnup.
            FACTORY_TURNUP_CHECKS_PASSED = 1

            # The Zone is ready for site turnup. Deprecated, but not deleted.
            READY_FOR_SITE_TURNUP = 1

            # The Zone failed in factory turnup checks.
            FACTORY_TURNUP_CHECKS_FAILED = 2

            # Verify that a valid cluster intent is present.
            VERIFY_CLUSTER_INTENT_PRESENCE = 4
          end

          # Valid provisioning state signals for a zone.
          module ProvisioningStateSignal
            # Provisioning state signal is unspecified.
            PROVISIONING_STATE_SIGNAL_UNSPECIFIED = 0

            # Provisioning is in progress.
            PROVISIONING_IN_PROGRESS = 1

            # Provisioning is complete.
            PROVISIONING_COMPLETE = 2
          end
        end

        # Represents the metadata of a long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. The verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to change the requested date of an order.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the order to update.
        #     Format: projects/\\{project}/locations/\\{location}/orders/\\{order}
        # @!attribute [rw] requested_date
        #   @return [::Google::Type::Date]
        #     Required. The date to which the customer or Google wants to set the
        #     scheduled installation date.
        class RequestOrderDateChangeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
