# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GDCHardwareManagement
      module V1alpha
        module GDCHardwareManagement
          # Path helper methods for the GDCHardwareManagement API.
          module Paths
            ##
            # Create a fully-qualified ChangeLogEntry resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/orders/{order}/changeLogEntries/{change_log_entry}`
            #
            # @param project [String]
            # @param location [String]
            # @param order [String]
            # @param change_log_entry [String]
            #
            # @return [::String]
            def change_log_entry_path project:, location:, order:, change_log_entry:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "order cannot contain /" if order.to_s.include? "/"

              "projects/#{project}/locations/#{location}/orders/#{order}/changeLogEntries/#{change_log_entry}"
            end

            ##
            # Create a fully-qualified Comment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/orders/{order}/comments/{comment}`
            #
            # @param project [String]
            # @param location [String]
            # @param order [String]
            # @param comment [String]
            #
            # @return [::String]
            def comment_path project:, location:, order:, comment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "order cannot contain /" if order.to_s.include? "/"

              "projects/#{project}/locations/#{location}/orders/#{order}/comments/#{comment}"
            end

            ##
            # Create a fully-qualified Hardware resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/hardware/{hardware}`
            #
            # @param project [String]
            # @param location [String]
            # @param hardware [String]
            #
            # @return [::String]
            def hardware_path project:, location:, hardware:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/hardware/#{hardware}"
            end

            ##
            # Create a fully-qualified HardwareGroup resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/orders/{order}/hardwareGroups/{hardware_group}`
            #
            # @param project [String]
            # @param location [String]
            # @param order [String]
            # @param hardware_group [String]
            #
            # @return [::String]
            def hardware_group_path project:, location:, order:, hardware_group:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "order cannot contain /" if order.to_s.include? "/"

              "projects/#{project}/locations/#{location}/orders/#{order}/hardwareGroups/#{hardware_group}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Order resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/orders/{order}`
            #
            # @param project [String]
            # @param location [String]
            # @param order [String]
            #
            # @return [::String]
            def order_path project:, location:, order:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/orders/#{order}"
            end

            ##
            # Create a fully-qualified Site resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/sites/{site}`
            #
            # @param project [String]
            # @param location [String]
            # @param site [String]
            #
            # @return [::String]
            def site_path project:, location:, site:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/sites/#{site}"
            end

            ##
            # Create a fully-qualified Sku resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/skus/{sku}`
            #
            # @param project [String]
            # @param location [String]
            # @param sku [String]
            #
            # @return [::String]
            def sku_path project:, location:, sku:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/skus/#{sku}"
            end

            ##
            # Create a fully-qualified Zone resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/zones/{zone}`
            #
            # @param project [String]
            # @param location [String]
            # @param zone [String]
            #
            # @return [::String]
            def zone_path project:, location:, zone:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/zones/#{zone}"
            end

            extend self
          end
        end
      end
    end
  end
end
