# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gdchardwaremanagement/v1alpha/service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module GDCHardwareManagement
      module V1alpha
        module GDCHardwareManagement
          ##
          # Client for the GDCHardwareManagement service.
          #
          # The GDC Hardware Management service.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "gdchardwaremanagement.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :gdc_hardware_management_stub

            ##
            # Configure the GDCHardwareManagement Client class.
            #
            # See {::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all GDCHardwareManagement clients
            #   ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "GDCHardwareManagement", "V1alpha"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_orders.timeout = 60.0
                default_config.rpcs.list_orders.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_order.timeout = 60.0
                default_config.rpcs.get_order.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_order.timeout = 60.0

                default_config.rpcs.update_order.timeout = 60.0
                default_config.rpcs.update_order.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_order.timeout = 60.0
                default_config.rpcs.delete_order.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.submit_order.timeout = 60.0
                default_config.rpcs.submit_order.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.cancel_order.timeout = 60.0
                default_config.rpcs.cancel_order.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_sites.timeout = 60.0
                default_config.rpcs.list_sites.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_site.timeout = 60.0
                default_config.rpcs.get_site.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_site.timeout = 60.0

                default_config.rpcs.update_site.timeout = 60.0
                default_config.rpcs.update_site.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_site.timeout = 60.0
                default_config.rpcs.delete_site.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_hardware_groups.timeout = 60.0
                default_config.rpcs.list_hardware_groups.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_hardware_group.timeout = 60.0
                default_config.rpcs.get_hardware_group.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_hardware_group.timeout = 60.0

                default_config.rpcs.update_hardware_group.timeout = 60.0
                default_config.rpcs.update_hardware_group.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_hardware_group.timeout = 60.0
                default_config.rpcs.delete_hardware_group.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_hardware.timeout = 60.0
                default_config.rpcs.list_hardware.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_hardware.timeout = 60.0
                default_config.rpcs.get_hardware.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_hardware.timeout = 60.0

                default_config.rpcs.update_hardware.timeout = 60.0
                default_config.rpcs.update_hardware.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_hardware.timeout = 60.0
                default_config.rpcs.delete_hardware.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_comments.timeout = 60.0
                default_config.rpcs.list_comments.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_comment.timeout = 60.0
                default_config.rpcs.get_comment.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_comment.timeout = 60.0

                default_config.rpcs.list_change_log_entries.timeout = 60.0
                default_config.rpcs.list_change_log_entries.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_change_log_entry.timeout = 60.0
                default_config.rpcs.get_change_log_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_skus.timeout = 60.0
                default_config.rpcs.list_skus.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_sku.timeout = 60.0
                default_config.rpcs.get_sku.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_zones.timeout = 60.0
                default_config.rpcs.list_zones.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_zone.timeout = 60.0
                default_config.rpcs.get_zone.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_zone.timeout = 60.0

                default_config.rpcs.update_zone.timeout = 60.0
                default_config.rpcs.update_zone.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_zone.timeout = 60.0
                default_config.rpcs.delete_zone.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the GDCHardwareManagement Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @gdc_hardware_management_stub.universe_domain
            end

            ##
            # Create a new GDCHardwareManagement client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the GDCHardwareManagement client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/gdchardwaremanagement/v1alpha/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @gdc_hardware_management_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @gdc_hardware_management_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @gdc_hardware_management_stub.endpoint
                config.universe_domain = @gdc_hardware_management_stub.universe_domain
                config.logger = @gdc_hardware_management_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @gdc_hardware_management_stub.logger
            end

            # Service calls

            ##
            # Lists orders in a given project and location.
            #
            # @overload list_orders(request, options = nil)
            #   Pass arguments to `list_orders` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_orders(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_orders` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to list orders in.
            #     Format: `projects/{project}/locations/{location}`
            #
            #     To list orders across all locations, substitute `-` (the hyphen or
            #     dash character) for the location and check the unreachable field in
            #     the response message.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Order>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Order>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest.new
            #
            #   # Call the list_orders method.
            #   result = client.list_orders request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GDCHardwareManagement::V1alpha::Order.
            #     p item
            #   end
            #
            def list_orders request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::ListOrdersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_orders.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_orders.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_orders.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :list_orders, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gdc_hardware_management_stub, :list_orders, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of an order.
            #
            # @overload get_order(request, options = nil)
            #   Pass arguments to `get_order` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_order(name: nil)
            #   Pass arguments to `get_order` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::Order]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Order]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest.new
            #
            #   # Call the get_order method.
            #   result = client.get_order request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::Order.
            #   p result
            #
            def get_order request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::GetOrderRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_order.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_order.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_order.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :get_order, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new order in a given project and location.
            #
            # @overload create_order(request, options = nil)
            #   Pass arguments to `create_order` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_order(parent: nil, order_id: nil, order: nil, request_id: nil)
            #   Pass arguments to `create_order` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to create the order in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param order_id [::String]
            #     Optional. ID used to uniquely identify the Order within its parent scope.
            #     This field should contain at most 63 characters and must start with
            #     lowercase characters.
            #     Only lowercase characters, numbers and `-` are accepted.
            #     The `-` character cannot be the first or the last one.
            #     A system generated ID will be used if the field is not set.
            #
            #     The order.name field in the request will be ignored.
            #   @param order [::Google::Cloud::GDCHardwareManagement::V1alpha::Order, ::Hash]
            #     Required. The order to create.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest.new
            #
            #   # Call the create_order method.
            #   result = client.create_order request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_order request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateOrderRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_order.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_order.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_order.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :create_order, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of an order.
            #
            # @overload update_order(request, options = nil)
            #   Pass arguments to `update_order` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_order(update_mask: nil, order: nil, request_id: nil)
            #   Pass arguments to `update_order` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. A mask to specify the fields in the Order to overwrite with this
            #     update. The fields specified in the update_mask are relative to the order,
            #     not the full request. A field will be overwritten if it is in the mask. If
            #     you don't provide a mask then all fields will be overwritten.
            #   @param order [::Google::Cloud::GDCHardwareManagement::V1alpha::Order, ::Hash]
            #     Required. The order to update.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest.new
            #
            #   # Call the update_order method.
            #   result = client.update_order request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_order request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateOrderRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_order.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.order&.name
                header_params["order.name"] = request.order.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_order.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_order.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :update_order, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an order.
            #
            # @overload delete_order(request, options = nil)
            #   Pass arguments to `delete_order` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_order(name: nil, request_id: nil, force: nil)
            #   Pass arguments to `delete_order` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the order.
            #     Format: `projects/{project}/locations/{location}/orders/{order}`
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #   @param force [::Boolean]
            #     Optional. An option to delete any nested resources in the Order, such as a
            #     HardwareGroup. If true, any nested resources for this Order will also be
            #     deleted. Otherwise, the request will only succeed if the Order has no
            #     nested resources.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest.new
            #
            #   # Call the delete_order method.
            #   result = client.delete_order request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_order request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteOrderRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_order.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_order.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_order.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :delete_order, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Submits an order.
            #
            # @overload submit_order(request, options = nil)
            #   Pass arguments to `submit_order` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload submit_order(name: nil, request_id: nil, type: nil)
            #   Pass arguments to `submit_order` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the order.
            #     Format: `projects/{project}/locations/{location}/orders/{order}`
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #   @param type [::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest::Type]
            #     Optional. Type of this request. If unset, the request type is assumed to be
            #     `INFO_PENDING`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest.new
            #
            #   # Call the submit_order method.
            #   result = client.submit_order request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def submit_order request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::SubmitOrderRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.submit_order.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.submit_order.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.submit_order.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :submit_order, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels an order.
            #
            # @overload cancel_order(request, options = nil)
            #   Pass arguments to `cancel_order` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_order(name: nil, request_id: nil)
            #   Pass arguments to `cancel_order` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the order.
            #     Format: `projects/{project}/locations/{location}/orders/{order}`
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest.new
            #
            #   # Call the cancel_order method.
            #   result = client.cancel_order request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def cancel_order request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::CancelOrderRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_order.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_order.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_order.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :cancel_order, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists sites in a given project and location.
            #
            # @overload list_sites(request, options = nil)
            #   Pass arguments to `list_sites` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_sites(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_sites` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to list sites in.
            #     Format: `projects/{project}/locations/{location}`
            #
            #     To list sites across all locations, substitute `-` (the hyphen or
            #     dash character) for the location and check the unreachable field in
            #     the response message.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Site>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Site>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest.new
            #
            #   # Call the list_sites method.
            #   result = client.list_sites request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GDCHardwareManagement::V1alpha::Site.
            #     p item
            #   end
            #
            def list_sites request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSitesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_sites.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_sites.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_sites.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :list_sites, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gdc_hardware_management_stub, :list_sites, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a site.
            #
            # @overload get_site(request, options = nil)
            #   Pass arguments to `get_site` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_site(name: nil)
            #   Pass arguments to `get_site` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the site.
            #     Format: `projects/{project}/locations/{location}/sites/{site}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::Site]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Site]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest.new
            #
            #   # Call the get_site method.
            #   result = client.get_site request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::Site.
            #   p result
            #
            def get_site request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::GetSiteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_site.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_site.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_site.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :get_site, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new site in a given project and location.
            #
            # @overload create_site(request, options = nil)
            #   Pass arguments to `create_site` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_site(parent: nil, site_id: nil, site: nil, request_id: nil)
            #   Pass arguments to `create_site` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to create the site in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param site_id [::String]
            #     Optional. ID used to uniquely identify the Site within its parent scope.
            #     This field should contain at most 63 characters and must start with
            #     lowercase characters.
            #     Only lowercase characters, numbers and `-` are accepted.
            #     The `-` character cannot be the first or the last one.
            #     A system generated ID will be used if the field is not set.
            #
            #     The site.name field in the request will be ignored.
            #   @param site [::Google::Cloud::GDCHardwareManagement::V1alpha::Site, ::Hash]
            #     Required. The site to create.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest.new
            #
            #   # Call the create_site method.
            #   result = client.create_site request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_site request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateSiteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_site.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_site.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_site.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :create_site, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a site.
            #
            # @overload update_site(request, options = nil)
            #   Pass arguments to `update_site` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_site(update_mask: nil, site: nil, request_id: nil)
            #   Pass arguments to `update_site` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. A mask to specify the fields in the Site to overwrite with this
            #     update. The fields specified in the update_mask are relative to the site,
            #     not the full request. A field will be overwritten if it is in the mask. If
            #     you don't provide a mask then all fields will be overwritten.
            #   @param site [::Google::Cloud::GDCHardwareManagement::V1alpha::Site, ::Hash]
            #     Required. The site to update.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest.new
            #
            #   # Call the update_site method.
            #   result = client.update_site request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_site request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateSiteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_site.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.site&.name
                header_params["site.name"] = request.site.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_site.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_site.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :update_site, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a site.
            #
            # @overload delete_site(request, options = nil)
            #   Pass arguments to `delete_site` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_site(name: nil, request_id: nil)
            #   Pass arguments to `delete_site` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the site.
            #     Format: `projects/{project}/locations/{location}/sites/{site}`
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest.new
            #
            #   # Call the delete_site method.
            #   result = client.delete_site request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_site request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteSiteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_site.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_site.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_site.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :delete_site, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists hardware groups in a given order.
            #
            # @overload list_hardware_groups(request, options = nil)
            #   Pass arguments to `list_hardware_groups` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_hardware_groups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_hardware_groups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The order to list hardware groups in.
            #     Format: `projects/{project}/locations/{location}/orders/{order}`
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest.new
            #
            #   # Call the list_hardware_groups method.
            #   result = client.list_hardware_groups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup.
            #     p item
            #   end
            #
            def list_hardware_groups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareGroupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_hardware_groups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_hardware_groups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_hardware_groups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :list_hardware_groups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gdc_hardware_management_stub, :list_hardware_groups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a hardware group.
            #
            # @overload get_hardware_group(request, options = nil)
            #   Pass arguments to `get_hardware_group` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_hardware_group(name: nil)
            #   Pass arguments to `get_hardware_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the hardware group.
            #     Format:
            #     `projects/{project}/locations/{location}/orders/{order}/hardwareGroups/{hardware_group}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest.new
            #
            #   # Call the get_hardware_group method.
            #   result = client.get_hardware_group request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup.
            #   p result
            #
            def get_hardware_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_hardware_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_hardware_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_hardware_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :get_hardware_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new hardware group in a given order.
            #
            # @overload create_hardware_group(request, options = nil)
            #   Pass arguments to `create_hardware_group` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_hardware_group(parent: nil, hardware_group_id: nil, hardware_group: nil, request_id: nil)
            #   Pass arguments to `create_hardware_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The order to create the hardware group in.
            #     Format: `projects/{project}/locations/{location}/orders/{order}`
            #   @param hardware_group_id [::String]
            #     Optional. ID used to uniquely identify the HardwareGroup within its parent
            #     scope. This field should contain at most 63 characters and must start with
            #     lowercase characters.
            #     Only lowercase characters, numbers and `-` are accepted.
            #     The `-` character cannot be the first or the last one.
            #     A system generated ID will be used if the field is not set.
            #
            #     The hardware_group.name field in the request will be ignored.
            #   @param hardware_group [::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup, ::Hash]
            #     Required. The hardware group to create.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest.new
            #
            #   # Call the create_hardware_group method.
            #   result = client.create_hardware_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_hardware_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_hardware_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_hardware_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_hardware_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :create_hardware_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a hardware group.
            #
            # @overload update_hardware_group(request, options = nil)
            #   Pass arguments to `update_hardware_group` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_hardware_group(update_mask: nil, hardware_group: nil, request_id: nil)
            #   Pass arguments to `update_hardware_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. A mask to specify the fields in the HardwareGroup to overwrite
            #     with this update. The fields specified in the update_mask are relative to
            #     the hardware group, not the full request. A field will be overwritten if it
            #     is in the mask. If you don't provide a mask then all fields will be
            #     overwritten.
            #   @param hardware_group [::Google::Cloud::GDCHardwareManagement::V1alpha::HardwareGroup, ::Hash]
            #     Required. The hardware group to update.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest.new
            #
            #   # Call the update_hardware_group method.
            #   result = client.update_hardware_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_hardware_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_hardware_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.hardware_group&.name
                header_params["hardware_group.name"] = request.hardware_group.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_hardware_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_hardware_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :update_hardware_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a hardware group.
            #
            # @overload delete_hardware_group(request, options = nil)
            #   Pass arguments to `delete_hardware_group` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_hardware_group(name: nil, request_id: nil)
            #   Pass arguments to `delete_hardware_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the hardware group.
            #     Format:
            #     `projects/{project}/locations/{location}/orders/{order}/hardwareGroups/{hardware_group}`
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest.new
            #
            #   # Call the delete_hardware_group method.
            #   result = client.delete_hardware_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_hardware_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_hardware_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_hardware_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_hardware_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :delete_hardware_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists hardware in a given project and location.
            #
            # @overload list_hardware(request, options = nil)
            #   Pass arguments to `list_hardware` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_hardware(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_hardware` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to list hardware in.
            #     Format: `projects/{project}/locations/{location}`
            #
            #     To list hardware across all locations, substitute `-` (the hyphen or
            #     dash character) for the location and check the unreachable field in
            #     the response message.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest.new
            #
            #   # Call the list_hardware method.
            #   result = client.list_hardware request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware.
            #     p item
            #   end
            #
            def list_hardware request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::ListHardwareRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_hardware.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_hardware.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_hardware.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :list_hardware, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gdc_hardware_management_stub, :list_hardware, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets hardware details.
            #
            # @overload get_hardware(request, options = nil)
            #   Pass arguments to `get_hardware` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_hardware(name: nil)
            #   Pass arguments to `get_hardware` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the hardware.
            #     Format: `projects/{project}/locations/{location}/hardware/{hardware}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest.new
            #
            #   # Call the get_hardware method.
            #   result = client.get_hardware request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::Hardware.
            #   p result
            #
            def get_hardware request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::GetHardwareRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_hardware.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_hardware.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_hardware.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :get_hardware, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates new hardware in a given project and location.
            #
            # @overload create_hardware(request, options = nil)
            #   Pass arguments to `create_hardware` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_hardware(parent: nil, hardware_id: nil, hardware: nil)
            #   Pass arguments to `create_hardware` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to create hardware in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param hardware_id [::String]
            #     Optional. ID used to uniquely identify the Hardware within its parent
            #     scope. This field should contain at most 63 characters and must start with
            #     lowercase characters.
            #     Only lowercase characters, numbers and `-` are accepted.
            #     The `-` character cannot be the first or the last one.
            #     A system generated ID will be used if the field is not set.
            #
            #     The hardware.name field in the request will be ignored.
            #   @param hardware [::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware, ::Hash]
            #     Required. The resource to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest.new
            #
            #   # Call the create_hardware method.
            #   result = client.create_hardware request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_hardware request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateHardwareRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_hardware.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_hardware.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_hardware.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :create_hardware, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates hardware parameters.
            #
            # @overload update_hardware(request, options = nil)
            #   Pass arguments to `update_hardware` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_hardware(update_mask: nil, hardware: nil, request_id: nil)
            #   Pass arguments to `update_hardware` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. A mask to specify the fields in the Hardware to overwrite with
            #     this update. The fields specified in the update_mask are relative to the
            #     hardware, not the full request. A field will be overwritten if it is in the
            #     mask. If you don't provide a mask then all fields will be overwritten.
            #   @param hardware [::Google::Cloud::GDCHardwareManagement::V1alpha::Hardware, ::Hash]
            #     Required. The hardware to update.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest.new
            #
            #   # Call the update_hardware method.
            #   result = client.update_hardware request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_hardware request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateHardwareRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_hardware.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.hardware&.name
                header_params["hardware.name"] = request.hardware.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_hardware.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_hardware.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :update_hardware, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes hardware.
            #
            # @overload delete_hardware(request, options = nil)
            #   Pass arguments to `delete_hardware` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_hardware(name: nil, request_id: nil)
            #   Pass arguments to `delete_hardware` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the hardware.
            #     Format: `projects/{project}/locations/{location}/hardware/{hardware}`
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest.new
            #
            #   # Call the delete_hardware method.
            #   result = client.delete_hardware request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_hardware request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteHardwareRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_hardware.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_hardware.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_hardware.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :delete_hardware, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the comments on an order.
            #
            # @overload list_comments(request, options = nil)
            #   Pass arguments to `list_comments` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_comments(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_comments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The order to list comments on.
            #     Format: `projects/{project}/locations/{location}/orders/{order}`
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Comment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Comment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest.new
            #
            #   # Call the list_comments method.
            #   result = client.list_comments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GDCHardwareManagement::V1alpha::Comment.
            #     p item
            #   end
            #
            def list_comments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::ListCommentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_comments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_comments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_comments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :list_comments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gdc_hardware_management_stub, :list_comments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the content of a comment.
            #
            # @overload get_comment(request, options = nil)
            #   Pass arguments to `get_comment` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_comment(name: nil)
            #   Pass arguments to `get_comment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the comment.
            #     Format:
            #     `projects/{project}/locations/{location}/orders/{order}/comments/{comment}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::Comment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Comment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest.new
            #
            #   # Call the get_comment method.
            #   result = client.get_comment request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::Comment.
            #   p result
            #
            def get_comment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::GetCommentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_comment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_comment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_comment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :get_comment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new comment on an order.
            #
            # @overload create_comment(request, options = nil)
            #   Pass arguments to `create_comment` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_comment(parent: nil, comment_id: nil, comment: nil, request_id: nil)
            #   Pass arguments to `create_comment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The order to create the comment on.
            #     Format: `projects/{project}/locations/{location}/orders/{order}`
            #   @param comment_id [::String]
            #     Optional. ID used to uniquely identify the Comment within its parent scope.
            #     This field should contain at most 63 characters and must start with
            #     lowercase characters.
            #     Only lowercase characters, numbers and `-` are accepted.
            #     The `-` character cannot be the first or the last one.
            #     A system generated ID will be used if the field is not set.
            #
            #     The comment.name field in the request will be ignored.
            #   @param comment [::Google::Cloud::GDCHardwareManagement::V1alpha::Comment, ::Hash]
            #     Required. The comment to create.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest.new
            #
            #   # Call the create_comment method.
            #   result = client.create_comment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_comment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateCommentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_comment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_comment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_comment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :create_comment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Record Action on a Comment. If the Action specified in the request is READ,
            # the viewed time in the comment is set to the time the request was received.
            # If the comment is already marked as read, subsequent calls will be ignored.
            # If the Action is UNREAD, the viewed time is cleared from the comment.
            #
            # @overload record_action_on_comment(request, options = nil)
            #   Pass arguments to `record_action_on_comment` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload record_action_on_comment(name: nil, action_type: nil)
            #   Pass arguments to `record_action_on_comment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the comment.
            #     Format:
            #     `projects/{project}/locations/{location}/orders/{order}/comments/{comment}`
            #   @param action_type [::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest::ActionType]
            #     Required. The action type of the recorded action.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::Comment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Comment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest.new
            #
            #   # Call the record_action_on_comment method.
            #   result = client.record_action_on_comment request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::Comment.
            #   p result
            #
            def record_action_on_comment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::RecordActionOnCommentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.record_action_on_comment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.record_action_on_comment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.record_action_on_comment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :record_action_on_comment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the changes made to an order.
            #
            # @overload list_change_log_entries(request, options = nil)
            #   Pass arguments to `list_change_log_entries` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_change_log_entries(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_change_log_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The order to list change log entries for.
            #     Format: `projects/{project}/locations/{location}/orders/{order}`
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest.new
            #
            #   # Call the list_change_log_entries method.
            #   result = client.list_change_log_entries request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry.
            #     p item
            #   end
            #
            def list_change_log_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::ListChangeLogEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_change_log_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_change_log_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_change_log_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :list_change_log_entries, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gdc_hardware_management_stub, :list_change_log_entries, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a change to an order.
            #
            # @overload get_change_log_entry(request, options = nil)
            #   Pass arguments to `get_change_log_entry` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_change_log_entry(name: nil)
            #   Pass arguments to `get_change_log_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the change log entry.
            #     Format:
            #     `projects/{project}/locations/{location}/orders/{order}/changeLogEntries/{change_log_entry}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest.new
            #
            #   # Call the get_change_log_entry method.
            #   result = client.get_change_log_entry request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::ChangeLogEntry.
            #   p result
            #
            def get_change_log_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::GetChangeLogEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_change_log_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_change_log_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_change_log_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :get_change_log_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists SKUs for a given project and location.
            #
            # @overload list_skus(request, options = nil)
            #   Pass arguments to `list_skus` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_skus(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_skus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to list SKUs in.
            #     Format: `projects/{project}/locations/{location}`
            #
            #     To list SKUs across all locations, substitute `-` (the hyphen or
            #     dash character) for the location and check the unreachable field in
            #     the response message.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Sku>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Sku>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest.new
            #
            #   # Call the list_skus method.
            #   result = client.list_skus request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GDCHardwareManagement::V1alpha::Sku.
            #     p item
            #   end
            #
            def list_skus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::ListSkusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_skus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_skus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_skus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :list_skus, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gdc_hardware_management_stub, :list_skus, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of an SKU.
            #
            # @overload get_sku(request, options = nil)
            #   Pass arguments to `get_sku` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_sku(name: nil)
            #   Pass arguments to `get_sku` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the SKU.
            #     Format: `projects/{project}/locations/{location}/skus/{sku}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::Sku]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Sku]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest.new
            #
            #   # Call the get_sku method.
            #   result = client.get_sku request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::Sku.
            #   p result
            #
            def get_sku request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::GetSkuRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_sku.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_sku.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_sku.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :get_sku, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists zones in a given project and location.
            #
            # @overload list_zones(request, options = nil)
            #   Pass arguments to `list_zones` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_zones(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_zones` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to list zones in.
            #     Format: `projects/{project}/locations/{location}`
            #
            #     To list zones across all locations, substitute `-` (the hyphen or
            #     dash character) for the location and check the unreachable field in
            #     the response message.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering condition. See [AIP-160](https://google.aip.dev/160).
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Zone>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GDCHardwareManagement::V1alpha::Zone>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest.new
            #
            #   # Call the list_zones method.
            #   result = client.list_zones request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GDCHardwareManagement::V1alpha::Zone.
            #     p item
            #   end
            #
            def list_zones request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::ListZonesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_zones.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_zones.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_zones.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :list_zones, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @gdc_hardware_management_stub, :list_zones, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a zone.
            #
            # @overload get_zone(request, options = nil)
            #   Pass arguments to `get_zone` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_zone(name: nil)
            #   Pass arguments to `get_zone` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the zone.
            #     Format: `projects/{project}/locations/{location}/zones/{zone}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GDCHardwareManagement::V1alpha::Zone]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GDCHardwareManagement::V1alpha::Zone]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest.new
            #
            #   # Call the get_zone method.
            #   result = client.get_zone request
            #
            #   # The returned object is of type Google::Cloud::GDCHardwareManagement::V1alpha::Zone.
            #   p result
            #
            def get_zone request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::GetZoneRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_zone.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_zone.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_zone.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :get_zone, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new zone in a given project and location.
            #
            # @overload create_zone(request, options = nil)
            #   Pass arguments to `create_zone` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_zone(parent: nil, zone_id: nil, zone: nil, request_id: nil)
            #   Pass arguments to `create_zone` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location to create the zone in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param zone_id [::String]
            #     Optional. ID used to uniquely identify the Zone within its parent scope.
            #     This field should contain at most 63 characters and must start with
            #     lowercase characters.
            #     Only lowercase characters, numbers and `-` are accepted.
            #     The `-` character cannot be the first or the last one.
            #     A system generated ID will be used if the field is not set.
            #
            #     The zone.name field in the request will be ignored.
            #   @param zone [::Google::Cloud::GDCHardwareManagement::V1alpha::Zone, ::Hash]
            #     Required. The zone to create.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest.new
            #
            #   # Call the create_zone method.
            #   result = client.create_zone request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_zone request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::CreateZoneRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_zone.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_zone.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_zone.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :create_zone, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a zone.
            #
            # @overload update_zone(request, options = nil)
            #   Pass arguments to `update_zone` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_zone(update_mask: nil, zone: nil, request_id: nil)
            #   Pass arguments to `update_zone` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. A mask to specify the fields in the Zone to overwrite with this
            #     update. The fields specified in the update_mask are relative to the zone,
            #     not the full request. A field will be overwritten if it is in the mask. If
            #     you don't provide a mask then all fields will be overwritten.
            #   @param zone [::Google::Cloud::GDCHardwareManagement::V1alpha::Zone, ::Hash]
            #     Required. The zone to update.
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest.new
            #
            #   # Call the update_zone method.
            #   result = client.update_zone request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_zone request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::UpdateZoneRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_zone.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.zone&.name
                header_params["zone.name"] = request.zone.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_zone.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_zone.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :update_zone, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a zone.
            #
            # @overload delete_zone(request, options = nil)
            #   Pass arguments to `delete_zone` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_zone(name: nil, request_id: nil)
            #   Pass arguments to `delete_zone` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the zone.
            #     Format: `projects/{project}/locations/{location}/zones/{zone}`
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest.new
            #
            #   # Call the delete_zone method.
            #   result = client.delete_zone request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_zone request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::DeleteZoneRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_zone.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_zone.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_zone.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :delete_zone, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Signals the state of a zone.
            #
            # @overload signal_zone_state(request, options = nil)
            #   Pass arguments to `signal_zone_state` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload signal_zone_state(name: nil, request_id: nil, state_signal: nil, provisioning_state_signal: nil, step: nil, details: nil)
            #   Pass arguments to `signal_zone_state` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the zone.
            #     Format: `projects/{project}/locations/{location}/zones/{zone}`
            #   @param request_id [::String]
            #     Optional. An optional unique identifier for this request. See
            #     [AIP-155](https://google.aip.dev/155).
            #   @param state_signal [::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest::StateSignal]
            #     Optional. The state signal to send for this zone. Either state_signal or
            #     provisioning_state_signal must be set, but not both.
            #   @param provisioning_state_signal [::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest::ProvisioningStateSignal]
            #     Optional. The provisioning state signal to send for this zone. Either
            #     state_signal or provisioning_state_signal must be set, but not both.
            #   @param step [::String]
            #     Optional. The step being executed. Provides a finer grained status when the
            #     state_signal is FACTORY_TURNUP_CHECKS_STARTED or
            #     FACTORY_TURNUP_CHECKS_FAILED.
            #   @param details [::String]
            #     Optional. Additional details, such as an error message when state_signal is
            #     FACTORY_TURNUP_CHECKS_FAILED.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest.new
            #
            #   # Call the signal_zone_state method.
            #   result = client.signal_zone_state request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def signal_zone_state request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::SignalZoneStateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.signal_zone_state.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.signal_zone_state.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.signal_zone_state.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :signal_zone_state, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the requested date change of a single Order.
            #
            # @overload request_order_date_change(request, options = nil)
            #   Pass arguments to `request_order_date_change` via a request object, either of type
            #   {::Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload request_order_date_change(name: nil, requested_date: nil)
            #   Pass arguments to `request_order_date_change` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the order to update.
            #     Format: projects/\\{project}/locations/\\{location}/orders/\\{order}
            #   @param requested_date [::Google::Type::Date, ::Hash]
            #     Required. The date to which the customer or Google wants to set the
            #     scheduled installation date.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gdc_hardware_management/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest.new
            #
            #   # Call the request_order_date_change method.
            #   result = client.request_order_date_change request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def request_order_date_change request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GDCHardwareManagement::V1alpha::RequestOrderDateChangeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.request_order_date_change.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GDCHardwareManagement::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.request_order_date_change.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.request_order_date_change.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @gdc_hardware_management_stub.call_rpc :request_order_date_change, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the GDCHardwareManagement API.
            #
            # This class represents the configuration for GDCHardwareManagement,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_orders to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_orders.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_orders.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "gdchardwaremanagement.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the GDCHardwareManagement API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_orders`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_orders
                ##
                # RPC-specific configuration for `get_order`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_order
                ##
                # RPC-specific configuration for `create_order`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_order
                ##
                # RPC-specific configuration for `update_order`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_order
                ##
                # RPC-specific configuration for `delete_order`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_order
                ##
                # RPC-specific configuration for `submit_order`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :submit_order
                ##
                # RPC-specific configuration for `cancel_order`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_order
                ##
                # RPC-specific configuration for `list_sites`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_sites
                ##
                # RPC-specific configuration for `get_site`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_site
                ##
                # RPC-specific configuration for `create_site`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_site
                ##
                # RPC-specific configuration for `update_site`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_site
                ##
                # RPC-specific configuration for `delete_site`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_site
                ##
                # RPC-specific configuration for `list_hardware_groups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_hardware_groups
                ##
                # RPC-specific configuration for `get_hardware_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_hardware_group
                ##
                # RPC-specific configuration for `create_hardware_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_hardware_group
                ##
                # RPC-specific configuration for `update_hardware_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_hardware_group
                ##
                # RPC-specific configuration for `delete_hardware_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_hardware_group
                ##
                # RPC-specific configuration for `list_hardware`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_hardware
                ##
                # RPC-specific configuration for `get_hardware`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_hardware
                ##
                # RPC-specific configuration for `create_hardware`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_hardware
                ##
                # RPC-specific configuration for `update_hardware`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_hardware
                ##
                # RPC-specific configuration for `delete_hardware`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_hardware
                ##
                # RPC-specific configuration for `list_comments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_comments
                ##
                # RPC-specific configuration for `get_comment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_comment
                ##
                # RPC-specific configuration for `create_comment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_comment
                ##
                # RPC-specific configuration for `record_action_on_comment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :record_action_on_comment
                ##
                # RPC-specific configuration for `list_change_log_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_change_log_entries
                ##
                # RPC-specific configuration for `get_change_log_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_change_log_entry
                ##
                # RPC-specific configuration for `list_skus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_skus
                ##
                # RPC-specific configuration for `get_sku`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_sku
                ##
                # RPC-specific configuration for `list_zones`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_zones
                ##
                # RPC-specific configuration for `get_zone`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_zone
                ##
                # RPC-specific configuration for `create_zone`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_zone
                ##
                # RPC-specific configuration for `update_zone`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_zone
                ##
                # RPC-specific configuration for `delete_zone`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_zone
                ##
                # RPC-specific configuration for `signal_zone_state`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :signal_zone_state
                ##
                # RPC-specific configuration for `request_order_date_change`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :request_order_date_change

                # @private
                def initialize parent_rpcs = nil
                  list_orders_config = parent_rpcs.list_orders if parent_rpcs.respond_to? :list_orders
                  @list_orders = ::Gapic::Config::Method.new list_orders_config
                  get_order_config = parent_rpcs.get_order if parent_rpcs.respond_to? :get_order
                  @get_order = ::Gapic::Config::Method.new get_order_config
                  create_order_config = parent_rpcs.create_order if parent_rpcs.respond_to? :create_order
                  @create_order = ::Gapic::Config::Method.new create_order_config
                  update_order_config = parent_rpcs.update_order if parent_rpcs.respond_to? :update_order
                  @update_order = ::Gapic::Config::Method.new update_order_config
                  delete_order_config = parent_rpcs.delete_order if parent_rpcs.respond_to? :delete_order
                  @delete_order = ::Gapic::Config::Method.new delete_order_config
                  submit_order_config = parent_rpcs.submit_order if parent_rpcs.respond_to? :submit_order
                  @submit_order = ::Gapic::Config::Method.new submit_order_config
                  cancel_order_config = parent_rpcs.cancel_order if parent_rpcs.respond_to? :cancel_order
                  @cancel_order = ::Gapic::Config::Method.new cancel_order_config
                  list_sites_config = parent_rpcs.list_sites if parent_rpcs.respond_to? :list_sites
                  @list_sites = ::Gapic::Config::Method.new list_sites_config
                  get_site_config = parent_rpcs.get_site if parent_rpcs.respond_to? :get_site
                  @get_site = ::Gapic::Config::Method.new get_site_config
                  create_site_config = parent_rpcs.create_site if parent_rpcs.respond_to? :create_site
                  @create_site = ::Gapic::Config::Method.new create_site_config
                  update_site_config = parent_rpcs.update_site if parent_rpcs.respond_to? :update_site
                  @update_site = ::Gapic::Config::Method.new update_site_config
                  delete_site_config = parent_rpcs.delete_site if parent_rpcs.respond_to? :delete_site
                  @delete_site = ::Gapic::Config::Method.new delete_site_config
                  list_hardware_groups_config = parent_rpcs.list_hardware_groups if parent_rpcs.respond_to? :list_hardware_groups
                  @list_hardware_groups = ::Gapic::Config::Method.new list_hardware_groups_config
                  get_hardware_group_config = parent_rpcs.get_hardware_group if parent_rpcs.respond_to? :get_hardware_group
                  @get_hardware_group = ::Gapic::Config::Method.new get_hardware_group_config
                  create_hardware_group_config = parent_rpcs.create_hardware_group if parent_rpcs.respond_to? :create_hardware_group
                  @create_hardware_group = ::Gapic::Config::Method.new create_hardware_group_config
                  update_hardware_group_config = parent_rpcs.update_hardware_group if parent_rpcs.respond_to? :update_hardware_group
                  @update_hardware_group = ::Gapic::Config::Method.new update_hardware_group_config
                  delete_hardware_group_config = parent_rpcs.delete_hardware_group if parent_rpcs.respond_to? :delete_hardware_group
                  @delete_hardware_group = ::Gapic::Config::Method.new delete_hardware_group_config
                  list_hardware_config = parent_rpcs.list_hardware if parent_rpcs.respond_to? :list_hardware
                  @list_hardware = ::Gapic::Config::Method.new list_hardware_config
                  get_hardware_config = parent_rpcs.get_hardware if parent_rpcs.respond_to? :get_hardware
                  @get_hardware = ::Gapic::Config::Method.new get_hardware_config
                  create_hardware_config = parent_rpcs.create_hardware if parent_rpcs.respond_to? :create_hardware
                  @create_hardware = ::Gapic::Config::Method.new create_hardware_config
                  update_hardware_config = parent_rpcs.update_hardware if parent_rpcs.respond_to? :update_hardware
                  @update_hardware = ::Gapic::Config::Method.new update_hardware_config
                  delete_hardware_config = parent_rpcs.delete_hardware if parent_rpcs.respond_to? :delete_hardware
                  @delete_hardware = ::Gapic::Config::Method.new delete_hardware_config
                  list_comments_config = parent_rpcs.list_comments if parent_rpcs.respond_to? :list_comments
                  @list_comments = ::Gapic::Config::Method.new list_comments_config
                  get_comment_config = parent_rpcs.get_comment if parent_rpcs.respond_to? :get_comment
                  @get_comment = ::Gapic::Config::Method.new get_comment_config
                  create_comment_config = parent_rpcs.create_comment if parent_rpcs.respond_to? :create_comment
                  @create_comment = ::Gapic::Config::Method.new create_comment_config
                  record_action_on_comment_config = parent_rpcs.record_action_on_comment if parent_rpcs.respond_to? :record_action_on_comment
                  @record_action_on_comment = ::Gapic::Config::Method.new record_action_on_comment_config
                  list_change_log_entries_config = parent_rpcs.list_change_log_entries if parent_rpcs.respond_to? :list_change_log_entries
                  @list_change_log_entries = ::Gapic::Config::Method.new list_change_log_entries_config
                  get_change_log_entry_config = parent_rpcs.get_change_log_entry if parent_rpcs.respond_to? :get_change_log_entry
                  @get_change_log_entry = ::Gapic::Config::Method.new get_change_log_entry_config
                  list_skus_config = parent_rpcs.list_skus if parent_rpcs.respond_to? :list_skus
                  @list_skus = ::Gapic::Config::Method.new list_skus_config
                  get_sku_config = parent_rpcs.get_sku if parent_rpcs.respond_to? :get_sku
                  @get_sku = ::Gapic::Config::Method.new get_sku_config
                  list_zones_config = parent_rpcs.list_zones if parent_rpcs.respond_to? :list_zones
                  @list_zones = ::Gapic::Config::Method.new list_zones_config
                  get_zone_config = parent_rpcs.get_zone if parent_rpcs.respond_to? :get_zone
                  @get_zone = ::Gapic::Config::Method.new get_zone_config
                  create_zone_config = parent_rpcs.create_zone if parent_rpcs.respond_to? :create_zone
                  @create_zone = ::Gapic::Config::Method.new create_zone_config
                  update_zone_config = parent_rpcs.update_zone if parent_rpcs.respond_to? :update_zone
                  @update_zone = ::Gapic::Config::Method.new update_zone_config
                  delete_zone_config = parent_rpcs.delete_zone if parent_rpcs.respond_to? :delete_zone
                  @delete_zone = ::Gapic::Config::Method.new delete_zone_config
                  signal_zone_state_config = parent_rpcs.signal_zone_state if parent_rpcs.respond_to? :signal_zone_state
                  @signal_zone_state = ::Gapic::Config::Method.new signal_zone_state_config
                  request_order_date_change_config = parent_rpcs.request_order_date_change if parent_rpcs.respond_to? :request_order_date_change
                  @request_order_date_change = ::Gapic::Config::Method.new request_order_date_change_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
