# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/gdc_hardware_management/v1alpha/version"

require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management/credentials"
require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management/paths"
require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management/operations"
require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management/client"
require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management/rest"

module Google
  module Cloud
    module GDCHardwareManagement
      module V1alpha
        ##
        # The GDC Hardware Management service.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management"
        #     client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management/rest"
        #     client = ::Google::Cloud::GDCHardwareManagement::V1alpha::GDCHardwareManagement::Rest::Client.new
        #
        module GDCHardwareManagement
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "gdc_hardware_management", "helpers.rb"
require "google/cloud/gdc_hardware_management/v1alpha/gdc_hardware_management/helpers" if ::File.file? helper_path
