# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/functions/v2/functions_pb"
require "google/cloud/functions/v2/function_service"

class ::Google::Cloud::Functions::V2::FunctionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_function
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Functions::V2::Function.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revision = "hello world"

    get_function_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_function, name
      assert_kind_of ::Google::Cloud::Functions::V2::GetFunctionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["revision"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_function_client_stub do
      # Create client
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_function({ name: name, revision: revision }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_function name: name, revision: revision do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_function ::Google::Cloud::Functions::V2::GetFunctionRequest.new(name: name, revision: revision) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_function({ name: name, revision: revision }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_function(::Google::Cloud::Functions::V2::GetFunctionRequest.new(name: name, revision: revision), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_function_client_stub.call_rpc_count
    end
  end

  def test_list_functions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Functions::V2::ListFunctionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_functions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_functions, name
      assert_kind_of ::Google::Cloud::Functions::V2::ListFunctionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_functions_client_stub do
      # Create client
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_functions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_functions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_functions ::Google::Cloud::Functions::V2::ListFunctionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_functions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_functions(::Google::Cloud::Functions::V2::ListFunctionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_functions_client_stub.call_rpc_count
    end
  end

  def test_create_function
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    function = {}
    function_id = "hello world"

    create_function_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_function, name
      assert_kind_of ::Google::Cloud::Functions::V2::CreateFunctionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Functions::V2::Function), request["function"]
      assert_equal "hello world", request["function_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_function_client_stub do
      # Create client
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_function({ parent: parent, function: function, function_id: function_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_function parent: parent, function: function, function_id: function_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_function ::Google::Cloud::Functions::V2::CreateFunctionRequest.new(parent: parent, function: function, function_id: function_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_function({ parent: parent, function: function, function_id: function_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_function(::Google::Cloud::Functions::V2::CreateFunctionRequest.new(parent: parent, function: function, function_id: function_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_function_client_stub.call_rpc_count
    end
  end

  def test_update_function
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    function = {}
    update_mask = {}

    update_function_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_function, name
      assert_kind_of ::Google::Cloud::Functions::V2::UpdateFunctionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Functions::V2::Function), request["function"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_function_client_stub do
      # Create client
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_function({ function: function, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_function function: function, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_function ::Google::Cloud::Functions::V2::UpdateFunctionRequest.new(function: function, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_function({ function: function, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_function(::Google::Cloud::Functions::V2::UpdateFunctionRequest.new(function: function, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_function_client_stub.call_rpc_count
    end
  end

  def test_delete_function
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_function_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_function, name
      assert_kind_of ::Google::Cloud::Functions::V2::DeleteFunctionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_function_client_stub do
      # Create client
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_function({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_function name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_function ::Google::Cloud::Functions::V2::DeleteFunctionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_function({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_function(::Google::Cloud::Functions::V2::DeleteFunctionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_function_client_stub.call_rpc_count
    end
  end

  def test_generate_upload_url
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Functions::V2::GenerateUploadUrlResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    kms_key_name = "hello world"
    environment = :ENVIRONMENT_UNSPECIFIED

    generate_upload_url_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_upload_url, name
      assert_kind_of ::Google::Cloud::Functions::V2::GenerateUploadUrlRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["kms_key_name"]
      assert_equal :ENVIRONMENT_UNSPECIFIED, request["environment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_upload_url_client_stub do
      # Create client
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_upload_url({ parent: parent, kms_key_name: kms_key_name, environment: environment }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_upload_url parent: parent, kms_key_name: kms_key_name, environment: environment do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_upload_url ::Google::Cloud::Functions::V2::GenerateUploadUrlRequest.new(parent: parent, kms_key_name: kms_key_name, environment: environment) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_upload_url({ parent: parent, kms_key_name: kms_key_name, environment: environment }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_upload_url(::Google::Cloud::Functions::V2::GenerateUploadUrlRequest.new(parent: parent, kms_key_name: kms_key_name, environment: environment), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_upload_url_client_stub.call_rpc_count
    end
  end

  def test_generate_download_url
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Functions::V2::GenerateDownloadUrlResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    generate_download_url_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_download_url, name
      assert_kind_of ::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_download_url_client_stub do
      # Create client
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_download_url({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_download_url name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_download_url ::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_download_url({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_download_url(::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_download_url_client_stub.call_rpc_count
    end
  end

  def test_list_runtimes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Functions::V2::ListRuntimesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"

    list_runtimes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_runtimes, name
      assert_kind_of ::Google::Cloud::Functions::V2::ListRuntimesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_runtimes_client_stub do
      # Create client
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_runtimes({ parent: parent, filter: filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_runtimes parent: parent, filter: filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_runtimes ::Google::Cloud::Functions::V2::ListRuntimesRequest.new(parent: parent, filter: filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_runtimes({ parent: parent, filter: filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_runtimes(::Google::Cloud::Functions::V2::ListRuntimesRequest.new(parent: parent, filter: filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_runtimes_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Functions::V2::FunctionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Functions::V2::FunctionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Functions::V2::FunctionService::Operations, client.operations_client
  end
end
