# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/functions/v2/functions_pb"
require "google/cloud/functions/v2/function_service/rest"


class ::Google::Cloud::Functions::V2::FunctionService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_function
    # Create test objects.
    client_result = ::Google::Cloud::Functions::V2::Function.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revision = "hello world"

    get_function_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Functions::V2::FunctionService::Rest::ServiceStub.stub :transcode_get_function_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_function_client_stub do
        # Create client
        client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_function({ name: name, revision: revision }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_function name: name, revision: revision do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_function ::Google::Cloud::Functions::V2::GetFunctionRequest.new(name: name, revision: revision) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_function({ name: name, revision: revision }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_function(::Google::Cloud::Functions::V2::GetFunctionRequest.new(name: name, revision: revision), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_function_client_stub.call_count
      end
    end
  end

  def test_list_functions
    # Create test objects.
    client_result = ::Google::Cloud::Functions::V2::ListFunctionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_functions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Functions::V2::FunctionService::Rest::ServiceStub.stub :transcode_list_functions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_functions_client_stub do
        # Create client
        client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_functions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_functions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_functions ::Google::Cloud::Functions::V2::ListFunctionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_functions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_functions(::Google::Cloud::Functions::V2::ListFunctionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_functions_client_stub.call_count
      end
    end
  end

  def test_create_function
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    function = {}
    function_id = "hello world"

    create_function_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Functions::V2::FunctionService::Rest::ServiceStub.stub :transcode_create_function_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_function_client_stub do
        # Create client
        client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_function({ parent: parent, function: function, function_id: function_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_function parent: parent, function: function, function_id: function_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_function ::Google::Cloud::Functions::V2::CreateFunctionRequest.new(parent: parent, function: function, function_id: function_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_function({ parent: parent, function: function, function_id: function_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_function(::Google::Cloud::Functions::V2::CreateFunctionRequest.new(parent: parent, function: function, function_id: function_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_function_client_stub.call_count
      end
    end
  end

  def test_update_function
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    function = {}
    update_mask = {}

    update_function_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Functions::V2::FunctionService::Rest::ServiceStub.stub :transcode_update_function_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_function_client_stub do
        # Create client
        client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_function({ function: function, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_function function: function, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_function ::Google::Cloud::Functions::V2::UpdateFunctionRequest.new(function: function, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_function({ function: function, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_function(::Google::Cloud::Functions::V2::UpdateFunctionRequest.new(function: function, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_function_client_stub.call_count
      end
    end
  end

  def test_delete_function
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_function_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Functions::V2::FunctionService::Rest::ServiceStub.stub :transcode_delete_function_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_function_client_stub do
        # Create client
        client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_function({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_function name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_function ::Google::Cloud::Functions::V2::DeleteFunctionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_function({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_function(::Google::Cloud::Functions::V2::DeleteFunctionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_function_client_stub.call_count
      end
    end
  end

  def test_generate_upload_url
    # Create test objects.
    client_result = ::Google::Cloud::Functions::V2::GenerateUploadUrlResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    kms_key_name = "hello world"
    environment = :ENVIRONMENT_UNSPECIFIED

    generate_upload_url_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Functions::V2::FunctionService::Rest::ServiceStub.stub :transcode_generate_upload_url_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_upload_url_client_stub do
        # Create client
        client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_upload_url({ parent: parent, kms_key_name: kms_key_name, environment: environment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_upload_url parent: parent, kms_key_name: kms_key_name, environment: environment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_upload_url ::Google::Cloud::Functions::V2::GenerateUploadUrlRequest.new(parent: parent, kms_key_name: kms_key_name, environment: environment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_upload_url({ parent: parent, kms_key_name: kms_key_name, environment: environment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_upload_url(::Google::Cloud::Functions::V2::GenerateUploadUrlRequest.new(parent: parent, kms_key_name: kms_key_name, environment: environment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_upload_url_client_stub.call_count
      end
    end
  end

  def test_generate_download_url
    # Create test objects.
    client_result = ::Google::Cloud::Functions::V2::GenerateDownloadUrlResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    generate_download_url_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Functions::V2::FunctionService::Rest::ServiceStub.stub :transcode_generate_download_url_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_download_url_client_stub do
        # Create client
        client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_download_url({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_download_url name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_download_url ::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_download_url({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_download_url(::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_download_url_client_stub.call_count
      end
    end
  end

  def test_list_runtimes
    # Create test objects.
    client_result = ::Google::Cloud::Functions::V2::ListRuntimesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"

    list_runtimes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Functions::V2::FunctionService::Rest::ServiceStub.stub :transcode_list_runtimes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_runtimes_client_stub do
        # Create client
        client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_runtimes({ parent: parent, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_runtimes parent: parent, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_runtimes ::Google::Cloud::Functions::V2::ListRuntimesRequest.new(parent: parent, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_runtimes({ parent: parent, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_runtimes(::Google::Cloud::Functions::V2::ListRuntimesRequest.new(parent: parent, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_runtimes_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Functions::V2::FunctionService::Rest::Client::Configuration, config
  end
end
