# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Functions
      module V2
        # Describes a Cloud Function that contains user computation executed in
        # response to an event. It encapsulates function and trigger configurations.
        # @!attribute [rw] name
        #   @return [::String]
        #     A user-defined name of the function. Function names must be unique
        #     globally and match pattern `projects/*/locations/*/functions/*`
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description of a function.
        # @!attribute [rw] build_config
        #   @return [::Google::Cloud::Functions::V2::BuildConfig]
        #     Describes the Build step of the function that builds a container from the
        #     given source.
        # @!attribute [rw] service_config
        #   @return [::Google::Cloud::Functions::V2::ServiceConfig]
        #     Describes the Service being deployed. Currently deploys services to Cloud
        #     Run (fully managed).
        # @!attribute [rw] event_trigger
        #   @return [::Google::Cloud::Functions::V2::EventTrigger]
        #     An Eventarc trigger managed by Google Cloud Functions that fires events in
        #     response to a condition in another service.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Functions::V2::Function::State]
        #     Output only. State of the function.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of a Cloud Function.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this Cloud Function.
        # @!attribute [r] state_messages
        #   @return [::Array<::Google::Cloud::Functions::V2::StateMessage>]
        #     Output only. State Messages for this Cloud Function.
        # @!attribute [rw] environment
        #   @return [::Google::Cloud::Functions::V2::Environment]
        #     Describe whether the function is 1st Gen or 2nd Gen.
        # @!attribute [r] url
        #   @return [::String]
        #     Output only. The deployed url for the function.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Resource name of a KMS crypto key (managed by the user) used to
        #     encrypt/decrypt function resources.
        #
        #     It must match the pattern
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp of a Cloud Function. This is only
        #     applicable to 2nd Gen functions.
        class Function
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes the current state of the function.
          module State
            # Not specified. Invalid state.
            STATE_UNSPECIFIED = 0

            # Function has been successfully deployed and is serving.
            ACTIVE = 1

            # Function deployment failed and the function is not serving.
            FAILED = 2

            # Function is being created or updated.
            DEPLOYING = 3

            # Function is being deleted.
            DELETING = 4

            # Function deployment failed and the function serving state is undefined.
            # The function should be updated or deleted to move it out of this state.
            UNKNOWN = 5
          end
        end

        # Informational messages about the state of the Cloud Function or Operation.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::Functions::V2::StateMessage::Severity]
        #     Severity of the state message.
        # @!attribute [rw] type
        #   @return [::String]
        #     One-word CamelCase type of the state message.
        # @!attribute [rw] message
        #   @return [::String]
        #     The message.
        class StateMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Severity of the state message.
          module Severity
            # Not specified. Invalid severity.
            SEVERITY_UNSPECIFIED = 0

            # ERROR-level severity.
            ERROR = 1

            # WARNING-level severity.
            WARNING = 2

            # INFO-level severity.
            INFO = 3
          end
        end

        # Location of the source in an archive file in Google Cloud Storage.
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Google Cloud Storage bucket containing the source (see
        #     [Bucket Name
        #     Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        # @!attribute [rw] object
        #   @return [::String]
        #     Google Cloud Storage object containing the source.
        #
        #     This object must be a gzipped archive file (`.tar.gz`) containing source to
        #     build.
        # @!attribute [rw] generation
        #   @return [::Integer]
        #     Google Cloud Storage generation for the object. If the generation is
        #     omitted, the latest generation will be used.
        # @!attribute [rw] source_upload_url
        #   @return [::String]
        #     When the specified storage bucket is a 1st gen function uploard url bucket,
        #     this field should be set as the generated upload url for 1st gen
        #     deployment.
        class StorageSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of the source in a Google Cloud Source Repository.
        # @!attribute [rw] branch_name
        #   @return [::String]
        #     Regex matching branches to build.
        #
        #     The syntax of the regular expressions accepted is the syntax accepted by
        #     RE2 and described at https://github.com/google/re2/wiki/Syntax
        #
        #     Note: The following fields are mutually exclusive: `branch_name`, `tag_name`, `commit_sha`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag_name
        #   @return [::String]
        #     Regex matching tags to build.
        #
        #     The syntax of the regular expressions accepted is the syntax accepted by
        #     RE2 and described at https://github.com/google/re2/wiki/Syntax
        #
        #     Note: The following fields are mutually exclusive: `tag_name`, `branch_name`, `commit_sha`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] commit_sha
        #   @return [::String]
        #     Explicit commit SHA to build.
        #
        #     Note: The following fields are mutually exclusive: `commit_sha`, `branch_name`, `tag_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     ID of the project that owns the Cloud Source Repository. If omitted, the
        #     project ID requesting the build is assumed.
        # @!attribute [rw] repo_name
        #   @return [::String]
        #     Name of the Cloud Source Repository.
        # @!attribute [rw] dir
        #   @return [::String]
        #     Directory, relative to the source root, in which to run the build.
        #
        #     This must be a relative path. If a step's `dir` is specified and is an
        #     absolute path, this value is ignored for that step's execution.
        #     eg. helloworld (no leading slash allowed)
        # @!attribute [rw] invert_regex
        #   @return [::Boolean]
        #     Only trigger a build if the revision regex does NOT match the revision
        #     regex.
        class RepoSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The location of the function source code.
        # @!attribute [rw] storage_source
        #   @return [::Google::Cloud::Functions::V2::StorageSource]
        #     If provided, get the source from this location in Google Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `storage_source`, `repo_source`, `git_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] repo_source
        #   @return [::Google::Cloud::Functions::V2::RepoSource]
        #     If provided, get the source from this location in a Cloud Source
        #     Repository.
        #
        #     Note: The following fields are mutually exclusive: `repo_source`, `storage_source`, `git_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] git_uri
        #   @return [::String]
        #     If provided, get the source from GitHub repository. This option is valid
        #     only for GCF 1st Gen function.
        #     Example: https://github.com/<user>/<repo>/blob/<commit>/<path-to-code>
        #
        #     Note: The following fields are mutually exclusive: `git_uri`, `storage_source`, `repo_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Source
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Provenance of the source. Ways to find the original source, or verify that
        # some source was used for this build.
        # @!attribute [rw] resolved_storage_source
        #   @return [::Google::Cloud::Functions::V2::StorageSource]
        #     A copy of the build's `source.storage_source`, if exists, with any
        #     generations resolved.
        # @!attribute [rw] resolved_repo_source
        #   @return [::Google::Cloud::Functions::V2::RepoSource]
        #     A copy of the build's `source.repo_source`, if exists, with any
        #     revisions resolved.
        # @!attribute [rw] git_uri
        #   @return [::String]
        #     A copy of the build's `source.git_uri`, if exists, with any commits
        #     resolved.
        class SourceProvenance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the Build step of the function that builds a container from the
        # given source.
        # @!attribute [rw] automatic_update_policy
        #   @return [::Google::Cloud::Functions::V2::AutomaticUpdatePolicy]
        #     Note: The following fields are mutually exclusive: `automatic_update_policy`, `on_deploy_update_policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] on_deploy_update_policy
        #   @return [::Google::Cloud::Functions::V2::OnDeployUpdatePolicy]
        #     Note: The following fields are mutually exclusive: `on_deploy_update_policy`, `automatic_update_policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. The Cloud Build name of the latest successful deployment of
        #     the function.
        # @!attribute [rw] runtime
        #   @return [::String]
        #     The runtime in which to run the function. Required when deploying a new
        #     function, optional when updating an existing function. For a complete
        #     list of possible choices, see the
        #     [`gcloud` command
        #     reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
        # @!attribute [rw] entry_point
        #   @return [::String]
        #     The name of the function (as defined in source code) that will be
        #     executed. Defaults to the resource name suffix, if not specified. For
        #     backward compatibility, if function with given name is not found, then the
        #     system will try to use function named "function".
        #     For Node.js this is name of a function exported by the module specified
        #     in `source_location`.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::Functions::V2::Source]
        #     The location of the function source code.
        # @!attribute [r] source_provenance
        #   @return [::Google::Cloud::Functions::V2::SourceProvenance]
        #     Output only. A permanent fixed identifier for source.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     Name of the Cloud Build Custom Worker Pool that should be used to build the
        #     function. The format of this field is
        #     `projects/{project}/locations/{region}/workerPools/{workerPool}` where
        #     \\{project} and \\{region} are the project id and region respectively where the
        #     worker pool is defined and \\{workerPool} is the short name of the worker
        #     pool.
        #
        #     If the project id is not the same as the function, then the Cloud
        #     Functions Service Agent
        #     (service-<project_number>@gcf-admin-robot.iam.gserviceaccount.com) must be
        #     granted the role Cloud Build Custom Workers Builder
        #     (roles/cloudbuild.customworkers.builder) in the project.
        # @!attribute [rw] environment_variables
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-provided build-time environment variables for the function
        # @!attribute [rw] docker_registry
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Functions::V2::BuildConfig::DockerRegistry]
        #     Docker Registry to use for this deployment. This configuration is only
        #     applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
        #     Registry.
        #     Deprecated: As of March 2025, `CONTAINER_REGISTRY` option is no longer
        #     available in response to Container Registry's deprecation:
        #     https://cloud.google.com/artifact-registry/docs/transition/transition-from-gcr
        #     Please use Artifact Registry instead, which is the default choice.
        #
        #     If unspecified, it defaults to `ARTIFACT_REGISTRY`.
        #     If `docker_repository` field is specified, this field should either be left
        #     unspecified or set to `ARTIFACT_REGISTRY`.
        # @!attribute [rw] docker_repository
        #   @return [::String]
        #     Repository in Artifact Registry to which the function docker image will be
        #     pushed after it is built by Cloud Build. If specified by user, it is
        #     created and managed by user with a customer managed encryption key.
        #     Otherwise, GCF will create and use a repository named 'gcf-artifacts'
        #     for every deployed region.
        #
        #     It must match the pattern
        #     `projects/{project}/locations/{location}/repositories/{repository}`.
        #     Repository format must be 'DOCKER'.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Service account to be used for building the container. The format of this
        #     field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
        class BuildConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class EnvironmentVariablesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Docker Registry to use for storing function Docker images.
          module DockerRegistry
            # Unspecified.
            DOCKER_REGISTRY_UNSPECIFIED = 0

            # Docker images will be stored in multi-regional Container Registry
            # repositories named `gcf`.
            CONTAINER_REGISTRY = 1

            # Docker images will be stored in regional Artifact Registry repositories.
            # By default, GCF will create and use repositories named `gcf-artifacts`
            # in every region in which a function is deployed. But the repository to
            # use can also be specified by the user using the `docker_repository`
            # field.
            ARTIFACT_REGISTRY = 2
          end
        end

        # Describes the Service being deployed.
        # Currently Supported : Cloud Run (fully managed).
        # @!attribute [r] service
        #   @return [::String]
        #     Output only. Name of the service associated with a Function.
        #     The format of this field is
        #     `projects/{project}/locations/{region}/services/{service}`
        # @!attribute [rw] timeout_seconds
        #   @return [::Integer]
        #     The function execution timeout. Execution is considered failed and
        #     can be terminated if the function is not completed at the end of the
        #     timeout period. Defaults to 60 seconds.
        # @!attribute [rw] available_memory
        #   @return [::String]
        #     The amount of memory available for a function.
        #     Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
        #     supplied the value is interpreted as bytes.
        #     See
        #     https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        #     a full description.
        # @!attribute [rw] available_cpu
        #   @return [::String]
        #     The number of CPUs used in a single container instance.
        #     Default value is calculated from available memory.
        #     Supports the same values as Cloud Run, see
        #     https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
        #     Example: "1" indicates 1 vCPU
        # @!attribute [rw] environment_variables
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Environment variables that shall be available during function execution.
        # @!attribute [rw] max_instance_count
        #   @return [::Integer]
        #     The limit on the maximum number of function instances that may coexist at a
        #     given time.
        #
        #     In some cases, such as rapid traffic surges, Cloud Functions may, for a
        #     short period of time, create more instances than the specified max
        #     instances limit. If your function cannot tolerate this temporary behavior,
        #     you may want to factor in a safety margin and set a lower max instances
        #     value than your function can tolerate.
        #
        #     See the [Max
        #     Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
        #     more details.
        # @!attribute [rw] min_instance_count
        #   @return [::Integer]
        #     The limit on the minimum number of function instances that may coexist at a
        #     given time.
        #
        #     Function instances are kept in idle state for a short period after they
        #     finished executing the request to reduce cold start time for subsequent
        #     requests. Setting a minimum instance count will ensure that the given
        #     number of instances are kept running in idle state always. This can help
        #     with cold start times when jump in incoming request count occurs after the
        #     idle instance would have been stopped in the default case.
        # @!attribute [rw] vpc_connector
        #   @return [::String]
        #     The Serverless VPC Access connector that this cloud function can connect
        #     to. The format of this field is `projects/*/locations/*/connectors/*`.
        # @!attribute [rw] vpc_connector_egress_settings
        #   @return [::Google::Cloud::Functions::V2::ServiceConfig::VpcConnectorEgressSettings]
        #     The egress settings for the connector, controlling what traffic is diverted
        #     through it.
        # @!attribute [rw] ingress_settings
        #   @return [::Google::Cloud::Functions::V2::ServiceConfig::IngressSettings]
        #     The ingress settings for the function, controlling what traffic can reach
        #     it.
        # @!attribute [r] uri
        #   @return [::String]
        #     Output only. URI of the Service deployed.
        # @!attribute [rw] service_account_email
        #   @return [::String]
        #     The email of the service's service account. If empty, defaults to
        #     `{project_number}-compute@developer.gserviceaccount.com`.
        # @!attribute [rw] all_traffic_on_latest_revision
        #   @return [::Boolean]
        #     Whether 100% of traffic is routed to the latest revision.
        #     On CreateFunction and UpdateFunction, when set to true, the revision being
        #     deployed will serve 100% of traffic, ignoring any traffic split settings,
        #     if any. On GetFunction, true will be returned if the latest revision is
        #     serving 100% of traffic.
        # @!attribute [rw] secret_environment_variables
        #   @return [::Array<::Google::Cloud::Functions::V2::SecretEnvVar>]
        #     Secret environment variables configuration.
        # @!attribute [rw] secret_volumes
        #   @return [::Array<::Google::Cloud::Functions::V2::SecretVolume>]
        #     Secret volumes configuration.
        # @!attribute [r] revision
        #   @return [::String]
        #     Output only. The name of service revision.
        # @!attribute [rw] max_instance_request_concurrency
        #   @return [::Integer]
        #     Sets the maximum number of concurrent requests that each instance
        #     can receive. Defaults to 1.
        # @!attribute [rw] security_level
        #   @return [::Google::Cloud::Functions::V2::ServiceConfig::SecurityLevel]
        #     Security level configure whether the function only accepts https.
        #     This configuration is only applicable to 1st Gen functions with Http
        #     trigger. By default https is optional for 1st Gen functions; 2nd Gen
        #     functions are https ONLY.
        # @!attribute [rw] binary_authorization_policy
        #   @return [::String]
        #     Optional. The binary authorization policy to be checked when deploying the
        #     Cloud Run service.
        class ServiceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class EnvironmentVariablesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Available egress settings.
          #
          # This controls what traffic is diverted through the VPC Access Connector
          # resource. By default PRIVATE_RANGES_ONLY will be used.
          module VpcConnectorEgressSettings
            # Unspecified.
            VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0

            # Use the VPC Access Connector only for private IP space from RFC1918.
            PRIVATE_RANGES_ONLY = 1

            # Force the use of VPC Access Connector for all egress traffic from the
            # function.
            ALL_TRAFFIC = 2
          end

          # Available ingress settings.
          #
          # This controls what traffic can reach the function.
          #
          # If unspecified, ALLOW_ALL will be used.
          module IngressSettings
            # Unspecified.
            INGRESS_SETTINGS_UNSPECIFIED = 0

            # Allow HTTP traffic from public and private sources.
            ALLOW_ALL = 1

            # Allow HTTP traffic from only private VPC sources.
            ALLOW_INTERNAL_ONLY = 2

            # Allow HTTP traffic from private VPC sources and through GCLB.
            ALLOW_INTERNAL_AND_GCLB = 3
          end

          # Available security level settings.
          #
          # This enforces security protocol on function URL.
          #
          # Security level is only configurable for 1st Gen functions, If unspecified,
          # SECURE_OPTIONAL will be used. 2nd Gen functions are SECURE_ALWAYS ONLY.
          module SecurityLevel
            # Unspecified.
            SECURITY_LEVEL_UNSPECIFIED = 0

            # Requests for a URL that match this handler that do not use HTTPS are
            # automatically redirected to the HTTPS URL with the same path. Query
            # parameters are reserved for the redirect.
            SECURE_ALWAYS = 1

            # Both HTTP and HTTPS requests with URLs that match the handler succeed
            # without redirects. The application can examine the request to determine
            # which protocol was used and respond accordingly.
            SECURE_OPTIONAL = 2
          end
        end

        # Configuration for a secret environment variable. It has the information
        # necessary to fetch the secret value from secret manager and expose it as an
        # environment variable.
        # @!attribute [rw] key
        #   @return [::String]
        #     Name of the environment variable.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project identifier (preferably project number but can also be the
        #     project ID) of the project that contains the secret. If not set, it is
        #     assumed that the secret is in the same project as the function.
        # @!attribute [rw] secret
        #   @return [::String]
        #     Name of the secret in secret manager (not the full resource name).
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of the secret (version number or the string 'latest'). It is
        #     recommended to use a numeric version for secret environment variables as
        #     any updates to the secret value is not reflected until new instances
        #     start.
        class SecretEnvVar
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for a secret volume. It has the information necessary to fetch
        # the secret value from secret manager and make it available as files mounted
        # at the requested paths within the application container.
        # @!attribute [rw] mount_path
        #   @return [::String]
        #     The path within the container to mount the secret volume. For example,
        #     setting the mount_path as `/etc/secrets` would mount the secret value files
        #     under the `/etc/secrets` directory. This directory will also be completely
        #     shadowed and unavailable to mount any other secrets.
        #     Recommended mount path: /etc/secrets
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project identifier (preferably project number but can also be the project
        #     ID) of the project that contains the secret. If not set, it is
        #     assumed that the secret is in the same project as the function.
        # @!attribute [rw] secret
        #   @return [::String]
        #     Name of the secret in secret manager (not the full resource name).
        # @!attribute [rw] versions
        #   @return [::Array<::Google::Cloud::Functions::V2::SecretVolume::SecretVersion>]
        #     List of secret versions to mount for this secret. If empty, the `latest`
        #     version of the secret will be made available in a file named after the
        #     secret under the mount point.
        class SecretVolume
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for a single version.
          # @!attribute [rw] version
          #   @return [::String]
          #     Version of the secret (version number or the string 'latest'). It is
          #     preferable to use `latest` version with secret volumes as secret value
          #     changes are reflected immediately.
          # @!attribute [rw] path
          #   @return [::String]
          #     Relative path of the file under the mount path where the secret value for
          #     this version will be fetched and made available. For example, setting the
          #     mount_path as '/etc/secrets' and path as `secret_foo` would mount the
          #     secret value file at `/etc/secrets/secret_foo`.
          class SecretVersion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Describes EventTrigger, used to request events to be sent from another
        # service.
        # @!attribute [r] trigger
        #   @return [::String]
        #     Output only. The resource name of the Eventarc trigger. The format of this
        #     field is `projects/{project}/locations/{region}/triggers/{trigger}`.
        # @!attribute [rw] trigger_region
        #   @return [::String]
        #     The region that the trigger will be in. The trigger will only receive
        #     events originating in this region. It can be the same
        #     region as the function, a different region or multi-region, or the global
        #     region. If not provided, defaults to the same region as the function.
        # @!attribute [rw] event_type
        #   @return [::String]
        #     Required. The type of event to observe. For example:
        #     `google.cloud.audit.log.v1.written` or
        #     `google.cloud.pubsub.topic.v1.messagePublished`.
        # @!attribute [rw] event_filters
        #   @return [::Array<::Google::Cloud::Functions::V2::EventFilter>]
        #     Criteria used to filter events.
        # @!attribute [rw] pubsub_topic
        #   @return [::String]
        #     Optional. The name of a Pub/Sub topic in the same project that will be used
        #     as the transport topic for the event delivery. Format:
        #     `projects/{project}/topics/{topic}`.
        #
        #     This is only valid for events of type
        #     `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
        #     will not be deleted at function deletion.
        # @!attribute [rw] service_account_email
        #   @return [::String]
        #     Optional. The email of the trigger's service account. The service account
        #     must have permission to invoke Cloud Run services, the permission is
        #     `run.routes.invoke`.
        #     If empty, defaults to the Compute Engine default service account:
        #     `{project_number}-compute@developer.gserviceaccount.com`.
        # @!attribute [rw] retry_policy
        #   @return [::Google::Cloud::Functions::V2::EventTrigger::RetryPolicy]
        #     Optional. If unset, then defaults to ignoring failures (i.e. not retrying
        #     them).
        # @!attribute [rw] channel
        #   @return [::String]
        #     Optional. The name of the channel associated with the trigger in
        #     `projects/{project}/locations/{location}/channels/{channel}` format.
        #     You must provide a channel to receive events from Eventarc SaaS partners.
        # @!attribute [rw] service
        #   @return [::String]
        #     Optional. The hostname of the service that 1st Gen function should be
        #     observed.
        #
        #     If no string is provided, the default service implementing the API will
        #     be used. For example, `storage.googleapis.com` is the default for all
        #     event types in the `google.storage` namespace.
        #
        #     The field is only applicable to 1st Gen functions.
        class EventTrigger
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes the retry policy in case of function's execution failure.
          # Retried execution is charged as any other execution.
          module RetryPolicy
            # Not specified.
            RETRY_POLICY_UNSPECIFIED = 0

            # Do not retry.
            RETRY_POLICY_DO_NOT_RETRY = 1

            # Retry on any failure, retry up to 7 days with an exponential backoff
            # (capped at 10 seconds).
            RETRY_POLICY_RETRY = 2
          end
        end

        # Filters events based on exact matches on the CloudEvents attributes.
        # @!attribute [rw] attribute
        #   @return [::String]
        #     Required. The name of a CloudEvents attribute.
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. The value for the attribute.
        # @!attribute [rw] operator
        #   @return [::String]
        #     Optional. The operator used for matching the events with the value of the
        #     filter. If not specified, only events that have an exact key-value pair
        #     specified in the filter are matched. The only allowed value is
        #     `match-path-pattern`.
        class EventFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `GetFunction` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the function which details should be obtained.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Optional. The optional version of the 1st gen function whose details should
        #     be obtained. The version of a 1st gen function is an integer that starts
        #     from 1 and gets incremented on redeployments. GCF may keep historical
        #     configs for old versions of 1st gen function. This field can be specified
        #     to fetch the historical configs. This field is valid only for GCF 1st gen
        #     function.
        class GetFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListFunctions` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the function should be
        #     listed, specified in the format `projects/*/locations/*` If you want to
        #     list functions in all locations, use "-" in place of a location. When
        #     listing functions in all locations, if one or more location(s) are
        #     unreachable, the response will contain functions from all reachable
        #     locations along with the names of any unreachable locations.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of functions to return per call. The largest allowed
        #     page_size is 1,000, if the page_size is omitted or specified as greater
        #     than 1,000 then it will be replaced as 1,000. The size of the list
        #     response can be less than specified when used with filters.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last
        #     `ListFunctionsResponse`; indicates that
        #     this is a continuation of a prior `ListFunctions` call, and that the
        #     system should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter for Functions that match the filter expression,
        #     following the syntax outlined in https://google.aip.dev/160.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     The sorting order of the resources returned. Value should be a comma
        #     separated list of fields. The default sorting order is ascending.
        #     See https://google.aip.dev/132#ordering.
        class ListFunctionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListFunctions` method.
        # @!attribute [rw] functions
        #   @return [::Array<::Google::Cloud::Functions::V2::Function>]
        #     The functions that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached. The response does not include any
        #     functions from these locations.
        class ListFunctionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `CreateFunction` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location in which the function should be created,
        #     specified in the format `projects/*/locations/*`
        # @!attribute [rw] function
        #   @return [::Google::Cloud::Functions::V2::Function]
        #     Required. Function to be created.
        # @!attribute [rw] function_id
        #   @return [::String]
        #     The ID to use for the function, which will become the final component of
        #     the function's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        class CreateFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `UpdateFunction` method.
        # @!attribute [rw] function
        #   @return [::Google::Cloud::Functions::V2::Function]
        #     Required. New version of the function.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     If no field mask is provided, all fields will be updated.
        class UpdateFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteFunction` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the function which should be deleted.
        class DeleteFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of `GenerateSourceUploadUrl` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location in which the Google Cloud Storage signed
        #     URL should be generated, specified in the format `projects/*/locations/*`.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Resource name of a KMS crypto key (managed by the user) used to
        #     encrypt/decrypt function source code objects in intermediate Cloud Storage
        #     buckets. When you generate an upload url and upload your source code, it
        #     gets copied to an intermediate Cloud Storage bucket. The source code is
        #     then copied to a versioned directory in the sources bucket in the consumer
        #     project during the function deployment.
        #
        #     It must match the pattern
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        #
        #     The Google Cloud Functions service account
        #     (service-\\{project_number}@gcf-admin-robot.iam.gserviceaccount.com) must be
        #     granted the role 'Cloud KMS CryptoKey Encrypter/Decrypter
        #     (roles/cloudkms.cryptoKeyEncrypterDecrypter)' on the
        #     Key/KeyRing/Project/Organization (least access preferred).
        # @!attribute [rw] environment
        #   @return [::Google::Cloud::Functions::V2::Environment]
        #     The function environment the generated upload url will be used for.
        #     The upload url for 2nd Gen functions can also be used for 1st gen
        #     functions, but not vice versa. If not specified, 2nd generation-style
        #     upload URLs are generated.
        class GenerateUploadUrlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of `GenerateSourceUploadUrl` method.
        # @!attribute [rw] upload_url
        #   @return [::String]
        #     The generated Google Cloud Storage signed URL that should be used for a
        #     function source code upload. The uploaded file should be a zip archive
        #     which contains a function.
        # @!attribute [rw] storage_source
        #   @return [::Google::Cloud::Functions::V2::StorageSource]
        #     The location of the source code in the upload bucket.
        #
        #     Once the archive is uploaded using the `upload_url` use this field to
        #     set the `function.build_config.source.storage_source`
        #     during CreateFunction and UpdateFunction.
        #
        #     Generation defaults to 0, as Cloud Storage provides a new generation only
        #     upon uploading a new object or version of an object.
        class GenerateUploadUrlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of `GenerateDownloadUrl` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of function for which source code Google Cloud Storage
        #     signed URL should be generated.
        class GenerateDownloadUrlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of `GenerateDownloadUrl` method.
        # @!attribute [rw] download_url
        #   @return [::String]
        #     The generated Google Cloud Storage signed URL that should be used for
        #     function source code download.
        class GenerateDownloadUrlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListRuntimes` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the runtimes should be
        #     listed, specified in the format `projects/*/locations/*`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter for Runtimes that match the filter expression,
        #     following the syntax outlined in https://google.aip.dev/160.
        class ListRuntimesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListRuntimes` method.
        # @!attribute [rw] runtimes
        #   @return [::Array<::Google::Cloud::Functions::V2::ListRuntimesResponse::Runtime>]
        #     The runtimes that match the request.
        class ListRuntimesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes a runtime and any special information (e.g., deprecation status)
          # related to it.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the runtime, e.g., 'go113', 'nodejs12', etc.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
          # @!attribute [rw] stage
          #   @return [::Google::Cloud::Functions::V2::ListRuntimesResponse::RuntimeStage]
          #     The stage of life this runtime is in, e.g., BETA, GA, etc.
          # @!attribute [rw] warnings
          #   @return [::Array<::String>]
          #     Warning messages, e.g., a deprecation warning.
          # @!attribute [rw] environment
          #   @return [::Google::Cloud::Functions::V2::Environment]
          #     The environment for the runtime.
          # @!attribute [rw] deprecation_date
          #   @return [::Google::Type::Date]
          #     Deprecation date for the runtime.
          # @!attribute [rw] decommission_date
          #   @return [::Google::Type::Date]
          #     Decommission date for the runtime.
          class Runtime
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The various stages that a runtime can be in.
          module RuntimeStage
            # Not specified.
            RUNTIME_STAGE_UNSPECIFIED = 0

            # The runtime is in development.
            DEVELOPMENT = 1

            # The runtime is in the Alpha stage.
            ALPHA = 2

            # The runtime is in the Beta stage.
            BETA = 3

            # The runtime is generally available.
            GA = 4

            # The runtime is deprecated.
            DEPRECATED = 5

            # The runtime is no longer supported.
            DECOMMISSIONED = 6
          end
        end

        # Security patches are applied automatically to the runtime without requiring
        # the function to be redeployed.
        class AutomaticUpdatePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Security patches are only applied when a function is redeployed.
        # @!attribute [r] runtime_version
        #   @return [::String]
        #     Output only. contains the runtime version which was used during latest
        #     function deployment.
        class OnDeployUpdatePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation finished running.
        # @!attribute [rw] target
        #   @return [::String]
        #     Server-defined resource path for the target of the operation.
        # @!attribute [rw] verb
        #   @return [::String]
        #     Name of the verb executed by the operation.
        # @!attribute [rw] status_detail
        #   @return [::String]
        #     Human-readable status of the operation, if any.
        # @!attribute [rw] cancel_requested
        #   @return [::Boolean]
        #     Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [rw] api_version
        #   @return [::String]
        #     API version used to start the operation.
        # @!attribute [rw] request_resource
        #   @return [::Google::Protobuf::Any]
        #     The original request that started the operation.
        # @!attribute [rw] stages
        #   @return [::Array<::Google::Cloud::Functions::V2::Stage>]
        #     Mechanism for reporting in-progress stages
        # @!attribute [rw] source_token
        #   @return [::String]
        #     An identifier for Firebase function sources. Disclaimer: This field is only
        #     supported for Firebase function deployments.
        # @!attribute [rw] build_name
        #   @return [::String]
        #     The build name of the function for create and update operations.
        # @!attribute [rw] operation_type
        #   @return [::Google::Cloud::Functions::V2::OperationType]
        #     The operation type.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Extra GCF specific location information.
        # @!attribute [rw] environments
        #   @return [::Array<::Google::Cloud::Functions::V2::Environment>]
        #     The Cloud Function environments this location supports.
        class LocationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Each Stage of the deployment process
        # @!attribute [rw] name
        #   @return [::Google::Cloud::Functions::V2::Stage::Name]
        #     Name of the Stage. This will be unique for each Stage.
        # @!attribute [rw] message
        #   @return [::String]
        #     Message describing the Stage
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Functions::V2::Stage::State]
        #     Current state of the Stage
        # @!attribute [rw] resource
        #   @return [::String]
        #     Resource of the Stage
        # @!attribute [rw] resource_uri
        #   @return [::String]
        #     Link to the current Stage resource
        # @!attribute [rw] state_messages
        #   @return [::Array<::Google::Cloud::Functions::V2::StateMessage>]
        #     State messages from the current Stage.
        class Stage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible names for a Stage
          module Name
            # Not specified. Invalid name.
            NAME_UNSPECIFIED = 0

            # Artifact Registry Stage
            ARTIFACT_REGISTRY = 1

            # Build Stage
            BUILD = 2

            # Service Stage
            SERVICE = 3

            # Trigger Stage
            TRIGGER = 4

            # Service Rollback Stage
            SERVICE_ROLLBACK = 5

            # Trigger Rollback Stage
            TRIGGER_ROLLBACK = 6
          end

          # Possible states for a Stage
          module State
            # Not specified. Invalid state.
            STATE_UNSPECIFIED = 0

            # Stage has not started.
            NOT_STARTED = 1

            # Stage is in progress.
            IN_PROGRESS = 2

            # Stage has completed.
            COMPLETE = 3
          end
        end

        # The type of the long running operation.
        module OperationType
          # Unspecified
          OPERATIONTYPE_UNSPECIFIED = 0

          # CreateFunction
          CREATE_FUNCTION = 1

          # UpdateFunction
          UPDATE_FUNCTION = 2

          # DeleteFunction
          DELETE_FUNCTION = 3
        end

        # The environment the function is hosted on.
        module Environment
          # Unspecified
          ENVIRONMENT_UNSPECIFIED = 0

          # Gen 1
          GEN_1 = 1

          # Gen 2
          GEN_2 = 2
        end
      end
    end
  end
end
