# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/functions/v2/functions.proto for package 'google.cloud.functions.v2'
# Original file comments:
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/functions/v2/functions_pb'

module Google
  module Cloud
    module Functions
      module V2
        module FunctionService
          # Google Cloud Functions is used to deploy functions that are executed by
          # Google in response to various events. Data connected with that event is
          # passed to a function as the input data.
          #
          # A **function** is a resource which describes a function that should be
          # executed and how it is triggered.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.functions.v2.FunctionService'

            # Returns a function with the given name from the requested project.
            rpc :GetFunction, ::Google::Cloud::Functions::V2::GetFunctionRequest, ::Google::Cloud::Functions::V2::Function
            # Returns a list of functions that belong to the requested project.
            rpc :ListFunctions, ::Google::Cloud::Functions::V2::ListFunctionsRequest, ::Google::Cloud::Functions::V2::ListFunctionsResponse
            # Creates a new function. If a function with the given name already exists in
            # the specified project, the long running operation will return
            # `ALREADY_EXISTS` error.
            rpc :CreateFunction, ::Google::Cloud::Functions::V2::CreateFunctionRequest, ::Google::Longrunning::Operation
            # Updates existing function.
            rpc :UpdateFunction, ::Google::Cloud::Functions::V2::UpdateFunctionRequest, ::Google::Longrunning::Operation
            # Deletes a function with the given name from the specified project. If the
            # given function is used by some trigger, the trigger will be updated to
            # remove this function.
            rpc :DeleteFunction, ::Google::Cloud::Functions::V2::DeleteFunctionRequest, ::Google::Longrunning::Operation
            # Returns a signed URL for uploading a function source code.
            # For more information about the signed URL usage see:
            # https://cloud.google.com/storage/docs/access-control/signed-urls.
            # Once the function source code upload is complete, the used signed
            # URL should be provided in CreateFunction or UpdateFunction request
            # as a reference to the function source code.
            #
            # When uploading source code to the generated signed URL, please follow
            # these restrictions:
            #
            # * Source file type should be a zip file.
            # * No credentials should be attached - the signed URLs provide access to the
            #   target bucket using internal service identity; if credentials were
            #   attached, the identity from the credentials would be used, but that
            #   identity does not have permissions to upload files to the URL.
            #
            # When making a HTTP PUT request, specify this header:
            #
            # * `content-type: application/zip`
            #
            # Do not specify this header:
            #
            # * `Authorization: Bearer YOUR_TOKEN`
            rpc :GenerateUploadUrl, ::Google::Cloud::Functions::V2::GenerateUploadUrlRequest, ::Google::Cloud::Functions::V2::GenerateUploadUrlResponse
            # Returns a signed URL for downloading deployed function source code.
            # The URL is only valid for a limited period and should be used within
            # 30 minutes of generation.
            # For more information about the signed URL usage see:
            # https://cloud.google.com/storage/docs/access-control/signed-urls
            rpc :GenerateDownloadUrl, ::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest, ::Google::Cloud::Functions::V2::GenerateDownloadUrlResponse
            # Returns a list of runtimes that are supported for the requested project.
            rpc :ListRuntimes, ::Google::Cloud::Functions::V2::ListRuntimesRequest, ::Google::Cloud::Functions::V2::ListRuntimesResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
