# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/functions/v2/version"
require "google/cloud/functions/v2/bindings_override"

require "google/cloud/functions/v2/function_service/credentials"
require "google/cloud/functions/v2/function_service/paths"
require "google/cloud/functions/v2/function_service/rest/operations"
require "google/cloud/functions/v2/function_service/rest/client"

module Google
  module Cloud
    module Functions
      module V2
        ##
        # Google Cloud Functions is used to deploy functions that are executed by
        # Google in response to various events. Data connected with that event is
        # passed to a function as the input data.
        #
        # A **function** is a resource which describes a function that should be
        # executed and how it is triggered.
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/functions/v2/function_service/rest"
        #     client = ::Google::Cloud::Functions::V2::FunctionService::Rest::Client.new
        #
        module FunctionService
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/functions/v2/function_service/rest/helpers" if ::File.file? helper_path
