# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/functions/v2/functions_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Functions
      module V2
        module FunctionService
          ##
          # Client for the FunctionService service.
          #
          # Google Cloud Functions is used to deploy functions that are executed by
          # Google in response to various events. Data connected with that event is
          # passed to a function as the input data.
          #
          # A **function** is a resource which describes a function that should be
          # executed and how it is triggered.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "cloudfunctions.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :function_service_stub

            ##
            # Configure the FunctionService Client class.
            #
            # See {::Google::Cloud::Functions::V2::FunctionService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all FunctionService clients
            #   ::Google::Cloud::Functions::V2::FunctionService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Functions", "V2"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the FunctionService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Functions::V2::FunctionService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @function_service_stub.universe_domain
            end

            ##
            # Create a new FunctionService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the FunctionService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/functions/v2/functions_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @function_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Functions::V2::FunctionService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @function_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @function_service_stub.endpoint
                config.universe_domain = @function_service_stub.universe_domain
                config.logger = @function_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @function_service_stub.endpoint
                config.universe_domain = @function_service_stub.universe_domain
                config.logger = @function_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Functions::V2::FunctionService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @function_service_stub.logger
            end

            # Service calls

            ##
            # Returns a function with the given name from the requested project.
            #
            # @overload get_function(request, options = nil)
            #   Pass arguments to `get_function` via a request object, either of type
            #   {::Google::Cloud::Functions::V2::GetFunctionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Functions::V2::GetFunctionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_function(name: nil, revision: nil)
            #   Pass arguments to `get_function` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the function which details should be obtained.
            #   @param revision [::String]
            #     Optional. The optional version of the 1st gen function whose details should
            #     be obtained. The version of a 1st gen function is an integer that starts
            #     from 1 and gets incremented on redeployments. GCF may keep historical
            #     configs for old versions of 1st gen function. This field can be specified
            #     to fetch the historical configs. This field is valid only for GCF 1st gen
            #     function.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Functions::V2::Function]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Functions::V2::Function]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/functions/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Functions::V2::GetFunctionRequest.new
            #
            #   # Call the get_function method.
            #   result = client.get_function request
            #
            #   # The returned object is of type Google::Cloud::Functions::V2::Function.
            #   p result
            #
            def get_function request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Functions::V2::GetFunctionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_function.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Functions::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_function.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_function.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @function_service_stub.call_rpc :get_function, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of functions that belong to the requested project.
            #
            # @overload list_functions(request, options = nil)
            #   Pass arguments to `list_functions` via a request object, either of type
            #   {::Google::Cloud::Functions::V2::ListFunctionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Functions::V2::ListFunctionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_functions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_functions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the function should be
            #     listed, specified in the format `projects/*/locations/*` If you want to
            #     list functions in all locations, use "-" in place of a location. When
            #     listing functions in all locations, if one or more location(s) are
            #     unreachable, the response will contain functions from all reachable
            #     locations along with the names of any unreachable locations.
            #   @param page_size [::Integer]
            #     Maximum number of functions to return per call. The largest allowed
            #     page_size is 1,000, if the page_size is omitted or specified as greater
            #     than 1,000 then it will be replaced as 1,000. The size of the list
            #     response can be less than specified when used with filters.
            #   @param page_token [::String]
            #     The value returned by the last
            #     `ListFunctionsResponse`; indicates that
            #     this is a continuation of a prior `ListFunctions` call, and that the
            #     system should return the next page of data.
            #   @param filter [::String]
            #     The filter for Functions that match the filter expression,
            #     following the syntax outlined in https://google.aip.dev/160.
            #   @param order_by [::String]
            #     The sorting order of the resources returned. Value should be a comma
            #     separated list of fields. The default sorting order is ascending.
            #     See https://google.aip.dev/132#ordering.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Functions::V2::Function>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Functions::V2::Function>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/functions/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Functions::V2::ListFunctionsRequest.new
            #
            #   # Call the list_functions method.
            #   result = client.list_functions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Functions::V2::Function.
            #     p item
            #   end
            #
            def list_functions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Functions::V2::ListFunctionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_functions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Functions::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_functions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_functions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @function_service_stub.call_rpc :list_functions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @function_service_stub, :list_functions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new function. If a function with the given name already exists in
            # the specified project, the long running operation will return
            # `ALREADY_EXISTS` error.
            #
            # @overload create_function(request, options = nil)
            #   Pass arguments to `create_function` via a request object, either of type
            #   {::Google::Cloud::Functions::V2::CreateFunctionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Functions::V2::CreateFunctionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_function(parent: nil, function: nil, function_id: nil)
            #   Pass arguments to `create_function` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location in which the function should be created,
            #     specified in the format `projects/*/locations/*`
            #   @param function [::Google::Cloud::Functions::V2::Function, ::Hash]
            #     Required. Function to be created.
            #   @param function_id [::String]
            #     The ID to use for the function, which will become the final component of
            #     the function's resource name.
            #
            #     This value should be 4-63 characters, and valid characters
            #     are /[a-z][0-9]-/.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/functions/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Functions::V2::CreateFunctionRequest.new
            #
            #   # Call the create_function method.
            #   result = client.create_function request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_function request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Functions::V2::CreateFunctionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_function.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Functions::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_function.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_function.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @function_service_stub.call_rpc :create_function, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates existing function.
            #
            # @overload update_function(request, options = nil)
            #   Pass arguments to `update_function` via a request object, either of type
            #   {::Google::Cloud::Functions::V2::UpdateFunctionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Functions::V2::UpdateFunctionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_function(function: nil, update_mask: nil)
            #   Pass arguments to `update_function` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param function [::Google::Cloud::Functions::V2::Function, ::Hash]
            #     Required. New version of the function.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     If no field mask is provided, all fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/functions/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Functions::V2::UpdateFunctionRequest.new
            #
            #   # Call the update_function method.
            #   result = client.update_function request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_function request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Functions::V2::UpdateFunctionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_function.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Functions::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.function&.name
                header_params["function.name"] = request.function.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_function.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_function.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @function_service_stub.call_rpc :update_function, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a function with the given name from the specified project. If the
            # given function is used by some trigger, the trigger will be updated to
            # remove this function.
            #
            # @overload delete_function(request, options = nil)
            #   Pass arguments to `delete_function` via a request object, either of type
            #   {::Google::Cloud::Functions::V2::DeleteFunctionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Functions::V2::DeleteFunctionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_function(name: nil)
            #   Pass arguments to `delete_function` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the function which should be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/functions/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Functions::V2::DeleteFunctionRequest.new
            #
            #   # Call the delete_function method.
            #   result = client.delete_function request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_function request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Functions::V2::DeleteFunctionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_function.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Functions::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_function.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_function.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @function_service_stub.call_rpc :delete_function, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a signed URL for uploading a function source code.
            # For more information about the signed URL usage see:
            # https://cloud.google.com/storage/docs/access-control/signed-urls.
            # Once the function source code upload is complete, the used signed
            # URL should be provided in CreateFunction or UpdateFunction request
            # as a reference to the function source code.
            #
            # When uploading source code to the generated signed URL, please follow
            # these restrictions:
            #
            # * Source file type should be a zip file.
            # * No credentials should be attached - the signed URLs provide access to the
            #   target bucket using internal service identity; if credentials were
            #   attached, the identity from the credentials would be used, but that
            #   identity does not have permissions to upload files to the URL.
            #
            # When making a HTTP PUT request, specify this header:
            #
            # * `content-type: application/zip`
            #
            # Do not specify this header:
            #
            # * `Authorization: Bearer YOUR_TOKEN`
            #
            # @overload generate_upload_url(request, options = nil)
            #   Pass arguments to `generate_upload_url` via a request object, either of type
            #   {::Google::Cloud::Functions::V2::GenerateUploadUrlRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Functions::V2::GenerateUploadUrlRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_upload_url(parent: nil, kms_key_name: nil, environment: nil)
            #   Pass arguments to `generate_upload_url` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location in which the Google Cloud Storage signed
            #     URL should be generated, specified in the format `projects/*/locations/*`.
            #   @param kms_key_name [::String]
            #     Resource name of a KMS crypto key (managed by the user) used to
            #     encrypt/decrypt function source code objects in intermediate Cloud Storage
            #     buckets. When you generate an upload url and upload your source code, it
            #     gets copied to an intermediate Cloud Storage bucket. The source code is
            #     then copied to a versioned directory in the sources bucket in the consumer
            #     project during the function deployment.
            #
            #     It must match the pattern
            #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
            #
            #     The Google Cloud Functions service account
            #     (service-\\{project_number}@gcf-admin-robot.iam.gserviceaccount.com) must be
            #     granted the role 'Cloud KMS CryptoKey Encrypter/Decrypter
            #     (roles/cloudkms.cryptoKeyEncrypterDecrypter)' on the
            #     Key/KeyRing/Project/Organization (least access preferred).
            #   @param environment [::Google::Cloud::Functions::V2::Environment]
            #     The function environment the generated upload url will be used for.
            #     The upload url for 2nd Gen functions can also be used for 1st gen
            #     functions, but not vice versa. If not specified, 2nd generation-style
            #     upload URLs are generated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Functions::V2::GenerateUploadUrlResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Functions::V2::GenerateUploadUrlResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/functions/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Functions::V2::GenerateUploadUrlRequest.new
            #
            #   # Call the generate_upload_url method.
            #   result = client.generate_upload_url request
            #
            #   # The returned object is of type Google::Cloud::Functions::V2::GenerateUploadUrlResponse.
            #   p result
            #
            def generate_upload_url request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Functions::V2::GenerateUploadUrlRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_upload_url.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Functions::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_upload_url.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_upload_url.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @function_service_stub.call_rpc :generate_upload_url, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a signed URL for downloading deployed function source code.
            # The URL is only valid for a limited period and should be used within
            # 30 minutes of generation.
            # For more information about the signed URL usage see:
            # https://cloud.google.com/storage/docs/access-control/signed-urls
            #
            # @overload generate_download_url(request, options = nil)
            #   Pass arguments to `generate_download_url` via a request object, either of type
            #   {::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_download_url(name: nil)
            #   Pass arguments to `generate_download_url` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of function for which source code Google Cloud Storage
            #     signed URL should be generated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Functions::V2::GenerateDownloadUrlResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Functions::V2::GenerateDownloadUrlResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/functions/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Functions::V2::GenerateDownloadUrlRequest.new
            #
            #   # Call the generate_download_url method.
            #   result = client.generate_download_url request
            #
            #   # The returned object is of type Google::Cloud::Functions::V2::GenerateDownloadUrlResponse.
            #   p result
            #
            def generate_download_url request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Functions::V2::GenerateDownloadUrlRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_download_url.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Functions::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_download_url.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_download_url.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @function_service_stub.call_rpc :generate_download_url, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of runtimes that are supported for the requested project.
            #
            # @overload list_runtimes(request, options = nil)
            #   Pass arguments to `list_runtimes` via a request object, either of type
            #   {::Google::Cloud::Functions::V2::ListRuntimesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Functions::V2::ListRuntimesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_runtimes(parent: nil, filter: nil)
            #   Pass arguments to `list_runtimes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the runtimes should be
            #     listed, specified in the format `projects/*/locations/*`
            #   @param filter [::String]
            #     The filter for Runtimes that match the filter expression,
            #     following the syntax outlined in https://google.aip.dev/160.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Functions::V2::ListRuntimesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Functions::V2::ListRuntimesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/functions/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Functions::V2::FunctionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Functions::V2::ListRuntimesRequest.new
            #
            #   # Call the list_runtimes method.
            #   result = client.list_runtimes request
            #
            #   # The returned object is of type Google::Cloud::Functions::V2::ListRuntimesResponse.
            #   p result
            #
            def list_runtimes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Functions::V2::ListRuntimesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_runtimes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Functions::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_runtimes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_runtimes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @function_service_stub.call_rpc :list_runtimes, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the FunctionService API.
            #
            # This class represents the configuration for FunctionService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Functions::V2::FunctionService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_function to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Functions::V2::FunctionService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_function.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_function.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Functions::V2::FunctionService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "cloudfunctions.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the FunctionService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_function`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_function
                ##
                # RPC-specific configuration for `list_functions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_functions
                ##
                # RPC-specific configuration for `create_function`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_function
                ##
                # RPC-specific configuration for `update_function`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_function
                ##
                # RPC-specific configuration for `delete_function`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_function
                ##
                # RPC-specific configuration for `generate_upload_url`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_upload_url
                ##
                # RPC-specific configuration for `generate_download_url`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_download_url
                ##
                # RPC-specific configuration for `list_runtimes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_runtimes

                # @private
                def initialize parent_rpcs = nil
                  get_function_config = parent_rpcs.get_function if parent_rpcs.respond_to? :get_function
                  @get_function = ::Gapic::Config::Method.new get_function_config
                  list_functions_config = parent_rpcs.list_functions if parent_rpcs.respond_to? :list_functions
                  @list_functions = ::Gapic::Config::Method.new list_functions_config
                  create_function_config = parent_rpcs.create_function if parent_rpcs.respond_to? :create_function
                  @create_function = ::Gapic::Config::Method.new create_function_config
                  update_function_config = parent_rpcs.update_function if parent_rpcs.respond_to? :update_function
                  @update_function = ::Gapic::Config::Method.new update_function_config
                  delete_function_config = parent_rpcs.delete_function if parent_rpcs.respond_to? :delete_function
                  @delete_function = ::Gapic::Config::Method.new delete_function_config
                  generate_upload_url_config = parent_rpcs.generate_upload_url if parent_rpcs.respond_to? :generate_upload_url
                  @generate_upload_url = ::Gapic::Config::Method.new generate_upload_url_config
                  generate_download_url_config = parent_rpcs.generate_download_url if parent_rpcs.respond_to? :generate_download_url
                  @generate_download_url = ::Gapic::Config::Method.new generate_download_url_config
                  list_runtimes_config = parent_rpcs.list_runtimes if parent_rpcs.respond_to? :list_runtimes
                  @list_runtimes = ::Gapic::Config::Method.new list_runtimes_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
