# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Functions
      module V1
        # Metadata describing an {::Google::Longrunning::Operation Operation}
        # @!attribute [rw] target
        #   @return [::String]
        #     Target of the operation - for example
        #     `projects/project-1/locations/region-1/functions/function-1`
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Functions::V1::OperationType]
        #     Type of operation.
        # @!attribute [rw] request
        #   @return [::Google::Protobuf::Any]
        #     The original request that started the operation.
        # @!attribute [rw] version_id
        #   @return [::Integer]
        #     Version id of the function created or updated by an API call.
        #     This field is only populated for Create and Update operations.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update timestamp of the operation.
        # @!attribute [rw] build_id
        #   @return [::String]
        #     The Cloud Build ID of the function created or updated by an API call.
        #     This field is only populated for Create and Update operations.
        # @!attribute [rw] source_token
        #   @return [::String]
        #     An identifier for Firebase function sources. Disclaimer: This field is only
        #     supported for Firebase function deployments.
        # @!attribute [rw] build_name
        #   @return [::String]
        #     The Cloud Build Name of the function deployment.
        #     This field is only populated for Create and Update operations.
        #     `projects/<project-number>/locations/<region>/builds/<build-id>`.
        class OperationMetadataV1
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A type of an operation.
        module OperationType
          # Unknown operation type.
          OPERATION_UNSPECIFIED = 0

          # Triggered by CreateFunction call
          CREATE_FUNCTION = 1

          # Triggered by UpdateFunction call
          UPDATE_FUNCTION = 2

          # Triggered by DeleteFunction call.
          DELETE_FUNCTION = 3
        end
      end
    end
  end
end
