# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Functions
      module V1
        # Describes a Cloud Function that contains user computation executed in
        # response to an event. It encapsulate function and triggers configurations.
        # @!attribute [rw] name
        #   @return [::String]
        #     A user-defined name of the function. Function names must be unique
        #     globally and match pattern `projects/*/locations/*/functions/*`
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description of a function.
        # @!attribute [rw] source_archive_url
        #   @return [::String]
        #     The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
        #     archive which contains the function.
        #
        #     Note: The following fields are mutually exclusive: `source_archive_url`, `source_repository`, `source_upload_url`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_repository
        #   @return [::Google::Cloud::Functions::V1::SourceRepository]
        #     **Beta Feature**
        #
        #     The source repository where a function is hosted.
        #
        #     Note: The following fields are mutually exclusive: `source_repository`, `source_archive_url`, `source_upload_url`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_upload_url
        #   @return [::String]
        #     The Google Cloud Storage signed URL used for source uploading, generated
        #     by calling [google.cloud.functions.v1.GenerateUploadUrl].
        #
        #     The signature is validated on write methods (Create, Update)
        #     The signature is stripped from the Function object on read methods (Get,
        #     List)
        #
        #     Note: The following fields are mutually exclusive: `source_upload_url`, `source_archive_url`, `source_repository`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] https_trigger
        #   @return [::Google::Cloud::Functions::V1::HttpsTrigger]
        #     An HTTPS endpoint type of source that can be triggered via URL.
        #
        #     Note: The following fields are mutually exclusive: `https_trigger`, `event_trigger`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] event_trigger
        #   @return [::Google::Cloud::Functions::V1::EventTrigger]
        #     A source that fires events in response to a condition in another service.
        #
        #     Note: The following fields are mutually exclusive: `event_trigger`, `https_trigger`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Functions::V1::CloudFunctionStatus]
        #     Output only. Status of the function deployment.
        # @!attribute [rw] entry_point
        #   @return [::String]
        #     The name of the function (as defined in source code) that will be
        #     executed. Defaults to the resource name suffix (ID of the function), if not
        #     specified.
        # @!attribute [rw] runtime
        #   @return [::String]
        #     The runtime in which to run the function. Required when deploying a new
        #     function, optional when updating an existing function. For a complete
        #     list of possible choices, see the
        #     [`gcloud` command
        #     reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     The function execution timeout. Execution is considered failed and
        #     can be terminated if the function is not completed at the end of the
        #     timeout period. Defaults to 60 seconds.
        # @!attribute [rw] available_memory_mb
        #   @return [::Integer]
        #     The amount of memory in MB available for a function.
        #     Defaults to 256MB.
        # @!attribute [rw] service_account_email
        #   @return [::String]
        #     The email of the function's service account. If empty, defaults to
        #     `{project_id}@appspot.gserviceaccount.com`.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of a Cloud Function.
        # @!attribute [r] version_id
        #   @return [::Integer]
        #     Output only. The version identifier of the Cloud Function. Each deployment
        #     attempt results in a new version of a function being created.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this Cloud Function.
        # @!attribute [rw] environment_variables
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Environment variables that shall be available during function execution.
        # @!attribute [rw] build_environment_variables
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Build environment variables that shall be available during build time.
        # @!attribute [rw] network
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated: use vpc_connector
        # @!attribute [rw] max_instances
        #   @return [::Integer]
        #     The limit on the maximum number of function instances that may coexist at a
        #     given time.
        #
        #     In some cases, such as rapid traffic surges, Cloud Functions may, for a
        #     short period of time, create more instances than the specified max
        #     instances limit. If your function cannot tolerate this temporary behavior,
        #     you may want to factor in a safety margin and set a lower max instances
        #     value than your function can tolerate.
        #
        #     See the [Max
        #     Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
        #     more details.
        # @!attribute [rw] min_instances
        #   @return [::Integer]
        #     A lower bound for the number function instances that may coexist at a
        #     given time.
        # @!attribute [rw] vpc_connector
        #   @return [::String]
        #     The VPC Network Connector that this cloud function can connect to. It can
        #     be either the fully-qualified URI, or the short name of the network
        #     connector resource. The format of this field is
        #     `projects/*/locations/*/connectors/*`
        #
        #     This field is mutually exclusive with `network` field and will eventually
        #     replace it.
        #
        #     See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
        #     more information on connecting Cloud projects.
        # @!attribute [rw] vpc_connector_egress_settings
        #   @return [::Google::Cloud::Functions::V1::CloudFunction::VpcConnectorEgressSettings]
        #     The egress settings for the connector, controlling what traffic is diverted
        #     through it.
        # @!attribute [rw] ingress_settings
        #   @return [::Google::Cloud::Functions::V1::CloudFunction::IngressSettings]
        #     The ingress settings for the function, controlling what traffic can reach
        #     it.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Resource name of a KMS crypto key (managed by the user) used to
        #     encrypt/decrypt function resources.
        #
        #     It must match the pattern
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        #
        #     If specified, you must also provide an artifact registry repository using
        #     the `docker_repository` field that was created with the same KMS crypto
        #     key.
        #
        #     The following service accounts need to be granted the role 'Cloud KMS
        #     CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
        #     on the Key/KeyRing/Project/Organization (least access preferred).
        #
        #     1. Google Cloud Functions service account
        #        (service-\\{project_number}@gcf-admin-robot.iam.gserviceaccount.com) -
        #        Required to protect the function's image.
        #     2. Google Storage service account
        #        (service-\\{project_number}@gs-project-accounts.iam.gserviceaccount.com) -
        #        Required to protect the function's source code.
        #        If this service account does not exist, deploying a function without a
        #        KMS key or retrieving the service agent name provisions it. For more
        #        information, see
        #        https://cloud.google.com/storage/docs/projects#service-agents and
        #        https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
        #
        #     Google Cloud Functions delegates access to service agents to protect
        #     function resources in internal projects that are not accessible by the
        #     end user.
        # @!attribute [rw] build_worker_pool
        #   @return [::String]
        #     Name of the Cloud Build Custom Worker Pool that should be used to build the
        #     function. The format of this field is
        #     `projects/{project}/locations/{region}/workerPools/{workerPool}` where
        #     `{project}` and `{region}` are the project id and region respectively where
        #     the worker pool is defined and `{workerPool}` is the short name of the
        #     worker pool.
        #
        #     If the project id is not the same as the function, then the Cloud
        #     Functions Service Agent
        #     (`service-<project_number>@gcf-admin-robot.iam.gserviceaccount.com`) must
        #     be granted the role Cloud Build Custom Workers Builder
        #     (`roles/cloudbuild.customworkers.builder`) in the project.
        # @!attribute [r] build_id
        #   @return [::String]
        #     Output only. The Cloud Build ID of the latest successful deployment of the
        #     function.
        # @!attribute [r] build_name
        #   @return [::String]
        #     Output only. The Cloud Build Name of the function deployment.
        #     `projects/<project-number>/locations/<region>/builds/<build-id>`.
        # @!attribute [rw] secret_environment_variables
        #   @return [::Array<::Google::Cloud::Functions::V1::SecretEnvVar>]
        #     Secret environment variables configuration.
        # @!attribute [rw] secret_volumes
        #   @return [::Array<::Google::Cloud::Functions::V1::SecretVolume>]
        #     Secret volumes configuration.
        # @!attribute [rw] source_token
        #   @return [::String]
        #     Input only. An identifier for Firebase function sources. Disclaimer: This
        #     field is only supported for Firebase function deployments.
        # @!attribute [rw] docker_repository
        #   @return [::String]
        #     User-managed repository created in Artifact Registry to which the
        #     function's Docker image will be pushed after it is built by Cloud Build.
        #     May optionally be encrypted with a customer-managed encryption key (CMEK).
        #     If unspecified and `docker_registry` is not explicitly set to
        #     `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry
        #     repository named 'gcf-artifacts' in the region.
        #
        #     It must match the pattern
        #     `projects/{project}/locations/{location}/repositories/{repository}`.
        #
        #     Cross-project repositories are not supported.
        #     Cross-location repositories are not supported.
        #     Repository format must be 'DOCKER'.
        # @!attribute [rw] docker_registry
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Functions::V1::CloudFunction::DockerRegistry]
        #     Docker Registry to use for this deployment.
        #     As of March 2025, `CONTAINER_REGISTRY` option is no longer
        #     available in response to Container Registry's deprecation:
        #     https://cloud.google.com/artifact-registry/docs/transition/transition-from-gcr
        #     Please use Artifact Registry instead, which is the default choice.
        #
        #     If unspecified, it defaults to `ARTIFACT_REGISTRY`.
        #     If `docker_repository` field is specified, this field should either be left
        #     unspecified or set to `ARTIFACT_REGISTRY`.
        # @!attribute [rw] automatic_update_policy
        #   @return [::Google::Cloud::Functions::V1::CloudFunction::AutomaticUpdatePolicy]
        #     Note: The following fields are mutually exclusive: `automatic_update_policy`, `on_deploy_update_policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] on_deploy_update_policy
        #   @return [::Google::Cloud::Functions::V1::CloudFunction::OnDeployUpdatePolicy]
        #     Note: The following fields are mutually exclusive: `on_deploy_update_policy`, `automatic_update_policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] build_service_account
        #   @return [::String]
        #     A service account the user provides for use with Cloud Build. The format of
        #     this field is
        #     `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
        class CloudFunction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Security patches are applied automatically to the runtime without requiring
          # the function to be redeployed.
          class AutomaticUpdatePolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Security patches are only applied when a function is redeployed.
          # @!attribute [r] runtime_version
          #   @return [::String]
          #     Output only. Contains the runtime version which was used during latest
          #     function deployment.
          class OnDeployUpdatePolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class EnvironmentVariablesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class BuildEnvironmentVariablesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Available egress settings.
          #
          # This controls what traffic is diverted through the VPC Access Connector
          # resource. By default PRIVATE_RANGES_ONLY will be used.
          module VpcConnectorEgressSettings
            # Unspecified.
            VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0

            # Use the VPC Access Connector only for private IP space from RFC1918.
            PRIVATE_RANGES_ONLY = 1

            # Force the use of VPC Access Connector for all egress traffic from the
            # function.
            ALL_TRAFFIC = 2
          end

          # Available ingress settings.
          #
          # This controls what traffic can reach the function.
          #
          # If unspecified, ALLOW_ALL will be used.
          module IngressSettings
            # Unspecified.
            INGRESS_SETTINGS_UNSPECIFIED = 0

            # Allow HTTP traffic from public and private sources.
            ALLOW_ALL = 1

            # Allow HTTP traffic from only private VPC sources.
            ALLOW_INTERNAL_ONLY = 2

            # Allow HTTP traffic from private VPC sources and through GCLB.
            ALLOW_INTERNAL_AND_GCLB = 3
          end

          # Docker Registry to use for storing function Docker images.
          module DockerRegistry
            # Unspecified.
            DOCKER_REGISTRY_UNSPECIFIED = 0

            # Docker images will be stored in multi-regional Container Registry
            # repositories named `gcf`.
            CONTAINER_REGISTRY = 1

            # Docker images will be stored in regional Artifact Registry repositories.
            # By default, GCF will create and use repositories named `gcf-artifacts`
            # in every region in which a function is deployed. But the repository to
            # use can also be specified by the user using the `docker_repository`
            # field.
            ARTIFACT_REGISTRY = 2
          end
        end

        # Describes SourceRepository, used to represent parameters related to
        # source repository where a function is hosted.
        # @!attribute [rw] url
        #   @return [::String]
        #     The URL pointing to the hosted repository where the function is defined.
        #     There are supported Cloud Source Repository URLs in the following
        #     formats:
        #
        #     To refer to a specific commit:
        #     `https://source.developers.google.com/projects/*/repos/*/revisions/*/paths/*`
        #     To refer to a moveable alias (branch):
        #     `https://source.developers.google.com/projects/*/repos/*/moveable-aliases/*/paths/*`
        #     In particular, to refer to HEAD use `master` moveable alias.
        #     To refer to a specific fixed alias (tag):
        #     `https://source.developers.google.com/projects/*/repos/*/fixed-aliases/*/paths/*`
        #
        #     You may omit `paths/*` if you want to use the main directory. The function
        #     response may add an empty `/paths/` to the URL.
        # @!attribute [r] deployed_url
        #   @return [::String]
        #     Output only. The URL pointing to the hosted repository where the function
        #     were defined at the time of deployment. It always points to a specific
        #     commit in the format described above.
        class SourceRepository
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes HttpsTrigger, could be used to connect web hooks to function.
        # @!attribute [r] url
        #   @return [::String]
        #     Output only. The deployed url for the function.
        # @!attribute [rw] security_level
        #   @return [::Google::Cloud::Functions::V1::HttpsTrigger::SecurityLevel]
        #     The security level for the function.
        class HttpsTrigger
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Available security level settings.
          #
          # This controls the methods to enforce security (HTTPS) on a URL.
          #
          # If unspecified, SECURE_OPTIONAL will be used.
          module SecurityLevel
            # Unspecified.
            SECURITY_LEVEL_UNSPECIFIED = 0

            # Requests for a URL that match this handler that do not use HTTPS are
            # automatically redirected to the HTTPS URL with the same path. Query
            # parameters are reserved for the redirect.
            SECURE_ALWAYS = 1

            # Both HTTP and HTTPS requests with URLs that match the handler succeed
            # without redirects. The application can examine the request to determine
            # which protocol was used and respond accordingly.
            SECURE_OPTIONAL = 2
          end
        end

        # Describes EventTrigger, used to request events be sent from another
        # service.
        # @!attribute [rw] event_type
        #   @return [::String]
        #     Required. The type of event to observe. For example:
        #     `providers/cloud.storage/eventTypes/object.change` and
        #     `providers/cloud.pubsub/eventTypes/topic.publish`.
        #
        #     Event types match pattern `providers/*/eventTypes/*.*`.
        #     The pattern contains:
        #
        #     1. namespace: For example, `cloud.storage` and
        #        `google.firebase.analytics`.
        #     2. resource type: The type of resource on which event occurs. For
        #        example, the Google Cloud Storage API includes the type `object`.
        #     3. action: The action that generates the event. For example, action for
        #        a Google Cloud Storage Object is 'change'.
        #     These parts are lower case.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Required. The resource(s) from which to observe events, for example,
        #     `projects/_/buckets/myBucket`.
        #
        #     Not all syntactically correct values are accepted by all services. For
        #     example:
        #
        #     1. The authorization model must support it. Google Cloud Functions
        #        only allows EventTriggers to be deployed that observe resources in the
        #        same project as the `CloudFunction`.
        #     2. The resource type must match the pattern expected for an
        #        `event_type`. For example, an `EventTrigger` that has an
        #        `event_type` of "google.pubsub.topic.publish" should have a resource
        #        that matches Google Cloud Pub/Sub topics.
        #
        #     Additionally, some services may support short names when creating an
        #     `EventTrigger`. These will always be returned in the normalized "long"
        #     format.
        #
        #     See each *service's* documentation for supported formats.
        # @!attribute [rw] service
        #   @return [::String]
        #     The hostname of the service that should be observed.
        #
        #     If no string is provided, the default service implementing the API will
        #     be used. For example, `storage.googleapis.com` is the default for all
        #     event types in the `google.storage` namespace.
        # @!attribute [rw] failure_policy
        #   @return [::Google::Cloud::Functions::V1::FailurePolicy]
        #     Specifies policy for failed executions.
        class EventTrigger
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the policy in case of function's execution failure.
        # If empty, then defaults to ignoring failures (i.e. not retrying them).
        # @!attribute [rw] retry
        #   @return [::Google::Cloud::Functions::V1::FailurePolicy::Retry]
        #     If specified, then the function will be retried in case of a failure.
        class FailurePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes the retry policy in case of function's execution failure.
          # A function execution will be retried on any failure.
          # A failed execution will be retried up to 7 days with an exponential backoff
          # (capped at 10 seconds).
          # Retried execution is charged as any other execution.
          class Retry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration for a secret environment variable. It has the information
        # necessary to fetch the secret value from secret manager and expose it as an
        # environment variable.
        # @!attribute [rw] key
        #   @return [::String]
        #     Name of the environment variable.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project identifier (preferably project number but can also be the project
        #     ID) of the project that contains the secret. If not set, it will be
        #     populated with the function's project assuming that the secret exists in
        #     the same project as of the function.
        # @!attribute [rw] secret
        #   @return [::String]
        #     Name of the secret in secret manager (not the full resource name).
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of the secret (version number or the string 'latest'). It is
        #     recommended to use a numeric version for secret environment variables as
        #     any updates to the secret value is not reflected until new instances start.
        class SecretEnvVar
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for a secret volume. It has the information necessary to fetch
        # the secret value from secret manager and make it available as files mounted
        # at the requested paths within the application container. Secret value is not
        # a part of the configuration. Every filesystem read operation performs a
        # lookup in secret manager to retrieve the secret value.
        # @!attribute [rw] mount_path
        #   @return [::String]
        #     The path within the container to mount the secret volume. For example,
        #     setting the mount_path as `/etc/secrets` would mount the secret value files
        #     under the `/etc/secrets` directory. This directory will also be completely
        #     shadowed and unavailable to mount any other secrets.
        #
        #     Recommended mount paths: /etc/secrets
        #     Restricted mount paths: /cloudsql, /dev/log, /pod, /proc, /var/log
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project identifier (preferrably project number but can also be the project
        #     ID) of the project that contains the secret. If not set, it will be
        #     populated with the function's project assuming that the secret exists in
        #     the same project as of the function.
        # @!attribute [rw] secret
        #   @return [::String]
        #     Name of the secret in secret manager (not the full resource name).
        # @!attribute [rw] versions
        #   @return [::Array<::Google::Cloud::Functions::V1::SecretVolume::SecretVersion>]
        #     List of secret versions to mount for this secret. If empty, the `latest`
        #     version of the secret will be made available in a file named after the
        #     secret under the mount point.
        class SecretVolume
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for a single version.
          # @!attribute [rw] version
          #   @return [::String]
          #     Version of the secret (version number or the string 'latest'). It is
          #     preferable to use `latest` version with secret volumes as secret value
          #     changes are reflected immediately.
          # @!attribute [rw] path
          #   @return [::String]
          #     Relative path of the file under the mount path where the secret value for
          #     this version will be fetched and made available. For example, setting the
          #     mount_path as '/etc/secrets' and path as `/secret_foo` would mount the
          #     secret value file at `/etc/secrets/secret_foo`.
          class SecretVersion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for the `CreateFunction` method.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The project and location in which the function should be created,
        #     specified in the format `projects/*/locations/*`
        # @!attribute [rw] function
        #   @return [::Google::Cloud::Functions::V1::CloudFunction]
        #     Required. Function to be created.
        class CreateFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `UpdateFunction` method.
        # @!attribute [rw] function
        #   @return [::Google::Cloud::Functions::V1::CloudFunction]
        #     Required. New version of the function.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields in `CloudFunction` that have to be updated.
        class UpdateFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `GetFunction` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the function which details should be obtained.
        # @!attribute [rw] version_id
        #   @return [::Integer]
        #     Optional. The optional version of the function whose details should be
        #     obtained. The version of a 1st Gen function is an integer that starts from
        #     1 and gets incremented on redeployments. Each deployment creates a config
        #     version of the underlying function. GCF may keep historical configs for old
        #     versions. This field can be specified to fetch the historical configs.
        #     Leave it blank or set to 0 to get the latest version of the function.
        class GetFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListFunctions` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The project and location from which the function should be listed,
        #     specified in the format `projects/*/locations/*`
        #     If you want to list functions in all locations, use "-" in place of a
        #     location. When listing functions in all locations, if one or more
        #     location(s) are unreachable, the response will contain functions from all
        #     reachable locations along with the names of any unreachable locations.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of functions to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last
        #     `ListFunctionsResponse`; indicates that
        #     this is a continuation of a prior `ListFunctions` call, and that the
        #     system should return the next page of data.
        class ListFunctionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListFunctions` method.
        # @!attribute [rw] functions
        #   @return [::Array<::Google::Cloud::Functions::V1::CloudFunction>]
        #     The functions that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If not empty, indicates that there may be more functions that match
        #     the request; this value should be passed in a new
        #     {::Google::Cloud::Functions::V1::ListFunctionsRequest google.cloud.functions.v1.ListFunctionsRequest}
        #     to get more functions.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached. The response does not include any
        #     functions from these locations.
        class ListFunctionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteFunction` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the function which should be deleted.
        class DeleteFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `CallFunction` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the function to be called.
        # @!attribute [rw] data
        #   @return [::String]
        #     Required. Input to be passed to the function.
        class CallFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of `CallFunction` method.
        # @!attribute [rw] execution_id
        #   @return [::String]
        #     Execution id of function invocation.
        # @!attribute [rw] result
        #   @return [::String]
        #     Result populated for successful execution of synchronous function. Will
        #     not be populated if function does not return a result through context.
        # @!attribute [rw] error
        #   @return [::String]
        #     Either system or user-function generated error. Set if execution
        #     was not successful.
        class CallFunctionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of `GenerateSourceUploadUrl` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The project and location in which the Google Cloud Storage signed URL
        #     should be generated, specified in the format `projects/*/locations/*`.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Resource name of a KMS crypto key (managed by the user) used to
        #     encrypt/decrypt function source code objects in intermediate Cloud Storage
        #     buckets. When you generate an upload url and upload your source code, it
        #     gets copied to an intermediate Cloud Storage bucket. The source code is
        #     then copied to a versioned directory in the sources bucket in the consumer
        #     project during the function deployment.
        #
        #     It must match the pattern
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        #
        #     The Google Cloud Functions service account
        #     (service-\\{project_number}@gcf-admin-robot.iam.gserviceaccount.com) must be
        #     granted the role 'Cloud KMS CryptoKey Encrypter/Decrypter
        #     (roles/cloudkms.cryptoKeyEncrypterDecrypter)' on the
        #     Key/KeyRing/Project/Organization (least access preferred). GCF will
        #     delegate access to the Google Storage service account in the internal
        #     project.
        class GenerateUploadUrlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of `GenerateSourceUploadUrl` method.
        # @!attribute [rw] upload_url
        #   @return [::String]
        #     The generated Google Cloud Storage signed URL that should be used for a
        #     function source code upload. The uploaded file should be a zip archive
        #     which contains a function.
        class GenerateUploadUrlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of `GenerateDownloadUrl` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of function for which source code Google Cloud Storage signed
        #     URL should be generated.
        # @!attribute [rw] version_id
        #   @return [::Integer]
        #     The optional version of function. If not set, default, current version
        #     is used.
        class GenerateDownloadUrlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of `GenerateDownloadUrl` method.
        # @!attribute [rw] download_url
        #   @return [::String]
        #     The generated Google Cloud Storage signed URL that should be used for
        #     function source code download.
        class GenerateDownloadUrlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the current stage of a deployment.
        module CloudFunctionStatus
          # Not specified. Invalid state.
          CLOUD_FUNCTION_STATUS_UNSPECIFIED = 0

          # Function has been successfully deployed and is serving.
          ACTIVE = 1

          # Function deployment failed and the function isn’t serving.
          OFFLINE = 2

          # Function is being created or updated.
          DEPLOY_IN_PROGRESS = 3

          # Function is being deleted.
          DELETE_IN_PROGRESS = 4

          # Function deployment failed and the function serving state is undefined.
          # The function should be updated or deleted to move it out of this state.
          UNKNOWN = 5
        end
      end
    end
  end
end
