# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/functions/v1/functions.proto for package 'google.cloud.functions.v1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/functions/v1/functions_pb'

module Google
  module Cloud
    module Functions
      module V1
        module CloudFunctionsService
          # A service that application uses to manipulate triggers and functions.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.functions.v1.CloudFunctionsService'

            # Returns a list of functions that belong to the requested project.
            rpc :ListFunctions, ::Google::Cloud::Functions::V1::ListFunctionsRequest, ::Google::Cloud::Functions::V1::ListFunctionsResponse
            # Returns a function with the given name from the requested project.
            rpc :GetFunction, ::Google::Cloud::Functions::V1::GetFunctionRequest, ::Google::Cloud::Functions::V1::CloudFunction
            # Creates a new function. If a function with the given name already exists in
            # the specified project, the long running operation will return
            # `ALREADY_EXISTS` error.
            rpc :CreateFunction, ::Google::Cloud::Functions::V1::CreateFunctionRequest, ::Google::Longrunning::Operation
            # Updates existing function.
            rpc :UpdateFunction, ::Google::Cloud::Functions::V1::UpdateFunctionRequest, ::Google::Longrunning::Operation
            # Deletes a function with the given name from the specified project. If the
            # given function is used by some trigger, the trigger will be updated to
            # remove this function.
            rpc :DeleteFunction, ::Google::Cloud::Functions::V1::DeleteFunctionRequest, ::Google::Longrunning::Operation
            # Synchronously invokes a deployed Cloud Function. To be used for testing
            # purposes as very limited traffic is allowed. For more information on
            # the actual limits, refer to
            # [Rate Limits](https://cloud.google.com/functions/quotas#rate_limits).
            rpc :CallFunction, ::Google::Cloud::Functions::V1::CallFunctionRequest, ::Google::Cloud::Functions::V1::CallFunctionResponse
            # Returns a signed URL for uploading a function source code.
            # For more information about the signed URL usage see:
            # https://cloud.google.com/storage/docs/access-control/signed-urls.
            # Once the function source code upload is complete, the used signed
            # URL should be provided in CreateFunction or UpdateFunction request
            # as a reference to the function source code.
            #
            # When uploading source code to the generated signed URL, please follow
            # these restrictions:
            #
            # * Source file type should be a zip file.
            # * Source file size should not exceed 100MB limit.
            # * No credentials should be attached - the signed URLs provide access to the
            #   target bucket using internal service identity; if credentials were
            #   attached, the identity from the credentials would be used, but that
            #   identity does not have permissions to upload files to the URL.
            #
            # When making a HTTP PUT request, these two headers need to be specified:
            #
            # * `content-type: application/zip`
            # * `x-goog-content-length-range: 0,104857600`
            #
            # And this header SHOULD NOT be specified:
            #
            # * `Authorization: Bearer YOUR_TOKEN`
            rpc :GenerateUploadUrl, ::Google::Cloud::Functions::V1::GenerateUploadUrlRequest, ::Google::Cloud::Functions::V1::GenerateUploadUrlResponse
            # Returns a signed URL for downloading deployed function source code.
            # The URL is only valid for a limited period and should be used within
            # minutes after generation.
            # For more information about the signed URL usage see:
            # https://cloud.google.com/storage/docs/access-control/signed-urls
            rpc :GenerateDownloadUrl, ::Google::Cloud::Functions::V1::GenerateDownloadUrlRequest, ::Google::Cloud::Functions::V1::GenerateDownloadUrlResponse
            # Sets the IAM access control policy on the specified function.
            # Replaces any existing policy.
            rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Gets the IAM access control policy for a function.
            # Returns an empty policy if the function exists and does not have a policy
            # set.
            rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Tests the specified permissions against the IAM access control policy
            # for a function.
            # If the function does not exist, this will return an empty set of
            # permissions, not a NOT_FOUND error.
            rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
