<img src="https://avatars2.githubusercontent.com/u/2810941?v=3&s=96" alt="Google Cloud Platform logo" title="Google Cloud Platform" align="right" height="96" width="96"/>

# Google Cloud Firestore Ruby Samples

The [Google Cloud Firestore API](https://cloud.google.com/firestore/) enables easy integration of the Google Cloud
Firestore database into developer applications.

## Setup

1. Open the [Firebase Console](https://console.firebase.google.com/) and create a new project. (You can't use both Cloud
   Firestore and Cloud Datastore in the same project, which might affect apps using App Engine. Try using Cloud
   Firestore with a different project if this is the case).

1. In the Database section, click the 'Get Started' button for Cloud Firestore Beta.

1. When prompted, select 'Start in test mode' and click 'Enable'.

1. Enable APIs for your project. [Click
   here](https://console.cloud.google.com/flows/enableapi?apiid=firestore.googleapis.com&showconfirmation=true) to visit
   Cloud Platform Console and enable the Google Cloud Firestore API.

1. On command line, set the `FIRESTORE_PROJECT` environment variable equal to your Google Cloud / Firebase project ID.

    `export FIRESTORE_PROJECT=your-firestore-project-id`

### Authentication

Create a [Service Account key file](https://cloud.google.com/docs/authentication#service_accounts). This file can be
used to authenticate to Google Cloud Platform services from any environment. To use the file, set the
`FIRESTORE_CREDENTIALS` environment variable to the path to the key file, for example:

    `export FIRESTORE_CREDENTIALS=/path/to/service_account.json`

### Install Dependencies

1. Install the [Bundler](http://bundler.io/) gem.

1. Install dependencies using:

    `bundle install`

## Run samples

### Run Quickstart

    Usage: bundle exec ruby quickstart.rb [command]

    Commands:
      initialize  Initialize a Cloud Firestore client.
      add_data_1  Add a sample document to a collection.
      add_data_2  Add a sample document.
      get_all     Retrieve all documents from a collection.

### Run Add Data

    Usage: bundle exec ruby add_data.rb [command]

    Commands:
      set_document                Set document data.
      update_create_if_missing    Update a document - create it if it's missing.
      set_document_data_types     Set document data with multiple data types.
      set_requires_id             Set document data with a given document id.
      add_doc_data_with_auto_id   Add document data with autogenerated id.
      add_doc_data_after_auto_id  Generate id, then add document data.
      update_doc                  Update a document.
      update_doc_array            Update an array field in a document.
      update_nested_fields        Update fields in nested data.
      update_server_timestamp     Update field with server timestamp.
      update_document_increment   Update a document number field using Increment.

### Run Query Data

    Usage: bundle exec ruby query_data.rb [command]

    Commands:
      query_create_examples          Create an example collection of documents.
      create_query_state             Create a query by state.
      create_query_capital           Create a query by capital.
      simple_queries                 Create simple queries with a single where clause.
      chained_query                  Create a query with chained clauses.
      composite_index_chained_query  Create a composite index chained query.
      range_query                    Create a query with range clauses.
      invalid_range_query            An example of an invalid range query.

### Run Data Model

    Usage: bundle exec ruby data_model.rb [command]

    Commands:
      document_ref       Create a document reference.
      collection_ref     Create a collection reference.
      document_path_ref  Create a document path reference.
      subcollection_ref  Create a subcollection reference.

### Run Delete Data

    Usage: bundle exec ruby delete_data.rb [command]

    Commands:
      delete_doc         Delete a document.
      delete_field       Delete a field.
      delete_collection  Delete an entire collection.

### Run Get Data

    Usage: bundle exec ruby get_data.rb [command]

    Commands:
      retrieve_create_examples  Create an example collection of documents.
      get_document              Get a document.
      get_multiple_docs         Get multiple documents from a collection.
      get_all_docs              Get all documents from a collection.
      add_subcollection         Add a document to a subcollection.
      list_subcollections       List subcollections of a document.

### Run Order Limit Data

    Usage: bundle exec ruby order_limit_data.rb [command]

    Commands:
      order_by_name_limit_query            Create an order by name with limit query.
      order_by_name_desc_limit_query       Create an order by name descending with limit query.
      order_by_state_and_population_query  Create an order by state and descending population query.
      where_order_by_limit_query           Combine where with order by and limit in a query.
      range_order_by_query                 Create a range with order by query.
      invalid_range_order_by_query         An example of an invalid range with order by query.

### Run Paginate Data

    Usage: bundle exec ruby paginate_data.rb [command]

    Commands:
      start_at_field_query_cursor  Define field start point for a query.
      end_at_field_query_cursor    Define field end point for a query.
      paginated_query_cursor       Paginate using query cursors.
      multiple_cursor_conditions   Set multiple cursor conditions.

### Run Transactions And Batched Writes

    Usage: bundle exec ruby transactions_and_batched_writes.rb [command]

    Commands:
      run_simple_transaction   Run a simple transaction.
      return_info_transaction  Run a transaction and get information returned.
      batch_write              Perform a batch write.

## Run tests

Run the acceptance tests for these samples:

    bundle exec rake test
