# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/firestore/v1/firestore_pb"
require "google/cloud/firestore/v1/firestore"

class ::Google::Cloud::Firestore::V1::Firestore::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_document
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::Document.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    mask = {}
    transaction = "hello world"

    get_document_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_document, name
      assert_kind_of ::Google::Cloud::Firestore::V1::GetDocumentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::DocumentMask), request["mask"]
      assert_equal "hello world", request["transaction"]
      assert_equal :transaction, request.consistency_selector
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_document_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_document({ name: name, mask: mask, transaction: transaction }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_document name: name, mask: mask, transaction: transaction do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_document ::Google::Cloud::Firestore::V1::GetDocumentRequest.new(name: name, mask: mask, transaction: transaction) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_document({ name: name, mask: mask, transaction: transaction }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_document(::Google::Cloud::Firestore::V1::GetDocumentRequest.new(name: name, mask: mask, transaction: transaction), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_document_client_stub.call_rpc_count
    end
  end

  def test_list_documents
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::ListDocumentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    collection_id = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    mask = {}
    transaction = "hello world"
    show_missing = true

    list_documents_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_documents, name
      assert_kind_of ::Google::Cloud::Firestore::V1::ListDocumentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["collection_id"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::DocumentMask), request["mask"]
      assert_equal "hello world", request["transaction"]
      assert_equal :transaction, request.consistency_selector
      assert_equal true, request["show_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_documents_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_documents({ parent: parent, collection_id: collection_id, page_size: page_size, page_token: page_token, order_by: order_by, mask: mask, transaction: transaction, show_missing: show_missing }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_documents parent: parent, collection_id: collection_id, page_size: page_size, page_token: page_token, order_by: order_by, mask: mask, transaction: transaction, show_missing: show_missing do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_documents ::Google::Cloud::Firestore::V1::ListDocumentsRequest.new(parent: parent, collection_id: collection_id, page_size: page_size, page_token: page_token, order_by: order_by, mask: mask, transaction: transaction, show_missing: show_missing) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_documents({ parent: parent, collection_id: collection_id, page_size: page_size, page_token: page_token, order_by: order_by, mask: mask, transaction: transaction, show_missing: show_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_documents(::Google::Cloud::Firestore::V1::ListDocumentsRequest.new(parent: parent, collection_id: collection_id, page_size: page_size, page_token: page_token, order_by: order_by, mask: mask, transaction: transaction, show_missing: show_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_documents_client_stub.call_rpc_count
    end
  end

  def test_update_document
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::Document.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    document = {}
    update_mask = {}
    mask = {}
    current_document = {}

    update_document_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_document, name
      assert_kind_of ::Google::Cloud::Firestore::V1::UpdateDocumentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::Document), request["document"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::DocumentMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::DocumentMask), request["mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::Precondition), request["current_document"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_document_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_document({ document: document, update_mask: update_mask, mask: mask, current_document: current_document }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_document document: document, update_mask: update_mask, mask: mask, current_document: current_document do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_document ::Google::Cloud::Firestore::V1::UpdateDocumentRequest.new(document: document, update_mask: update_mask, mask: mask, current_document: current_document) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_document({ document: document, update_mask: update_mask, mask: mask, current_document: current_document }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_document(::Google::Cloud::Firestore::V1::UpdateDocumentRequest.new(document: document, update_mask: update_mask, mask: mask, current_document: current_document), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_document_client_stub.call_rpc_count
    end
  end

  def test_delete_document
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    current_document = {}

    delete_document_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_document, name
      assert_kind_of ::Google::Cloud::Firestore::V1::DeleteDocumentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::Precondition), request["current_document"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_document_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_document({ name: name, current_document: current_document }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_document name: name, current_document: current_document do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_document ::Google::Cloud::Firestore::V1::DeleteDocumentRequest.new(name: name, current_document: current_document) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_document({ name: name, current_document: current_document }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_document(::Google::Cloud::Firestore::V1::DeleteDocumentRequest.new(name: name, current_document: current_document), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_document_client_stub.call_rpc_count
    end
  end

  def test_batch_get_documents
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    database = "hello world"
    documents = ["hello world"]
    mask = {}
    transaction = "hello world"

    batch_get_documents_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :batch_get_documents, name
      assert_kind_of ::Google::Cloud::Firestore::V1::BatchGetDocumentsRequest, request
      assert_equal "hello world", request["database"]
      assert_equal ["hello world"], request["documents"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::DocumentMask), request["mask"]
      assert_equal "hello world", request["transaction"]
      assert_equal :transaction, request.consistency_selector
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_get_documents_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_get_documents({ database: database, documents: documents, mask: mask, transaction: transaction }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_get_documents database: database, documents: documents, mask: mask, transaction: transaction do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_get_documents ::Google::Cloud::Firestore::V1::BatchGetDocumentsRequest.new(database: database, documents: documents, mask: mask, transaction: transaction) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_get_documents({ database: database, documents: documents, mask: mask, transaction: transaction }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_get_documents(::Google::Cloud::Firestore::V1::BatchGetDocumentsRequest.new(database: database, documents: documents, mask: mask, transaction: transaction), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_get_documents_client_stub.call_rpc_count
    end
  end

  def test_begin_transaction
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::BeginTransactionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    database = "hello world"
    options = {}

    begin_transaction_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :begin_transaction, name
      assert_kind_of ::Google::Cloud::Firestore::V1::BeginTransactionRequest, request
      assert_equal "hello world", request["database"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::TransactionOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, begin_transaction_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.begin_transaction({ database: database, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.begin_transaction database: database, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.begin_transaction ::Google::Cloud::Firestore::V1::BeginTransactionRequest.new(database: database, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.begin_transaction({ database: database, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.begin_transaction(::Google::Cloud::Firestore::V1::BeginTransactionRequest.new(database: database, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, begin_transaction_client_stub.call_rpc_count
    end
  end

  def test_commit
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::CommitResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    database = "hello world"
    writes = [{}]
    transaction = "hello world"

    commit_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :commit, name
      assert_kind_of ::Google::Cloud::Firestore::V1::CommitRequest, request
      assert_equal "hello world", request["database"]
      assert_kind_of ::Google::Cloud::Firestore::V1::Write, request["writes"].first
      assert_equal "hello world", request["transaction"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, commit_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.commit({ database: database, writes: writes, transaction: transaction }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.commit database: database, writes: writes, transaction: transaction do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.commit ::Google::Cloud::Firestore::V1::CommitRequest.new(database: database, writes: writes, transaction: transaction) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.commit({ database: database, writes: writes, transaction: transaction }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.commit(::Google::Cloud::Firestore::V1::CommitRequest.new(database: database, writes: writes, transaction: transaction), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, commit_client_stub.call_rpc_count
    end
  end

  def test_rollback
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    database = "hello world"
    transaction = "hello world"

    rollback_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rollback, name
      assert_kind_of ::Google::Cloud::Firestore::V1::RollbackRequest, request
      assert_equal "hello world", request["database"]
      assert_equal "hello world", request["transaction"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rollback_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rollback({ database: database, transaction: transaction }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rollback database: database, transaction: transaction do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rollback ::Google::Cloud::Firestore::V1::RollbackRequest.new(database: database, transaction: transaction) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rollback({ database: database, transaction: transaction }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rollback(::Google::Cloud::Firestore::V1::RollbackRequest.new(database: database, transaction: transaction), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rollback_client_stub.call_rpc_count
    end
  end

  def test_run_query
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::RunQueryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    parent = "hello world"
    structured_query = {}
    transaction = "hello world"
    explain_options = {}

    run_query_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :run_query, name
      assert_kind_of ::Google::Cloud::Firestore::V1::RunQueryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::StructuredQuery), request["structured_query"]
      assert_equal :structured_query, request.query_type
      assert_equal "hello world", request["transaction"]
      assert_equal :transaction, request.consistency_selector
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::ExplainOptions), request["explain_options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_query_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_query({ parent: parent, structured_query: structured_query, transaction: transaction, explain_options: explain_options }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_query parent: parent, structured_query: structured_query, transaction: transaction, explain_options: explain_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_query ::Google::Cloud::Firestore::V1::RunQueryRequest.new(parent: parent, structured_query: structured_query, transaction: transaction, explain_options: explain_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_query({ parent: parent, structured_query: structured_query, transaction: transaction, explain_options: explain_options }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_query(::Google::Cloud::Firestore::V1::RunQueryRequest.new(parent: parent, structured_query: structured_query, transaction: transaction, explain_options: explain_options), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_query_client_stub.call_rpc_count
    end
  end

  def test_execute_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::ExecutePipelineResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    database = "hello world"
    structured_pipeline = {}
    transaction = "hello world"

    execute_pipeline_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :execute_pipeline, name
      assert_kind_of ::Google::Cloud::Firestore::V1::ExecutePipelineRequest, request
      assert_equal "hello world", request["database"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::StructuredPipeline), request["structured_pipeline"]
      assert_equal :structured_pipeline, request.pipeline_type
      assert_equal "hello world", request["transaction"]
      assert_equal :transaction, request.consistency_selector
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, execute_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.execute_pipeline({ database: database, structured_pipeline: structured_pipeline, transaction: transaction }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ExecutePipelineResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.execute_pipeline database: database, structured_pipeline: structured_pipeline, transaction: transaction do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ExecutePipelineResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.execute_pipeline ::Google::Cloud::Firestore::V1::ExecutePipelineRequest.new(database: database, structured_pipeline: structured_pipeline, transaction: transaction) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ExecutePipelineResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.execute_pipeline({ database: database, structured_pipeline: structured_pipeline, transaction: transaction }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ExecutePipelineResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.execute_pipeline(::Google::Cloud::Firestore::V1::ExecutePipelineRequest.new(database: database, structured_pipeline: structured_pipeline, transaction: transaction), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ExecutePipelineResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, execute_pipeline_client_stub.call_rpc_count
    end
  end

  def test_run_aggregation_query
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::RunAggregationQueryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    parent = "hello world"
    structured_aggregation_query = {}
    transaction = "hello world"
    explain_options = {}

    run_aggregation_query_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :run_aggregation_query, name
      assert_kind_of ::Google::Cloud::Firestore::V1::RunAggregationQueryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::StructuredAggregationQuery), request["structured_aggregation_query"]
      assert_equal :structured_aggregation_query, request.query_type
      assert_equal "hello world", request["transaction"]
      assert_equal :transaction, request.consistency_selector
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::ExplainOptions), request["explain_options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_aggregation_query_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_aggregation_query({ parent: parent, structured_aggregation_query: structured_aggregation_query, transaction: transaction, explain_options: explain_options }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunAggregationQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_aggregation_query parent: parent, structured_aggregation_query: structured_aggregation_query, transaction: transaction, explain_options: explain_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunAggregationQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_aggregation_query ::Google::Cloud::Firestore::V1::RunAggregationQueryRequest.new(parent: parent, structured_aggregation_query: structured_aggregation_query, transaction: transaction, explain_options: explain_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunAggregationQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_aggregation_query({ parent: parent, structured_aggregation_query: structured_aggregation_query, transaction: transaction, explain_options: explain_options }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunAggregationQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_aggregation_query(::Google::Cloud::Firestore::V1::RunAggregationQueryRequest.new(parent: parent, structured_aggregation_query: structured_aggregation_query, transaction: transaction, explain_options: explain_options), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::RunAggregationQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_aggregation_query_client_stub.call_rpc_count
    end
  end

  def test_partition_query
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::PartitionQueryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    structured_query = {}
    partition_count = 42
    page_token = "hello world"
    page_size = 42
    read_time = {}

    partition_query_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :partition_query, name
      assert_kind_of ::Google::Cloud::Firestore::V1::PartitionQueryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::StructuredQuery), request["structured_query"]
      assert_equal :structured_query, request.query_type
      assert_equal 42, request["partition_count"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["read_time"]
      assert_equal :read_time, request.consistency_selector
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, partition_query_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.partition_query({ parent: parent, structured_query: structured_query, partition_count: partition_count, page_token: page_token, page_size: page_size, read_time: read_time }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.partition_query parent: parent, structured_query: structured_query, partition_count: partition_count, page_token: page_token, page_size: page_size, read_time: read_time do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.partition_query ::Google::Cloud::Firestore::V1::PartitionQueryRequest.new(parent: parent, structured_query: structured_query, partition_count: partition_count, page_token: page_token, page_size: page_size, read_time: read_time) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.partition_query({ parent: parent, structured_query: structured_query, partition_count: partition_count, page_token: page_token, page_size: page_size, read_time: read_time }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.partition_query(::Google::Cloud::Firestore::V1::PartitionQueryRequest.new(parent: parent, structured_query: structured_query, partition_count: partition_count, page_token: page_token, page_size: page_size, read_time: read_time), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, partition_query_client_stub.call_rpc_count
    end
  end

  def test_write
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::WriteResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    database = "hello world"
    stream_id = "hello world"
    writes = [{}]
    stream_token = "hello world"
    labels = {}

    write_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :write, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, write_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { database: database, stream_id: stream_id, writes: writes, stream_token: stream_token, labels: labels }
      request_proto = ::Google::Cloud::Firestore::V1::WriteRequest.new database: database, stream_id: stream_id, writes: writes, stream_token: stream_token, labels: labels
      enum_input = [request_hash, request_proto].to_enum
      client.write enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::WriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { database: database, stream_id: stream_id, writes: writes, stream_token: stream_token, labels: labels }
      request_proto = ::Google::Cloud::Firestore::V1::WriteRequest.new database: database, stream_id: stream_id, writes: writes, stream_token: stream_token, labels: labels
      stream_input = Gapic::StreamInput.new
      client.write stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::WriteResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { database: database, stream_id: stream_id, writes: writes, stream_token: stream_token, labels: labels }
      request_proto = ::Google::Cloud::Firestore::V1::WriteRequest.new database: database, stream_id: stream_id, writes: writes, stream_token: stream_token, labels: labels
      enum_input = [request_hash, request_proto].to_enum
      client.write enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::WriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { database: database, stream_id: stream_id, writes: writes, stream_token: stream_token, labels: labels }
      request_proto = ::Google::Cloud::Firestore::V1::WriteRequest.new database: database, stream_id: stream_id, writes: writes, stream_token: stream_token, labels: labels
      stream_input = Gapic::StreamInput.new
      client.write stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::WriteResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, write_client_stub.call_rpc_count
      write_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::WriteRequest, r
          assert_equal "hello world", r["database"]
          assert_equal "hello world", r["stream_id"]
          assert_kind_of ::Google::Cloud::Firestore::V1::Write, r["writes"].first
          assert_equal "hello world", r["stream_token"]
          assert_equal({}, r["labels"].to_h)
        end
      end
    end
  end

  def test_listen
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::ListenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    database = "hello world"
    add_target = {}
    labels = {}

    listen_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :listen, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, listen_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { database: database, add_target: add_target, labels: labels }
      request_proto = ::Google::Cloud::Firestore::V1::ListenRequest.new database: database, add_target: add_target, labels: labels
      enum_input = [request_hash, request_proto].to_enum
      client.listen enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ListenResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { database: database, add_target: add_target, labels: labels }
      request_proto = ::Google::Cloud::Firestore::V1::ListenRequest.new database: database, add_target: add_target, labels: labels
      stream_input = Gapic::StreamInput.new
      client.listen stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ListenResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { database: database, add_target: add_target, labels: labels }
      request_proto = ::Google::Cloud::Firestore::V1::ListenRequest.new database: database, add_target: add_target, labels: labels
      enum_input = [request_hash, request_proto].to_enum
      client.listen enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ListenResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { database: database, add_target: add_target, labels: labels }
      request_proto = ::Google::Cloud::Firestore::V1::ListenRequest.new database: database, add_target: add_target, labels: labels
      stream_input = Gapic::StreamInput.new
      client.listen stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ListenResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, listen_client_stub.call_rpc_count
      listen_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Firestore::V1::ListenRequest, r
          assert_equal "hello world", r["database"]
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::Target), r["add_target"]
          assert_equal :add_target, r.target_change
          assert_equal({}, r["labels"].to_h)
        end
      end
    end
  end

  def test_list_collection_ids
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::ListCollectionIdsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    read_time = {}

    list_collection_ids_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_collection_ids, name
      assert_kind_of ::Google::Cloud::Firestore::V1::ListCollectionIdsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["read_time"]
      assert_equal :read_time, request.consistency_selector
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_collection_ids_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_collection_ids({ parent: parent, page_size: page_size, page_token: page_token, read_time: read_time }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_collection_ids parent: parent, page_size: page_size, page_token: page_token, read_time: read_time do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_collection_ids ::Google::Cloud::Firestore::V1::ListCollectionIdsRequest.new(parent: parent, page_size: page_size, page_token: page_token, read_time: read_time) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_collection_ids({ parent: parent, page_size: page_size, page_token: page_token, read_time: read_time }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_collection_ids(::Google::Cloud::Firestore::V1::ListCollectionIdsRequest.new(parent: parent, page_size: page_size, page_token: page_token, read_time: read_time), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_collection_ids_client_stub.call_rpc_count
    end
  end

  def test_batch_write
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::BatchWriteResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    database = "hello world"
    writes = [{}]
    labels = {}

    batch_write_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_write, name
      assert_kind_of ::Google::Cloud::Firestore::V1::BatchWriteRequest, request
      assert_equal "hello world", request["database"]
      assert_kind_of ::Google::Cloud::Firestore::V1::Write, request["writes"].first
      assert_equal({}, request["labels"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_write_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_write({ database: database, writes: writes, labels: labels }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_write database: database, writes: writes, labels: labels do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_write ::Google::Cloud::Firestore::V1::BatchWriteRequest.new(database: database, writes: writes, labels: labels) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_write({ database: database, writes: writes, labels: labels }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_write(::Google::Cloud::Firestore::V1::BatchWriteRequest.new(database: database, writes: writes, labels: labels), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_write_client_stub.call_rpc_count
    end
  end

  def test_create_document
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Firestore::V1::Document.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    collection_id = "hello world"
    document_id = "hello world"
    document = {}
    mask = {}

    create_document_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_document, name
      assert_kind_of ::Google::Cloud::Firestore::V1::CreateDocumentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["collection_id"]
      assert_equal "hello world", request["document_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::Document), request["document"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Firestore::V1::DocumentMask), request["mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_document_client_stub do
      # Create client
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_document({ parent: parent, collection_id: collection_id, document_id: document_id, document: document, mask: mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_document parent: parent, collection_id: collection_id, document_id: document_id, document: document, mask: mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_document ::Google::Cloud::Firestore::V1::CreateDocumentRequest.new(parent: parent, collection_id: collection_id, document_id: document_id, document: document, mask: mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_document({ parent: parent, collection_id: collection_id, document_id: document_id, document: document, mask: mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_document(::Google::Cloud::Firestore::V1::CreateDocumentRequest.new(parent: parent, collection_id: collection_id, document_id: document_id, document: document, mask: mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_document_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Firestore::V1::Firestore::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Firestore::V1::Firestore::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
