# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Firestore
      module V1
        # A write on a document.
        # @!attribute [rw] update
        #   @return [::Google::Cloud::Firestore::V1::Document]
        #     A document to write.
        #
        #     Note: The following fields are mutually exclusive: `update`, `delete`, `transform`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] delete
        #   @return [::String]
        #     A document name to delete. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        #
        #     Note: The following fields are mutually exclusive: `delete`, `update`, `transform`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] transform
        #   @return [::Google::Cloud::Firestore::V1::DocumentTransform]
        #     Applies a transformation to a document.
        #
        #     Note: The following fields are mutually exclusive: `transform`, `update`, `delete`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] update_mask
        #   @return [::Google::Cloud::Firestore::V1::DocumentMask]
        #     The fields to update in this write.
        #
        #     This field can be set only when the operation is `update`.
        #     If the mask is not set for an `update` and the document exists, any
        #     existing data will be overwritten.
        #     If the mask is set and the document on the server has fields not covered by
        #     the mask, they are left unchanged.
        #     Fields referenced in the mask, but not present in the input document, are
        #     deleted from the document on the server.
        #     The field paths in this mask must not contain a reserved field name.
        # @!attribute [rw] update_transforms
        #   @return [::Array<::Google::Cloud::Firestore::V1::DocumentTransform::FieldTransform>]
        #     The transforms to perform after update.
        #
        #     This field can be set only when the operation is `update`. If present, this
        #     write is equivalent to performing `update` and `transform` to the same
        #     document atomically and in order.
        # @!attribute [rw] current_document
        #   @return [::Google::Cloud::Firestore::V1::Precondition]
        #     An optional precondition on the document.
        #
        #     The write will fail if this is set and not met by the target document.
        class Write
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A transformation of a document.
        # @!attribute [rw] document
        #   @return [::String]
        #     The name of the document to transform.
        # @!attribute [rw] field_transforms
        #   @return [::Array<::Google::Cloud::Firestore::V1::DocumentTransform::FieldTransform>]
        #     The list of transformations to apply to the fields of the document, in
        #     order.
        #     This must not be empty.
        class DocumentTransform
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A transformation of a field of the document.
          # @!attribute [rw] field_path
          #   @return [::String]
          #     The path of the field. See
          #     {::Google::Cloud::Firestore::V1::Document#fields Document.fields} for the field path
          #     syntax reference.
          # @!attribute [rw] set_to_server_value
          #   @return [::Google::Cloud::Firestore::V1::DocumentTransform::FieldTransform::ServerValue]
          #     Sets the field to the given server value.
          #
          #     Note: The following fields are mutually exclusive: `set_to_server_value`, `increment`, `maximum`, `minimum`, `append_missing_elements`, `remove_all_from_array`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] increment
          #   @return [::Google::Cloud::Firestore::V1::Value]
          #     Adds the given value to the field's current value.
          #
          #     This must be an integer or a double value.
          #     If the field is not an integer or double, or if the field does not yet
          #     exist, the transformation will set the field to the given value.
          #     If either of the given value or the current field value are doubles,
          #     both values will be interpreted as doubles. Double arithmetic and
          #     representation of double values follow IEEE 754 semantics.
          #     If there is positive/negative integer overflow, the field is resolved
          #     to the largest magnitude positive/negative integer.
          #
          #     Note: The following fields are mutually exclusive: `increment`, `set_to_server_value`, `maximum`, `minimum`, `append_missing_elements`, `remove_all_from_array`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] maximum
          #   @return [::Google::Cloud::Firestore::V1::Value]
          #     Sets the field to the maximum of its current value and the given value.
          #
          #     This must be an integer or a double value.
          #     If the field is not an integer or double, or if the field does not yet
          #     exist, the transformation will set the field to the given value.
          #     If a maximum operation is applied where the field and the input value
          #     are of mixed types (that is - one is an integer and one is a double)
          #     the field takes on the type of the larger operand. If the operands are
          #     equivalent (e.g. 3 and 3.0), the field does not change.
          #     0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
          #     zero input value is always the stored value.
          #     The maximum of any numeric value x and NaN is NaN.
          #
          #     Note: The following fields are mutually exclusive: `maximum`, `set_to_server_value`, `increment`, `minimum`, `append_missing_elements`, `remove_all_from_array`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] minimum
          #   @return [::Google::Cloud::Firestore::V1::Value]
          #     Sets the field to the minimum of its current value and the given value.
          #
          #     This must be an integer or a double value.
          #     If the field is not an integer or double, or if the field does not yet
          #     exist, the transformation will set the field to the input value.
          #     If a minimum operation is applied where the field and the input value
          #     are of mixed types (that is - one is an integer and one is a double)
          #     the field takes on the type of the smaller operand. If the operands are
          #     equivalent (e.g. 3 and 3.0), the field does not change.
          #     0, 0.0, and -0.0 are all zero. The minimum of a zero stored value and
          #     zero input value is always the stored value.
          #     The minimum of any numeric value x and NaN is NaN.
          #
          #     Note: The following fields are mutually exclusive: `minimum`, `set_to_server_value`, `increment`, `maximum`, `append_missing_elements`, `remove_all_from_array`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] append_missing_elements
          #   @return [::Google::Cloud::Firestore::V1::ArrayValue]
          #     Append the given elements in order if they are not already present in
          #     the current field value.
          #     If the field is not an array, or if the field does not yet exist, it is
          #     first set to the empty array.
          #
          #     Equivalent numbers of different types (e.g. 3L and 3.0) are
          #     considered equal when checking if a value is missing.
          #     NaN is equal to NaN, and Null is equal to Null.
          #     If the input contains multiple equivalent values, only the first will
          #     be considered.
          #
          #     The corresponding transform_result will be the null value.
          #
          #     Note: The following fields are mutually exclusive: `append_missing_elements`, `set_to_server_value`, `increment`, `maximum`, `minimum`, `remove_all_from_array`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] remove_all_from_array
          #   @return [::Google::Cloud::Firestore::V1::ArrayValue]
          #     Remove all of the given elements from the array in the field.
          #     If the field is not an array, or if the field does not yet exist, it is
          #     set to the empty array.
          #
          #     Equivalent numbers of the different types (e.g. 3L and 3.0) are
          #     considered equal when deciding whether an element should be removed.
          #     NaN is equal to NaN, and Null is equal to Null.
          #     This will remove all equivalent values if there are duplicates.
          #
          #     The corresponding transform_result will be the null value.
          #
          #     Note: The following fields are mutually exclusive: `remove_all_from_array`, `set_to_server_value`, `increment`, `maximum`, `minimum`, `append_missing_elements`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class FieldTransform
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A value that is calculated by the server.
            module ServerValue
              # Unspecified. This value must not be used.
              SERVER_VALUE_UNSPECIFIED = 0

              # The time at which the server processed the request, with millisecond
              # precision. If used on multiple fields (same or different documents) in
              # a transaction, all the fields will get the same server timestamp.
              REQUEST_TIME = 1
            end
          end
        end

        # The result of applying a write.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the document after applying the write. Not set
        #     after a `delete`.
        #
        #     If the write did not actually change the document, this will be the
        #     previous update_time.
        # @!attribute [rw] transform_results
        #   @return [::Array<::Google::Cloud::Firestore::V1::Value>]
        #     The results of applying each
        #     {::Google::Cloud::Firestore::V1::DocumentTransform::FieldTransform DocumentTransform.FieldTransform},
        #     in the same order.
        class WriteResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A {::Google::Cloud::Firestore::V1::Document Document} has changed.
        #
        # May be the result of multiple {::Google::Cloud::Firestore::V1::Write writes}, including
        # deletes, that ultimately resulted in a new value for the
        # {::Google::Cloud::Firestore::V1::Document Document}.
        #
        # Multiple {::Google::Cloud::Firestore::V1::DocumentChange DocumentChange} messages may be
        # returned for the same logical change, if multiple targets are affected.
        # @!attribute [rw] document
        #   @return [::Google::Cloud::Firestore::V1::Document]
        #     The new state of the {::Google::Cloud::Firestore::V1::Document Document}.
        #
        #     If `mask` is set, contains only fields that were updated or added.
        # @!attribute [rw] target_ids
        #   @return [::Array<::Integer>]
        #     A set of target IDs of targets that match this document.
        # @!attribute [rw] removed_target_ids
        #   @return [::Array<::Integer>]
        #     A set of target IDs for targets that no longer match this document.
        class DocumentChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A {::Google::Cloud::Firestore::V1::Document Document} has been deleted.
        #
        # May be the result of multiple {::Google::Cloud::Firestore::V1::Write writes}, including
        # updates, the last of which deleted the
        # {::Google::Cloud::Firestore::V1::Document Document}.
        #
        # Multiple {::Google::Cloud::Firestore::V1::DocumentDelete DocumentDelete} messages may be
        # returned for the same logical delete, if multiple targets are affected.
        # @!attribute [rw] document
        #   @return [::String]
        #     The resource name of the {::Google::Cloud::Firestore::V1::Document Document} that was
        #     deleted.
        # @!attribute [rw] removed_target_ids
        #   @return [::Array<::Integer>]
        #     A set of target IDs for targets that previously matched this entity.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The read timestamp at which the delete was observed.
        #
        #     Greater or equal to the `commit_time` of the delete.
        class DocumentDelete
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A {::Google::Cloud::Firestore::V1::Document Document} has been removed from the view of
        # the targets.
        #
        # Sent if the document is no longer relevant to a target and is out of view.
        # Can be sent instead of a DocumentDelete or a DocumentChange if the server
        # can not send the new value of the document.
        #
        # Multiple {::Google::Cloud::Firestore::V1::DocumentRemove DocumentRemove} messages may be
        # returned for the same logical write or delete, if multiple targets are
        # affected.
        # @!attribute [rw] document
        #   @return [::String]
        #     The resource name of the {::Google::Cloud::Firestore::V1::Document Document} that has
        #     gone out of view.
        # @!attribute [rw] removed_target_ids
        #   @return [::Array<::Integer>]
        #     A set of target IDs for targets that previously matched this document.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The read timestamp at which the remove was observed.
        #
        #     Greater or equal to the `commit_time` of the change/delete/remove.
        class DocumentRemove
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A digest of all the documents that match a given target.
        # @!attribute [rw] target_id
        #   @return [::Integer]
        #     The target ID to which this filter applies.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     The total count of documents that match
        #     {::Google::Cloud::Firestore::V1::ExistenceFilter#target_id target_id}.
        #
        #     If different from the count of documents in the client that match, the
        #     client must manually determine which documents no longer match the target.
        #
        #     The client can use the `unchanged_names` bloom filter to assist with
        #     this determination by testing ALL the document names against the filter;
        #     if the document name is NOT in the filter, it means the document no
        #     longer matches the target.
        # @!attribute [rw] unchanged_names
        #   @return [::Google::Cloud::Firestore::V1::BloomFilter]
        #     A bloom filter that, despite its name, contains the UTF-8 byte encodings of
        #     the resource names of ALL the documents that match
        #     {::Google::Cloud::Firestore::V1::ExistenceFilter#target_id target_id}, in the form
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        #
        #     This bloom filter may be omitted at the server's discretion, such as if it
        #     is deemed that the client will not make use of it or if it is too
        #     computationally expensive to calculate or transmit. Clients must gracefully
        #     handle this field being absent by falling back to the logic used before
        #     this field existed; that is, re-add the target without a resume token to
        #     figure out which documents in the client's cache are out of sync.
        class ExistenceFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
