# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Firestore
      module V1
        # Explain options for the query.
        # @!attribute [rw] analyze
        #   @return [::Boolean]
        #     Optional. Whether to execute this query.
        #
        #     When false (the default), the query will be planned, returning only
        #     metrics from the planning stages.
        #
        #     When true, the query will be planned and executed, returning the full
        #     query results along with both planning and execution stage metrics.
        class ExplainOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Explain metrics for the query.
        # @!attribute [rw] plan_summary
        #   @return [::Google::Cloud::Firestore::V1::PlanSummary]
        #     Planning phase information for the query.
        # @!attribute [rw] execution_stats
        #   @return [::Google::Cloud::Firestore::V1::ExecutionStats]
        #     Aggregated stats from the execution of the query. Only present when
        #     {::Google::Cloud::Firestore::V1::ExplainOptions#analyze ExplainOptions.analyze} is set
        #     to true.
        class ExplainMetrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Planning phase information for the query.
        # @!attribute [rw] indexes_used
        #   @return [::Array<::Google::Protobuf::Struct>]
        #     The indexes selected for the query. For example:
        #      [
        #        \\{"query_scope": "Collection", "properties": "(foo ASC, __name__ ASC)"},
        #        \\{"query_scope": "Collection", "properties": "(bar ASC, __name__ ASC)"}
        #      ]
        class PlanSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Execution statistics for the query.
        # @!attribute [rw] results_returned
        #   @return [::Integer]
        #     Total number of results returned, including documents, projections,
        #     aggregation results, keys.
        # @!attribute [rw] execution_duration
        #   @return [::Google::Protobuf::Duration]
        #     Total time to execute the query in the backend.
        # @!attribute [rw] read_operations
        #   @return [::Integer]
        #     Total billable read operations.
        # @!attribute [rw] debug_stats
        #   @return [::Google::Protobuf::Struct]
        #     Debugging statistics from the execution of the query. Note that the
        #     debugging stats are subject to change as Firestore evolves. It could
        #     include:
        #      {
        #        "indexes_entries_scanned": "1000",
        #        "documents_scanned": "20",
        #        "billing_details" : {
        #           "documents_billable": "20",
        #           "index_entries_billable": "1000",
        #           "min_query_cost": "0"
        #        }
        #      }
        class ExecutionStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
