# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Firestore
      module V1
        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#get_document Firestore.GetDocument}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Document to get. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        # @!attribute [rw] mask
        #   @return [::Google::Cloud::Firestore::V1::DocumentMask]
        #     The fields to return. If not set, returns all fields.
        #
        #     If the document has a field that is not present in this mask, that field
        #     will not be returned in the response.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     Reads the document in a transaction.
        #
        #     Note: The following fields are mutually exclusive: `transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Reads the version of the document at the given time.
        #
        #     This must be a microsecond precision timestamp within the past one hour,
        #     or if Point-in-Time Recovery is enabled, can additionally be a whole
        #     minute timestamp within the past 7 days.
        #
        #     Note: The following fields are mutually exclusive: `read_time`, `transaction`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class GetDocumentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#list_documents Firestore.ListDocuments}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents` or
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        #
        #     For example:
        #     `projects/my-project/databases/my-database/documents` or
        #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
        # @!attribute [rw] collection_id
        #   @return [::String]
        #     Optional. The collection ID, relative to `parent`, to list.
        #
        #     For example: `chatrooms` or `messages`.
        #
        #     This is optional, and when not provided, Firestore will list documents
        #     from all collections under the provided `parent`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of documents to return in a single response.
        #
        #     Firestore may return fewer than this value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListDocuments` response.
        #
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters (with the exception of `page_size`) must match the values set
        #     in the request that generated the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The optional ordering of the documents to return.
        #
        #     For example: `priority desc, __name__ desc`.
        #
        #     This mirrors the {::Google::Cloud::Firestore::V1::StructuredQuery#order_by `ORDER BY`}
        #     used in Firestore queries but in a string representation. When absent,
        #     documents are ordered based on `__name__ ASC`.
        # @!attribute [rw] mask
        #   @return [::Google::Cloud::Firestore::V1::DocumentMask]
        #     Optional. The fields to return. If not set, returns all fields.
        #
        #     If a document has a field that is not present in this mask, that field
        #     will not be returned in the response.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     Perform the read as part of an already active transaction.
        #
        #     Note: The following fields are mutually exclusive: `transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Perform the read at the provided time.
        #
        #     This must be a microsecond precision timestamp within the past one hour,
        #     or if Point-in-Time Recovery is enabled, can additionally be a whole
        #     minute timestamp within the past 7 days.
        #
        #     Note: The following fields are mutually exclusive: `read_time`, `transaction`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] show_missing
        #   @return [::Boolean]
        #     If the list should show missing documents.
        #
        #     A document is missing if it does not exist, but there are sub-documents
        #     nested underneath it. When true, such missing documents will be returned
        #     with a key but will not have fields,
        #     {::Google::Cloud::Firestore::V1::Document#create_time `create_time`}, or
        #     {::Google::Cloud::Firestore::V1::Document#update_time `update_time`} set.
        #
        #     Requests with `show_missing` may not specify `where` or `order_by`.
        class ListDocumentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#list_documents Firestore.ListDocuments}.
        # @!attribute [rw] documents
        #   @return [::Array<::Google::Cloud::Firestore::V1::Document>]
        #     The Documents found.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of documents.
        #
        #     If this field is omitted, there are no subsequent pages.
        class ListDocumentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#create_document Firestore.CreateDocument}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource. For example:
        #     `projects/{project_id}/databases/{database_id}/documents` or
        #     `projects/{project_id}/databases/{database_id}/documents/chatrooms/{chatroom_id}`
        # @!attribute [rw] collection_id
        #   @return [::String]
        #     Required. The collection ID, relative to `parent`, to list. For example:
        #     `chatrooms`.
        # @!attribute [rw] document_id
        #   @return [::String]
        #     The client-assigned document ID to use for this document.
        #
        #     Optional. If not specified, an ID will be assigned by the service.
        # @!attribute [rw] document
        #   @return [::Google::Cloud::Firestore::V1::Document]
        #     Required. The document to create. `name` must not be set.
        # @!attribute [rw] mask
        #   @return [::Google::Cloud::Firestore::V1::DocumentMask]
        #     The fields to return. If not set, returns all fields.
        #
        #     If the document has a field that is not present in this mask, that field
        #     will not be returned in the response.
        class CreateDocumentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#update_document Firestore.UpdateDocument}.
        # @!attribute [rw] document
        #   @return [::Google::Cloud::Firestore::V1::Document]
        #     Required. The updated document.
        #     Creates the document if it does not already exist.
        # @!attribute [rw] update_mask
        #   @return [::Google::Cloud::Firestore::V1::DocumentMask]
        #     The fields to update.
        #     None of the field paths in the mask may contain a reserved name.
        #
        #     If the document exists on the server and has fields not referenced in the
        #     mask, they are left unchanged.
        #     Fields referenced in the mask, but not present in the input document, are
        #     deleted from the document on the server.
        # @!attribute [rw] mask
        #   @return [::Google::Cloud::Firestore::V1::DocumentMask]
        #     The fields to return. If not set, returns all fields.
        #
        #     If the document has a field that is not present in this mask, that field
        #     will not be returned in the response.
        # @!attribute [rw] current_document
        #   @return [::Google::Cloud::Firestore::V1::Precondition]
        #     An optional precondition on the document.
        #     The request will fail if this is set and not met by the target document.
        class UpdateDocumentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#delete_document Firestore.DeleteDocument}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Document to delete. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        # @!attribute [rw] current_document
        #   @return [::Google::Cloud::Firestore::V1::Precondition]
        #     An optional precondition on the document.
        #     The request will fail if this is set and not met by the target document.
        class DeleteDocumentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#batch_get_documents Firestore.BatchGetDocuments}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database name. In the format:
        #     `projects/{project_id}/databases/{database_id}`.
        # @!attribute [rw] documents
        #   @return [::Array<::String>]
        #     The names of the documents to retrieve. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        #     The request will fail if any of the document is not a child resource of the
        #     given `database`. Duplicate names will be elided.
        # @!attribute [rw] mask
        #   @return [::Google::Cloud::Firestore::V1::DocumentMask]
        #     The fields to return. If not set, returns all fields.
        #
        #     If a document has a field that is not present in this mask, that field will
        #     not be returned in the response.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     Reads documents in a transaction.
        #
        #     Note: The following fields are mutually exclusive: `transaction`, `new_transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_transaction
        #   @return [::Google::Cloud::Firestore::V1::TransactionOptions]
        #     Starts a new transaction and reads the documents.
        #     Defaults to a read-only transaction.
        #     The new transaction ID will be returned as the first response in the
        #     stream.
        #
        #     Note: The following fields are mutually exclusive: `new_transaction`, `transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Reads documents as they were at the given time.
        #
        #     This must be a microsecond precision timestamp within the past one hour,
        #     or if Point-in-Time Recovery is enabled, can additionally be a whole
        #     minute timestamp within the past 7 days.
        #
        #     Note: The following fields are mutually exclusive: `read_time`, `transaction`, `new_transaction`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BatchGetDocumentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The streamed response for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#batch_get_documents Firestore.BatchGetDocuments}.
        # @!attribute [rw] found
        #   @return [::Google::Cloud::Firestore::V1::Document]
        #     A document that was requested.
        #
        #     Note: The following fields are mutually exclusive: `found`, `missing`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] missing
        #   @return [::String]
        #     A document name that was requested but does not exist. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        #
        #     Note: The following fields are mutually exclusive: `missing`, `found`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     The transaction that was started as part of this request.
        #     Will only be set in the first response, and only if
        #     {::Google::Cloud::Firestore::V1::BatchGetDocumentsRequest#new_transaction BatchGetDocumentsRequest.new_transaction}
        #     was set in the request.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the document was read.
        #     This may be monotically increasing, in this case the previous documents in
        #     the result stream are guaranteed not to have changed between their
        #     read_time and this one.
        class BatchGetDocumentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#begin_transaction Firestore.BeginTransaction}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database name. In the format:
        #     `projects/{project_id}/databases/{database_id}`.
        # @!attribute [rw] options
        #   @return [::Google::Cloud::Firestore::V1::TransactionOptions]
        #     The options for the transaction.
        #     Defaults to a read-write transaction.
        class BeginTransactionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#begin_transaction Firestore.BeginTransaction}.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     The transaction that was started.
        class BeginTransactionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Firestore::V1::Firestore::Client#commit Firestore.Commit}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database name. In the format:
        #     `projects/{project_id}/databases/{database_id}`.
        # @!attribute [rw] writes
        #   @return [::Array<::Google::Cloud::Firestore::V1::Write>]
        #     The writes to apply.
        #
        #     Always executed atomically and in order.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     If set, applies all writes in this transaction, and commits it.
        class CommitRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for {::Google::Cloud::Firestore::V1::Firestore::Client#commit Firestore.Commit}.
        # @!attribute [rw] write_results
        #   @return [::Array<::Google::Cloud::Firestore::V1::WriteResult>]
        #     The result of applying the writes.
        #
        #     This i-th write result corresponds to the i-th write in the
        #     request.
        # @!attribute [rw] commit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the commit occurred. Any read with an equal or greater
        #     `read_time` is guaranteed to see the effects of the commit.
        class CommitResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Firestore::V1::Firestore::Client#rollback Firestore.Rollback}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database name. In the format:
        #     `projects/{project_id}/databases/{database_id}`.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     Required. The transaction to roll back.
        class RollbackRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Firestore::V1::Firestore::Client#run_query Firestore.RunQuery}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents` or
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        #     For example:
        #     `projects/my-project/databases/my-database/documents` or
        #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
        # @!attribute [rw] structured_query
        #   @return [::Google::Cloud::Firestore::V1::StructuredQuery]
        #     A structured query.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     Run the query within an already active transaction.
        #
        #     The value here is the opaque transaction ID to execute the query in.
        #
        #     Note: The following fields are mutually exclusive: `transaction`, `new_transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_transaction
        #   @return [::Google::Cloud::Firestore::V1::TransactionOptions]
        #     Starts a new transaction and reads the documents.
        #     Defaults to a read-only transaction.
        #     The new transaction ID will be returned as the first response in the
        #     stream.
        #
        #     Note: The following fields are mutually exclusive: `new_transaction`, `transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Reads documents as they were at the given time.
        #
        #     This must be a microsecond precision timestamp within the past one hour,
        #     or if Point-in-Time Recovery is enabled, can additionally be a whole
        #     minute timestamp within the past 7 days.
        #
        #     Note: The following fields are mutually exclusive: `read_time`, `transaction`, `new_transaction`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] explain_options
        #   @return [::Google::Cloud::Firestore::V1::ExplainOptions]
        #     Optional. Explain options for the query. If set, additional query
        #     statistics will be returned. If not, only query results will be returned.
        class RunQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#run_query Firestore.RunQuery}.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     The transaction that was started as part of this request.
        #     Can only be set in the first response, and only if
        #     {::Google::Cloud::Firestore::V1::RunQueryRequest#new_transaction RunQueryRequest.new_transaction}
        #     was set in the request. If set, no other fields will be set in this
        #     response.
        # @!attribute [rw] document
        #   @return [::Google::Cloud::Firestore::V1::Document]
        #     A query result, not set when reporting partial progress.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the document was read. This may be monotonically
        #     increasing; in this case, the previous documents in the result stream are
        #     guaranteed not to have changed between their `read_time` and this one.
        #
        #     If the query returns no results, a response with `read_time` and no
        #     `document` will be sent, and this represents the time at which the query
        #     was run.
        # @!attribute [rw] skipped_results
        #   @return [::Integer]
        #     The number of results that have been skipped due to an offset between
        #     the last response and the current response.
        # @!attribute [rw] done
        #   @return [::Boolean]
        #     If present, Firestore has completely finished the request and no more
        #     documents will be returned.
        # @!attribute [rw] explain_metrics
        #   @return [::Google::Cloud::Firestore::V1::ExplainMetrics]
        #     Query explain metrics. This is only present when the
        #     {::Google::Cloud::Firestore::V1::RunQueryRequest#explain_options RunQueryRequest.explain_options}
        #     is provided, and it is sent only once with the last response in the stream.
        class RunQueryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#execute_pipeline Firestore.ExecutePipeline}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. Database identifier, in the form
        #     `projects/{project}/databases/{database}`.
        # @!attribute [rw] structured_pipeline
        #   @return [::Google::Cloud::Firestore::V1::StructuredPipeline]
        #     A pipelined operation.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     Run the query within an already active transaction.
        #
        #     The value here is the opaque transaction ID to execute the query in.
        #
        #     Note: The following fields are mutually exclusive: `transaction`, `new_transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_transaction
        #   @return [::Google::Cloud::Firestore::V1::TransactionOptions]
        #     Execute the pipeline in a new transaction.
        #
        #     The identifier of the newly created transaction will be returned in the
        #     first response on the stream. This defaults to a read-only transaction.
        #
        #     Note: The following fields are mutually exclusive: `new_transaction`, `transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Execute the pipeline in a snapshot transaction at the given time.
        #
        #     This must be a microsecond precision timestamp within the past one hour,
        #     or if Point-in-Time Recovery is enabled, can additionally be a whole
        #     minute timestamp within the past 7 days.
        #
        #     Note: The following fields are mutually exclusive: `read_time`, `transaction`, `new_transaction`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ExecutePipelineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for [Firestore.Execute][].
        # @!attribute [rw] transaction
        #   @return [::String]
        #     Newly created transaction identifier.
        #
        #     This field is only specified as part of the first response from the server,
        #     alongside the `results` field when the original request specified
        #     [ExecuteRequest.new_transaction][].
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Firestore::V1::Document>]
        #     An ordered batch of results returned executing a pipeline.
        #
        #     The batch size is variable, and can even be zero for when only a partial
        #     progress message is returned.
        #
        #     The fields present in the returned documents are only those that were
        #     explicitly requested in the pipeline, this includes those like
        #     {::Google::Cloud::Firestore::V1::Document#name `__name__`} and
        #     {::Google::Cloud::Firestore::V1::Document#update_time `__update_time__`}. This is
        #     explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
        #     RPCs which always return such fields even when they are not specified in
        #     the {::Google::Cloud::Firestore::V1::DocumentMask `mask`}.
        # @!attribute [rw] execution_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the results are valid.
        #
        #     This is a (not strictly) monotonically increasing value across multiple
        #     responses in the same stream. The API guarantees that all previously
        #     returned results are still valid at the latest `execution_time`. This
        #     allows the API consumer to treat the query if it ran at the latest
        #     `execution_time` returned.
        #
        #     If the query returns no results, a response with `execution_time` and no
        #     `results` will be sent, and this represents the time at which the operation
        #     was run.
        # @!attribute [rw] explain_stats
        #   @return [::Google::Cloud::Firestore::V1::ExplainStats]
        #     Query explain stats.
        #
        #     This is present on the **last** response if the request configured explain
        #     to run in 'analyze' or 'explain' mode in the pipeline options. If the query
        #     does not return any results, a response with `explain_stats` and no
        #     `results` will still be sent.
        class ExecutePipelineResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#run_aggregation_query Firestore.RunAggregationQuery}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents` or
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        #     For example:
        #     `projects/my-project/databases/my-database/documents` or
        #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
        # @!attribute [rw] structured_aggregation_query
        #   @return [::Google::Cloud::Firestore::V1::StructuredAggregationQuery]
        #     An aggregation query.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     Run the aggregation within an already active transaction.
        #
        #     The value here is the opaque transaction ID to execute the query in.
        #
        #     Note: The following fields are mutually exclusive: `transaction`, `new_transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_transaction
        #   @return [::Google::Cloud::Firestore::V1::TransactionOptions]
        #     Starts a new transaction as part of the query, defaulting to read-only.
        #
        #     The new transaction ID will be returned as the first response in the
        #     stream.
        #
        #     Note: The following fields are mutually exclusive: `new_transaction`, `transaction`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Executes the query at the given timestamp.
        #
        #     This must be a microsecond precision timestamp within the past one hour,
        #     or if Point-in-Time Recovery is enabled, can additionally be a whole
        #     minute timestamp within the past 7 days.
        #
        #     Note: The following fields are mutually exclusive: `read_time`, `transaction`, `new_transaction`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] explain_options
        #   @return [::Google::Cloud::Firestore::V1::ExplainOptions]
        #     Optional. Explain options for the query. If set, additional query
        #     statistics will be returned. If not, only query results will be returned.
        class RunAggregationQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#run_aggregation_query Firestore.RunAggregationQuery}.
        # @!attribute [rw] result
        #   @return [::Google::Cloud::Firestore::V1::AggregationResult]
        #     A single aggregation result.
        #
        #     Not present when reporting partial progress.
        # @!attribute [rw] transaction
        #   @return [::String]
        #     The transaction that was started as part of this request.
        #
        #     Only present on the first response when the request requested to start
        #     a new transaction.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the aggregate result was computed. This is always
        #     monotonically increasing; in this case, the previous AggregationResult in
        #     the result stream are guaranteed not to have changed between their
        #     `read_time` and this one.
        #
        #     If the query returns no results, a response with `read_time` and no
        #     `result` will be sent, and this represents the time at which the query
        #     was run.
        # @!attribute [rw] explain_metrics
        #   @return [::Google::Cloud::Firestore::V1::ExplainMetrics]
        #     Query explain metrics. This is only present when the
        #     {::Google::Cloud::Firestore::V1::RunAggregationQueryRequest#explain_options RunAggregationQueryRequest.explain_options}
        #     is provided, and it is sent only once with the last response in the stream.
        class RunAggregationQueryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#partition_query Firestore.PartitionQuery}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents`.
        #     Document resource names are not supported; only database resource names
        #     can be specified.
        # @!attribute [rw] structured_query
        #   @return [::Google::Cloud::Firestore::V1::StructuredQuery]
        #     A structured query.
        #     Query must specify collection with all descendants and be ordered by name
        #     ascending. Other filters, order bys, limits, offsets, and start/end
        #     cursors are not supported.
        # @!attribute [rw] partition_count
        #   @return [::Integer]
        #     The desired maximum number of partition points.
        #     The partitions may be returned across multiple pages of results.
        #     The number must be positive. The actual number of partitions
        #     returned may be fewer.
        #
        #     For example, this may be set to one fewer than the number of parallel
        #     queries to be run, or in running a data pipeline job, one fewer than the
        #     number of workers or compute instances available.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The `next_page_token` value returned from a previous call to
        #     PartitionQuery that may be used to get an additional set of results.
        #     There are no ordering guarantees between sets of results. Thus, using
        #     multiple sets of results will require merging the different result sets.
        #
        #     For example, two subsequent calls using a page_token may return:
        #
        #      * cursor B, cursor M, cursor Q
        #      * cursor A, cursor U, cursor W
        #
        #     To obtain a complete result set ordered with respect to the results of the
        #     query supplied to PartitionQuery, the results sets should be merged:
        #     cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of partitions to return in this call, subject to
        #     `partition_count`.
        #
        #     For example, if `partition_count` = 10 and `page_size` = 8, the first call
        #     to PartitionQuery will return up to 8 partitions and a `next_page_token`
        #     if more results exist. A second call to PartitionQuery will return up to
        #     2 partitions, to complete the total of 10 specified in `partition_count`.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Reads documents as they were at the given time.
        #
        #     This must be a microsecond precision timestamp within the past one hour,
        #     or if Point-in-Time Recovery is enabled, can additionally be a whole
        #     minute timestamp within the past 7 days.
        class PartitionQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#partition_query Firestore.PartitionQuery}.
        # @!attribute [rw] partitions
        #   @return [::Array<::Google::Cloud::Firestore::V1::Cursor>]
        #     Partition results.
        #     Each partition is a split point that can be used by RunQuery as a starting
        #     or end point for the query results. The RunQuery requests must be made with
        #     the same query supplied to this PartitionQuery request. The partition
        #     cursors will be ordered according to same ordering as the results of the
        #     query supplied to PartitionQuery.
        #
        #     For example, if a PartitionQuery request returns partition cursors A and B,
        #     running the following three queries will return the entire result set of
        #     the original query:
        #
        #      * query, end_at A
        #      * query, start_at A, end_at B
        #      * query, start_at B
        #
        #     An empty result may indicate that the query has too few results to be
        #     partitioned, or that the query is not yet supported for partitioning.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A page token that may be used to request an additional set of results, up
        #     to the number specified by `partition_count` in the PartitionQuery request.
        #     If blank, there are no more results.
        class PartitionQueryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::Firestore::V1::Firestore::Client#write Firestore.Write}.
        #
        # The first request creates a stream, or resumes an existing one from a token.
        #
        # When creating a new stream, the server replies with a response containing
        # only an ID and a token, to use in the next request.
        #
        # When resuming a stream, the server first streams any responses later than the
        # given token, then a response containing only an up-to-date token, to use in
        # the next request.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database name. In the format:
        #     `projects/{project_id}/databases/{database_id}`.
        #     This is only required in the first message.
        # @!attribute [rw] stream_id
        #   @return [::String]
        #     The ID of the write stream to resume.
        #     This may only be set in the first message. When left empty, a new write
        #     stream will be created.
        # @!attribute [rw] writes
        #   @return [::Array<::Google::Cloud::Firestore::V1::Write>]
        #     The writes to apply.
        #
        #     Always executed atomically and in order.
        #     This must be empty on the first request.
        #     This may be empty on the last request.
        #     This must not be empty on all other requests.
        # @!attribute [rw] stream_token
        #   @return [::String]
        #     A stream token that was previously sent by the server.
        #
        #     The client should set this field to the token from the most recent
        #     {::Google::Cloud::Firestore::V1::WriteResponse WriteResponse} it has received. This
        #     acknowledges that the client has received responses up to this token. After
        #     sending this token, earlier tokens may not be used anymore.
        #
        #     The server may close the stream if there are too many unacknowledged
        #     responses.
        #
        #     Leave this field unset when creating a new stream. To resume a stream at
        #     a specific point, set this field and the `stream_id` field.
        #
        #     Leave this field unset when creating a new stream.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this write request.
        class WriteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response for {::Google::Cloud::Firestore::V1::Firestore::Client#write Firestore.Write}.
        # @!attribute [rw] stream_id
        #   @return [::String]
        #     The ID of the stream.
        #     Only set on the first message, when a new stream was created.
        # @!attribute [rw] stream_token
        #   @return [::String]
        #     A token that represents the position of this response in the stream.
        #     This can be used by a client to resume the stream at this point.
        #
        #     This field is always set.
        # @!attribute [rw] write_results
        #   @return [::Array<::Google::Cloud::Firestore::V1::WriteResult>]
        #     The result of applying the writes.
        #
        #     This i-th write result corresponds to the i-th write in the
        #     request.
        # @!attribute [rw] commit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the commit occurred. Any read with an equal or greater
        #     `read_time` is guaranteed to see the effects of the write.
        class WriteResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request for {::Google::Cloud::Firestore::V1::Firestore::Client#listen Firestore.Listen}
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database name. In the format:
        #     `projects/{project_id}/databases/{database_id}`.
        # @!attribute [rw] add_target
        #   @return [::Google::Cloud::Firestore::V1::Target]
        #     A target to add to this stream.
        #
        #     Note: The following fields are mutually exclusive: `add_target`, `remove_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] remove_target
        #   @return [::Integer]
        #     The ID of a target to remove from this stream.
        #
        #     Note: The following fields are mutually exclusive: `remove_target`, `add_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this target change.
        class ListenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response for {::Google::Cloud::Firestore::V1::Firestore::Client#listen Firestore.Listen}.
        # @!attribute [rw] target_change
        #   @return [::Google::Cloud::Firestore::V1::TargetChange]
        #     Targets have changed.
        #
        #     Note: The following fields are mutually exclusive: `target_change`, `document_change`, `document_delete`, `document_remove`, `filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] document_change
        #   @return [::Google::Cloud::Firestore::V1::DocumentChange]
        #     A {::Google::Cloud::Firestore::V1::Document Document} has changed.
        #
        #     Note: The following fields are mutually exclusive: `document_change`, `target_change`, `document_delete`, `document_remove`, `filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] document_delete
        #   @return [::Google::Cloud::Firestore::V1::DocumentDelete]
        #     A {::Google::Cloud::Firestore::V1::Document Document} has been deleted.
        #
        #     Note: The following fields are mutually exclusive: `document_delete`, `target_change`, `document_change`, `document_remove`, `filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] document_remove
        #   @return [::Google::Cloud::Firestore::V1::DocumentRemove]
        #     A {::Google::Cloud::Firestore::V1::Document Document} has been removed from a target
        #     (because it is no longer relevant to that target).
        #
        #     Note: The following fields are mutually exclusive: `document_remove`, `target_change`, `document_change`, `document_delete`, `filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::Firestore::V1::ExistenceFilter]
        #     A filter to apply to the set of documents previously returned for the
        #     given target.
        #
        #     Returned when documents may have been removed from the given target, but
        #     the exact documents are unknown.
        #
        #     Note: The following fields are mutually exclusive: `filter`, `target_change`, `document_change`, `document_delete`, `document_remove`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ListenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A specification of a set of documents to listen to.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::Firestore::V1::Target::QueryTarget]
        #     A target specified by a query.
        #
        #     Note: The following fields are mutually exclusive: `query`, `documents`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] documents
        #   @return [::Google::Cloud::Firestore::V1::Target::DocumentsTarget]
        #     A target specified by a set of document names.
        #
        #     Note: The following fields are mutually exclusive: `documents`, `query`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] resume_token
        #   @return [::String]
        #     A resume token from a prior
        #     {::Google::Cloud::Firestore::V1::TargetChange TargetChange} for an identical target.
        #
        #     Using a resume token with a different target is unsupported and may fail.
        #
        #     Note: The following fields are mutually exclusive: `resume_token`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Start listening after a specific `read_time`.
        #
        #     The client must know the state of matching documents at this time.
        #
        #     Note: The following fields are mutually exclusive: `read_time`, `resume_token`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] target_id
        #   @return [::Integer]
        #     The target ID that identifies the target on the stream. Must be a positive
        #     number and non-zero.
        #
        #     If `target_id` is 0 (or unspecified), the server will assign an ID for this
        #     target and return that in a `TargetChange::ADD` event. Once a target with
        #     `target_id=0` is added, all subsequent targets must also have
        #     `target_id=0`. If an `AddTarget` request with `target_id != 0` is
        #     sent to the server after a target with `target_id=0` is added, the server
        #     will immediately send a response with a `TargetChange::Remove` event.
        #
        #     Note that if the client sends multiple `AddTarget` requests
        #     without an ID, the order of IDs returned in `TargetChange.target_ids` are
        #     undefined. Therefore, clients should provide a target ID instead of relying
        #     on the server to assign one.
        #
        #     If `target_id` is non-zero, there must not be an existing active target on
        #     this stream with the same ID.
        # @!attribute [rw] once
        #   @return [::Boolean]
        #     If the target should be removed once it is current and consistent.
        # @!attribute [rw] expected_count
        #   @return [::Google::Protobuf::Int32Value]
        #     The number of documents that last matched the query at the resume token or
        #     read time.
        #
        #     This value is only relevant when a `resume_type` is provided. This value
        #     being present and greater than zero signals that the client wants
        #     `ExistenceFilter.unchanged_names` to be included in the response.
        class Target
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A target specified by a set of documents names.
          # @!attribute [rw] documents
          #   @return [::Array<::String>]
          #     The names of the documents to retrieve. In the format:
          #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
          #     The request will fail if any of the document is not a child resource of
          #     the given `database`. Duplicate names will be elided.
          class DocumentsTarget
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A target specified by a query.
          # @!attribute [rw] parent
          #   @return [::String]
          #     The parent resource name. In the format:
          #     `projects/{project_id}/databases/{database_id}/documents` or
          #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
          #     For example:
          #     `projects/my-project/databases/my-database/documents` or
          #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
          # @!attribute [rw] structured_query
          #   @return [::Google::Cloud::Firestore::V1::StructuredQuery]
          #     A structured query.
          class QueryTarget
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Targets being watched have changed.
        # @!attribute [rw] target_change_type
        #   @return [::Google::Cloud::Firestore::V1::TargetChange::TargetChangeType]
        #     The type of change that occurred.
        # @!attribute [rw] target_ids
        #   @return [::Array<::Integer>]
        #     The target IDs of targets that have changed.
        #
        #     If empty, the change applies to all targets.
        #
        #     The order of the target IDs is not defined.
        # @!attribute [rw] cause
        #   @return [::Google::Rpc::Status]
        #     The error that resulted in this change, if applicable.
        # @!attribute [rw] resume_token
        #   @return [::String]
        #     A token that can be used to resume the stream for the given `target_ids`,
        #     or all targets if `target_ids` is empty.
        #
        #     Not set on every target change.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The consistent `read_time` for the given `target_ids` (omitted when the
        #     target_ids are not at a consistent snapshot).
        #
        #     The stream is guaranteed to send a `read_time` with `target_ids` empty
        #     whenever the entire stream reaches a new consistent snapshot. ADD,
        #     CURRENT, and RESET messages are guaranteed to (eventually) result in a
        #     new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
        #
        #     For a given stream, `read_time` is guaranteed to be monotonically
        #     increasing.
        class TargetChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of change.
          module TargetChangeType
            # No change has occurred. Used only to send an updated `resume_token`.
            NO_CHANGE = 0

            # The targets have been added.
            ADD = 1

            # The targets have been removed.
            REMOVE = 2

            # The targets reflect all changes committed before the targets were added
            # to the stream.
            #
            # This will be sent after or with a `read_time` that is greater than or
            # equal to the time at which the targets were added.
            #
            # Listeners can wait for this change if read-after-write semantics
            # are desired.
            CURRENT = 3

            # The targets have been reset, and a new initial state for the targets
            # will be returned in subsequent changes.
            #
            # After the initial state is complete, `CURRENT` will be returned even
            # if the target was previously indicated to be `CURRENT`.
            RESET = 4
          end
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#list_collection_ids Firestore.ListCollectionIds}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent document. In the format:
        #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
        #     For example:
        #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token. Must be a value from
        #     {::Google::Cloud::Firestore::V1::ListCollectionIdsResponse ListCollectionIdsResponse}.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Reads documents as they were at the given time.
        #
        #     This must be a microsecond precision timestamp within the past one hour,
        #     or if Point-in-Time Recovery is enabled, can additionally be a whole
        #     minute timestamp within the past 7 days.
        class ListCollectionIdsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from
        # {::Google::Cloud::Firestore::V1::Firestore::Client#list_collection_ids Firestore.ListCollectionIds}.
        # @!attribute [rw] collection_ids
        #   @return [::Array<::String>]
        #     The collection ids.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A page token that may be used to continue the list.
        class ListCollectionIdsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::Firestore::V1::Firestore::Client#batch_write Firestore.BatchWrite}.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. The database name. In the format:
        #     `projects/{project_id}/databases/{database_id}`.
        # @!attribute [rw] writes
        #   @return [::Array<::Google::Cloud::Firestore::V1::Write>]
        #     The writes to apply.
        #
        #     Method does not apply writes atomically and does not guarantee ordering.
        #     Each write succeeds or fails independently. You cannot write to the same
        #     document more than once per request.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this batch write.
        class BatchWriteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response from
        # {::Google::Cloud::Firestore::V1::Firestore::Client#batch_write Firestore.BatchWrite}.
        # @!attribute [rw] write_results
        #   @return [::Array<::Google::Cloud::Firestore::V1::WriteResult>]
        #     The result of applying the writes.
        #
        #     This i-th write result corresponds to the i-th write in the
        #     request.
        # @!attribute [rw] status
        #   @return [::Array<::Google::Rpc::Status>]
        #     The status of applying the writes.
        #
        #     This i-th write status corresponds to the i-th write in the
        #     request.
        class BatchWriteResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
