# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/firestore/v1/firestore_pb"
require "google/cloud/location"

module Google
  module Cloud
    module Firestore
      module V1
        module Firestore
          ##
          # Client for the Firestore service.
          #
          # The Cloud Firestore service.
          #
          # Cloud Firestore is a fast, fully managed, serverless, cloud-native NoSQL
          # document database that simplifies storing, syncing, and querying data for
          # your mobile, web, and IoT apps at global scale. Its client libraries provide
          # live synchronization and offline support, while its security features and
          # integrations with Firebase and Google Cloud Platform accelerate building
          # truly serverless apps.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "firestore.$UNIVERSE_DOMAIN$"

            # @private
            attr_reader :firestore_stub

            ##
            # Configure the Firestore Client class.
            #
            # See {::Google::Cloud::Firestore::V1::Firestore::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Firestore clients
            #   ::Google::Cloud::Firestore::V1::Firestore::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Firestore", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.get_document.timeout = 60.0
                default_config.rpcs.get_document.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.list_documents.timeout = 60.0
                default_config.rpcs.list_documents.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.update_document.timeout = 60.0
                default_config.rpcs.update_document.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14]
                }

                default_config.rpcs.delete_document.timeout = 60.0
                default_config.rpcs.delete_document.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.batch_get_documents.timeout = 300.0
                default_config.rpcs.batch_get_documents.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.begin_transaction.timeout = 60.0
                default_config.rpcs.begin_transaction.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.commit.timeout = 60.0
                default_config.rpcs.commit.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14]
                }

                default_config.rpcs.rollback.timeout = 60.0
                default_config.rpcs.rollback.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.run_query.timeout = 300.0
                default_config.rpcs.run_query.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.execute_pipeline.timeout = 300.0
                default_config.rpcs.execute_pipeline.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.run_aggregation_query.timeout = 300.0
                default_config.rpcs.run_aggregation_query.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.partition_query.timeout = 300.0
                default_config.rpcs.partition_query.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.write.timeout = 86_400.0

                default_config.rpcs.listen.timeout = 86_400.0
                default_config.rpcs.listen.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.list_collection_ids.timeout = 60.0
                default_config.rpcs.list_collection_ids.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 13, 4]
                }

                default_config.rpcs.batch_write.timeout = 60.0
                default_config.rpcs.batch_write.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14, 10]
                }

                default_config.rpcs.create_document.timeout = 60.0
                default_config.rpcs.create_document.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [8, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Firestore Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Firestore::V1::Firestore::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @firestore_stub.universe_domain
            end

            ##
            # Create a new Firestore client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Firestore client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/firestore/v1/firestore_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @firestore_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Firestore::V1::Firestore::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @firestore_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @firestore_stub.endpoint
                config.universe_domain = @firestore_stub.universe_domain
                config.logger = @firestore_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @firestore_stub.logger
            end

            # Service calls

            ##
            # Gets a single document.
            #
            # @overload get_document(request, options = nil)
            #   Pass arguments to `get_document` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::GetDocumentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::GetDocumentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_document(name: nil, mask: nil, transaction: nil, read_time: nil)
            #   Pass arguments to `get_document` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Document to get. In the format:
            #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
            #   @param mask [::Google::Cloud::Firestore::V1::DocumentMask, ::Hash]
            #     The fields to return. If not set, returns all fields.
            #
            #     If the document has a field that is not present in this mask, that field
            #     will not be returned in the response.
            #   @param transaction [::String]
            #     Reads the document in a transaction.
            #
            #     Note: The following parameters are mutually exclusive: `transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Reads the version of the document at the given time.
            #
            #     This must be a microsecond precision timestamp within the past one hour,
            #     or if Point-in-Time Recovery is enabled, can additionally be a whole
            #     minute timestamp within the past 7 days.
            #
            #     Note: The following parameters are mutually exclusive: `read_time`, `transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Firestore::V1::Document]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Firestore::V1::Document]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::GetDocumentRequest.new
            #
            #   # Call the get_document method.
            #   result = client.get_document request
            #
            #   # The returned object is of type Google::Cloud::Firestore::V1::Document.
            #   p result
            #
            def get_document request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::GetDocumentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_document.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_document.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_document.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :get_document, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists documents.
            #
            # @overload list_documents(request, options = nil)
            #   Pass arguments to `list_documents` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::ListDocumentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::ListDocumentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_documents(parent: nil, collection_id: nil, page_size: nil, page_token: nil, order_by: nil, mask: nil, transaction: nil, read_time: nil, show_missing: nil)
            #   Pass arguments to `list_documents` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name. In the format:
            #     `projects/{project_id}/databases/{database_id}/documents` or
            #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
            #
            #     For example:
            #     `projects/my-project/databases/my-database/documents` or
            #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
            #   @param collection_id [::String]
            #     Optional. The collection ID, relative to `parent`, to list.
            #
            #     For example: `chatrooms` or `messages`.
            #
            #     This is optional, and when not provided, Firestore will list documents
            #     from all collections under the provided `parent`.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of documents to return in a single response.
            #
            #     Firestore may return fewer than this value.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous `ListDocuments` response.
            #
            #     Provide this to retrieve the subsequent page. When paginating, all other
            #     parameters (with the exception of `page_size`) must match the values set
            #     in the request that generated the page token.
            #   @param order_by [::String]
            #     Optional. The optional ordering of the documents to return.
            #
            #     For example: `priority desc, __name__ desc`.
            #
            #     This mirrors the {::Google::Cloud::Firestore::V1::StructuredQuery#order_by `ORDER BY`}
            #     used in Firestore queries but in a string representation. When absent,
            #     documents are ordered based on `__name__ ASC`.
            #   @param mask [::Google::Cloud::Firestore::V1::DocumentMask, ::Hash]
            #     Optional. The fields to return. If not set, returns all fields.
            #
            #     If a document has a field that is not present in this mask, that field
            #     will not be returned in the response.
            #   @param transaction [::String]
            #     Perform the read as part of an already active transaction.
            #
            #     Note: The following parameters are mutually exclusive: `transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Perform the read at the provided time.
            #
            #     This must be a microsecond precision timestamp within the past one hour,
            #     or if Point-in-Time Recovery is enabled, can additionally be a whole
            #     minute timestamp within the past 7 days.
            #
            #     Note: The following parameters are mutually exclusive: `read_time`, `transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param show_missing [::Boolean]
            #     If the list should show missing documents.
            #
            #     A document is missing if it does not exist, but there are sub-documents
            #     nested underneath it. When true, such missing documents will be returned
            #     with a key but will not have fields,
            #     {::Google::Cloud::Firestore::V1::Document#create_time `create_time`}, or
            #     {::Google::Cloud::Firestore::V1::Document#update_time `update_time`} set.
            #
            #     Requests with `show_missing` may not specify `where` or `order_by`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Firestore::V1::Document>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Firestore::V1::Document>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::ListDocumentsRequest.new
            #
            #   # Call the list_documents method.
            #   result = client.list_documents request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Firestore::V1::Document.
            #     p item
            #   end
            #
            def list_documents request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::ListDocumentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_documents.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end
              if request.collection_id
                header_params["collection_id"] = request.collection_id
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_documents.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_documents.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :list_documents, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @firestore_stub, :list_documents, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates or inserts a document.
            #
            # @overload update_document(request, options = nil)
            #   Pass arguments to `update_document` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::UpdateDocumentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::UpdateDocumentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_document(document: nil, update_mask: nil, mask: nil, current_document: nil)
            #   Pass arguments to `update_document` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param document [::Google::Cloud::Firestore::V1::Document, ::Hash]
            #     Required. The updated document.
            #     Creates the document if it does not already exist.
            #   @param update_mask [::Google::Cloud::Firestore::V1::DocumentMask, ::Hash]
            #     The fields to update.
            #     None of the field paths in the mask may contain a reserved name.
            #
            #     If the document exists on the server and has fields not referenced in the
            #     mask, they are left unchanged.
            #     Fields referenced in the mask, but not present in the input document, are
            #     deleted from the document on the server.
            #   @param mask [::Google::Cloud::Firestore::V1::DocumentMask, ::Hash]
            #     The fields to return. If not set, returns all fields.
            #
            #     If the document has a field that is not present in this mask, that field
            #     will not be returned in the response.
            #   @param current_document [::Google::Cloud::Firestore::V1::Precondition, ::Hash]
            #     An optional precondition on the document.
            #     The request will fail if this is set and not met by the target document.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Firestore::V1::Document]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Firestore::V1::Document]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::UpdateDocumentRequest.new
            #
            #   # Call the update_document method.
            #   result = client.update_document request
            #
            #   # The returned object is of type Google::Cloud::Firestore::V1::Document.
            #   p result
            #
            def update_document request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::UpdateDocumentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_document.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.document&.name
                header_params["document.name"] = request.document.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_document.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_document.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :update_document, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a document.
            #
            # @overload delete_document(request, options = nil)
            #   Pass arguments to `delete_document` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::DeleteDocumentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::DeleteDocumentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_document(name: nil, current_document: nil)
            #   Pass arguments to `delete_document` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Document to delete. In the format:
            #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
            #   @param current_document [::Google::Cloud::Firestore::V1::Precondition, ::Hash]
            #     An optional precondition on the document.
            #     The request will fail if this is set and not met by the target document.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::DeleteDocumentRequest.new
            #
            #   # Call the delete_document method.
            #   result = client.delete_document request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_document request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::DeleteDocumentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_document.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_document.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_document.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :delete_document, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets multiple documents.
            #
            # Documents returned by this method are not guaranteed to be returned in the
            # same order that they were requested.
            #
            # @overload batch_get_documents(request, options = nil)
            #   Pass arguments to `batch_get_documents` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::BatchGetDocumentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::BatchGetDocumentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_get_documents(database: nil, documents: nil, mask: nil, transaction: nil, new_transaction: nil, read_time: nil)
            #   Pass arguments to `batch_get_documents` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. The database name. In the format:
            #     `projects/{project_id}/databases/{database_id}`.
            #   @param documents [::Array<::String>]
            #     The names of the documents to retrieve. In the format:
            #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
            #     The request will fail if any of the document is not a child resource of the
            #     given `database`. Duplicate names will be elided.
            #   @param mask [::Google::Cloud::Firestore::V1::DocumentMask, ::Hash]
            #     The fields to return. If not set, returns all fields.
            #
            #     If a document has a field that is not present in this mask, that field will
            #     not be returned in the response.
            #   @param transaction [::String]
            #     Reads documents in a transaction.
            #
            #     Note: The following parameters are mutually exclusive: `transaction`, `new_transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param new_transaction [::Google::Cloud::Firestore::V1::TransactionOptions, ::Hash]
            #     Starts a new transaction and reads the documents.
            #     Defaults to a read-only transaction.
            #     The new transaction ID will be returned as the first response in the
            #     stream.
            #
            #     Note: The following parameters are mutually exclusive: `new_transaction`, `transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Reads documents as they were at the given time.
            #
            #     This must be a microsecond precision timestamp within the past one hour,
            #     or if Point-in-Time Recovery is enabled, can additionally be a whole
            #     minute timestamp within the past 7 days.
            #
            #     Note: The following parameters are mutually exclusive: `read_time`, `transaction`, `new_transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::BatchGetDocumentsRequest.new
            #
            #   # Call the batch_get_documents method to start streaming.
            #   output = client.batch_get_documents request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Firestore::V1::BatchGetDocumentsResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def batch_get_documents request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::BatchGetDocumentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_get_documents.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                header_params["database"] = request.database
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_get_documents.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_get_documents.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :batch_get_documents, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Starts a new transaction.
            #
            # @overload begin_transaction(request, options = nil)
            #   Pass arguments to `begin_transaction` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::BeginTransactionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::BeginTransactionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload begin_transaction(database: nil, options: nil)
            #   Pass arguments to `begin_transaction` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. The database name. In the format:
            #     `projects/{project_id}/databases/{database_id}`.
            #   @param options [::Google::Cloud::Firestore::V1::TransactionOptions, ::Hash]
            #     The options for the transaction.
            #     Defaults to a read-write transaction.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Firestore::V1::BeginTransactionResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Firestore::V1::BeginTransactionResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::BeginTransactionRequest.new
            #
            #   # Call the begin_transaction method.
            #   result = client.begin_transaction request
            #
            #   # The returned object is of type Google::Cloud::Firestore::V1::BeginTransactionResponse.
            #   p result
            #
            def begin_transaction request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::BeginTransactionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.begin_transaction.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                header_params["database"] = request.database
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.begin_transaction.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.begin_transaction.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :begin_transaction, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Commits a transaction, while optionally updating documents.
            #
            # @overload commit(request, options = nil)
            #   Pass arguments to `commit` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::CommitRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::CommitRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload commit(database: nil, writes: nil, transaction: nil)
            #   Pass arguments to `commit` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. The database name. In the format:
            #     `projects/{project_id}/databases/{database_id}`.
            #   @param writes [::Array<::Google::Cloud::Firestore::V1::Write, ::Hash>]
            #     The writes to apply.
            #
            #     Always executed atomically and in order.
            #   @param transaction [::String]
            #     If set, applies all writes in this transaction, and commits it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Firestore::V1::CommitResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Firestore::V1::CommitResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::CommitRequest.new
            #
            #   # Call the commit method.
            #   result = client.commit request
            #
            #   # The returned object is of type Google::Cloud::Firestore::V1::CommitResponse.
            #   p result
            #
            def commit request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::CommitRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.commit.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                header_params["database"] = request.database
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.commit.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.commit.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :commit, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Rolls back a transaction.
            #
            # @overload rollback(request, options = nil)
            #   Pass arguments to `rollback` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::RollbackRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::RollbackRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rollback(database: nil, transaction: nil)
            #   Pass arguments to `rollback` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. The database name. In the format:
            #     `projects/{project_id}/databases/{database_id}`.
            #   @param transaction [::String]
            #     Required. The transaction to roll back.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::RollbackRequest.new
            #
            #   # Call the rollback method.
            #   result = client.rollback request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def rollback request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::RollbackRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rollback.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                header_params["database"] = request.database
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rollback.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rollback.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :rollback, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Runs a query.
            #
            # @overload run_query(request, options = nil)
            #   Pass arguments to `run_query` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::RunQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::RunQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload run_query(parent: nil, structured_query: nil, transaction: nil, new_transaction: nil, read_time: nil, explain_options: nil)
            #   Pass arguments to `run_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name. In the format:
            #     `projects/{project_id}/databases/{database_id}/documents` or
            #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
            #     For example:
            #     `projects/my-project/databases/my-database/documents` or
            #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
            #   @param structured_query [::Google::Cloud::Firestore::V1::StructuredQuery, ::Hash]
            #     A structured query.
            #   @param transaction [::String]
            #     Run the query within an already active transaction.
            #
            #     The value here is the opaque transaction ID to execute the query in.
            #
            #     Note: The following parameters are mutually exclusive: `transaction`, `new_transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param new_transaction [::Google::Cloud::Firestore::V1::TransactionOptions, ::Hash]
            #     Starts a new transaction and reads the documents.
            #     Defaults to a read-only transaction.
            #     The new transaction ID will be returned as the first response in the
            #     stream.
            #
            #     Note: The following parameters are mutually exclusive: `new_transaction`, `transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Reads documents as they were at the given time.
            #
            #     This must be a microsecond precision timestamp within the past one hour,
            #     or if Point-in-Time Recovery is enabled, can additionally be a whole
            #     minute timestamp within the past 7 days.
            #
            #     Note: The following parameters are mutually exclusive: `read_time`, `transaction`, `new_transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param explain_options [::Google::Cloud::Firestore::V1::ExplainOptions, ::Hash]
            #     Optional. Explain options for the query. If set, additional query
            #     statistics will be returned. If not, only query results will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Firestore::V1::RunQueryResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Firestore::V1::RunQueryResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::RunQueryRequest.new
            #
            #   # Call the run_query method to start streaming.
            #   output = client.run_query request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Firestore::V1::RunQueryResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def run_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::RunQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.run_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.run_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.run_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :run_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Executes a pipeline query.
            #
            # @overload execute_pipeline(request, options = nil)
            #   Pass arguments to `execute_pipeline` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::ExecutePipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::ExecutePipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload execute_pipeline(database: nil, structured_pipeline: nil, transaction: nil, new_transaction: nil, read_time: nil)
            #   Pass arguments to `execute_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. Database identifier, in the form
            #     `projects/{project}/databases/{database}`.
            #   @param structured_pipeline [::Google::Cloud::Firestore::V1::StructuredPipeline, ::Hash]
            #     A pipelined operation.
            #   @param transaction [::String]
            #     Run the query within an already active transaction.
            #
            #     The value here is the opaque transaction ID to execute the query in.
            #
            #     Note: The following parameters are mutually exclusive: `transaction`, `new_transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param new_transaction [::Google::Cloud::Firestore::V1::TransactionOptions, ::Hash]
            #     Execute the pipeline in a new transaction.
            #
            #     The identifier of the newly created transaction will be returned in the
            #     first response on the stream. This defaults to a read-only transaction.
            #
            #     Note: The following parameters are mutually exclusive: `new_transaction`, `transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Execute the pipeline in a snapshot transaction at the given time.
            #
            #     This must be a microsecond precision timestamp within the past one hour,
            #     or if Point-in-Time Recovery is enabled, can additionally be a whole
            #     minute timestamp within the past 7 days.
            #
            #     Note: The following parameters are mutually exclusive: `read_time`, `transaction`, `new_transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Firestore::V1::ExecutePipelineResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Firestore::V1::ExecutePipelineResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::ExecutePipelineRequest.new
            #
            #   # Call the execute_pipeline method to start streaming.
            #   output = client.execute_pipeline request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Firestore::V1::ExecutePipelineResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def execute_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::ExecutePipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.execute_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                regex_match = %r{^projects/(?<project_id>[^/]+)(?:/.*)?$}.match request.database
                if regex_match
                  header_params["project_id"] = regex_match["project_id".to_s]
                end
              end
              if request.database
                regex_match = %r{^projects/[^/]+/databases/(?<database_id>[^/]+)(?:/.*)?$}.match request.database
                if regex_match
                  header_params["database_id"] = regex_match["database_id".to_s]
                end
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.execute_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.execute_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :execute_pipeline, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Runs an aggregation query.
            #
            # Rather than producing {::Google::Cloud::Firestore::V1::Document Document} results like
            # {::Google::Cloud::Firestore::V1::Firestore::Client#run_query Firestore.RunQuery}, this API
            # allows running an aggregation to produce a series of
            # {::Google::Cloud::Firestore::V1::AggregationResult AggregationResult} server-side.
            #
            # High-Level Example:
            #
            # ```
            # -- Return the number of documents in table given a filter.
            # SELECT COUNT(*) FROM ( SELECT * FROM k where a = true );
            # ```
            #
            # @overload run_aggregation_query(request, options = nil)
            #   Pass arguments to `run_aggregation_query` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::RunAggregationQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::RunAggregationQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload run_aggregation_query(parent: nil, structured_aggregation_query: nil, transaction: nil, new_transaction: nil, read_time: nil, explain_options: nil)
            #   Pass arguments to `run_aggregation_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name. In the format:
            #     `projects/{project_id}/databases/{database_id}/documents` or
            #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
            #     For example:
            #     `projects/my-project/databases/my-database/documents` or
            #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
            #   @param structured_aggregation_query [::Google::Cloud::Firestore::V1::StructuredAggregationQuery, ::Hash]
            #     An aggregation query.
            #   @param transaction [::String]
            #     Run the aggregation within an already active transaction.
            #
            #     The value here is the opaque transaction ID to execute the query in.
            #
            #     Note: The following parameters are mutually exclusive: `transaction`, `new_transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param new_transaction [::Google::Cloud::Firestore::V1::TransactionOptions, ::Hash]
            #     Starts a new transaction as part of the query, defaulting to read-only.
            #
            #     The new transaction ID will be returned as the first response in the
            #     stream.
            #
            #     Note: The following parameters are mutually exclusive: `new_transaction`, `transaction`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Executes the query at the given timestamp.
            #
            #     This must be a microsecond precision timestamp within the past one hour,
            #     or if Point-in-Time Recovery is enabled, can additionally be a whole
            #     minute timestamp within the past 7 days.
            #
            #     Note: The following parameters are mutually exclusive: `read_time`, `transaction`, `new_transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param explain_options [::Google::Cloud::Firestore::V1::ExplainOptions, ::Hash]
            #     Optional. Explain options for the query. If set, additional query
            #     statistics will be returned. If not, only query results will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Firestore::V1::RunAggregationQueryResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Firestore::V1::RunAggregationQueryResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::RunAggregationQueryRequest.new
            #
            #   # Call the run_aggregation_query method to start streaming.
            #   output = client.run_aggregation_query request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Firestore::V1::RunAggregationQueryResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def run_aggregation_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::RunAggregationQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.run_aggregation_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.run_aggregation_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.run_aggregation_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :run_aggregation_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Partitions a query by returning partition cursors that can be used to run
            # the query in parallel. The returned partition cursors are split points that
            # can be used by RunQuery as starting/end points for the query results.
            #
            # @overload partition_query(request, options = nil)
            #   Pass arguments to `partition_query` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::PartitionQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::PartitionQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload partition_query(parent: nil, structured_query: nil, partition_count: nil, page_token: nil, page_size: nil, read_time: nil)
            #   Pass arguments to `partition_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name. In the format:
            #     `projects/{project_id}/databases/{database_id}/documents`.
            #     Document resource names are not supported; only database resource names
            #     can be specified.
            #   @param structured_query [::Google::Cloud::Firestore::V1::StructuredQuery, ::Hash]
            #     A structured query.
            #     Query must specify collection with all descendants and be ordered by name
            #     ascending. Other filters, order bys, limits, offsets, and start/end
            #     cursors are not supported.
            #   @param partition_count [::Integer]
            #     The desired maximum number of partition points.
            #     The partitions may be returned across multiple pages of results.
            #     The number must be positive. The actual number of partitions
            #     returned may be fewer.
            #
            #     For example, this may be set to one fewer than the number of parallel
            #     queries to be run, or in running a data pipeline job, one fewer than the
            #     number of workers or compute instances available.
            #   @param page_token [::String]
            #     The `next_page_token` value returned from a previous call to
            #     PartitionQuery that may be used to get an additional set of results.
            #     There are no ordering guarantees between sets of results. Thus, using
            #     multiple sets of results will require merging the different result sets.
            #
            #     For example, two subsequent calls using a page_token may return:
            #
            #      * cursor B, cursor M, cursor Q
            #      * cursor A, cursor U, cursor W
            #
            #     To obtain a complete result set ordered with respect to the results of the
            #     query supplied to PartitionQuery, the results sets should be merged:
            #     cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
            #   @param page_size [::Integer]
            #     The maximum number of partitions to return in this call, subject to
            #     `partition_count`.
            #
            #     For example, if `partition_count` = 10 and `page_size` = 8, the first call
            #     to PartitionQuery will return up to 8 partitions and a `next_page_token`
            #     if more results exist. A second call to PartitionQuery will return up to
            #     2 partitions, to complete the total of 10 specified in `partition_count`.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Reads documents as they were at the given time.
            #
            #     This must be a microsecond precision timestamp within the past one hour,
            #     or if Point-in-Time Recovery is enabled, can additionally be a whole
            #     minute timestamp within the past 7 days.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Firestore::V1::Cursor>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Firestore::V1::Cursor>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::PartitionQueryRequest.new
            #
            #   # Call the partition_query method.
            #   result = client.partition_query request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Firestore::V1::Cursor.
            #     p item
            #   end
            #
            def partition_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::PartitionQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.partition_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.partition_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.partition_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :partition_query, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @firestore_stub, :partition_query, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Streams batches of document updates and deletes, in order. This method is
            # only available via gRPC or WebChannel (not REST).
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::Firestore::V1::WriteRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::Firestore::V1::WriteRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Firestore::V1::WriteResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Firestore::V1::WriteResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the write method to start streaming.
            #   output = client.write input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::Firestore::V1::WriteRequest.new
            #   input << Google::Cloud::Firestore::V1::WriteRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Firestore::V1::WriteResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def write request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::Firestore::V1::WriteRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.write.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.write.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.write.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :write, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Listens to changes. This method is only available via gRPC or WebChannel
            # (not REST).
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::Firestore::V1::ListenRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::Firestore::V1::ListenRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Firestore::V1::ListenResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Firestore::V1::ListenResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the listen method to start streaming.
            #   output = client.listen input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::Firestore::V1::ListenRequest.new
            #   input << Google::Cloud::Firestore::V1::ListenRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Firestore::V1::ListenResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def listen request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::Firestore::V1::ListenRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.listen.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.listen.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.listen.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :listen, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all the collection IDs underneath a document.
            #
            # @overload list_collection_ids(request, options = nil)
            #   Pass arguments to `list_collection_ids` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::ListCollectionIdsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::ListCollectionIdsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_collection_ids(parent: nil, page_size: nil, page_token: nil, read_time: nil)
            #   Pass arguments to `list_collection_ids` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent document. In the format:
            #     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
            #     For example:
            #     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
            #   @param page_size [::Integer]
            #     The maximum number of results to return.
            #   @param page_token [::String]
            #     A page token. Must be a value from
            #     {::Google::Cloud::Firestore::V1::ListCollectionIdsResponse ListCollectionIdsResponse}.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Reads documents as they were at the given time.
            #
            #     This must be a microsecond precision timestamp within the past one hour,
            #     or if Point-in-Time Recovery is enabled, can additionally be a whole
            #     minute timestamp within the past 7 days.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Firestore::V1::ListCollectionIdsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Firestore::V1::ListCollectionIdsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::ListCollectionIdsRequest.new
            #
            #   # Call the list_collection_ids method.
            #   result = client.list_collection_ids request
            #
            #   # The returned object is of type Google::Cloud::Firestore::V1::ListCollectionIdsResponse.
            #   p result
            #
            def list_collection_ids request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::ListCollectionIdsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_collection_ids.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_collection_ids.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_collection_ids.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :list_collection_ids, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Applies a batch of write operations.
            #
            # The BatchWrite method does not apply the write operations atomically
            # and can apply them out of order. Method does not allow more than one write
            # per document. Each write succeeds or fails independently. See the
            # {::Google::Cloud::Firestore::V1::BatchWriteResponse BatchWriteResponse} for the
            # success status of each write.
            #
            # If you require an atomically applied set of writes, use
            # {::Google::Cloud::Firestore::V1::Firestore::Client#commit Commit} instead.
            #
            # @overload batch_write(request, options = nil)
            #   Pass arguments to `batch_write` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::BatchWriteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::BatchWriteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_write(database: nil, writes: nil, labels: nil)
            #   Pass arguments to `batch_write` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. The database name. In the format:
            #     `projects/{project_id}/databases/{database_id}`.
            #   @param writes [::Array<::Google::Cloud::Firestore::V1::Write, ::Hash>]
            #     The writes to apply.
            #
            #     Method does not apply writes atomically and does not guarantee ordering.
            #     Each write succeeds or fails independently. You cannot write to the same
            #     document more than once per request.
            #   @param labels [::Hash{::String => ::String}]
            #     Labels associated with this batch write.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Firestore::V1::BatchWriteResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Firestore::V1::BatchWriteResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::BatchWriteRequest.new
            #
            #   # Call the batch_write method.
            #   result = client.batch_write request
            #
            #   # The returned object is of type Google::Cloud::Firestore::V1::BatchWriteResponse.
            #   p result
            #
            def batch_write request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::BatchWriteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_write.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                header_params["database"] = request.database
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_write.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_write.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :batch_write, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new document.
            #
            # @overload create_document(request, options = nil)
            #   Pass arguments to `create_document` via a request object, either of type
            #   {::Google::Cloud::Firestore::V1::CreateDocumentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Firestore::V1::CreateDocumentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_document(parent: nil, collection_id: nil, document_id: nil, document: nil, mask: nil)
            #   Pass arguments to `create_document` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource. For example:
            #     `projects/{project_id}/databases/{database_id}/documents` or
            #     `projects/{project_id}/databases/{database_id}/documents/chatrooms/{chatroom_id}`
            #   @param collection_id [::String]
            #     Required. The collection ID, relative to `parent`, to list. For example:
            #     `chatrooms`.
            #   @param document_id [::String]
            #     The client-assigned document ID to use for this document.
            #
            #     Optional. If not specified, an ID will be assigned by the service.
            #   @param document [::Google::Cloud::Firestore::V1::Document, ::Hash]
            #     Required. The document to create. `name` must not be set.
            #   @param mask [::Google::Cloud::Firestore::V1::DocumentMask, ::Hash]
            #     The fields to return. If not set, returns all fields.
            #
            #     If the document has a field that is not present in this mask, that field
            #     will not be returned in the response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Firestore::V1::Document]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Firestore::V1::Document]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/firestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Firestore::V1::Firestore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Firestore::V1::CreateDocumentRequest.new
            #
            #   # Call the create_document method.
            #   result = client.create_document request
            #
            #   # The returned object is of type Google::Cloud::Firestore::V1::Document.
            #   p result
            #
            def create_document request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::V1::CreateDocumentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_document.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Firestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end
              if request.collection_id
                header_params["collection_id"] = request.collection_id
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_document.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_document.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @firestore_stub.call_rpc :create_document, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Firestore API.
            #
            # This class represents the configuration for Firestore,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Firestore::V1::Firestore::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_document to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Firestore::V1::Firestore::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_document.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_document.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Firestore::V1::Firestore::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "firestore.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Firestore API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_document`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_document
                ##
                # RPC-specific configuration for `list_documents`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_documents
                ##
                # RPC-specific configuration for `update_document`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_document
                ##
                # RPC-specific configuration for `delete_document`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_document
                ##
                # RPC-specific configuration for `batch_get_documents`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_get_documents
                ##
                # RPC-specific configuration for `begin_transaction`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :begin_transaction
                ##
                # RPC-specific configuration for `commit`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :commit
                ##
                # RPC-specific configuration for `rollback`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rollback
                ##
                # RPC-specific configuration for `run_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :run_query
                ##
                # RPC-specific configuration for `execute_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :execute_pipeline
                ##
                # RPC-specific configuration for `run_aggregation_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :run_aggregation_query
                ##
                # RPC-specific configuration for `partition_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :partition_query
                ##
                # RPC-specific configuration for `write`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :write
                ##
                # RPC-specific configuration for `listen`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :listen
                ##
                # RPC-specific configuration for `list_collection_ids`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_collection_ids
                ##
                # RPC-specific configuration for `batch_write`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_write
                ##
                # RPC-specific configuration for `create_document`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_document

                # @private
                def initialize parent_rpcs = nil
                  get_document_config = parent_rpcs.get_document if parent_rpcs.respond_to? :get_document
                  @get_document = ::Gapic::Config::Method.new get_document_config
                  list_documents_config = parent_rpcs.list_documents if parent_rpcs.respond_to? :list_documents
                  @list_documents = ::Gapic::Config::Method.new list_documents_config
                  update_document_config = parent_rpcs.update_document if parent_rpcs.respond_to? :update_document
                  @update_document = ::Gapic::Config::Method.new update_document_config
                  delete_document_config = parent_rpcs.delete_document if parent_rpcs.respond_to? :delete_document
                  @delete_document = ::Gapic::Config::Method.new delete_document_config
                  batch_get_documents_config = parent_rpcs.batch_get_documents if parent_rpcs.respond_to? :batch_get_documents
                  @batch_get_documents = ::Gapic::Config::Method.new batch_get_documents_config
                  begin_transaction_config = parent_rpcs.begin_transaction if parent_rpcs.respond_to? :begin_transaction
                  @begin_transaction = ::Gapic::Config::Method.new begin_transaction_config
                  commit_config = parent_rpcs.commit if parent_rpcs.respond_to? :commit
                  @commit = ::Gapic::Config::Method.new commit_config
                  rollback_config = parent_rpcs.rollback if parent_rpcs.respond_to? :rollback
                  @rollback = ::Gapic::Config::Method.new rollback_config
                  run_query_config = parent_rpcs.run_query if parent_rpcs.respond_to? :run_query
                  @run_query = ::Gapic::Config::Method.new run_query_config
                  execute_pipeline_config = parent_rpcs.execute_pipeline if parent_rpcs.respond_to? :execute_pipeline
                  @execute_pipeline = ::Gapic::Config::Method.new execute_pipeline_config
                  run_aggregation_query_config = parent_rpcs.run_aggregation_query if parent_rpcs.respond_to? :run_aggregation_query
                  @run_aggregation_query = ::Gapic::Config::Method.new run_aggregation_query_config
                  partition_query_config = parent_rpcs.partition_query if parent_rpcs.respond_to? :partition_query
                  @partition_query = ::Gapic::Config::Method.new partition_query_config
                  write_config = parent_rpcs.write if parent_rpcs.respond_to? :write
                  @write = ::Gapic::Config::Method.new write_config
                  listen_config = parent_rpcs.listen if parent_rpcs.respond_to? :listen
                  @listen = ::Gapic::Config::Method.new listen_config
                  list_collection_ids_config = parent_rpcs.list_collection_ids if parent_rpcs.respond_to? :list_collection_ids
                  @list_collection_ids = ::Gapic::Config::Method.new list_collection_ids_config
                  batch_write_config = parent_rpcs.batch_write if parent_rpcs.respond_to? :batch_write
                  @batch_write = ::Gapic::Config::Method.new batch_write_config
                  create_document_config = parent_rpcs.create_document if parent_rpcs.respond_to? :create_document
                  @create_document = ::Gapic::Config::Method.new create_document_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
