# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Firestore
      module Admin
        module V1
          # A Cloud Firestore User Creds.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the UserCreds.
          #     Format:
          #     `projects/{project}/databases/{database}/userCreds/{user_creds}`
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the user creds were created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the user creds were last updated.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Firestore::Admin::V1::UserCreds::State]
          #     Output only. Whether the user creds are enabled or disabled. Defaults to
          #     ENABLED on creation.
          # @!attribute [r] secure_password
          #   @return [::String]
          #     Output only. The plaintext server-generated password for the user creds.
          #     Only populated in responses for CreateUserCreds and ResetUserPassword.
          # @!attribute [rw] resource_identity
          #   @return [::Google::Cloud::Firestore::Admin::V1::UserCreds::ResourceIdentity]
          #     Resource Identity descriptor.
          class UserCreds
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes a Resource Identity principal.
            # @!attribute [r] principal
            #   @return [::String]
            #     Output only. Principal identifier string.
            #     See: https://cloud.google.com/iam/docs/principal-identifiers
            class ResourceIdentity
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The state of the user creds (ENABLED or DISABLED).
            module State
              # The default value. Should not be used.
              STATE_UNSPECIFIED = 0

              # The user creds are enabled.
              ENABLED = 1

              # The user creds are disabled.
              DISABLED = 2
            end
          end
        end
      end
    end
  end
end
