# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Firestore
      module Admin
        module V1
          # A consistent snapshot of a database at a specific point in time.
          # A PITR (Point-in-time recovery) snapshot with previous versions of a
          # database's data is available for every minute up to the associated database's
          # data retention period. If the PITR feature is enabled, the retention period
          # is 7 days; otherwise, it is one hour.
          # @!attribute [rw] database
          #   @return [::String]
          #     Required. The name of the database that this was a snapshot of. Format:
          #     `projects/{project}/databases/{database}`.
          # @!attribute [r] database_uid
          #   @return [::String]
          #     Output only. Public UUID of the database the snapshot was associated with.
          # @!attribute [rw] snapshot_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. Snapshot time of the database.
          class PitrSnapshot
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
