# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Firestore
      module Admin
        module V1
          # A backup schedule for a Cloud Firestore Database.
          #
          # This resource is owned by the database it is backing up, and is deleted along
          # with the database. The actual backups are not though.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The unique backup schedule identifier across all locations and
          #     databases for the given project.
          #
          #     This will be auto-assigned.
          #
          #     Format is
          #     `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp at which this backup schedule was created and
          #     effective since.
          #
          #     No backups will be created for this schedule before this time.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp at which this backup schedule was most recently
          #     updated. When a backup schedule is first created, this is the same as
          #     create_time.
          # @!attribute [rw] retention
          #   @return [::Google::Protobuf::Duration]
          #     At what relative time in the future, compared to its creation time,
          #     the backup should be deleted, e.g. keep backups for 7 days.
          #
          #     The maximum supported retention period is 14 weeks.
          # @!attribute [rw] daily_recurrence
          #   @return [::Google::Cloud::Firestore::Admin::V1::DailyRecurrence]
          #     For a schedule that runs daily.
          #
          #     Note: The following fields are mutually exclusive: `daily_recurrence`, `weekly_recurrence`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] weekly_recurrence
          #   @return [::Google::Cloud::Firestore::Admin::V1::WeeklyRecurrence]
          #     For a schedule that runs weekly on a specific day.
          #
          #     Note: The following fields are mutually exclusive: `weekly_recurrence`, `daily_recurrence`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class BackupSchedule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a recurring schedule that runs every day.
          #
          # The time zone is UTC.
          class DailyRecurrence
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a recurring schedule that runs on a specified day of the week.
          #
          # The time zone is UTC.
          # @!attribute [rw] day
          #   @return [::Google::Type::DayOfWeek]
          #     The day of week to run.
          #
          #     DAY_OF_WEEK_UNSPECIFIED is not allowed.
          class WeeklyRecurrence
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
