# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Firestore
      module Admin
        module V1
          # A request to list the Firestore Databases in all locations for a project.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. A parent name of the form
          #     `projects/{project_id}`
          # @!attribute [rw] show_deleted
          #   @return [::Boolean]
          #     If true, also returns deleted resources.
          class ListDatabasesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#create_database FirestoreAdmin.CreateDatabase}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. A parent name of the form
          #     `projects/{project_id}`
          # @!attribute [rw] database
          #   @return [::Google::Cloud::Firestore::Admin::V1::Database]
          #     Required. The Database to create.
          # @!attribute [rw] database_id
          #   @return [::String]
          #     Required. The ID to use for the database, which will become the final
          #     component of the database's resource name.
          #
          #     This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
          #     with first character a letter and the last a letter or a number. Must not
          #     be UUID-like /[0-9a-f]\\{8}(-[0-9a-f]\\{4})\\{3}-[0-9a-f]\\{12}/.
          #
          #     "(default)" database ID is also valid.
          class CreateDatabaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata related to the create database operation.
          class CreateDatabaseMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The list of databases for a project.
          # @!attribute [rw] databases
          #   @return [::Array<::Google::Cloud::Firestore::Admin::V1::Database>]
          #     The databases in the project.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     In the event that data about individual databases cannot be listed they
          #     will be recorded here.
          #
          #     An example entry might be: projects/some_project/locations/some_location
          #     This can happen if the Cloud Region that the Database resides in is
          #     currently unavailable.  In this case we can't fetch all the details about
          #     the database. You may be able to get a more detailed error message
          #     (or possibly fetch the resource) by sending a 'Get' request for the
          #     resource or a 'List' request for the specific location.
          class ListDatabasesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#get_database FirestoreAdmin.GetDatabase}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}`
          class GetDatabaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#update_database FirestoreAdmin.UpdateDatabase}.
          # @!attribute [rw] database
          #   @return [::Google::Cloud::Firestore::Admin::V1::Database]
          #     Required. The database to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The list of fields to be updated.
          class UpdateDatabaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata related to the update database operation.
          class UpdateDatabaseMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#delete_database FirestoreAdmin.DeleteDatabase}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}`
          # @!attribute [rw] etag
          #   @return [::String]
          #     The current etag of the Database.
          #     If an etag is provided and does not match the current etag of the database,
          #     deletion will be blocked and a FAILED_PRECONDITION error will be returned.
          class DeleteDatabaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata related to the delete database operation.
          class DeleteDatabaseMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#create_user_creds FirestoreAdmin.CreateUserCreds}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. A parent name of the form
          #     `projects/{project_id}/databases/{database_id}`
          # @!attribute [rw] user_creds
          #   @return [::Google::Cloud::Firestore::Admin::V1::UserCreds]
          #     Required. The user creds to create.
          # @!attribute [rw] user_creds_id
          #   @return [::String]
          #     Required. The ID to use for the user creds, which will become the final
          #     component of the user creds's resource name.
          #
          #     This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
          #     with first character a letter and the last a letter or a number. Must not
          #     be UUID-like /[0-9a-f]\\{8}(-[0-9a-f]\\{4})\\{3}-[0-9a-f]\\{12}/.
          class CreateUserCredsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#get_user_creds FirestoreAdmin.GetUserCreds}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
          class GetUserCredsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_user_creds FirestoreAdmin.ListUserCreds}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. A parent database name of the form
          #     `projects/{project_id}/databases/{database_id}`
          class ListUserCredsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_user_creds FirestoreAdmin.ListUserCreds}.
          # @!attribute [rw] user_creds
          #   @return [::Array<::Google::Cloud::Firestore::Admin::V1::UserCreds>]
          #     The user creds for the database.
          class ListUserCredsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#enable_user_creds FirestoreAdmin.EnableUserCreds}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
          class EnableUserCredsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#disable_user_creds FirestoreAdmin.DisableUserCreds}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
          class DisableUserCredsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#reset_user_password FirestoreAdmin.ResetUserPassword}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
          class ResetUserPasswordRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#delete_user_creds FirestoreAdmin.DeleteUserCreds}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
          class DeleteUserCredsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#create_backup_schedule FirestoreAdmin.CreateBackupSchedule}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent database.
          #
          #      Format `projects/{project}/databases/{database}`
          # @!attribute [rw] backup_schedule
          #   @return [::Google::Cloud::Firestore::Admin::V1::BackupSchedule]
          #     Required. The backup schedule to create.
          class CreateBackupScheduleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#get_backup_schedule FirestoreAdmin.GetBackupSchedule}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the backup schedule.
          #
          #     Format
          #     `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
          class GetBackupScheduleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#update_backup_schedule FirestoreAdmin.UpdateBackupSchedule}.
          # @!attribute [rw] backup_schedule
          #   @return [::Google::Cloud::Firestore::Admin::V1::BackupSchedule]
          #     Required. The backup schedule to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The list of fields to be updated.
          class UpdateBackupScheduleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_backup_schedules FirestoreAdmin.ListBackupSchedules}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent database.
          #
          #     Format is `projects/{project}/databases/{database}`.
          class ListBackupSchedulesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_backup_schedules FirestoreAdmin.ListBackupSchedules}.
          # @!attribute [rw] backup_schedules
          #   @return [::Array<::Google::Cloud::Firestore::Admin::V1::BackupSchedule>]
          #     List of all backup schedules.
          class ListBackupSchedulesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for [FirestoreAdmin.DeleteBackupSchedules][].
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the backup schedule.
          #
          #     Format
          #     `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
          class DeleteBackupScheduleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#create_index FirestoreAdmin.CreateIndex}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. A parent name of the form
          #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
          # @!attribute [rw] index
          #   @return [::Google::Cloud::Firestore::Admin::V1::Index]
          #     Required. The composite index to create.
          class CreateIndexRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_indexes FirestoreAdmin.ListIndexes}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. A parent name of the form
          #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
          # @!attribute [rw] filter
          #   @return [::String]
          #     The filter to apply to list results.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The number of results to return.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A page token, returned from a previous call to
          #     {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_indexes FirestoreAdmin.ListIndexes},
          #     that may be used to get the next page of results.
          class ListIndexesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_indexes FirestoreAdmin.ListIndexes}.
          # @!attribute [rw] indexes
          #   @return [::Array<::Google::Cloud::Firestore::Admin::V1::Index>]
          #     The requested indexes.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A page token that may be used to request another page of results. If blank,
          #     this is the last page.
          class ListIndexesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#get_index FirestoreAdmin.GetIndex}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
          class GetIndexRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#delete_index FirestoreAdmin.DeleteIndex}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
          class DeleteIndexRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#update_field FirestoreAdmin.UpdateField}.
          # @!attribute [rw] field
          #   @return [::Google::Cloud::Firestore::Admin::V1::Field]
          #     Required. The field to be updated.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     A mask, relative to the field. If specified, only configuration specified
          #     by this field_mask will be updated in the field.
          class UpdateFieldRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#get_field FirestoreAdmin.GetField}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. A name of the form
          #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_id}`
          class GetFieldRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_fields FirestoreAdmin.ListFields}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. A parent name of the form
          #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
          # @!attribute [rw] filter
          #   @return [::String]
          #     The filter to apply to list results. Currently,
          #     {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_fields FirestoreAdmin.ListFields}
          #     only supports listing fields that have been explicitly overridden. To issue
          #     this query, call
          #     {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_fields FirestoreAdmin.ListFields}
          #     with a filter that includes `indexConfig.usesAncestorConfig:false` or
          #     `ttlConfig:*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The number of results to return.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A page token, returned from a previous call to
          #     {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_fields FirestoreAdmin.ListFields},
          #     that may be used to get the next page of results.
          class ListFieldsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_fields FirestoreAdmin.ListFields}.
          # @!attribute [rw] fields
          #   @return [::Array<::Google::Cloud::Firestore::Admin::V1::Field>]
          #     The requested fields.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A page token that may be used to request another page of results. If blank,
          #     this is the last page.
          class ListFieldsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#export_documents FirestoreAdmin.ExportDocuments}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Database to export. Should be of the form:
          #     `projects/{project_id}/databases/{database_id}`.
          # @!attribute [rw] collection_ids
          #   @return [::Array<::String>]
          #     Which collection IDs to export. Unspecified means all collections. Each
          #     collection ID in this list must be unique.
          # @!attribute [rw] output_uri_prefix
          #   @return [::String]
          #     The output URI. Currently only supports Google Cloud Storage URIs of the
          #     form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
          #     of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
          #     Google Cloud Storage namespace path. When
          #     choosing a name, be sure to consider Google Cloud Storage naming
          #     guidelines: https://cloud.google.com/storage/docs/naming.
          #     If the URI is a bucket (without a namespace path), a prefix will be
          #     generated based on the start time.
          # @!attribute [rw] namespace_ids
          #   @return [::Array<::String>]
          #     An empty list represents all namespaces. This is the preferred
          #     usage for databases that don't use namespaces.
          #
          #     An empty string element represents the default namespace. This should be
          #     used if the database has data in non-default namespaces, but doesn't want
          #     to include them. Each namespace in this list must be unique.
          # @!attribute [rw] snapshot_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp that corresponds to the version of the database to be
          #     exported. The timestamp must be in the past, rounded to the minute and not
          #     older than
          #     {::Google::Cloud::Firestore::Admin::V1::Database#earliest_version_time earliestVersionTime}.
          #     If specified, then the exported documents will represent a consistent view
          #     of the database at the provided time. Otherwise, there are no guarantees
          #     about the consistency of the exported documents.
          class ExportDocumentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#import_documents FirestoreAdmin.ImportDocuments}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Database to import into. Should be of the form:
          #     `projects/{project_id}/databases/{database_id}`.
          # @!attribute [rw] collection_ids
          #   @return [::Array<::String>]
          #     Which collection IDs to import. Unspecified means all collections included
          #     in the import. Each collection ID in this list must be unique.
          # @!attribute [rw] input_uri_prefix
          #   @return [::String]
          #     Location of the exported files.
          #     This must match the output_uri_prefix of an ExportDocumentsResponse from
          #     an export that has completed successfully.
          #     See:
          #     {::Google::Cloud::Firestore::Admin::V1::ExportDocumentsResponse#output_uri_prefix google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix}.
          # @!attribute [rw] namespace_ids
          #   @return [::Array<::String>]
          #     An empty list represents all namespaces. This is the preferred
          #     usage for databases that don't use namespaces.
          #
          #     An empty string element represents the default namespace. This should be
          #     used if the database has data in non-default namespaces, but doesn't want
          #     to include them. Each namespace in this list must be unique.
          class ImportDocumentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#bulk_delete_documents FirestoreAdmin.BulkDeleteDocuments}.
          #
          # When both collection_ids and namespace_ids are set, only documents satisfying
          # both conditions will be deleted.
          #
          # Requests with namespace_ids and collection_ids both empty will be rejected.
          # Please use
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#delete_database FirestoreAdmin.DeleteDatabase}
          # instead.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Database to operate. Should be of the form:
          #     `projects/{project_id}/databases/{database_id}`.
          # @!attribute [rw] collection_ids
          #   @return [::Array<::String>]
          #     Optional. IDs of the collection groups to delete. Unspecified means all
          #     collection groups.
          #
          #     Each collection group in this list must be unique.
          # @!attribute [rw] namespace_ids
          #   @return [::Array<::String>]
          #     Optional. Namespaces to delete.
          #
          #     An empty list means all namespaces. This is the recommended
          #     usage for databases that don't use namespaces.
          #
          #     An empty string element represents the default namespace. This should be
          #     used if the database has data in non-default namespaces, but doesn't want
          #     to delete from them.
          #
          #     Each namespace in this list must be unique.
          class BulkDeleteDocumentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#bulk_delete_documents FirestoreAdmin.BulkDeleteDocuments}.
          class BulkDeleteDocumentsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#get_backup FirestoreAdmin.GetBackup}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the backup to fetch.
          #
          #     Format is `projects/{project}/locations/{location}/backups/{backup}`.
          class GetBackupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_backups FirestoreAdmin.ListBackups}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The location to list backups from.
          #
          #     Format is `projects/{project}/locations/{location}`.
          #     Use `{location} = '-'` to list backups from all locations for the given
          #     project. This allows listing backups from a single location or from all
          #     locations.
          # @!attribute [rw] filter
          #   @return [::String]
          #     An expression that filters the list of returned backups.
          #
          #     A filter expression consists of a field name, a comparison operator, and a
          #     value for filtering.
          #     The value must be a string, a number, or a boolean. The comparison operator
          #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
          #     Colon `:` is the contains operator. Filter rules are not case sensitive.
          #
          #     The following fields in the {::Google::Cloud::Firestore::Admin::V1::Backup Backup} are
          #     eligible for filtering:
          #
          #       * `database_uid` (supports `=` only)
          class ListBackupsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#list_backups FirestoreAdmin.ListBackups}.
          # @!attribute [rw] backups
          #   @return [::Array<::Google::Cloud::Firestore::Admin::V1::Backup>]
          #     List of all backups for the project.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     List of locations that existing backups were not able to be fetched from.
          #
          #     Instead of failing the entire requests when a single location is
          #     unreachable, this response returns a partial result set and list of
          #     locations unable to be reached here. The request can be retried against a
          #     single location to get a concrete error.
          class ListBackupsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#delete_backup FirestoreAdmin.DeleteBackup}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the backup to delete.
          #
          #     format is `projects/{project}/locations/{location}/backups/{backup}`.
          class DeleteBackupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#restore_database FirestoreAdmin.RestoreDatabase}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The project to restore the database in. Format is
          #     `projects/{project_id}`.
          # @!attribute [rw] database_id
          #   @return [::String]
          #     Required. The ID to use for the database, which will become the final
          #     component of the database's resource name. This database ID must not be
          #     associated with an existing database.
          #
          #     This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
          #     with first character a letter and the last a letter or a number. Must not
          #     be UUID-like /[0-9a-f]\\{8}(-[0-9a-f]\\{4})\\{3}-[0-9a-f]\\{12}/.
          #
          #     "(default)" database ID is also valid.
          # @!attribute [rw] backup
          #   @return [::String]
          #     Required. Backup to restore from. Must be from the same project as the
          #     parent.
          #
          #     The restored database will be created in the same location as the source
          #     backup.
          #
          #     Format is: `projects/{project_id}/locations/{location}/backups/{backup}`
          # @!attribute [rw] encryption_config
          #   @return [::Google::Cloud::Firestore::Admin::V1::Database::EncryptionConfig]
          #     Optional. Encryption configuration for the restored database.
          #
          #     If this field is not specified, the restored database will use
          #     the same encryption configuration as the backup, namely
          #     {::Google::Cloud::Firestore::Admin::V1::Database::EncryptionConfig#use_source_encryption use_source_encryption}.
          # @!attribute [rw] tags
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Immutable. Tags to be bound to the restored database.
          #
          #     The tags should be provided in the format of
          #     `tagKeys/{tag_key_id} -> tagValues/{tag_value_id}`.
          class RestoreDatabaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class TagsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The request message for
          # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Client#clone_database FirestoreAdmin.CloneDatabase}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The project to clone the database in. Format is
          #     `projects/{project_id}`.
          # @!attribute [rw] database_id
          #   @return [::String]
          #     Required. The ID to use for the database, which will become the final
          #     component of the database's resource name. This database ID must not be
          #     associated with an existing database.
          #
          #     This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
          #     with first character a letter and the last a letter or a number. Must not
          #     be UUID-like /[0-9a-f]\\{8}(-[0-9a-f]\\{4})\\{3}-[0-9a-f]\\{12}/.
          #
          #     "(default)" database ID is also valid.
          # @!attribute [rw] pitr_snapshot
          #   @return [::Google::Cloud::Firestore::Admin::V1::PitrSnapshot]
          #     Required. Specification of the PITR data to clone from. The source database
          #     must exist.
          #
          #     The cloned database will be created in the same location as the source
          #     database.
          # @!attribute [rw] encryption_config
          #   @return [::Google::Cloud::Firestore::Admin::V1::Database::EncryptionConfig]
          #     Optional. Encryption configuration for the cloned database.
          #
          #     If this field is not specified, the cloned database will use
          #     the same encryption configuration as the source database, namely
          #     {::Google::Cloud::Firestore::Admin::V1::Database::EncryptionConfig#use_source_encryption use_source_encryption}.
          # @!attribute [rw] tags
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Immutable. Tags to be bound to the cloned database.
          #
          #     The tags should be provided in the format of
          #     `tagKeys/{tag_key_id} -> tagValues/{tag_value_id}`.
          class CloneDatabaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class TagsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
