# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/firestore/admin/v1/firestore_admin_pb"
require "google/cloud/firestore/admin/v1/firestore_admin/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Firestore
      module Admin
        module V1
          module FirestoreAdmin
            module Rest
              ##
              # REST client for the FirestoreAdmin service.
              #
              # The Cloud Firestore Admin API.
              #
              # This API provides several administrative services for Cloud Firestore.
              #
              # Project, Database, Namespace, Collection, Collection Group, and Document are
              # used as defined in the Google Cloud Firestore API.
              #
              # Operation: An Operation represents work being performed in the background.
              #
              # The index service manages Cloud Firestore indexes.
              #
              # Index creation is performed asynchronously.
              # An Operation resource is created for each such asynchronous operation.
              # The state of the operation (including any errors encountered)
              # may be queried via the Operation resource.
              #
              # The Operations collection provides a record of actions performed for the
              # specified Project (including any Operations in progress). Operations are not
              # created directly but through calls on other collections or resources.
              #
              # An Operation that is done may be deleted so that it is no longer listed as
              # part of the Operation collection. Operations are garbage collected after
              # 30 days. By default, ListOperations will only return in progress and failed
              # operations. To list completed operation, issue a ListOperations request with
              # the filter `done: true`.
              #
              # Operations are created by service `FirestoreAdmin`, but are accessed via
              # service `google.longrunning.Operations`.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "firestore.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :firestore_admin_stub

                ##
                # Configure the FirestoreAdmin Client class.
                #
                # See {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all FirestoreAdmin clients
                #   ::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Firestore", "Admin", "V1"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.create_index.timeout = 60.0

                    default_config.rpcs.list_indexes.timeout = 60.0
                    default_config.rpcs.list_indexes.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 13, 4]
                    }

                    default_config.rpcs.get_index.timeout = 60.0
                    default_config.rpcs.get_index.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 13, 4]
                    }

                    default_config.rpcs.delete_index.timeout = 60.0
                    default_config.rpcs.delete_index.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 13, 4]
                    }

                    default_config.rpcs.get_field.timeout = 60.0
                    default_config.rpcs.get_field.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 13, 4]
                    }

                    default_config.rpcs.update_field.timeout = 60.0

                    default_config.rpcs.list_fields.timeout = 60.0
                    default_config.rpcs.list_fields.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 13, 4]
                    }

                    default_config.rpcs.export_documents.timeout = 60.0

                    default_config.rpcs.import_documents.timeout = 60.0

                    default_config.rpcs.bulk_delete_documents.timeout = 60.0

                    default_config.rpcs.create_database.timeout = 120.0

                    default_config.rpcs.restore_database.timeout = 120.0

                    default_config.rpcs.clone_database.timeout = 120.0

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the FirestoreAdmin Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @firestore_admin_stub.universe_domain
                end

                ##
                # Create a new FirestoreAdmin REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the FirestoreAdmin client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @operations_client = ::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Operations.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @config.endpoint
                    config.universe_domain = @config.universe_domain
                  end

                  @firestore_admin_stub = ::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @firestore_admin_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end

                  @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @firestore_admin_stub.endpoint
                    config.universe_domain = @firestore_admin_stub.universe_domain
                    config.logger = @firestore_admin_stub.logger if config.respond_to? :logger=
                  end
                end

                ##
                # Get the associated client for long-running operations.
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Operations]
                #
                attr_reader :operations_client

                ##
                # Get the associated client for mix-in of the Locations.
                #
                # @return [Google::Cloud::Location::Locations::Rest::Client]
                #
                attr_reader :location_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @firestore_admin_stub.logger
                end

                # Service calls

                ##
                # Creates a composite index. This returns a
                # {::Google::Longrunning::Operation google.longrunning.Operation} which may be
                # used to track the status of the creation. The metadata for the operation
                # will be the type
                # {::Google::Cloud::Firestore::Admin::V1::IndexOperationMetadata IndexOperationMetadata}.
                #
                # @overload create_index(request, options = nil)
                #   Pass arguments to `create_index` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::CreateIndexRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::CreateIndexRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_index(parent: nil, index: nil)
                #   Pass arguments to `create_index` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. A parent name of the form
                #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
                #   @param index [::Google::Cloud::Firestore::Admin::V1::Index, ::Hash]
                #     Required. The composite index to create.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::CreateIndexRequest.new
                #
                #   # Call the create_index method.
                #   result = client.create_index request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def create_index request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::CreateIndexRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_index.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_index.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_index.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.create_index request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists composite indexes.
                #
                # @overload list_indexes(request, options = nil)
                #   Pass arguments to `list_indexes` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ListIndexesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ListIndexesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_indexes(parent: nil, filter: nil, page_size: nil, page_token: nil)
                #   Pass arguments to `list_indexes` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. A parent name of the form
                #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
                #   @param filter [::String]
                #     The filter to apply to list results.
                #   @param page_size [::Integer]
                #     The number of results to return.
                #   @param page_token [::String]
                #     A page token, returned from a previous call to
                #     {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#list_indexes FirestoreAdmin.ListIndexes},
                #     that may be used to get the next page of results.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Firestore::Admin::V1::Index>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Firestore::Admin::V1::Index>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ListIndexesRequest.new
                #
                #   # Call the list_indexes method.
                #   result = client.list_indexes request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Firestore::Admin::V1::Index.
                #     p item
                #   end
                #
                def list_indexes request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ListIndexesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_indexes.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_indexes.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_indexes.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.list_indexes request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @firestore_admin_stub, :list_indexes, "indexes", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets a composite index.
                #
                # @overload get_index(request, options = nil)
                #   Pass arguments to `get_index` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::GetIndexRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::GetIndexRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_index(name: nil)
                #   Pass arguments to `get_index` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::Index]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::Index]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::GetIndexRequest.new
                #
                #   # Call the get_index method.
                #   result = client.get_index request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::Index.
                #   p result
                #
                def get_index request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::GetIndexRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_index.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_index.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_index.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.get_index request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a composite index.
                #
                # @overload delete_index(request, options = nil)
                #   Pass arguments to `delete_index` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::DeleteIndexRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::DeleteIndexRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_index(name: nil)
                #   Pass arguments to `delete_index` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::DeleteIndexRequest.new
                #
                #   # Call the delete_index method.
                #   result = client.delete_index request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_index request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::DeleteIndexRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_index.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_index.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_index.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.delete_index request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets the metadata and configuration for a Field.
                #
                # @overload get_field(request, options = nil)
                #   Pass arguments to `get_field` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::GetFieldRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::GetFieldRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_field(name: nil)
                #   Pass arguments to `get_field` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::Field]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::Field]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::GetFieldRequest.new
                #
                #   # Call the get_field method.
                #   result = client.get_field request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::Field.
                #   p result
                #
                def get_field request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::GetFieldRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_field.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_field.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_field.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.get_field request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates a field configuration. Currently, field updates apply only to
                # single field index configuration. However, calls to
                # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#update_field FirestoreAdmin.UpdateField}
                # should provide a field mask to avoid changing any configuration that the
                # caller isn't aware of. The field mask should be specified as: `{ paths:
                # "index_config" }`.
                #
                # This call returns a
                # {::Google::Longrunning::Operation google.longrunning.Operation} which may be
                # used to track the status of the field update. The metadata for the
                # operation will be the type
                # {::Google::Cloud::Firestore::Admin::V1::FieldOperationMetadata FieldOperationMetadata}.
                #
                # To configure the default field settings for the database, use
                # the special `Field` with resource name:
                # `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/*`.
                #
                # @overload update_field(request, options = nil)
                #   Pass arguments to `update_field` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::UpdateFieldRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::UpdateFieldRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_field(field: nil, update_mask: nil)
                #   Pass arguments to `update_field` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param field [::Google::Cloud::Firestore::Admin::V1::Field, ::Hash]
                #     Required. The field to be updated.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     A mask, relative to the field. If specified, only configuration specified
                #     by this field_mask will be updated in the field.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::UpdateFieldRequest.new
                #
                #   # Call the update_field method.
                #   result = client.update_field request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def update_field request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::UpdateFieldRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_field.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_field.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_field.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.update_field request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists the field configuration and metadata for this database.
                #
                # Currently,
                # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#list_fields FirestoreAdmin.ListFields}
                # only supports listing fields that have been explicitly overridden. To issue
                # this query, call
                # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#list_fields FirestoreAdmin.ListFields}
                # with the filter set to `indexConfig.usesAncestorConfig:false` or
                # `ttlConfig:*`.
                #
                # @overload list_fields(request, options = nil)
                #   Pass arguments to `list_fields` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ListFieldsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ListFieldsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_fields(parent: nil, filter: nil, page_size: nil, page_token: nil)
                #   Pass arguments to `list_fields` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. A parent name of the form
                #     `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
                #   @param filter [::String]
                #     The filter to apply to list results. Currently,
                #     {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#list_fields FirestoreAdmin.ListFields}
                #     only supports listing fields that have been explicitly overridden. To issue
                #     this query, call
                #     {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#list_fields FirestoreAdmin.ListFields}
                #     with a filter that includes `indexConfig.usesAncestorConfig:false` or
                #     `ttlConfig:*`.
                #   @param page_size [::Integer]
                #     The number of results to return.
                #   @param page_token [::String]
                #     A page token, returned from a previous call to
                #     {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#list_fields FirestoreAdmin.ListFields},
                #     that may be used to get the next page of results.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Firestore::Admin::V1::Field>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Firestore::Admin::V1::Field>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ListFieldsRequest.new
                #
                #   # Call the list_fields method.
                #   result = client.list_fields request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Firestore::Admin::V1::Field.
                #     p item
                #   end
                #
                def list_fields request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ListFieldsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_fields.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_fields.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_fields.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.list_fields request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @firestore_admin_stub, :list_fields, "fields", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Exports a copy of all or a subset of documents from Google Cloud Firestore
                # to another storage system, such as Google Cloud Storage. Recent updates to
                # documents may not be reflected in the export. The export occurs in the
                # background and its progress can be monitored and managed via the
                # Operation resource that is created. The output of an export may only be
                # used once the associated operation is done. If an export operation is
                # cancelled before completion it may leave partial data behind in Google
                # Cloud Storage.
                #
                # For more details on export behavior and output format, refer to:
                # https://cloud.google.com/firestore/docs/manage-data/export-import
                #
                # @overload export_documents(request, options = nil)
                #   Pass arguments to `export_documents` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ExportDocumentsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ExportDocumentsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload export_documents(name: nil, collection_ids: nil, output_uri_prefix: nil, namespace_ids: nil, snapshot_time: nil)
                #   Pass arguments to `export_documents` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Database to export. Should be of the form:
                #     `projects/{project_id}/databases/{database_id}`.
                #   @param collection_ids [::Array<::String>]
                #     Which collection IDs to export. Unspecified means all collections. Each
                #     collection ID in this list must be unique.
                #   @param output_uri_prefix [::String]
                #     The output URI. Currently only supports Google Cloud Storage URIs of the
                #     form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
                #     of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
                #     Google Cloud Storage namespace path. When
                #     choosing a name, be sure to consider Google Cloud Storage naming
                #     guidelines: https://cloud.google.com/storage/docs/naming.
                #     If the URI is a bucket (without a namespace path), a prefix will be
                #     generated based on the start time.
                #   @param namespace_ids [::Array<::String>]
                #     An empty list represents all namespaces. This is the preferred
                #     usage for databases that don't use namespaces.
                #
                #     An empty string element represents the default namespace. This should be
                #     used if the database has data in non-default namespaces, but doesn't want
                #     to include them. Each namespace in this list must be unique.
                #   @param snapshot_time [::Google::Protobuf::Timestamp, ::Hash]
                #     The timestamp that corresponds to the version of the database to be
                #     exported. The timestamp must be in the past, rounded to the minute and not
                #     older than
                #     {::Google::Cloud::Firestore::Admin::V1::Database#earliest_version_time earliestVersionTime}.
                #     If specified, then the exported documents will represent a consistent view
                #     of the database at the provided time. Otherwise, there are no guarantees
                #     about the consistency of the exported documents.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ExportDocumentsRequest.new
                #
                #   # Call the export_documents method.
                #   result = client.export_documents request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def export_documents request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ExportDocumentsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.export_documents.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.export_documents.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.export_documents.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.export_documents request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Imports documents into Google Cloud Firestore. Existing documents with the
                # same name are overwritten. The import occurs in the background and its
                # progress can be monitored and managed via the Operation resource that is
                # created. If an ImportDocuments operation is cancelled, it is possible
                # that a subset of the data has already been imported to Cloud Firestore.
                #
                # @overload import_documents(request, options = nil)
                #   Pass arguments to `import_documents` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ImportDocumentsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ImportDocumentsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload import_documents(name: nil, collection_ids: nil, input_uri_prefix: nil, namespace_ids: nil)
                #   Pass arguments to `import_documents` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Database to import into. Should be of the form:
                #     `projects/{project_id}/databases/{database_id}`.
                #   @param collection_ids [::Array<::String>]
                #     Which collection IDs to import. Unspecified means all collections included
                #     in the import. Each collection ID in this list must be unique.
                #   @param input_uri_prefix [::String]
                #     Location of the exported files.
                #     This must match the output_uri_prefix of an ExportDocumentsResponse from
                #     an export that has completed successfully.
                #     See:
                #     {::Google::Cloud::Firestore::Admin::V1::ExportDocumentsResponse#output_uri_prefix google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix}.
                #   @param namespace_ids [::Array<::String>]
                #     An empty list represents all namespaces. This is the preferred
                #     usage for databases that don't use namespaces.
                #
                #     An empty string element represents the default namespace. This should be
                #     used if the database has data in non-default namespaces, but doesn't want
                #     to include them. Each namespace in this list must be unique.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ImportDocumentsRequest.new
                #
                #   # Call the import_documents method.
                #   result = client.import_documents request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def import_documents request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ImportDocumentsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.import_documents.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.import_documents.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.import_documents.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.import_documents request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Bulk deletes a subset of documents from Google Cloud Firestore.
                # Documents created or updated after the underlying system starts to process
                # the request will not be deleted. The bulk delete occurs in the background
                # and its progress can be monitored and managed via the Operation resource
                # that is created.
                #
                # For more details on bulk delete behavior, refer to:
                # https://cloud.google.com/firestore/docs/manage-data/bulk-delete
                #
                # @overload bulk_delete_documents(request, options = nil)
                #   Pass arguments to `bulk_delete_documents` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::BulkDeleteDocumentsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::BulkDeleteDocumentsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload bulk_delete_documents(name: nil, collection_ids: nil, namespace_ids: nil)
                #   Pass arguments to `bulk_delete_documents` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Database to operate. Should be of the form:
                #     `projects/{project_id}/databases/{database_id}`.
                #   @param collection_ids [::Array<::String>]
                #     Optional. IDs of the collection groups to delete. Unspecified means all
                #     collection groups.
                #
                #     Each collection group in this list must be unique.
                #   @param namespace_ids [::Array<::String>]
                #     Optional. Namespaces to delete.
                #
                #     An empty list means all namespaces. This is the recommended
                #     usage for databases that don't use namespaces.
                #
                #     An empty string element represents the default namespace. This should be
                #     used if the database has data in non-default namespaces, but doesn't want
                #     to delete from them.
                #
                #     Each namespace in this list must be unique.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::BulkDeleteDocumentsRequest.new
                #
                #   # Call the bulk_delete_documents method.
                #   result = client.bulk_delete_documents request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def bulk_delete_documents request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::BulkDeleteDocumentsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.bulk_delete_documents.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.bulk_delete_documents.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.bulk_delete_documents.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.bulk_delete_documents request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a database.
                #
                # @overload create_database(request, options = nil)
                #   Pass arguments to `create_database` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::CreateDatabaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::CreateDatabaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_database(parent: nil, database: nil, database_id: nil)
                #   Pass arguments to `create_database` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. A parent name of the form
                #     `projects/{project_id}`
                #   @param database [::Google::Cloud::Firestore::Admin::V1::Database, ::Hash]
                #     Required. The Database to create.
                #   @param database_id [::String]
                #     Required. The ID to use for the database, which will become the final
                #     component of the database's resource name.
                #
                #     This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
                #     with first character a letter and the last a letter or a number. Must not
                #     be UUID-like /[0-9a-f]\\{8}(-[0-9a-f]\\{4})\\{3}-[0-9a-f]\\{12}/.
                #
                #     "(default)" database ID is also valid.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::CreateDatabaseRequest.new
                #
                #   # Call the create_database method.
                #   result = client.create_database request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def create_database request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::CreateDatabaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_database.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_database.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_database.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.create_database request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets information about a database.
                #
                # @overload get_database(request, options = nil)
                #   Pass arguments to `get_database` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::GetDatabaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::GetDatabaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_database(name: nil)
                #   Pass arguments to `get_database` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::Database]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::Database]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::GetDatabaseRequest.new
                #
                #   # Call the get_database method.
                #   result = client.get_database request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::Database.
                #   p result
                #
                def get_database request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::GetDatabaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_database.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_database.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_database.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.get_database request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # List all the databases in the project.
                #
                # @overload list_databases(request, options = nil)
                #   Pass arguments to `list_databases` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ListDatabasesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ListDatabasesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_databases(parent: nil, show_deleted: nil)
                #   Pass arguments to `list_databases` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. A parent name of the form
                #     `projects/{project_id}`
                #   @param show_deleted [::Boolean]
                #     If true, also returns deleted resources.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::ListDatabasesResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::ListDatabasesResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ListDatabasesRequest.new
                #
                #   # Call the list_databases method.
                #   result = client.list_databases request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::ListDatabasesResponse.
                #   p result
                #
                def list_databases request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ListDatabasesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_databases.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_databases.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_databases.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.list_databases request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates a database.
                #
                # @overload update_database(request, options = nil)
                #   Pass arguments to `update_database` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::UpdateDatabaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::UpdateDatabaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_database(database: nil, update_mask: nil)
                #   Pass arguments to `update_database` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param database [::Google::Cloud::Firestore::Admin::V1::Database, ::Hash]
                #     Required. The database to update.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     The list of fields to be updated.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::UpdateDatabaseRequest.new
                #
                #   # Call the update_database method.
                #   result = client.update_database request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def update_database request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::UpdateDatabaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_database.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_database.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_database.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.update_database request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a database.
                #
                # @overload delete_database(request, options = nil)
                #   Pass arguments to `delete_database` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::DeleteDatabaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::DeleteDatabaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_database(name: nil, etag: nil)
                #   Pass arguments to `delete_database` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}`
                #   @param etag [::String]
                #     The current etag of the Database.
                #     If an etag is provided and does not match the current etag of the database,
                #     deletion will be blocked and a FAILED_PRECONDITION error will be returned.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::DeleteDatabaseRequest.new
                #
                #   # Call the delete_database method.
                #   result = client.delete_database request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def delete_database request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::DeleteDatabaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_database.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_database.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_database.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.delete_database request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a user creds.
                #
                # @overload create_user_creds(request, options = nil)
                #   Pass arguments to `create_user_creds` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::CreateUserCredsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::CreateUserCredsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_user_creds(parent: nil, user_creds: nil, user_creds_id: nil)
                #   Pass arguments to `create_user_creds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. A parent name of the form
                #     `projects/{project_id}/databases/{database_id}`
                #   @param user_creds [::Google::Cloud::Firestore::Admin::V1::UserCreds, ::Hash]
                #     Required. The user creds to create.
                #   @param user_creds_id [::String]
                #     Required. The ID to use for the user creds, which will become the final
                #     component of the user creds's resource name.
                #
                #     This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
                #     with first character a letter and the last a letter or a number. Must not
                #     be UUID-like /[0-9a-f]\\{8}(-[0-9a-f]\\{4})\\{3}-[0-9a-f]\\{12}/.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::CreateUserCredsRequest.new
                #
                #   # Call the create_user_creds method.
                #   result = client.create_user_creds request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::UserCreds.
                #   p result
                #
                def create_user_creds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::CreateUserCredsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_user_creds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_user_creds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_user_creds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.create_user_creds request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets a user creds resource. Note that the returned resource does not
                # contain the secret value itself.
                #
                # @overload get_user_creds(request, options = nil)
                #   Pass arguments to `get_user_creds` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::GetUserCredsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::GetUserCredsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_user_creds(name: nil)
                #   Pass arguments to `get_user_creds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::GetUserCredsRequest.new
                #
                #   # Call the get_user_creds method.
                #   result = client.get_user_creds request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::UserCreds.
                #   p result
                #
                def get_user_creds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::GetUserCredsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_user_creds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_user_creds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_user_creds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.get_user_creds request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # List all user creds in the database. Note that the returned resource
                # does not contain the secret value itself.
                #
                # @overload list_user_creds(request, options = nil)
                #   Pass arguments to `list_user_creds` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ListUserCredsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ListUserCredsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_user_creds(parent: nil)
                #   Pass arguments to `list_user_creds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. A parent database name of the form
                #     `projects/{project_id}/databases/{database_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::ListUserCredsResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::ListUserCredsResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ListUserCredsRequest.new
                #
                #   # Call the list_user_creds method.
                #   result = client.list_user_creds request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::ListUserCredsResponse.
                #   p result
                #
                def list_user_creds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ListUserCredsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_user_creds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_user_creds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_user_creds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.list_user_creds request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Enables a user creds. No-op if the user creds are already enabled.
                #
                # @overload enable_user_creds(request, options = nil)
                #   Pass arguments to `enable_user_creds` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::EnableUserCredsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::EnableUserCredsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload enable_user_creds(name: nil)
                #   Pass arguments to `enable_user_creds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::EnableUserCredsRequest.new
                #
                #   # Call the enable_user_creds method.
                #   result = client.enable_user_creds request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::UserCreds.
                #   p result
                #
                def enable_user_creds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::EnableUserCredsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.enable_user_creds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.enable_user_creds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.enable_user_creds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.enable_user_creds request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Disables a user creds. No-op if the user creds are already disabled.
                #
                # @overload disable_user_creds(request, options = nil)
                #   Pass arguments to `disable_user_creds` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::DisableUserCredsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::DisableUserCredsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload disable_user_creds(name: nil)
                #   Pass arguments to `disable_user_creds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::DisableUserCredsRequest.new
                #
                #   # Call the disable_user_creds method.
                #   result = client.disable_user_creds request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::UserCreds.
                #   p result
                #
                def disable_user_creds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::DisableUserCredsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.disable_user_creds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.disable_user_creds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.disable_user_creds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.disable_user_creds request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Resets the password of a user creds.
                #
                # @overload reset_user_password(request, options = nil)
                #   Pass arguments to `reset_user_password` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ResetUserPasswordRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ResetUserPasswordRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload reset_user_password(name: nil)
                #   Pass arguments to `reset_user_password` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::UserCreds]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ResetUserPasswordRequest.new
                #
                #   # Call the reset_user_password method.
                #   result = client.reset_user_password request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::UserCreds.
                #   p result
                #
                def reset_user_password request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ResetUserPasswordRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.reset_user_password.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.reset_user_password.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.reset_user_password.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.reset_user_password request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a user creds.
                #
                # @overload delete_user_creds(request, options = nil)
                #   Pass arguments to `delete_user_creds` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::DeleteUserCredsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::DeleteUserCredsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_user_creds(name: nil)
                #   Pass arguments to `delete_user_creds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. A name of the form
                #     `projects/{project_id}/databases/{database_id}/userCreds/{user_creds_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::DeleteUserCredsRequest.new
                #
                #   # Call the delete_user_creds method.
                #   result = client.delete_user_creds request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_user_creds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::DeleteUserCredsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_user_creds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_user_creds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_user_creds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.delete_user_creds request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets information about a backup.
                #
                # @overload get_backup(request, options = nil)
                #   Pass arguments to `get_backup` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::GetBackupRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::GetBackupRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_backup(name: nil)
                #   Pass arguments to `get_backup` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Name of the backup to fetch.
                #
                #     Format is `projects/{project}/locations/{location}/backups/{backup}`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::Backup]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::Backup]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::GetBackupRequest.new
                #
                #   # Call the get_backup method.
                #   result = client.get_backup request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::Backup.
                #   p result
                #
                def get_backup request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::GetBackupRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_backup.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_backup.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.get_backup request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists all the backups.
                #
                # @overload list_backups(request, options = nil)
                #   Pass arguments to `list_backups` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ListBackupsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ListBackupsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_backups(parent: nil, filter: nil)
                #   Pass arguments to `list_backups` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The location to list backups from.
                #
                #     Format is `projects/{project}/locations/{location}`.
                #     Use `{location} = '-'` to list backups from all locations for the given
                #     project. This allows listing backups from a single location or from all
                #     locations.
                #   @param filter [::String]
                #     An expression that filters the list of returned backups.
                #
                #     A filter expression consists of a field name, a comparison operator, and a
                #     value for filtering.
                #     The value must be a string, a number, or a boolean. The comparison operator
                #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
                #     Colon `:` is the contains operator. Filter rules are not case sensitive.
                #
                #     The following fields in the {::Google::Cloud::Firestore::Admin::V1::Backup Backup} are
                #     eligible for filtering:
                #
                #       * `database_uid` (supports `=` only)
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::ListBackupsResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::ListBackupsResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ListBackupsRequest.new
                #
                #   # Call the list_backups method.
                #   result = client.list_backups request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::ListBackupsResponse.
                #   p result
                #
                def list_backups request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ListBackupsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_backups.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_backups.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.list_backups request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a backup.
                #
                # @overload delete_backup(request, options = nil)
                #   Pass arguments to `delete_backup` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::DeleteBackupRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::DeleteBackupRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_backup(name: nil)
                #   Pass arguments to `delete_backup` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Name of the backup to delete.
                #
                #     format is `projects/{project}/locations/{location}/backups/{backup}`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::DeleteBackupRequest.new
                #
                #   # Call the delete_backup method.
                #   result = client.delete_backup request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_backup request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::DeleteBackupRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_backup.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_backup.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.delete_backup request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates a new database by restoring from an existing backup.
                #
                # The new database must be in the same cloud region or multi-region location
                # as the existing backup. This behaves similar to
                # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#create_database FirestoreAdmin.CreateDatabase}
                # except instead of creating a new empty database, a new database is created
                # with the database type, index configuration, and documents from an existing
                # backup.
                #
                # The {::Google::Longrunning::Operation long-running operation} can be used to
                # track the progress of the restore, with the Operation's
                # {::Google::Longrunning::Operation#metadata metadata} field type being the
                # {::Google::Cloud::Firestore::Admin::V1::RestoreDatabaseMetadata RestoreDatabaseMetadata}.
                # The {::Google::Longrunning::Operation#response response} type is the
                # {::Google::Cloud::Firestore::Admin::V1::Database Database} if the restore was
                # successful. The new database is not readable or writeable until the LRO has
                # completed.
                #
                # @overload restore_database(request, options = nil)
                #   Pass arguments to `restore_database` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::RestoreDatabaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::RestoreDatabaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload restore_database(parent: nil, database_id: nil, backup: nil, encryption_config: nil, tags: nil)
                #   Pass arguments to `restore_database` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The project to restore the database in. Format is
                #     `projects/{project_id}`.
                #   @param database_id [::String]
                #     Required. The ID to use for the database, which will become the final
                #     component of the database's resource name. This database ID must not be
                #     associated with an existing database.
                #
                #     This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
                #     with first character a letter and the last a letter or a number. Must not
                #     be UUID-like /[0-9a-f]\\{8}(-[0-9a-f]\\{4})\\{3}-[0-9a-f]\\{12}/.
                #
                #     "(default)" database ID is also valid.
                #   @param backup [::String]
                #     Required. Backup to restore from. Must be from the same project as the
                #     parent.
                #
                #     The restored database will be created in the same location as the source
                #     backup.
                #
                #     Format is: `projects/{project_id}/locations/{location}/backups/{backup}`
                #   @param encryption_config [::Google::Cloud::Firestore::Admin::V1::Database::EncryptionConfig, ::Hash]
                #     Optional. Encryption configuration for the restored database.
                #
                #     If this field is not specified, the restored database will use
                #     the same encryption configuration as the backup, namely
                #     {::Google::Cloud::Firestore::Admin::V1::Database::EncryptionConfig#use_source_encryption use_source_encryption}.
                #   @param tags [::Hash{::String => ::String}]
                #     Optional. Immutable. Tags to be bound to the restored database.
                #
                #     The tags should be provided in the format of
                #     `tagKeys/{tag_key_id} -> tagValues/{tag_value_id}`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::RestoreDatabaseRequest.new
                #
                #   # Call the restore_database method.
                #   result = client.restore_database request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def restore_database request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::RestoreDatabaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.restore_database.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.restore_database.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.restore_database.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.restore_database request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates a backup schedule on a database.
                # At most two backup schedules can be configured on a database, one daily
                # backup schedule and one weekly backup schedule.
                #
                # @overload create_backup_schedule(request, options = nil)
                #   Pass arguments to `create_backup_schedule` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::CreateBackupScheduleRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::CreateBackupScheduleRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_backup_schedule(parent: nil, backup_schedule: nil)
                #   Pass arguments to `create_backup_schedule` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent database.
                #
                #      Format `projects/{project}/databases/{database}`
                #   @param backup_schedule [::Google::Cloud::Firestore::Admin::V1::BackupSchedule, ::Hash]
                #     Required. The backup schedule to create.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::BackupSchedule]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::BackupSchedule]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::CreateBackupScheduleRequest.new
                #
                #   # Call the create_backup_schedule method.
                #   result = client.create_backup_schedule request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::BackupSchedule.
                #   p result
                #
                def create_backup_schedule request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::CreateBackupScheduleRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_backup_schedule.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_backup_schedule.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_backup_schedule.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.create_backup_schedule request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets information about a backup schedule.
                #
                # @overload get_backup_schedule(request, options = nil)
                #   Pass arguments to `get_backup_schedule` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::GetBackupScheduleRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::GetBackupScheduleRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_backup_schedule(name: nil)
                #   Pass arguments to `get_backup_schedule` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the backup schedule.
                #
                #     Format
                #     `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::BackupSchedule]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::BackupSchedule]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::GetBackupScheduleRequest.new
                #
                #   # Call the get_backup_schedule method.
                #   result = client.get_backup_schedule request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::BackupSchedule.
                #   p result
                #
                def get_backup_schedule request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::GetBackupScheduleRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_backup_schedule.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_backup_schedule.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_backup_schedule.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.get_backup_schedule request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # List backup schedules.
                #
                # @overload list_backup_schedules(request, options = nil)
                #   Pass arguments to `list_backup_schedules` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::ListBackupSchedulesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::ListBackupSchedulesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_backup_schedules(parent: nil)
                #   Pass arguments to `list_backup_schedules` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent database.
                #
                #     Format is `projects/{project}/databases/{database}`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::ListBackupSchedulesResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::ListBackupSchedulesResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::ListBackupSchedulesRequest.new
                #
                #   # Call the list_backup_schedules method.
                #   result = client.list_backup_schedules request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::ListBackupSchedulesResponse.
                #   p result
                #
                def list_backup_schedules request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::ListBackupSchedulesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_backup_schedules.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_backup_schedules.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_backup_schedules.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.list_backup_schedules request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates a backup schedule.
                #
                # @overload update_backup_schedule(request, options = nil)
                #   Pass arguments to `update_backup_schedule` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::UpdateBackupScheduleRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::UpdateBackupScheduleRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_backup_schedule(backup_schedule: nil, update_mask: nil)
                #   Pass arguments to `update_backup_schedule` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param backup_schedule [::Google::Cloud::Firestore::Admin::V1::BackupSchedule, ::Hash]
                #     Required. The backup schedule to update.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     The list of fields to be updated.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Firestore::Admin::V1::BackupSchedule]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Firestore::Admin::V1::BackupSchedule]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::UpdateBackupScheduleRequest.new
                #
                #   # Call the update_backup_schedule method.
                #   result = client.update_backup_schedule request
                #
                #   # The returned object is of type Google::Cloud::Firestore::Admin::V1::BackupSchedule.
                #   p result
                #
                def update_backup_schedule request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::UpdateBackupScheduleRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_backup_schedule.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_backup_schedule.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_backup_schedule.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.update_backup_schedule request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a backup schedule.
                #
                # @overload delete_backup_schedule(request, options = nil)
                #   Pass arguments to `delete_backup_schedule` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::DeleteBackupScheduleRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::DeleteBackupScheduleRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_backup_schedule(name: nil)
                #   Pass arguments to `delete_backup_schedule` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the backup schedule.
                #
                #     Format
                #     `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::DeleteBackupScheduleRequest.new
                #
                #   # Call the delete_backup_schedule method.
                #   result = client.delete_backup_schedule request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_backup_schedule request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::DeleteBackupScheduleRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_backup_schedule.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_backup_schedule.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_backup_schedule.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.delete_backup_schedule request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates a new database by cloning an existing one.
                #
                # The new database must be in the same cloud region or multi-region location
                # as the existing database. This behaves similar to
                # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client#create_database FirestoreAdmin.CreateDatabase}
                # except instead of creating a new empty database, a new database is created
                # with the database type, index configuration, and documents from an existing
                # database.
                #
                # The {::Google::Longrunning::Operation long-running operation} can be used to
                # track the progress of the clone, with the Operation's
                # {::Google::Longrunning::Operation#metadata metadata} field type being the
                # {::Google::Cloud::Firestore::Admin::V1::CloneDatabaseMetadata CloneDatabaseMetadata}.
                # The {::Google::Longrunning::Operation#response response} type is the
                # {::Google::Cloud::Firestore::Admin::V1::Database Database} if the clone was
                # successful. The new database is not readable or writeable until the LRO has
                # completed.
                #
                # @overload clone_database(request, options = nil)
                #   Pass arguments to `clone_database` via a request object, either of type
                #   {::Google::Cloud::Firestore::Admin::V1::CloneDatabaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Firestore::Admin::V1::CloneDatabaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload clone_database(parent: nil, database_id: nil, pitr_snapshot: nil, encryption_config: nil, tags: nil)
                #   Pass arguments to `clone_database` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The project to clone the database in. Format is
                #     `projects/{project_id}`.
                #   @param database_id [::String]
                #     Required. The ID to use for the database, which will become the final
                #     component of the database's resource name. This database ID must not be
                #     associated with an existing database.
                #
                #     This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
                #     with first character a letter and the last a letter or a number. Must not
                #     be UUID-like /[0-9a-f]\\{8}(-[0-9a-f]\\{4})\\{3}-[0-9a-f]\\{12}/.
                #
                #     "(default)" database ID is also valid.
                #   @param pitr_snapshot [::Google::Cloud::Firestore::Admin::V1::PitrSnapshot, ::Hash]
                #     Required. Specification of the PITR data to clone from. The source database
                #     must exist.
                #
                #     The cloned database will be created in the same location as the source
                #     database.
                #   @param encryption_config [::Google::Cloud::Firestore::Admin::V1::Database::EncryptionConfig, ::Hash]
                #     Optional. Encryption configuration for the cloned database.
                #
                #     If this field is not specified, the cloned database will use
                #     the same encryption configuration as the source database, namely
                #     {::Google::Cloud::Firestore::Admin::V1::Database::EncryptionConfig#use_source_encryption use_source_encryption}.
                #   @param tags [::Hash{::String => ::String}]
                #     Optional. Immutable. Tags to be bound to the cloned database.
                #
                #     The tags should be provided in the format of
                #     `tagKeys/{tag_key_id} -> tagValues/{tag_value_id}`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/firestore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Firestore::Admin::V1::CloneDatabaseRequest.new
                #
                #   # Call the clone_database method.
                #   result = client.clone_database request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def clone_database request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Firestore::Admin::V1::CloneDatabaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.clone_database.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Firestore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.clone_database.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.clone_database.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @firestore_admin_stub.clone_database request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the FirestoreAdmin REST API.
                #
                # This class represents the configuration for FirestoreAdmin REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # create_index to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_index.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Firestore::Admin::V1::FirestoreAdmin::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_index.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "firestore.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the FirestoreAdmin API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `create_index`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_index
                    ##
                    # RPC-specific configuration for `list_indexes`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_indexes
                    ##
                    # RPC-specific configuration for `get_index`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_index
                    ##
                    # RPC-specific configuration for `delete_index`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_index
                    ##
                    # RPC-specific configuration for `get_field`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_field
                    ##
                    # RPC-specific configuration for `update_field`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_field
                    ##
                    # RPC-specific configuration for `list_fields`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_fields
                    ##
                    # RPC-specific configuration for `export_documents`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :export_documents
                    ##
                    # RPC-specific configuration for `import_documents`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :import_documents
                    ##
                    # RPC-specific configuration for `bulk_delete_documents`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :bulk_delete_documents
                    ##
                    # RPC-specific configuration for `create_database`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_database
                    ##
                    # RPC-specific configuration for `get_database`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_database
                    ##
                    # RPC-specific configuration for `list_databases`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_databases
                    ##
                    # RPC-specific configuration for `update_database`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_database
                    ##
                    # RPC-specific configuration for `delete_database`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_database
                    ##
                    # RPC-specific configuration for `create_user_creds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_user_creds
                    ##
                    # RPC-specific configuration for `get_user_creds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_user_creds
                    ##
                    # RPC-specific configuration for `list_user_creds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_user_creds
                    ##
                    # RPC-specific configuration for `enable_user_creds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :enable_user_creds
                    ##
                    # RPC-specific configuration for `disable_user_creds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :disable_user_creds
                    ##
                    # RPC-specific configuration for `reset_user_password`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :reset_user_password
                    ##
                    # RPC-specific configuration for `delete_user_creds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_user_creds
                    ##
                    # RPC-specific configuration for `get_backup`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_backup
                    ##
                    # RPC-specific configuration for `list_backups`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_backups
                    ##
                    # RPC-specific configuration for `delete_backup`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_backup
                    ##
                    # RPC-specific configuration for `restore_database`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :restore_database
                    ##
                    # RPC-specific configuration for `create_backup_schedule`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_backup_schedule
                    ##
                    # RPC-specific configuration for `get_backup_schedule`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_backup_schedule
                    ##
                    # RPC-specific configuration for `list_backup_schedules`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_backup_schedules
                    ##
                    # RPC-specific configuration for `update_backup_schedule`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_backup_schedule
                    ##
                    # RPC-specific configuration for `delete_backup_schedule`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_backup_schedule
                    ##
                    # RPC-specific configuration for `clone_database`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :clone_database

                    # @private
                    def initialize parent_rpcs = nil
                      create_index_config = parent_rpcs.create_index if parent_rpcs.respond_to? :create_index
                      @create_index = ::Gapic::Config::Method.new create_index_config
                      list_indexes_config = parent_rpcs.list_indexes if parent_rpcs.respond_to? :list_indexes
                      @list_indexes = ::Gapic::Config::Method.new list_indexes_config
                      get_index_config = parent_rpcs.get_index if parent_rpcs.respond_to? :get_index
                      @get_index = ::Gapic::Config::Method.new get_index_config
                      delete_index_config = parent_rpcs.delete_index if parent_rpcs.respond_to? :delete_index
                      @delete_index = ::Gapic::Config::Method.new delete_index_config
                      get_field_config = parent_rpcs.get_field if parent_rpcs.respond_to? :get_field
                      @get_field = ::Gapic::Config::Method.new get_field_config
                      update_field_config = parent_rpcs.update_field if parent_rpcs.respond_to? :update_field
                      @update_field = ::Gapic::Config::Method.new update_field_config
                      list_fields_config = parent_rpcs.list_fields if parent_rpcs.respond_to? :list_fields
                      @list_fields = ::Gapic::Config::Method.new list_fields_config
                      export_documents_config = parent_rpcs.export_documents if parent_rpcs.respond_to? :export_documents
                      @export_documents = ::Gapic::Config::Method.new export_documents_config
                      import_documents_config = parent_rpcs.import_documents if parent_rpcs.respond_to? :import_documents
                      @import_documents = ::Gapic::Config::Method.new import_documents_config
                      bulk_delete_documents_config = parent_rpcs.bulk_delete_documents if parent_rpcs.respond_to? :bulk_delete_documents
                      @bulk_delete_documents = ::Gapic::Config::Method.new bulk_delete_documents_config
                      create_database_config = parent_rpcs.create_database if parent_rpcs.respond_to? :create_database
                      @create_database = ::Gapic::Config::Method.new create_database_config
                      get_database_config = parent_rpcs.get_database if parent_rpcs.respond_to? :get_database
                      @get_database = ::Gapic::Config::Method.new get_database_config
                      list_databases_config = parent_rpcs.list_databases if parent_rpcs.respond_to? :list_databases
                      @list_databases = ::Gapic::Config::Method.new list_databases_config
                      update_database_config = parent_rpcs.update_database if parent_rpcs.respond_to? :update_database
                      @update_database = ::Gapic::Config::Method.new update_database_config
                      delete_database_config = parent_rpcs.delete_database if parent_rpcs.respond_to? :delete_database
                      @delete_database = ::Gapic::Config::Method.new delete_database_config
                      create_user_creds_config = parent_rpcs.create_user_creds if parent_rpcs.respond_to? :create_user_creds
                      @create_user_creds = ::Gapic::Config::Method.new create_user_creds_config
                      get_user_creds_config = parent_rpcs.get_user_creds if parent_rpcs.respond_to? :get_user_creds
                      @get_user_creds = ::Gapic::Config::Method.new get_user_creds_config
                      list_user_creds_config = parent_rpcs.list_user_creds if parent_rpcs.respond_to? :list_user_creds
                      @list_user_creds = ::Gapic::Config::Method.new list_user_creds_config
                      enable_user_creds_config = parent_rpcs.enable_user_creds if parent_rpcs.respond_to? :enable_user_creds
                      @enable_user_creds = ::Gapic::Config::Method.new enable_user_creds_config
                      disable_user_creds_config = parent_rpcs.disable_user_creds if parent_rpcs.respond_to? :disable_user_creds
                      @disable_user_creds = ::Gapic::Config::Method.new disable_user_creds_config
                      reset_user_password_config = parent_rpcs.reset_user_password if parent_rpcs.respond_to? :reset_user_password
                      @reset_user_password = ::Gapic::Config::Method.new reset_user_password_config
                      delete_user_creds_config = parent_rpcs.delete_user_creds if parent_rpcs.respond_to? :delete_user_creds
                      @delete_user_creds = ::Gapic::Config::Method.new delete_user_creds_config
                      get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                      @get_backup = ::Gapic::Config::Method.new get_backup_config
                      list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                      @list_backups = ::Gapic::Config::Method.new list_backups_config
                      delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                      @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                      restore_database_config = parent_rpcs.restore_database if parent_rpcs.respond_to? :restore_database
                      @restore_database = ::Gapic::Config::Method.new restore_database_config
                      create_backup_schedule_config = parent_rpcs.create_backup_schedule if parent_rpcs.respond_to? :create_backup_schedule
                      @create_backup_schedule = ::Gapic::Config::Method.new create_backup_schedule_config
                      get_backup_schedule_config = parent_rpcs.get_backup_schedule if parent_rpcs.respond_to? :get_backup_schedule
                      @get_backup_schedule = ::Gapic::Config::Method.new get_backup_schedule_config
                      list_backup_schedules_config = parent_rpcs.list_backup_schedules if parent_rpcs.respond_to? :list_backup_schedules
                      @list_backup_schedules = ::Gapic::Config::Method.new list_backup_schedules_config
                      update_backup_schedule_config = parent_rpcs.update_backup_schedule if parent_rpcs.respond_to? :update_backup_schedule
                      @update_backup_schedule = ::Gapic::Config::Method.new update_backup_schedule_config
                      delete_backup_schedule_config = parent_rpcs.delete_backup_schedule if parent_rpcs.respond_to? :delete_backup_schedule
                      @delete_backup_schedule = ::Gapic::Config::Method.new delete_backup_schedule_config
                      clone_database_config = parent_rpcs.clone_database if parent_rpcs.respond_to? :clone_database
                      @clone_database = ::Gapic::Config::Method.new clone_database_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
