# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Firestore
      module Admin
        module V1
          module FirestoreAdmin
            # Path helper methods for the FirestoreAdmin API.
            module Paths
              ##
              # Create a fully-qualified Backup resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/backups/{backup}`
              #
              # @param project [String]
              # @param location [String]
              # @param backup [String]
              #
              # @return [::String]
              def backup_path project:, location:, backup:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/backups/#{backup}"
              end

              ##
              # Create a fully-qualified BackupSchedule resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
              #
              # @param project [String]
              # @param database [String]
              # @param backup_schedule [String]
              #
              # @return [::String]
              def backup_schedule_path project:, database:, backup_schedule:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "database cannot contain /" if database.to_s.include? "/"

                "projects/#{project}/databases/#{database}/backupSchedules/#{backup_schedule}"
              end

              ##
              # Create a fully-qualified CollectionGroup resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/databases/{database}/collectionGroups/{collection}`
              #
              # @param project [String]
              # @param database [String]
              # @param collection [String]
              #
              # @return [::String]
              def collection_group_path project:, database:, collection:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "database cannot contain /" if database.to_s.include? "/"

                "projects/#{project}/databases/#{database}/collectionGroups/#{collection}"
              end

              ##
              # Create a fully-qualified Database resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/databases/{database}`
              #
              # @param project [String]
              # @param database [String]
              #
              # @return [::String]
              def database_path project:, database:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/databases/#{database}"
              end

              ##
              # Create a fully-qualified Field resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/databases/{database}/collectionGroups/{collection}/fields/{field}`
              #
              # @param project [String]
              # @param database [String]
              # @param collection [String]
              # @param field [String]
              #
              # @return [::String]
              def field_path project:, database:, collection:, field:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "database cannot contain /" if database.to_s.include? "/"
                raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"

                "projects/#{project}/databases/#{database}/collectionGroups/#{collection}/fields/#{field}"
              end

              ##
              # Create a fully-qualified Index resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/databases/{database}/collectionGroups/{collection}/indexes/{index}`
              #
              # @param project [String]
              # @param database [String]
              # @param collection [String]
              # @param index [String]
              #
              # @return [::String]
              def index_path project:, database:, collection:, index:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "database cannot contain /" if database.to_s.include? "/"
                raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"

                "projects/#{project}/databases/#{database}/collectionGroups/#{collection}/indexes/#{index}"
              end

              ##
              # Create a fully-qualified Location resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}`
              #
              # @param project [String]
              # @param location [String]
              #
              # @return [::String]
              def location_path project:, location:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/locations/#{location}"
              end

              ##
              # Create a fully-qualified Operation resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/databases/{database}/operations/{operation}`
              #
              # @param project [String]
              # @param database [String]
              # @param operation [String]
              #
              # @return [::String]
              def operation_path project:, database:, operation:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "database cannot contain /" if database.to_s.include? "/"

                "projects/#{project}/databases/#{database}/operations/#{operation}"
              end

              ##
              # Create a fully-qualified Project resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}`
              #
              # @param project [String]
              #
              # @return [::String]
              def project_path project:
                "projects/#{project}"
              end

              ##
              # Create a fully-qualified UserCreds resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/databases/{database}/userCreds/{user_creds}`
              #
              # @param project [String]
              # @param database [String]
              # @param user_creds [String]
              #
              # @return [::String]
              def user_creds_path project:, database:, user_creds:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "database cannot contain /" if database.to_s.include? "/"

                "projects/#{project}/databases/#{database}/userCreds/#{user_creds}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
