# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/financialservices/v1/service_pb"
require "google/cloud/financial_services/v1/aml"

class ::Google::Cloud::FinancialServices::V1::AML::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_instances
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::ListInstancesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_instances, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ListInstancesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_instances_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_instances ::Google::Cloud::FinancialServices::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_instances(::Google::Cloud::FinancialServices::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_instances_client_stub.call_rpc_count
    end
  end

  def test_get_instance
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::Instance.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_instance, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::GetInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_instance_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_instance({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_instance name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_instance ::Google::Cloud::FinancialServices::V1::GetInstanceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_instance({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_instance(::Google::Cloud::FinancialServices::V1::GetInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_instance_client_stub.call_rpc_count
    end
  end

  def test_create_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"
    instance = {}
    request_id = "hello world"

    create_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_instance, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::CreateInstanceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["instance_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::Instance), request["instance"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_instance_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_instance parent: parent, instance_id: instance_id, instance: instance, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_instance ::Google::Cloud::FinancialServices::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_instance(::Google::Cloud::FinancialServices::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_instance_client_stub.call_rpc_count
    end
  end

  def test_update_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    instance = {}
    request_id = "hello world"

    update_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_instance, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::UpdateInstanceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::Instance), request["instance"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_instance_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_instance({ update_mask: update_mask, instance: instance, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_instance update_mask: update_mask, instance: instance, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_instance ::Google::Cloud::FinancialServices::V1::UpdateInstanceRequest.new(update_mask: update_mask, instance: instance, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_instance({ update_mask: update_mask, instance: instance, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_instance(::Google::Cloud::FinancialServices::V1::UpdateInstanceRequest.new(update_mask: update_mask, instance: instance, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_instance_client_stub.call_rpc_count
    end
  end

  def test_delete_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_instance, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::DeleteInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_instance_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_instance({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_instance name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_instance ::Google::Cloud::FinancialServices::V1::DeleteInstanceRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_instance({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_instance(::Google::Cloud::FinancialServices::V1::DeleteInstanceRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_instance_client_stub.call_rpc_count
    end
  end

  def test_import_registered_parties
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    party_tables = ["hello world"]
    mode = :UPDATE_MODE_UNSPECIFIED
    validate_only = true
    line_of_business = :LINE_OF_BUSINESS_UNSPECIFIED

    import_registered_parties_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_registered_parties, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ImportRegisteredPartiesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["party_tables"]
      assert_equal :UPDATE_MODE_UNSPECIFIED, request["mode"]
      assert_equal true, request["validate_only"]
      assert_equal :LINE_OF_BUSINESS_UNSPECIFIED, request["line_of_business"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_registered_parties_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_registered_parties({ name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_registered_parties name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_registered_parties ::Google::Cloud::FinancialServices::V1::ImportRegisteredPartiesRequest.new(name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_registered_parties({ name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_registered_parties(::Google::Cloud::FinancialServices::V1::ImportRegisteredPartiesRequest.new(name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_registered_parties_client_stub.call_rpc_count
    end
  end

  def test_export_registered_parties
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    dataset = {}
    line_of_business = :LINE_OF_BUSINESS_UNSPECIFIED

    export_registered_parties_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_registered_parties, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ExportRegisteredPartiesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::BigQueryDestination), request["dataset"]
      assert_equal :LINE_OF_BUSINESS_UNSPECIFIED, request["line_of_business"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_registered_parties_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_registered_parties({ name: name, dataset: dataset, line_of_business: line_of_business }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_registered_parties name: name, dataset: dataset, line_of_business: line_of_business do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_registered_parties ::Google::Cloud::FinancialServices::V1::ExportRegisteredPartiesRequest.new(name: name, dataset: dataset, line_of_business: line_of_business) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_registered_parties({ name: name, dataset: dataset, line_of_business: line_of_business }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_registered_parties(::Google::Cloud::FinancialServices::V1::ExportRegisteredPartiesRequest.new(name: name, dataset: dataset, line_of_business: line_of_business), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_registered_parties_client_stub.call_rpc_count
    end
  end

  def test_list_datasets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::ListDatasetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_datasets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_datasets, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ListDatasetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_datasets_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_datasets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_datasets ::Google::Cloud::FinancialServices::V1::ListDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_datasets(::Google::Cloud::FinancialServices::V1::ListDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_datasets_client_stub.call_rpc_count
    end
  end

  def test_get_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::Dataset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_dataset, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::GetDatasetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_dataset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_dataset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_dataset ::Google::Cloud::FinancialServices::V1::GetDatasetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_dataset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_dataset(::Google::Cloud::FinancialServices::V1::GetDatasetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_dataset_client_stub.call_rpc_count
    end
  end

  def test_create_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset_id = "hello world"
    dataset = {}
    request_id = "hello world"

    create_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_dataset, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::CreateDatasetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["dataset_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::Dataset), request["dataset"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_dataset({ parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_dataset parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_dataset ::Google::Cloud::FinancialServices::V1::CreateDatasetRequest.new(parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_dataset({ parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_dataset(::Google::Cloud::FinancialServices::V1::CreateDatasetRequest.new(parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_dataset_client_stub.call_rpc_count
    end
  end

  def test_update_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    dataset = {}
    request_id = "hello world"

    update_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_dataset, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::UpdateDatasetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::Dataset), request["dataset"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_dataset({ update_mask: update_mask, dataset: dataset, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_dataset update_mask: update_mask, dataset: dataset, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_dataset ::Google::Cloud::FinancialServices::V1::UpdateDatasetRequest.new(update_mask: update_mask, dataset: dataset, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_dataset({ update_mask: update_mask, dataset: dataset, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_dataset(::Google::Cloud::FinancialServices::V1::UpdateDatasetRequest.new(update_mask: update_mask, dataset: dataset, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_dataset_client_stub.call_rpc_count
    end
  end

  def test_delete_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_dataset, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::DeleteDatasetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_dataset({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_dataset name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_dataset ::Google::Cloud::FinancialServices::V1::DeleteDatasetRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_dataset({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_dataset(::Google::Cloud::FinancialServices::V1::DeleteDatasetRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_dataset_client_stub.call_rpc_count
    end
  end

  def test_list_models
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::ListModelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_models_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_models, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ListModelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_models_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_models({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_models parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_models ::Google::Cloud::FinancialServices::V1::ListModelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_models({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_models(::Google::Cloud::FinancialServices::V1::ListModelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_models_client_stub.call_rpc_count
    end
  end

  def test_get_model
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::Model.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_model, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::GetModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_model_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_model({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_model name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_model ::Google::Cloud::FinancialServices::V1::GetModelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_model({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_model(::Google::Cloud::FinancialServices::V1::GetModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_model_client_stub.call_rpc_count
    end
  end

  def test_create_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_id = "hello world"
    model = {}
    request_id = "hello world"

    create_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_model, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::CreateModelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["model_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::Model), request["model"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_model_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_model({ parent: parent, model_id: model_id, model: model, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_model parent: parent, model_id: model_id, model: model, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_model ::Google::Cloud::FinancialServices::V1::CreateModelRequest.new(parent: parent, model_id: model_id, model: model, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_model({ parent: parent, model_id: model_id, model: model, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_model(::Google::Cloud::FinancialServices::V1::CreateModelRequest.new(parent: parent, model_id: model_id, model: model, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_model_client_stub.call_rpc_count
    end
  end

  def test_update_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    model = {}
    request_id = "hello world"

    update_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_model, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::UpdateModelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::Model), request["model"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_model_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_model({ update_mask: update_mask, model: model, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_model update_mask: update_mask, model: model, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_model ::Google::Cloud::FinancialServices::V1::UpdateModelRequest.new(update_mask: update_mask, model: model, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_model({ update_mask: update_mask, model: model, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_model(::Google::Cloud::FinancialServices::V1::UpdateModelRequest.new(update_mask: update_mask, model: model, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_model_client_stub.call_rpc_count
    end
  end

  def test_export_model_metadata
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    structured_metadata_destination = {}

    export_model_metadata_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_model_metadata, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ExportModelMetadataRequest, request
      assert_equal "hello world", request["model"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::BigQueryDestination), request["structured_metadata_destination"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_model_metadata_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_model_metadata({ model: model, structured_metadata_destination: structured_metadata_destination }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_model_metadata model: model, structured_metadata_destination: structured_metadata_destination do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_model_metadata ::Google::Cloud::FinancialServices::V1::ExportModelMetadataRequest.new(model: model, structured_metadata_destination: structured_metadata_destination) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_model_metadata({ model: model, structured_metadata_destination: structured_metadata_destination }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_model_metadata(::Google::Cloud::FinancialServices::V1::ExportModelMetadataRequest.new(model: model, structured_metadata_destination: structured_metadata_destination), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_model_metadata_client_stub.call_rpc_count
    end
  end

  def test_delete_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_model, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::DeleteModelRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_model_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_model({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_model name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_model ::Google::Cloud::FinancialServices::V1::DeleteModelRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_model({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_model(::Google::Cloud::FinancialServices::V1::DeleteModelRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_model_client_stub.call_rpc_count
    end
  end

  def test_list_engine_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::ListEngineConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_engine_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_engine_configs, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ListEngineConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_engine_configs_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_engine_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_engine_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_engine_configs ::Google::Cloud::FinancialServices::V1::ListEngineConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_engine_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_engine_configs(::Google::Cloud::FinancialServices::V1::ListEngineConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_engine_configs_client_stub.call_rpc_count
    end
  end

  def test_get_engine_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::EngineConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_engine_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_engine_config, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::GetEngineConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_engine_config_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_engine_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_engine_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_engine_config ::Google::Cloud::FinancialServices::V1::GetEngineConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_engine_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_engine_config(::Google::Cloud::FinancialServices::V1::GetEngineConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_engine_config_client_stub.call_rpc_count
    end
  end

  def test_create_engine_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    engine_config_id = "hello world"
    engine_config = {}
    request_id = "hello world"

    create_engine_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_engine_config, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::CreateEngineConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["engine_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::EngineConfig), request["engine_config"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_engine_config_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_engine_config({ parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_engine_config parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_engine_config ::Google::Cloud::FinancialServices::V1::CreateEngineConfigRequest.new(parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_engine_config({ parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_engine_config(::Google::Cloud::FinancialServices::V1::CreateEngineConfigRequest.new(parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_engine_config_client_stub.call_rpc_count
    end
  end

  def test_update_engine_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    engine_config = {}
    request_id = "hello world"

    update_engine_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_engine_config, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::UpdateEngineConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::EngineConfig), request["engine_config"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_engine_config_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_engine_config({ update_mask: update_mask, engine_config: engine_config, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_engine_config update_mask: update_mask, engine_config: engine_config, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_engine_config ::Google::Cloud::FinancialServices::V1::UpdateEngineConfigRequest.new(update_mask: update_mask, engine_config: engine_config, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_engine_config({ update_mask: update_mask, engine_config: engine_config, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_engine_config(::Google::Cloud::FinancialServices::V1::UpdateEngineConfigRequest.new(update_mask: update_mask, engine_config: engine_config, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_engine_config_client_stub.call_rpc_count
    end
  end

  def test_export_engine_config_metadata
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    engine_config = "hello world"
    structured_metadata_destination = {}

    export_engine_config_metadata_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_engine_config_metadata, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ExportEngineConfigMetadataRequest, request
      assert_equal "hello world", request["engine_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::BigQueryDestination), request["structured_metadata_destination"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_engine_config_metadata_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_engine_config_metadata({ engine_config: engine_config, structured_metadata_destination: structured_metadata_destination }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_engine_config_metadata engine_config: engine_config, structured_metadata_destination: structured_metadata_destination do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_engine_config_metadata ::Google::Cloud::FinancialServices::V1::ExportEngineConfigMetadataRequest.new(engine_config: engine_config, structured_metadata_destination: structured_metadata_destination) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_engine_config_metadata({ engine_config: engine_config, structured_metadata_destination: structured_metadata_destination }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_engine_config_metadata(::Google::Cloud::FinancialServices::V1::ExportEngineConfigMetadataRequest.new(engine_config: engine_config, structured_metadata_destination: structured_metadata_destination), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_engine_config_metadata_client_stub.call_rpc_count
    end
  end

  def test_delete_engine_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_engine_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_engine_config, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::DeleteEngineConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_engine_config_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_engine_config({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_engine_config name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_engine_config ::Google::Cloud::FinancialServices::V1::DeleteEngineConfigRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_engine_config({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_engine_config(::Google::Cloud::FinancialServices::V1::DeleteEngineConfigRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_engine_config_client_stub.call_rpc_count
    end
  end

  def test_get_engine_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::EngineVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_engine_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_engine_version, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::GetEngineVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_engine_version_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_engine_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_engine_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_engine_version ::Google::Cloud::FinancialServices::V1::GetEngineVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_engine_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_engine_version(::Google::Cloud::FinancialServices::V1::GetEngineVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_engine_version_client_stub.call_rpc_count
    end
  end

  def test_list_engine_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::ListEngineVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_engine_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_engine_versions, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ListEngineVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_engine_versions_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_engine_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_engine_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_engine_versions ::Google::Cloud::FinancialServices::V1::ListEngineVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_engine_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_engine_versions(::Google::Cloud::FinancialServices::V1::ListEngineVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_engine_versions_client_stub.call_rpc_count
    end
  end

  def test_list_prediction_results
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::ListPredictionResultsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_prediction_results_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_prediction_results, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ListPredictionResultsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_prediction_results_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_prediction_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_prediction_results parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_prediction_results ::Google::Cloud::FinancialServices::V1::ListPredictionResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_prediction_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_prediction_results(::Google::Cloud::FinancialServices::V1::ListPredictionResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_prediction_results_client_stub.call_rpc_count
    end
  end

  def test_get_prediction_result
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::PredictionResult.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_prediction_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_prediction_result, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::GetPredictionResultRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_prediction_result_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_prediction_result({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_prediction_result name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_prediction_result ::Google::Cloud::FinancialServices::V1::GetPredictionResultRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_prediction_result({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_prediction_result(::Google::Cloud::FinancialServices::V1::GetPredictionResultRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_prediction_result_client_stub.call_rpc_count
    end
  end

  def test_create_prediction_result
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    prediction_result_id = "hello world"
    prediction_result = {}
    request_id = "hello world"

    create_prediction_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_prediction_result, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::CreatePredictionResultRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["prediction_result_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::PredictionResult), request["prediction_result"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_prediction_result_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_prediction_result({ parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_prediction_result parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_prediction_result ::Google::Cloud::FinancialServices::V1::CreatePredictionResultRequest.new(parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_prediction_result({ parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_prediction_result(::Google::Cloud::FinancialServices::V1::CreatePredictionResultRequest.new(parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_prediction_result_client_stub.call_rpc_count
    end
  end

  def test_update_prediction_result
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    prediction_result = {}
    request_id = "hello world"

    update_prediction_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_prediction_result, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::UpdatePredictionResultRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::PredictionResult), request["prediction_result"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_prediction_result_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_prediction_result({ update_mask: update_mask, prediction_result: prediction_result, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_prediction_result update_mask: update_mask, prediction_result: prediction_result, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_prediction_result ::Google::Cloud::FinancialServices::V1::UpdatePredictionResultRequest.new(update_mask: update_mask, prediction_result: prediction_result, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_prediction_result({ update_mask: update_mask, prediction_result: prediction_result, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_prediction_result(::Google::Cloud::FinancialServices::V1::UpdatePredictionResultRequest.new(update_mask: update_mask, prediction_result: prediction_result, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_prediction_result_client_stub.call_rpc_count
    end
  end

  def test_export_prediction_result_metadata
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    prediction_result = "hello world"
    structured_metadata_destination = {}

    export_prediction_result_metadata_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_prediction_result_metadata, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ExportPredictionResultMetadataRequest, request
      assert_equal "hello world", request["prediction_result"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::BigQueryDestination), request["structured_metadata_destination"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_prediction_result_metadata_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_prediction_result_metadata({ prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_prediction_result_metadata prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_prediction_result_metadata ::Google::Cloud::FinancialServices::V1::ExportPredictionResultMetadataRequest.new(prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_prediction_result_metadata({ prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_prediction_result_metadata(::Google::Cloud::FinancialServices::V1::ExportPredictionResultMetadataRequest.new(prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_prediction_result_metadata_client_stub.call_rpc_count
    end
  end

  def test_delete_prediction_result
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_prediction_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_prediction_result, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::DeletePredictionResultRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_prediction_result_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_prediction_result({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_prediction_result name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_prediction_result ::Google::Cloud::FinancialServices::V1::DeletePredictionResultRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_prediction_result({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_prediction_result(::Google::Cloud::FinancialServices::V1::DeletePredictionResultRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_prediction_result_client_stub.call_rpc_count
    end
  end

  def test_list_backtest_results
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::ListBacktestResultsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backtest_results_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backtest_results, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ListBacktestResultsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backtest_results_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backtest_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backtest_results parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backtest_results ::Google::Cloud::FinancialServices::V1::ListBacktestResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backtest_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backtest_results(::Google::Cloud::FinancialServices::V1::ListBacktestResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backtest_results_client_stub.call_rpc_count
    end
  end

  def test_get_backtest_result
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::FinancialServices::V1::BacktestResult.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backtest_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backtest_result, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::GetBacktestResultRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backtest_result_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backtest_result({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backtest_result name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backtest_result ::Google::Cloud::FinancialServices::V1::GetBacktestResultRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backtest_result({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backtest_result(::Google::Cloud::FinancialServices::V1::GetBacktestResultRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backtest_result_client_stub.call_rpc_count
    end
  end

  def test_create_backtest_result
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backtest_result_id = "hello world"
    backtest_result = {}
    request_id = "hello world"

    create_backtest_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_backtest_result, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::CreateBacktestResultRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["backtest_result_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::BacktestResult), request["backtest_result"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_backtest_result_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_backtest_result({ parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_backtest_result parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_backtest_result ::Google::Cloud::FinancialServices::V1::CreateBacktestResultRequest.new(parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_backtest_result({ parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_backtest_result(::Google::Cloud::FinancialServices::V1::CreateBacktestResultRequest.new(parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_backtest_result_client_stub.call_rpc_count
    end
  end

  def test_update_backtest_result
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backtest_result = {}
    request_id = "hello world"

    update_backtest_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backtest_result, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::UpdateBacktestResultRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::BacktestResult), request["backtest_result"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backtest_result_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backtest_result({ update_mask: update_mask, backtest_result: backtest_result, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backtest_result update_mask: update_mask, backtest_result: backtest_result, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backtest_result ::Google::Cloud::FinancialServices::V1::UpdateBacktestResultRequest.new(update_mask: update_mask, backtest_result: backtest_result, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backtest_result({ update_mask: update_mask, backtest_result: backtest_result, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backtest_result(::Google::Cloud::FinancialServices::V1::UpdateBacktestResultRequest.new(update_mask: update_mask, backtest_result: backtest_result, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backtest_result_client_stub.call_rpc_count
    end
  end

  def test_export_backtest_result_metadata
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    backtest_result = "hello world"
    structured_metadata_destination = {}

    export_backtest_result_metadata_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_backtest_result_metadata, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::ExportBacktestResultMetadataRequest, request
      assert_equal "hello world", request["backtest_result"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::FinancialServices::V1::BigQueryDestination), request["structured_metadata_destination"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_backtest_result_metadata_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_backtest_result_metadata({ backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_backtest_result_metadata backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_backtest_result_metadata ::Google::Cloud::FinancialServices::V1::ExportBacktestResultMetadataRequest.new(backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_backtest_result_metadata({ backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_backtest_result_metadata(::Google::Cloud::FinancialServices::V1::ExportBacktestResultMetadataRequest.new(backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_backtest_result_metadata_client_stub.call_rpc_count
    end
  end

  def test_delete_backtest_result
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_backtest_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backtest_result, name
      assert_kind_of ::Google::Cloud::FinancialServices::V1::DeleteBacktestResultRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backtest_result_client_stub do
      # Create client
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backtest_result({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backtest_result name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backtest_result ::Google::Cloud::FinancialServices::V1::DeleteBacktestResultRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backtest_result({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backtest_result(::Google::Cloud::FinancialServices::V1::DeleteBacktestResultRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backtest_result_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::FinancialServices::V1::AML::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::FinancialServices::V1::AML::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::FinancialServices::V1::AML::Operations, client.operations_client
  end
end
