# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/financialservices/v1/service_pb"
require "google/cloud/financial_services/v1/aml/rest"


class ::Google::Cloud::FinancialServices::V1::AML::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_instances
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::ListInstancesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_list_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_instances_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_instances ::Google::Cloud::FinancialServices::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_instances(::Google::Cloud::FinancialServices::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_instances_client_stub.call_count
      end
    end
  end

  def test_get_instance
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::Instance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_get_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_instance_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_instance ::Google::Cloud::FinancialServices::V1::GetInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_instance(::Google::Cloud::FinancialServices::V1::GetInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_instance_client_stub.call_count
      end
    end
  end

  def test_create_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"
    instance = {}
    request_id = "hello world"

    create_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_create_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_instance_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_instance parent: parent, instance_id: instance_id, instance: instance, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_instance ::Google::Cloud::FinancialServices::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_instance(::Google::Cloud::FinancialServices::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_instance_client_stub.call_count
      end
    end
  end

  def test_update_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    instance = {}
    request_id = "hello world"

    update_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_update_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_instance_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_instance({ update_mask: update_mask, instance: instance, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_instance update_mask: update_mask, instance: instance, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_instance ::Google::Cloud::FinancialServices::V1::UpdateInstanceRequest.new(update_mask: update_mask, instance: instance, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_instance({ update_mask: update_mask, instance: instance, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_instance(::Google::Cloud::FinancialServices::V1::UpdateInstanceRequest.new(update_mask: update_mask, instance: instance, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_instance_client_stub.call_count
      end
    end
  end

  def test_delete_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_delete_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_instance_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_instance({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_instance name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_instance ::Google::Cloud::FinancialServices::V1::DeleteInstanceRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_instance({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_instance(::Google::Cloud::FinancialServices::V1::DeleteInstanceRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_instance_client_stub.call_count
      end
    end
  end

  def test_import_registered_parties
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    party_tables = ["hello world"]
    mode = :UPDATE_MODE_UNSPECIFIED
    validate_only = true
    line_of_business = :LINE_OF_BUSINESS_UNSPECIFIED

    import_registered_parties_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_import_registered_parties_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_registered_parties_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_registered_parties({ name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_registered_parties name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_registered_parties ::Google::Cloud::FinancialServices::V1::ImportRegisteredPartiesRequest.new(name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_registered_parties({ name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_registered_parties(::Google::Cloud::FinancialServices::V1::ImportRegisteredPartiesRequest.new(name: name, party_tables: party_tables, mode: mode, validate_only: validate_only, line_of_business: line_of_business), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_registered_parties_client_stub.call_count
      end
    end
  end

  def test_export_registered_parties
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    dataset = {}
    line_of_business = :LINE_OF_BUSINESS_UNSPECIFIED

    export_registered_parties_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_export_registered_parties_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_registered_parties_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_registered_parties({ name: name, dataset: dataset, line_of_business: line_of_business }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_registered_parties name: name, dataset: dataset, line_of_business: line_of_business do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_registered_parties ::Google::Cloud::FinancialServices::V1::ExportRegisteredPartiesRequest.new(name: name, dataset: dataset, line_of_business: line_of_business) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_registered_parties({ name: name, dataset: dataset, line_of_business: line_of_business }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_registered_parties(::Google::Cloud::FinancialServices::V1::ExportRegisteredPartiesRequest.new(name: name, dataset: dataset, line_of_business: line_of_business), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_registered_parties_client_stub.call_count
      end
    end
  end

  def test_list_datasets
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::ListDatasetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_datasets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_list_datasets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_datasets_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_datasets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_datasets ::Google::Cloud::FinancialServices::V1::ListDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_datasets(::Google::Cloud::FinancialServices::V1::ListDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_datasets_client_stub.call_count
      end
    end
  end

  def test_get_dataset
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::Dataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_get_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dataset ::Google::Cloud::FinancialServices::V1::GetDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dataset(::Google::Cloud::FinancialServices::V1::GetDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dataset_client_stub.call_count
      end
    end
  end

  def test_create_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset_id = "hello world"
    dataset = {}
    request_id = "hello world"

    create_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_create_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_dataset({ parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_dataset parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_dataset ::Google::Cloud::FinancialServices::V1::CreateDatasetRequest.new(parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_dataset({ parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_dataset(::Google::Cloud::FinancialServices::V1::CreateDatasetRequest.new(parent: parent, dataset_id: dataset_id, dataset: dataset, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_dataset_client_stub.call_count
      end
    end
  end

  def test_update_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    dataset = {}
    request_id = "hello world"

    update_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_update_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_dataset({ update_mask: update_mask, dataset: dataset, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_dataset update_mask: update_mask, dataset: dataset, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_dataset ::Google::Cloud::FinancialServices::V1::UpdateDatasetRequest.new(update_mask: update_mask, dataset: dataset, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_dataset({ update_mask: update_mask, dataset: dataset, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_dataset(::Google::Cloud::FinancialServices::V1::UpdateDatasetRequest.new(update_mask: update_mask, dataset: dataset, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_dataset_client_stub.call_count
      end
    end
  end

  def test_delete_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_delete_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_dataset({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_dataset name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_dataset ::Google::Cloud::FinancialServices::V1::DeleteDatasetRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_dataset({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_dataset(::Google::Cloud::FinancialServices::V1::DeleteDatasetRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_dataset_client_stub.call_count
      end
    end
  end

  def test_list_models
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::ListModelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_models_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_list_models_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_models_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_models({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_models parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_models ::Google::Cloud::FinancialServices::V1::ListModelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_models({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_models(::Google::Cloud::FinancialServices::V1::ListModelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_models_client_stub.call_count
      end
    end
  end

  def test_get_model
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::Model.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_get_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_model_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_model ::Google::Cloud::FinancialServices::V1::GetModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_model(::Google::Cloud::FinancialServices::V1::GetModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_model_client_stub.call_count
      end
    end
  end

  def test_create_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_id = "hello world"
    model = {}
    request_id = "hello world"

    create_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_create_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_model_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_model({ parent: parent, model_id: model_id, model: model, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_model parent: parent, model_id: model_id, model: model, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_model ::Google::Cloud::FinancialServices::V1::CreateModelRequest.new(parent: parent, model_id: model_id, model: model, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_model({ parent: parent, model_id: model_id, model: model, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_model(::Google::Cloud::FinancialServices::V1::CreateModelRequest.new(parent: parent, model_id: model_id, model: model, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_model_client_stub.call_count
      end
    end
  end

  def test_update_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    model = {}
    request_id = "hello world"

    update_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_update_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_model_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_model({ update_mask: update_mask, model: model, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_model update_mask: update_mask, model: model, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_model ::Google::Cloud::FinancialServices::V1::UpdateModelRequest.new(update_mask: update_mask, model: model, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_model({ update_mask: update_mask, model: model, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_model(::Google::Cloud::FinancialServices::V1::UpdateModelRequest.new(update_mask: update_mask, model: model, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_model_client_stub.call_count
      end
    end
  end

  def test_export_model_metadata
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    structured_metadata_destination = {}

    export_model_metadata_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_export_model_metadata_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_model_metadata_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_model_metadata({ model: model, structured_metadata_destination: structured_metadata_destination }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_model_metadata model: model, structured_metadata_destination: structured_metadata_destination do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_model_metadata ::Google::Cloud::FinancialServices::V1::ExportModelMetadataRequest.new(model: model, structured_metadata_destination: structured_metadata_destination) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_model_metadata({ model: model, structured_metadata_destination: structured_metadata_destination }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_model_metadata(::Google::Cloud::FinancialServices::V1::ExportModelMetadataRequest.new(model: model, structured_metadata_destination: structured_metadata_destination), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_model_metadata_client_stub.call_count
      end
    end
  end

  def test_delete_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_delete_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_model_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_model({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_model name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_model ::Google::Cloud::FinancialServices::V1::DeleteModelRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_model({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_model(::Google::Cloud::FinancialServices::V1::DeleteModelRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_model_client_stub.call_count
      end
    end
  end

  def test_list_engine_configs
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::ListEngineConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_engine_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_list_engine_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_engine_configs_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_engine_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_engine_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_engine_configs ::Google::Cloud::FinancialServices::V1::ListEngineConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_engine_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_engine_configs(::Google::Cloud::FinancialServices::V1::ListEngineConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_engine_configs_client_stub.call_count
      end
    end
  end

  def test_get_engine_config
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::EngineConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_engine_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_get_engine_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_engine_config_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_engine_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_engine_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_engine_config ::Google::Cloud::FinancialServices::V1::GetEngineConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_engine_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_engine_config(::Google::Cloud::FinancialServices::V1::GetEngineConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_engine_config_client_stub.call_count
      end
    end
  end

  def test_create_engine_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    engine_config_id = "hello world"
    engine_config = {}
    request_id = "hello world"

    create_engine_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_create_engine_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_engine_config_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_engine_config({ parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_engine_config parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_engine_config ::Google::Cloud::FinancialServices::V1::CreateEngineConfigRequest.new(parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_engine_config({ parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_engine_config(::Google::Cloud::FinancialServices::V1::CreateEngineConfigRequest.new(parent: parent, engine_config_id: engine_config_id, engine_config: engine_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_engine_config_client_stub.call_count
      end
    end
  end

  def test_update_engine_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    engine_config = {}
    request_id = "hello world"

    update_engine_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_update_engine_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_engine_config_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_engine_config({ update_mask: update_mask, engine_config: engine_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_engine_config update_mask: update_mask, engine_config: engine_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_engine_config ::Google::Cloud::FinancialServices::V1::UpdateEngineConfigRequest.new(update_mask: update_mask, engine_config: engine_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_engine_config({ update_mask: update_mask, engine_config: engine_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_engine_config(::Google::Cloud::FinancialServices::V1::UpdateEngineConfigRequest.new(update_mask: update_mask, engine_config: engine_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_engine_config_client_stub.call_count
      end
    end
  end

  def test_export_engine_config_metadata
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    engine_config = "hello world"
    structured_metadata_destination = {}

    export_engine_config_metadata_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_export_engine_config_metadata_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_engine_config_metadata_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_engine_config_metadata({ engine_config: engine_config, structured_metadata_destination: structured_metadata_destination }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_engine_config_metadata engine_config: engine_config, structured_metadata_destination: structured_metadata_destination do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_engine_config_metadata ::Google::Cloud::FinancialServices::V1::ExportEngineConfigMetadataRequest.new(engine_config: engine_config, structured_metadata_destination: structured_metadata_destination) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_engine_config_metadata({ engine_config: engine_config, structured_metadata_destination: structured_metadata_destination }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_engine_config_metadata(::Google::Cloud::FinancialServices::V1::ExportEngineConfigMetadataRequest.new(engine_config: engine_config, structured_metadata_destination: structured_metadata_destination), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_engine_config_metadata_client_stub.call_count
      end
    end
  end

  def test_delete_engine_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_engine_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_delete_engine_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_engine_config_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_engine_config({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_engine_config name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_engine_config ::Google::Cloud::FinancialServices::V1::DeleteEngineConfigRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_engine_config({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_engine_config(::Google::Cloud::FinancialServices::V1::DeleteEngineConfigRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_engine_config_client_stub.call_count
      end
    end
  end

  def test_get_engine_version
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::EngineVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_engine_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_get_engine_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_engine_version_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_engine_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_engine_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_engine_version ::Google::Cloud::FinancialServices::V1::GetEngineVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_engine_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_engine_version(::Google::Cloud::FinancialServices::V1::GetEngineVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_engine_version_client_stub.call_count
      end
    end
  end

  def test_list_engine_versions
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::ListEngineVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_engine_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_list_engine_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_engine_versions_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_engine_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_engine_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_engine_versions ::Google::Cloud::FinancialServices::V1::ListEngineVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_engine_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_engine_versions(::Google::Cloud::FinancialServices::V1::ListEngineVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_engine_versions_client_stub.call_count
      end
    end
  end

  def test_list_prediction_results
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::ListPredictionResultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_prediction_results_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_list_prediction_results_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_prediction_results_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_prediction_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_prediction_results parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_prediction_results ::Google::Cloud::FinancialServices::V1::ListPredictionResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_prediction_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_prediction_results(::Google::Cloud::FinancialServices::V1::ListPredictionResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_prediction_results_client_stub.call_count
      end
    end
  end

  def test_get_prediction_result
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::PredictionResult.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_prediction_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_get_prediction_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_prediction_result_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_prediction_result({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_prediction_result name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_prediction_result ::Google::Cloud::FinancialServices::V1::GetPredictionResultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_prediction_result({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_prediction_result(::Google::Cloud::FinancialServices::V1::GetPredictionResultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_prediction_result_client_stub.call_count
      end
    end
  end

  def test_create_prediction_result
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    prediction_result_id = "hello world"
    prediction_result = {}
    request_id = "hello world"

    create_prediction_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_create_prediction_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_prediction_result_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_prediction_result({ parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_prediction_result parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_prediction_result ::Google::Cloud::FinancialServices::V1::CreatePredictionResultRequest.new(parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_prediction_result({ parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_prediction_result(::Google::Cloud::FinancialServices::V1::CreatePredictionResultRequest.new(parent: parent, prediction_result_id: prediction_result_id, prediction_result: prediction_result, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_prediction_result_client_stub.call_count
      end
    end
  end

  def test_update_prediction_result
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    prediction_result = {}
    request_id = "hello world"

    update_prediction_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_update_prediction_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_prediction_result_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_prediction_result({ update_mask: update_mask, prediction_result: prediction_result, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_prediction_result update_mask: update_mask, prediction_result: prediction_result, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_prediction_result ::Google::Cloud::FinancialServices::V1::UpdatePredictionResultRequest.new(update_mask: update_mask, prediction_result: prediction_result, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_prediction_result({ update_mask: update_mask, prediction_result: prediction_result, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_prediction_result(::Google::Cloud::FinancialServices::V1::UpdatePredictionResultRequest.new(update_mask: update_mask, prediction_result: prediction_result, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_prediction_result_client_stub.call_count
      end
    end
  end

  def test_export_prediction_result_metadata
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    prediction_result = "hello world"
    structured_metadata_destination = {}

    export_prediction_result_metadata_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_export_prediction_result_metadata_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_prediction_result_metadata_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_prediction_result_metadata({ prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_prediction_result_metadata prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_prediction_result_metadata ::Google::Cloud::FinancialServices::V1::ExportPredictionResultMetadataRequest.new(prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_prediction_result_metadata({ prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_prediction_result_metadata(::Google::Cloud::FinancialServices::V1::ExportPredictionResultMetadataRequest.new(prediction_result: prediction_result, structured_metadata_destination: structured_metadata_destination), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_prediction_result_metadata_client_stub.call_count
      end
    end
  end

  def test_delete_prediction_result
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_prediction_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_delete_prediction_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_prediction_result_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_prediction_result({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_prediction_result name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_prediction_result ::Google::Cloud::FinancialServices::V1::DeletePredictionResultRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_prediction_result({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_prediction_result(::Google::Cloud::FinancialServices::V1::DeletePredictionResultRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_prediction_result_client_stub.call_count
      end
    end
  end

  def test_list_backtest_results
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::ListBacktestResultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backtest_results_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_list_backtest_results_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backtest_results_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backtest_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backtest_results parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backtest_results ::Google::Cloud::FinancialServices::V1::ListBacktestResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backtest_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backtest_results(::Google::Cloud::FinancialServices::V1::ListBacktestResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backtest_results_client_stub.call_count
      end
    end
  end

  def test_get_backtest_result
    # Create test objects.
    client_result = ::Google::Cloud::FinancialServices::V1::BacktestResult.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backtest_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_get_backtest_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backtest_result_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backtest_result({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backtest_result name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backtest_result ::Google::Cloud::FinancialServices::V1::GetBacktestResultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backtest_result({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backtest_result(::Google::Cloud::FinancialServices::V1::GetBacktestResultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backtest_result_client_stub.call_count
      end
    end
  end

  def test_create_backtest_result
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backtest_result_id = "hello world"
    backtest_result = {}
    request_id = "hello world"

    create_backtest_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_create_backtest_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backtest_result_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backtest_result({ parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backtest_result parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backtest_result ::Google::Cloud::FinancialServices::V1::CreateBacktestResultRequest.new(parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backtest_result({ parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backtest_result(::Google::Cloud::FinancialServices::V1::CreateBacktestResultRequest.new(parent: parent, backtest_result_id: backtest_result_id, backtest_result: backtest_result, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backtest_result_client_stub.call_count
      end
    end
  end

  def test_update_backtest_result
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backtest_result = {}
    request_id = "hello world"

    update_backtest_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_update_backtest_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backtest_result_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backtest_result({ update_mask: update_mask, backtest_result: backtest_result, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backtest_result update_mask: update_mask, backtest_result: backtest_result, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backtest_result ::Google::Cloud::FinancialServices::V1::UpdateBacktestResultRequest.new(update_mask: update_mask, backtest_result: backtest_result, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backtest_result({ update_mask: update_mask, backtest_result: backtest_result, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backtest_result(::Google::Cloud::FinancialServices::V1::UpdateBacktestResultRequest.new(update_mask: update_mask, backtest_result: backtest_result, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backtest_result_client_stub.call_count
      end
    end
  end

  def test_export_backtest_result_metadata
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    backtest_result = "hello world"
    structured_metadata_destination = {}

    export_backtest_result_metadata_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_export_backtest_result_metadata_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_backtest_result_metadata_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_backtest_result_metadata({ backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_backtest_result_metadata backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_backtest_result_metadata ::Google::Cloud::FinancialServices::V1::ExportBacktestResultMetadataRequest.new(backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_backtest_result_metadata({ backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_backtest_result_metadata(::Google::Cloud::FinancialServices::V1::ExportBacktestResultMetadataRequest.new(backtest_result: backtest_result, structured_metadata_destination: structured_metadata_destination), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_backtest_result_metadata_client_stub.call_count
      end
    end
  end

  def test_delete_backtest_result
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_backtest_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::FinancialServices::V1::AML::Rest::ServiceStub.stub :transcode_delete_backtest_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backtest_result_client_stub do
        # Create client
        client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backtest_result({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backtest_result name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backtest_result ::Google::Cloud::FinancialServices::V1::DeleteBacktestResultRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backtest_result({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backtest_result(::Google::Cloud::FinancialServices::V1::DeleteBacktestResultRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backtest_result_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::FinancialServices::V1::AML::Rest::Client::Configuration, config
  end
end
