# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/financial_services/v1/aml"

class ::Google::Cloud::FinancialServices::V1::AML::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_backtest_result_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.backtest_result_path project_num: "value0", location: "value1", instance: "value2", backtest_result: "value3"
      assert_equal "projects/value0/locations/value1/instances/value2/backtestResults/value3", path
    end
  end

  def test_dataset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.dataset_path project_num: "value0", location: "value1", instance: "value2", dataset: "value3"
      assert_equal "projects/value0/locations/value1/instances/value2/datasets/value3", path
    end
  end

  def test_engine_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.engine_config_path project_num: "value0", location: "value1", instance: "value2", engine_config: "value3"
      assert_equal "projects/value0/locations/value1/instances/value2/engineConfigs/value3", path
    end
  end

  def test_engine_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.engine_version_path project_num: "value0", location: "value1", instance: "value2", engine_version: "value3"
      assert_equal "projects/value0/locations/value1/instances/value2/engineVersions/value3", path
    end
  end

  def test_instance_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.instance_path project: "value0", location: "value1", instance: "value2"
      assert_equal "projects/value0/locations/value1/instances/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_model_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.model_path project_num: "value0", location: "value1", instance: "value2", model: "value3"
      assert_equal "projects/value0/locations/value1/instances/value2/models/value3", path
    end
  end

  def test_prediction_result_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::FinancialServices::V1::AML::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.prediction_result_path project_num: "value0", location: "value1", instance: "value2", prediction_result: "value3"
      assert_equal "projects/value0/locations/value1/instances/value2/predictionResults/value3", path
    end
  end
end
