# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module FinancialServices
      module V1
        # PredictionResult is the result of using a model to create predictions.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the PredictionResult.
        #     format:
        #     `/projects/{project_num}/locations/{location}/instances/{instance}/predictionResults/{prediction_result}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of creation of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of the most recent update of this resource.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels
        # @!attribute [r] state
        #   @return [::Google::Cloud::FinancialServices::V1::PredictionResult::State]
        #     Output only. State of the PredictionResult (creating, active, deleting,
        #     etc.)
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The resource name of the Dataset to do predictions on
        #     Format:
        #     `/projects/{project_num}/locations/{location}/instances/{instance}/dataset/{dataset_id}`
        # @!attribute [rw] model
        #   @return [::String]
        #     Required. The resource name of the Model to use to use to make predictions
        #     Format:
        #     `/projects/{project_num}/locations/{location}/instances/{instance}/models/{model}`
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. Specifies the latest time from which data is used to generate
        #     features for predictions.  This time should be no later than the end of the
        #     {::Google::Cloud::FinancialServices::V1::Dataset#date_range date_range} of the
        #     dataset.
        # @!attribute [rw] prediction_periods
        #   @return [::Integer]
        #     The number of consecutive months to produce predictions for, ending with
        #     the last full month prior to
        #     {::Google::Cloud::FinancialServices::V1::PredictionResult#end_time end_time}
        #     according to the dataset's timezone.
        # @!attribute [rw] outputs
        #   @return [::Google::Cloud::FinancialServices::V1::PredictionResult::Outputs]
        #     Required. Where to write the output of the predictions.
        # @!attribute [r] line_of_business
        #   @return [::Google::Cloud::FinancialServices::V1::LineOfBusiness]
        #     Output only. The line of business (Retail/Commercial) this prediction is
        #     for. Determined by Model, cannot be set by user.
        class PredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Outputs is a list of places where the operation will write results.
          # @!attribute [rw] prediction_destination
          #   @return [::Google::Cloud::FinancialServices::V1::BigQueryDestination]
          #     Required. The location to output the predictions.
          # @!attribute [rw] explainability_destination
          #   @return [::Google::Cloud::FinancialServices::V1::BigQueryDestination]
          #     The location to output explainability information.  If not specified
          #     no explainability data will be output.
          class Outputs
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible states of a resource.
          module State
            # State is unspecified, should not occur.
            STATE_UNSPECIFIED = 0

            # The resource has not finished being created.
            CREATING = 1

            # The resource is active/ready to be used.
            ACTIVE = 2

            # The resource is in the process of being updated.
            UPDATING = 3

            # The resource is in the process of being deleted.
            DELETING = 4
          end
        end

        # Request for retrieving a paginated list of PredictionResult resources that
        # meet the specified criteria.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the PredictionResult is the Instance.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The number of resources to be included in the response. The response
        #     contains a next_page_token, which can be used to retrieve the next page of
        #     resources.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     In case of paginated results, this is the token that was returned in the
        #     previous ListPredictionResultsResponse. It should be copied here to
        #     retrieve the next page of resources. Empty will give the first page of
        #     ListPredictionResultsRequest, and the last page will return an empty
        #     page_token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Specify a filter to narrow search results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Specify a field to use for ordering.
        class ListPredictionResultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for retrieving a list of PredictionResults
        # @!attribute [rw] prediction_results
        #   @return [::Array<::Google::Cloud::FinancialServices::V1::PredictionResult>]
        #     List of PredictionResult resources
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     This token should be passed to the next ListPredictionResultsRequest to
        #     retrieve the next page of PredictionResults (empty indicicates we are
        #     done).
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListPredictionResultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for retrieving a specific PredictionResult resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the PredictionResult
        class GetPredictionResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for creating a PredictionResult resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the PredictionResult is the Instance.
        # @!attribute [rw] prediction_result_id
        #   @return [::String]
        #     Required. The resource id of the PredictionResult
        # @!attribute [rw] prediction_result
        #   @return [::Google::Cloud::FinancialServices::V1::PredictionResult]
        #     Required. The PredictionResult that will be created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreatePredictionResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for updating a PredictionResult
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     PredictionResult resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] prediction_result
        #   @return [::Google::Cloud::FinancialServices::V1::PredictionResult]
        #     Required. The new value of the PredictionResult fields that will be updated
        #     according to the update_mask.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdatePredictionResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for deleting a PredictionResult.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the PredictionResult.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeletePredictionResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for exporting PredictionResult metadata.
        # @!attribute [rw] prediction_result
        #   @return [::String]
        #     Required. The resource name of the PredictionResult.
        # @!attribute [rw] structured_metadata_destination
        #   @return [::Google::Cloud::FinancialServices::V1::BigQueryDestination]
        #     Required. BigQuery output where the metadata will be written.
        class ExportPredictionResultMetadataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for exporting PredictionResult metadata.
        class ExportPredictionResultMetadataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
